/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.birt.report.designer.core.CorePlugin;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.DeferredGraphicalViewer;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.RootDragTracker;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.AutoexposeHelper;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.GuideLayer;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ViewportAutoexposeHelper;
import org.eclipse.swt.graphics.Color;

public class ReportRootEditPart
extends ScalableFreeformRootEditPart {
    private static final int DISTANCE = 6;
    private static final int DRAW_PIX = ReportColorConstants.ShadowColors.length;

    public DragTracker getDragTracker(Request req) {
        return new RootDragTracker();
    }

    protected LayeredPane createPrintableLayers() {
        FreeformLayeredPane layeredPane = new FreeformLayeredPane(){

            protected void paintFigure(Graphics graphics) {
                graphics.setBackgroundColor(ReportColorConstants.ReportRootBackgroundColor);
                graphics.fillRectangle(this.getBounds());
                if (!CorePlugin.isUseNormalTheme()) {
                    return;
                }
                Object obj = ReportRootEditPart.this.getViewer().getProperty("Layout Size");
                if (obj instanceof Rectangle) {
                    Color color;
                    Rectangle reportSize = (Rectangle)obj;
                    int i = 0;
                    while (i < DRAW_PIX) {
                        color = ReportColorConstants.ShadowColors[i];
                        graphics.setBackgroundColor(color);
                        int height = reportSize.height - 6 + 1;
                        graphics.fillRectangle(reportSize.x + reportSize.width - 1 + i + 1, reportSize.y + 6 - 1, 2, height);
                        ++i;
                    }
                    i = 0;
                    while (i < DRAW_PIX) {
                        color = ReportColorConstants.ShadowColors[i];
                        graphics.setBackgroundColor(color);
                        int width = reportSize.width - 6 + 1;
                        graphics.fillRectangle(reportSize.x + 6 - 1, reportSize.y + reportSize.height - 1 + i + 1, width, 2);
                        ++i;
                    }
                    i = DRAW_PIX - 1;
                    while (i > 0) {
                        color = ReportColorConstants.ShadowColors[i - 1];
                        graphics.setBackgroundColor(color);
                        int x = reportSize.x + reportSize.width;
                        int y = reportSize.y + reportSize.height;
                        graphics.fillArc(x - i, y - i, 2 * i, 2 * i, 0, -90);
                        --i;
                    }
                }
            }
        };
        FreeformLayer layer = new FreeformLayer(){

            public Rectangle getFreeformExtent() {
                Rectangle rect = super.getFreeformExtent();
                Rectangle retValue = rect.getCopy();
                Object obj = ReportRootEditPart.this.getViewer().getProperty("Report Size");
                if (obj instanceof Rectangle) {
                    Rectangle temp = (Rectangle)obj;
                    if (temp.width - rect.right() <= 20) {
                        retValue.width += 20;
                    }
                    if (temp.height - rect.bottom() <= 20) {
                        retValue.height += 20;
                    }
                }
                return retValue;
            }
        };
        layeredPane.add((IFigure)layer, (Object)"Primary Layer");
        layeredPane.add((IFigure)new ConnectionLayer(), (Object)"Connection Layer");
        return layeredPane;
    }

    protected void createLayers(LayeredPane layeredPane) {
        layeredPane.add((IFigure)this.getScaledLayers(), (Object)"Scalable Layers");
        layeredPane.add((IFigure)new FreeformLayer(), (Object)"Handle Layer");
        layeredPane.add((IFigure)new FeedbackLayer(), (Object)"Feedback Layer");
        layeredPane.add((IFigure)new GuideLayer(), (Object)"Guide Layer");
    }

    public Object getAdapter(Class adapter) {
        if (adapter == AutoexposeHelper.class) {
            return new ReportViewportAutoexposeHelper((GraphicalEditPart)this);
        }
        if (adapter == IModelEventProcessor.class) {
            return this.getContents().getAdapter(IModelEventProcessor.class);
        }
        return super.getAdapter(adapter);
    }

    public void activate() {
        this.getViewer().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("Layout Size".equals(evt.getPropertyName())) {
                    ReportRootEditPart.this.getFigure().repaint();
                }
            }
        });
        super.activate();
    }

    class FeedbackLayer
    extends FreeformLayer {
        FeedbackLayer() {
            this.setEnabled(false);
        }
    }

    private static class ReportViewportAutoexposeHelper
    extends ViewportAutoexposeHelper {
        private static final Insets DEFAULT_EXPOSE_THRESHOLD = new Insets(18);
        private long lastStepTime = 0L;
        private Insets threshold;

        public ReportViewportAutoexposeHelper(GraphicalEditPart owner) {
            super(owner);
            this.threshold = DEFAULT_EXPOSE_THRESHOLD;
        }

        public ReportViewportAutoexposeHelper(GraphicalEditPart owner, Insets threshold) {
            super(owner);
            this.threshold = threshold;
        }

        public boolean detect(Point where) {
            this.lastStepTime = 0L;
            Viewport port = this.findViewport(this.owner);
            Rectangle rect = Rectangle.SINGLETON;
            port.getClientArea(rect);
            port.translateToParent((Translatable)rect);
            port.translateToAbsolute((Translatable)rect);
            return rect.contains(where) && !rect.crop(this.threshold).contains(where);
        }

        public boolean step(Point where) {
            Viewport port = this.findViewport(this.owner);
            Rectangle rect = Rectangle.SINGLETON;
            port.getClientArea(rect);
            port.translateToParent((Translatable)rect);
            port.translateToAbsolute((Translatable)rect);
            if (!rect.contains(where) || rect.crop(this.threshold).contains(where)) {
                return false;
            }
            int scrollOffset = 0;
            if (this.lastStepTime == 0L) {
                this.lastStepTime = System.currentTimeMillis();
            }
            DeferredGraphicalViewer.OriginStepData stepData = ((DeferredGraphicalViewer)this.owner.getViewer()).getOriginStepData();
            long difference = System.currentTimeMillis() - this.lastStepTime;
            if (difference > 0L) {
                scrollOffset = (int)difference / 3;
                this.lastStepTime = System.currentTimeMillis();
            }
            if (scrollOffset == 0) {
                return true;
            }
            rect.crop(this.threshold);
            int region = rect.getPosition(where);
            Point loc = port.getViewLocation();
            if ((region & 4) != 0) {
                loc.y += scrollOffset;
            } else if ((region & 1) != 0) {
                loc.y -= scrollOffset;
            }
            if ((region & 0x10) != 0) {
                loc.x += scrollOffset;
            } else if ((region & 8) != 0) {
                loc.x -= scrollOffset;
            }
            if (stepData.minX > loc.x) {
                loc.x = port.getHorizontalRangeModel().getValue();
            }
            if (stepData.maxX - stepData.extendX < loc.x) {
                loc.x = port.getHorizontalRangeModel().getValue();
            }
            if (stepData.minY > loc.y) {
                loc.y = port.getVerticalRangeModel().getValue();
            }
            if (stepData.maxY - stepData.extendY < loc.y) {
                loc.y = port.getVerticalRangeModel().getValue();
            }
            port.setViewLocation(loc);
            return true;
        }
    }
}

