/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools;

import java.util.List;
import org.eclipse.birt.report.designer.core.model.schematic.ColumnHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.TableHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.TableDragGuideTracker;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.MetricUtility;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.graphics.Cursor;

public class ColumnDragTracker
extends TableDragGuideTracker {
    private static final String RESIZE_COLUMN_TRANS_LABEL = Messages.getString((String)"ColumnDragTracker.ResizeColumn");
    private static final String PREFIX_LABEL = Messages.getString((String)"ColumnDragTracker.Show.Label");

    public ColumnDragTracker(EditPart sourceEditPart, int start, int end) {
        super(sourceEditPart, start, end);
        this.setDisabledCursor(Cursors.SIZEWE);
    }

    protected void resize() {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        int value = this.getLocation().x - this.getStartLocation().x;
        part.getTableAdapter().transStar(RESIZE_COLUMN_TRANS_LABEL);
        if (this.isresizeMultipleColumn()) {
            List list = this.filterEditPart(part.getViewer().getSelectedEditParts());
            boolean resizeTable = false;
            int width = 0;
            int i = 0;
            while (i < list.size()) {
                int tempValue = value;
                Object model = ((EditPart)list.get(i)).getModel();
                ColumnHandleAdapter adapter = HandleAdapterFactory.getInstance().getColumnHandleAdapter(model);
                int start = adapter.getColumnNumber();
                int end = start + 1;
                int ori = TableUtil.caleVisualWidth(part, model);
                int adjustWidth = TableUtil.caleVisualWidth(part, part.getColumn(this.getStart())) + value;
                if (this.getStart() != start) {
                    tempValue = adjustWidth - ori;
                }
                if (start == part.getColumnCount()) {
                    end = start;
                    resizeTable = true;
                } else {
                    width += this.getTrueValue(tempValue, start, end);
                }
                this.resizeColumn(tempValue, start, end);
                ++i;
            }
            if (resizeTable) {
                Dimension size = part.getTableAdapter().getSize();
                try {
                    part.getTableAdapter().setSize(new Dimension(size.width + width, size.height));
                }
                catch (SemanticException e) {
                    part.getTableAdapter().rollBack();
                    ExceptionHandler.handle(e);
                }
            }
        } else {
            this.resizeColumn(value, this.getStart(), this.getEnd());
        }
        part.getTableAdapter().transEnd();
    }

    private void resizeColumn(int value, int start, int end) {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        if (start != end) {
            value = this.getTrueValue(value, start, end);
            part.resizeColumn(start, end, value);
        } else {
            Dimension dimension = this.getDragWidth(start, end);
            if (value < dimension.width) {
                value = dimension.width;
            }
            TableHandleAdapter adp = HandleAdapterFactory.getInstance().getTableHandleAdapter(part.getModel());
            Dimension dm = adp.calculateSize();
            dm.width += value;
            try {
                adp.ajustSize(dm);
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
            }
        }
    }

    private boolean isresizeMultipleColumn() {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        List list = this.filterEditPart(part.getViewer().getSelectedEditParts());
        if (list.size() < 2) {
            return false;
        }
        Object first = ((EditPart)list.get(0)).getModel();
        if (!(first instanceof ColumnHandle) || !((ColumnHandle)first).getContainer().equals(part.getModel())) {
            return false;
        }
        int i = 0;
        while (i < list.size()) {
            Object model = ((EditPart)list.get(i)).getModel();
            if (model.equals(part.getColumn(this.getStart()))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected Rectangle getMarqueeSelectionRectangle() {
        IFigure figure = ((TableEditPart)this.getSourceEditPart()).getFigure();
        Insets insets = figure.getInsets();
        int value = this.getLocation().x - this.getStartLocation().x;
        value = this.getTrueValue(value);
        Point p = this.getStartLocation().getCopy();
        figure.translateToAbsolute((Translatable)p);
        figure.translateToRelative((Translatable)p);
        Rectangle bounds = figure.getBounds().getCopy();
        figure.translateToAbsolute((Translatable)bounds);
        return new Rectangle(value + p.x, bounds.y + insets.top, 2, bounds.height - (insets.top + insets.bottom));
    }

    protected Dimension getDragWidth(int start, int end) {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        return new Dimension(part.getMinWidth(start) - this.getColumnWidth(start), Integer.MAX_VALUE);
    }

    protected void setCursor(Cursor cursor) {
        super.setCursor(cursor);
    }

    protected int getColumnWidth(int columnNumber) {
        Object column = this.getTableEditPart().getColumn(columnNumber);
        if (column == null) {
            return HandleAdapterFactory.getInstance().getTableHandleAdapter(this.getTableEditPart().getModel()).getDefaultWidth(columnNumber);
        }
        return this.getColumnWidth(column);
    }

    protected int getColumnWidth(Object column) {
        return TableUtil.caleVisualWidth(this.getTableEditPart(), column);
    }

    protected TableEditPart getTableEditPart() {
        return (TableEditPart)this.getSourceEditPart();
    }

    protected String getInfomation() {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        return this.getShowLabel(TableUtil.caleVisualWidth(part, part.getColumn(this.getStart())));
    }

    private String getShowLabel(int pix) {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        String unit = part.getTableAdapter().getHandle().getModuleHandle().getDefaultUnits();
        double doubleValue = MetricUtility.pixelToPixelInch((int)pix);
        double showValue = DimensionUtil.convertTo((double)doubleValue, (String)"in", (String)unit).getMeasure();
        return String.valueOf(PREFIX_LABEL) + " " + this.getShowValue(showValue) + " " + this.getUnitDisplayName(unit) + " (" + pix + " " + PIXELS_LABEL + ")";
    }

    private String getShowValue(double value) {
        return FORMAT.format(value);
    }

    protected boolean handleDragInProgress() {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        boolean bool = super.handleDragInProgress();
        int value = this.getTrueValue(this.getLocation().x - this.getStartLocation().x);
        int adjustWidth = TableUtil.caleVisualWidth(part, part.getColumn(this.getStart())) + value;
        this.updateInfomation(this.getShowLabel(adjustWidth));
        return bool;
    }
}

