/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.runtime.GUIException;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.AbstractToolHandleExtends;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.command.InvalidParentException;
import org.eclipse.birt.report.model.api.command.WrongTypeException;
import org.eclipse.jface.util.Assert;

public class LibraryElementsToolHandleExtends
extends AbstractToolHandleExtends {
    private DesignElementHandle elementHandle;

    public LibraryElementsToolHandleExtends(DesignElementHandle elementHandle) {
        Assert.isLegal((boolean)(elementHandle.getRoot() instanceof LibraryHandle));
        this.elementHandle = elementHandle;
    }

    public boolean preHandleMouseUp() {
        ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        LibraryHandle library = (LibraryHandle)this.elementHandle.getRoot();
        try {
            if (UIUtil.includeLibrary(moduleHandle, library)) {
                if (this.elementHandle instanceof ThemeHandle) {
                    ThemeHandle model = UIUtil.applyTheme((ThemeHandle)this.elementHandle, moduleHandle, library);
                    if (model != null) {
                        this.setModel(this.elementHandle);
                    }
                } else {
                    DesignElementHandle newHandle = moduleHandle.getElementFactory().newElementFrom(this.elementHandle, this.elementHandle.getName());
                    this.setModel(newHandle);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof InvalidParentException || e instanceof WrongTypeException) {
                GUIException exception = GUIException.createGUIException((String)"org.eclipse.birt.report.designer.ui", (Throwable)e, (String)"Library.DND.messages.outofsync");
                ExceptionHandler.handle((Throwable)exception);
            }
            ExceptionHandler.handle(e);
        }
        return super.preHandleMouseUp();
    }

    public boolean preHandleMouseDown() {
        return false;
    }
}

