/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools;

import java.util.List;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.RowHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.TableHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.TableDragGuideTracker;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.MetricUtility;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;

public class RowDragTracker
extends TableDragGuideTracker {
    private static final String RESIZE_COLUMN_TRANS_LABEL = Messages.getString((String)"RowDragTracker.ResizeRow");
    private static final String PREFIX_LABEL = Messages.getString((String)"RowDragTracker.Show.Label");

    public RowDragTracker(EditPart sourceEditPart, int start, int end) {
        super(sourceEditPart, start, end);
        this.setDisabledCursor(Cursors.SIZENS);
    }

    protected void resize() {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        int value = this.getLocation().y - this.getStartLocation().y;
        part.getTableAdapter().transStar(RESIZE_COLUMN_TRANS_LABEL);
        if (this.isresizeMultipleRow()) {
            List list = this.filterEditPart(part.getViewer().getSelectedEditParts());
            boolean resizeTable = false;
            int height = 0;
            int i = 0;
            while (i < list.size()) {
                int tempValue = value;
                Object model = ((EditPart)list.get(i)).getModel();
                RowHandleAdapter adapter = HandleAdapterFactory.getInstance().getRowHandleAdapter(model);
                int start = adapter.getRowNumber();
                int end = start + 1;
                int ori = TableUtil.caleVisualHeight(part, model);
                int adjustHeight = TableUtil.caleVisualHeight(part, part.getRow(this.getStart())) + value;
                if (this.getStart() != start) {
                    tempValue = adjustHeight - ori;
                }
                if (start == part.getRowCount()) {
                    end = start;
                    resizeTable = true;
                } else {
                    height += this.getTrueValue(tempValue, start, end);
                }
                this.resizeRow(tempValue, start, end);
                ++i;
            }
            if (resizeTable) {
                Dimension size = part.getTableAdapter().getSize();
                try {
                    part.getTableAdapter().setSize(new Dimension(size.width, size.height + height));
                }
                catch (SemanticException e) {
                    part.getTableAdapter().rollBack();
                    ExceptionHandler.handle(e);
                }
            }
        } else {
            this.resizeRow(value, this.getStart(), this.getEnd());
        }
        part.getTableAdapter().transEnd();
    }

    private void resizeRow(int value, int start, int end) {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        if (start != end) {
            value = this.getTrueValue(value, start, end);
            part.resizeRow(start, end, value);
        } else {
            Dimension dimension = this.getDragWidth(start, end);
            if (value < dimension.width) {
                value = dimension.width;
            }
            TableHandleAdapter adp = HandleAdapterFactory.getInstance().getTableHandleAdapter(part.getModel());
            Dimension dm = adp.calculateSize();
            dm.height += value;
            try {
                adp.ajustSize(dm);
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
            }
        }
    }

    private boolean isresizeMultipleRow() {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        List list = this.filterEditPart(part.getViewer().getSelectedEditParts());
        if (list.size() < 2) {
            return false;
        }
        Object first = ((EditPart)list.get(0)).getModel();
        if (!(first instanceof RowHandle) || !((RowHandle)first).getContainer().equals(part.getModel())) {
            return false;
        }
        int i = 0;
        while (i < list.size()) {
            Object model = ((EditPart)list.get(i)).getModel();
            if (model.equals(part.getRow(this.getStart()))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected Rectangle getMarqueeSelectionRectangle() {
        IFigure figure = ((TableEditPart)this.getSourceEditPart()).getFigure();
        Insets insets = figure.getInsets();
        int value = this.getLocation().y - this.getStartLocation().y;
        value = this.getTrueValue(value);
        Point p = this.getStartLocation().getCopy();
        figure.translateToAbsolute((Translatable)p);
        figure.translateToRelative((Translatable)p);
        Rectangle bounds = figure.getBounds().getCopy();
        figure.translateToAbsolute((Translatable)bounds);
        return new Rectangle(bounds.x + insets.left, value + p.y, bounds.width - (insets.left + insets.right), 2);
    }

    protected Dimension getDragWidth(int startNumber, int endNumber) {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        Object start = part.getRow(startNumber);
        return new Dimension(part.getMinHeight(startNumber) - this.getRowHeight(start), Integer.MAX_VALUE);
    }

    protected int getRowHeight(Object row) {
        return TableUtil.caleVisualHeight(this.getTableEditPart(), row);
    }

    protected int getRowHeight(int rowNumber) {
        Object row = this.getTableEditPart().getRow(rowNumber);
        return this.getRowHeight(row);
    }

    protected TableEditPart getTableEditPart() {
        return (TableEditPart)this.getSourceEditPart();
    }

    protected String getInfomation() {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        return this.getShowLabel(TableUtil.caleVisualHeight(part, part.getRow(this.getStart())));
    }

    private String getShowLabel(int pix) {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        String unit = part.getTableAdapter().getHandle().getModuleHandle().getDefaultUnits();
        double doubleValue = MetricUtility.pixelToPixelInch((int)pix);
        double showValue = DimensionUtil.convertTo((double)doubleValue, (String)"in", (String)unit).getMeasure();
        return String.valueOf(PREFIX_LABEL) + " " + this.getShowValue(showValue) + " " + this.getUnitDisplayName(unit) + " (" + pix + " " + PIXELS_LABEL + ")";
    }

    private String getShowValue(double value) {
        return FORMAT.format(value);
    }

    protected boolean handleDragInProgress() {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        boolean bool = super.handleDragInProgress();
        int value = this.getTrueValue(this.getLocation().y - this.getStartLocation().y);
        int adjustWidth = TableUtil.caleVisualHeight(part, part.getRow(this.getStart())) + value;
        this.updateInfomation(this.getShowLabel(adjustWidth));
        return bool;
    }
}

