/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.resourcelocator;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.BaseResourceEntity;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntry;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FragmentResourceEntry
extends BaseResourceEntity {
    public static final String TEMPLATE_ROOT = "templates";
    public static final String RESOURCE_ROOT = "resources";
    protected Bundle bundle;
    protected String name;
    protected String displayName;
    private FragmentResourceEntry parent;
    private String path;
    private List children = new ArrayList();
    private LibraryHandle library;
    private CssStyleSheetHandle cssStyleHandle;
    protected boolean isRoot;
    private boolean isFile;
    private final Collection<URL> parsedEntries = new HashSet<URL>();
    private FileFilter filter;

    public FragmentResourceEntry() {
        this(null);
    }

    public FragmentResourceEntry(String[] filePattern, String name, String displayName, String path) {
        this(filePattern, name, displayName, path, Platform.getBundle((String)"org.eclipse.birt.resources"));
    }

    public FragmentResourceEntry(String[] filePattern, String name, String displayName, String path, Bundle bundle) {
        this(name, displayName, path, null, false, true);
        if (filePattern != null) {
            this.filter = new FileFilter(filePattern);
        }
        this.bundle = bundle;
        if (bundle != null) {
            Enumeration<URL> enumeration = this.findEntries(path);
            this.parseResourceEntry(this, enumeration);
            this.parsedEntries.clear();
        }
    }

    public FragmentResourceEntry(String[] filePattern) {
        this(filePattern, Messages.getString((String)"FragmentResourceEntry.RootName"), Messages.getString((String)"FragmentResourceEntry.RootDisplayName"), RESOURCE_ROOT);
    }

    private void parseResourceEntry(FragmentResourceEntry parent, Enumeration<URL> enumeration) {
        while (enumeration != null && enumeration.hasMoreElements()) {
            URL element = enumeration.nextElement();
            String path = element.getPath();
            File file = null;
            try {
                file = new File(FileLocator.toFileURL((URL)element).getPath());
            }
            catch (IOException iOException) {
                continue;
            }
            FragmentResourceEntry entry = new FragmentResourceEntry(file.getName(), path, parent, file.isFile());
            entry.bundle = Platform.getBundle((String)"org.eclipse.birt.resources");
            this.parsedEntries.add(element);
            Enumeration<URL> children = this.findEntries(path);
            if (children == null) continue;
            this.parseResourceEntry(entry, children);
        }
    }

    protected FragmentResourceEntry(String name, String displayName, String path, FragmentResourceEntry parent, boolean isFile, boolean isRoot) {
        this(name, path, parent, isFile);
        this.isRoot = isRoot;
        this.displayName = displayName;
    }

    protected FragmentResourceEntry(String name, String path, FragmentResourceEntry parent, boolean isFile) {
        this.name = name;
        this.path = path;
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
        this.isFile = isFile;
    }

    private void addChild(FragmentResourceEntry entry) {
        this.children.add(entry);
    }

    private FragmentResourceEntry getChild(String name) {
        for (FragmentResourceEntry entry : this.children) {
            if (!entry.getName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    @Override
    public ResourceEntry[] getChildren() {
        return this.children.toArray(new ResourceEntry[this.children.size()]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public Image getImage() {
        if (this.isRoot || !this.isFile()) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        return super.getImage();
    }

    @Override
    public ResourceEntry getParent() {
        return this.parent;
    }

    @Override
    public URL getURL() {
        if (this.bundle != null) {
            return this.bundle.getResource(this.path);
        }
        return null;
    }

    @Override
    public boolean isFile() {
        return this.isFile;
    }

    @Override
    public boolean isRoot() {
        return this.isRoot;
    }

    @Override
    public void dispose() {
        if (this.library != null) {
            this.library.close();
            this.library = null;
        }
        if (this.cssStyleHandle != null) {
            this.cssStyleHandle = null;
        }
        ResourceEntry[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == LibraryHandle.class && this.getURL().toString().toLowerCase().endsWith("library")) {
            if (!this.hasChildren() && this.library == null) {
                try {
                    this.library = SessionHandleAdapter.getInstance().getSessionHandle().openLibrary(FileLocator.toFileURL((URL)this.getURL()).toString());
                }
                catch (Exception exception) {}
            }
            return this.library;
        }
        if (adapter == CssStyleSheetHandle.class) {
            if (this.cssStyleHandle == null && this.getURL().toString().toLowerCase().endsWith(".css")) {
                try {
                    this.cssStyleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle().openCssStyleSheet(FileLocator.toFileURL((URL)this.getURL()).toString());
                }
                catch (Exception exception) {}
            }
            return this.cssStyleHandle;
        }
        return super.getAdapter(adapter);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof FragmentResourceEntry) && !(object instanceof String)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof FragmentResourceEntry) {
            FragmentResourceEntry temp = (FragmentResourceEntry)object;
            if (temp.path.equals(this.path)) {
                return true;
            }
        } else if (object instanceof String && object.equals(this.path)) {
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    private Enumeration<URL> findEntries(String path) {
        HashSet<URL> entries = new HashSet<URL>();
        Enumeration children = this.bundle.findEntries(path, null, false);
        while (children != null && children.hasMoreElements()) {
            URL url = (URL)children.nextElement();
            if (this.filter != null && (this.filter == null || !this.filter.accept(url))) continue;
            entries.add(url);
        }
        children = this.bundle.findEntries(path, null, false);
        while (children != null && children.hasMoreElements()) {
            URL child = (URL)children.nextElement();
            if (this.isParsed(child) || !this.hasChildren(child)) continue;
            entries.add(child);
        }
        return new Vector(entries).elements();
    }

    private boolean hasChildren(URL url) {
        Enumeration children = this.bundle.findEntries(url.getPath(), null, false);
        return children != null && children.hasMoreElements();
    }

    private boolean isParsed(URL url) {
        return this.parsedEntries.contains(url);
    }

    class FileFilter {
        private String[] filePattern;

        public FileFilter(String[] filePattern) {
            this.filePattern = filePattern;
        }

        public boolean accept(URL path) {
            int i = 0;
            while (i < this.filePattern.length) {
                String[] regs = this.filePattern[i].split(";");
                int j = 0;
                while (j < regs.length) {
                    if (URLDecoder.decode(path.toString()).toLowerCase().endsWith(regs[j].toLowerCase().substring(1))) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
            return false;
        }
    }
}

