/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.ui.views.IReportResourceChangeEvent;
import org.eclipse.birt.report.designer.ui.views.IReportResourceChangeListener;
import org.eclipse.birt.report.designer.ui.views.IReportResourceSynchronizer;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;

public class ReportResourceSynchronizer
implements IReportResourceSynchronizer {
    private int[] eventTypes = new int[]{1, 2};
    private Map<Integer, List<IReportResourceChangeListener>> listeners = new HashMap<Integer, List<IReportResourceChangeListener>>();
    protected boolean disabled = false;

    private void internalAddListener(int type, IReportResourceChangeListener listener) {
        List<IReportResourceChangeListener> list = this.listeners.get(type);
        if (list == null) {
            list = new ArrayList<IReportResourceChangeListener>();
            this.listeners.put(type, list);
        }
        list.add(listener);
    }

    public void addListener(int type, IReportResourceChangeListener listener) {
        if (this.disabled) {
            return;
        }
        int i = 0;
        while (i < this.eventTypes.length) {
            if ((type & this.eventTypes[i]) != 0) {
                this.internalAddListener(this.eventTypes[i], listener);
            }
            ++i;
        }
    }

    public void removeListener(int type, IReportResourceChangeListener listener) {
        if (this.disabled) {
            return;
        }
        int i = 0;
        while (i < this.eventTypes.length) {
            if ((type & this.eventTypes[i]) != 0) {
                this.internalRemoveListener(this.eventTypes[i], listener);
            }
            ++i;
        }
    }

    private void internalRemoveListener(int type, IReportResourceChangeListener listener) {
        List<IReportResourceChangeListener> list = this.listeners.get(type);
        if (list != null) {
            list.remove(listener);
        }
    }

    protected void notifyListeners(final IReportResourceChangeEvent event) {
        System.out.println(event);
        List<IReportResourceChangeListener> list = this.listeners.get(event.getType());
        if (list == null) {
            return;
        }
        int i = 0;
        while (i < list.size()) {
            final IReportResourceChangeListener rcl = list.get(i);
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    rcl.resourceChanged(event);
                }
            });
            ++i;
        }
    }

    public void notifyResourceChanged(IReportResourceChangeEvent event) {
        if (this.disabled) {
            return;
        }
        this.notifyListeners(event);
    }
}

