/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.views.actions.GlobalCopyAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.GlobalCutAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.GlobalDeleteAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.GlobalInsertAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.GlobalInsertRowAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.GlobalPasteAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.GlobalRedoAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.GlobalStackAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.GlobalUndoAction;
import org.eclipse.birt.report.designer.ui.actions.NewDataSetAction;
import org.eclipse.birt.report.designer.ui.actions.NewDataSourceAction;
import org.eclipse.birt.report.designer.ui.actions.NewJointDataSetAction;
import org.eclipse.birt.report.designer.ui.actions.NewParameterAction;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.actions.ActionFactory;

public class GlobalActionFactory {
    public static final String COPY = ActionFactory.COPY.getId();
    public static final String CUT = ActionFactory.CUT.getId();
    public static final String PASTE = ActionFactory.PASTE.getId();
    public static final String DELETE = ActionFactory.DELETE.getId();
    public static final String UNDO = ActionFactory.UNDO.getId();
    public static final String REDO = ActionFactory.REDO.getId();
    public static final String[] GLOBAL_SELECTION_ACTIONS = new String[]{COPY, CUT, PASTE, DELETE};
    public static final String[] GLOBAL_STACK_ACTIONS = new String[]{UNDO, REDO};
    public static final String[] GLOBAL_INSERT_ACTIONS = new String[]{"Insert Text", "Insert Label", "Insert Data", "Insert Image", "Insert Grid", "Insert List", "Insert Table", "Insert Dynamic Text"};
    public static final String[] GLOBAL_PARAMETER_ACTIONS = new String[]{"org.eclipse.birt.report.designer.ui.actions.newScalarParameter", "org.eclipse.birt.report.designer.ui.actions.newCascadingParameterGroup", "org.eclipse.birt.report.designer.ui.actions.newParameterGroup"};
    public static final String[] GLOBAL_ELEMENT_ACTIONS = new String[]{"org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertRowAboveAction", "org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertRowBelowAction"};
    public static final String[] GLOBAL_DATA_ACTIONS = new String[]{"org.eclipse.birt.report.designer.ui.actions.NewDataSourceAction", "org.eclipse.birt.report.designer.ui.actions.NewDataSetAction", "org.eclipse.birt.report.designer.ui.actions.NewJointDataSetAction"};
    private static Map stackActionEntrys = new HashMap();

    public static IAction createSelectionAction(String id, ISelectionProvider provider) {
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)provider);
        if (COPY.equals(id)) {
            return new GlobalCopyAction(provider);
        }
        if (CUT.equals(id)) {
            return new GlobalCutAction(provider);
        }
        if (PASTE.equals(id)) {
            return new GlobalPasteAction(provider);
        }
        if (DELETE.equals(id)) {
            return new GlobalDeleteAction(provider);
        }
        if ("org.eclipse.birt.report.designer.ui.actions.NewDataSourceAction".equals(id)) {
            return new NewDataSourceAction();
        }
        if ("org.eclipse.birt.report.designer.ui.actions.NewDataSetAction".equals(id)) {
            return new NewDataSetAction();
        }
        if ("org.eclipse.birt.report.designer.ui.actions.NewJointDataSetAction".equals(id)) {
            return new NewJointDataSetAction();
        }
        String elementType = null;
        if ("Insert Text".equals(id)) {
            elementType = "Text";
        } else if ("Insert Label".equals(id)) {
            elementType = "Label";
        } else if ("Insert Data".equals(id)) {
            elementType = "Data";
        } else if ("Insert Image".equals(id)) {
            elementType = "Image";
        } else if ("Insert Grid".equals(id)) {
            elementType = "Grid";
        } else if ("Insert List".equals(id)) {
            elementType = "List";
        } else if ("Insert Table".equals(id)) {
            elementType = "Table";
        } else if ("Insert Dynamic Text".equals(id)) {
            elementType = "TextData";
        } else {
            if ("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertRowAboveAction".equals(id)) {
                return new GlobalInsertRowAction(provider, id, "above");
            }
            if ("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertRowBelowAction".equals(id)) {
                return new GlobalInsertRowAction(provider, id, "below");
            }
            if ("org.eclipse.birt.report.designer.ui.actions.newScalarParameter".equals(id)) {
                return new NewParameterAction(id, "ScalarParameter");
            }
            if ("org.eclipse.birt.report.designer.ui.actions.newCascadingParameterGroup".equals(id)) {
                return new NewParameterAction(id, "CascadingParameterGroup");
            }
            if ("org.eclipse.birt.report.designer.ui.actions.newParameterGroup".equals(id)) {
                return new NewParameterAction(id, "ParameterGroup");
            }
            if (DEUtil.getMetaDataDictionary().getExtension(id) != null) {
                elementType = id;
            }
        }
        if (elementType != null) {
            GlobalInsertAction action = new GlobalInsertAction(provider, id, elementType);
            action.setText(DEUtil.getElementDefn((String)elementType).getDisplayName());
            return action;
        }
        return null;
    }

    public static IAction createStackAction(String id, CommandStack stack) {
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)stack);
        GlobalStackActionEntry entry = (GlobalStackActionEntry)stackActionEntrys.get(stack);
        if (entry == null) {
            entry = new GlobalStackActionEntry(stack);
            stackActionEntrys.put(stack, entry);
        }
        return entry.getAction(id);
    }

    public static void removeStackActions(CommandStack stack) {
        stackActionEntrys.remove(stack);
    }

    private static class GlobalStackActionEntry {
        private GlobalUndoAction undoAction = null;
        private GlobalRedoAction redoAction = null;
        private CommandStack stack;

        public GlobalStackActionEntry(CommandStack stack) {
            this.stack = stack;
        }

        public GlobalStackAction getAction(String id) {
            GlobalStackAction action = null;
            if (UNDO.equals(id)) {
                if (this.undoAction == null) {
                    this.undoAction = new GlobalUndoAction(this.stack);
                }
                action = this.undoAction;
            } else if (REDO.equals(id)) {
                if (this.redoAction == null) {
                    this.redoAction = new GlobalRedoAction(this.stack);
                }
                action = this.redoAction;
            }
            if (action != null) {
                action.update();
            }
            return action;
        }
    }
}

