/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.dialogs.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.HighlightRuleBuilder;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;

public class HighlightHandleProvider {
    private static final HighlightRuleHandle[] EMPTY = new HighlightRuleHandle[0];
    protected DesignElementHandle elementHandle;
    public static int EXPRESSION_TYPE_ROW = 0;
    public static int EXPRESSION_TYPE_DATA = 1;
    private int expressionType;

    public HighlightHandleProvider() {
        this.expressionType = EXPRESSION_TYPE_ROW;
    }

    public HighlightHandleProvider(int expressionType) {
        this.expressionType = expressionType;
    }

    public int getExpressionType() {
        return this.expressionType;
    }

    public void setExpressionType(int expressionType) {
        this.expressionType = expressionType;
    }

    public static String getFontFamily(String fontFamily) {
        String destFontName = (String)DesignerConstants.familyMap.get(fontFamily);
        if (destFontName == null) {
            destFontName = fontFamily;
        }
        return destFontName;
    }

    public StyleHandle getStyleHandle() {
        return this.elementHandle.getStyle();
    }

    public DesignElementHandle getDesignElementHandle() {
        return this.elementHandle;
    }

    public String getColumnText(Object element, int columnIndex) {
        HighlightRuleHandle handle = (HighlightRuleHandle)element;
        switch (columnIndex) {
            case 0: {
                return String.valueOf(Messages.getString((String)"HighlightHandleProvider.text.Preview")) + DEUtil.getFontSize((String)handle.getFontSize().getStringValue()) + ")";
            }
            case 1: {
                String exp = String.valueOf(this.resolveNull(handle.getTestExpression())) + " " + HighlightRuleBuilder.getNameForOperator(handle.getOperator());
                int vv = HighlightRuleBuilder.determineValueVisible(handle.getOperator());
                if (vv == 1) {
                    exp = String.valueOf(exp) + " " + this.resolveNull(handle.getValue1());
                } else if (vv == 2) {
                    exp = String.valueOf(exp) + " " + this.resolveNull(handle.getValue1()) + " , " + this.resolveNull(handle.getValue2());
                } else if (vv == 3) {
                    exp = String.valueOf(exp) + " ";
                    int count = handle.getValue1List().size();
                    int i = 0;
                    while (i < count) {
                        exp = i == 0 ? String.valueOf(exp) + handle.getValue1List().get(i).toString() : String.valueOf(exp) + "; " + handle.getValue1List().get(i).toString();
                        ++i;
                    }
                }
                return exp;
            }
        }
        return "";
    }

    private String resolveNull(String src) {
        if (src == null) {
            return "";
        }
        return src;
    }

    public boolean doSwapItem(int pos, int direction) throws PropertyValueException {
        PropertyHandle phandle = this.elementHandle.getPropertyHandle("highlightRules");
        if (direction < 0) {
            phandle.moveItem(pos, pos - 1);
        } else {
            phandle.moveItem(pos, pos + 1);
        }
        return true;
    }

    public boolean doDeleteItem(int pos) throws PropertyValueException {
        PropertyHandle phandle = this.elementHandle.getPropertyHandle("highlightRules");
        phandle.removeItem(pos);
        return true;
    }

    public HighlightRuleHandle doAddItem(HighlightRule rule, int pos) {
        PropertyHandle phandle = this.elementHandle.getPropertyHandle("highlightRules");
        try {
            phandle.addItem((IStructure)rule);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
        StructureHandle handle = rule.getHandle((SimpleValueHandle)phandle, pos);
        return (HighlightRuleHandle)handle;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            inputElement = ((List)inputElement).size() > 0 ? ((List)inputElement).get(0) : null;
        }
        if (inputElement instanceof DesignElementHandle) {
            this.elementHandle = (DesignElementHandle)inputElement;
            PropertyHandle highRules = this.elementHandle.getPropertyHandle("highlightRules");
            ArrayList list = new ArrayList();
            for (Object o : highRules) {
                list.add(o);
            }
            return list.toArray(new HighlightRuleHandle[0]);
        }
        return EMPTY;
    }
}

