/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.property.widgets;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Timer;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.SpinnerTimeLayout;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.SpinnerTimeText;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class SpinnerTime
extends Composite
implements ActionListener,
IPropertyChangeListener {
    private Button up = null;
    private Button down = null;
    private Label label = null;
    private SpinnerTimeText hour = null;
    private SpinnerTimeText min = null;
    private SpinnerTimeText sec = null;
    private Label firstLabel = null;
    private Timer timer = null;
    private Label lastLabel = null;
    static SpinnerTimeText defaultText = null;
    private int value = 1;
    private final int delay = 150;
    private ArrayList listenerList = new ArrayList();

    public SpinnerTime(Composite parent, int style) {
        this(parent, style, 0, 0, 0);
    }

    public SpinnerTime(Composite parent, int style, int hour, int min, int sec) {
        super(parent, style | 0x800);
        defaultText = null;
        this.initComponents();
        this.hour.setValue(String.valueOf(hour));
        this.min.setValue(String.valueOf(min));
        this.sec.setValue(String.valueOf(sec));
        this.setLayout(new SpinnerTimeLayout());
        this.initActions();
        this.setSize(86, 28);
        this.timer = new Timer(150, this);
    }

    public void actionPerformed(ActionEvent evt) {
        this.buttonAction(this.value, false);
    }

    protected void checkWidget() {
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listenerList.add(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listenerList.remove(listener);
    }

    public void firePropertyListener(PropertyChangeEvent e) {
        int size = this.listenerList.size();
        int i = 0;
        while (i < size) {
            IPropertyChangeListener listener = (IPropertyChangeListener)this.listenerList.get(i);
            listener.propertyChange(e);
            ++i;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.firePropertyListener(event);
    }

    private void initComponents() {
        this.hour = new SpinnerTimeText(this, 0, 24, "hourchange");
        this.firstLabel = new Label((Composite)this, 0);
        this.min = new SpinnerTimeText(this, 0, 60, "minchange");
        this.lastLabel = new Label((Composite)this, 0);
        this.sec = new SpinnerTimeText(this, 0, 60, "secchange");
        Font font = FontManager.getFont((String)"Dialog", (int)10, (int)1);
        this.firstLabel.setBackground(Display.getCurrent().getSystemColor(1));
        this.lastLabel.setBackground(Display.getCurrent().getSystemColor(1));
        this.firstLabel.setFont(font);
        this.lastLabel.setFont(font);
        this.firstLabel.setForeground(Display.getCurrent().getSystemColor(2));
        this.lastLabel.setForeground(Display.getCurrent().getSystemColor(2));
        this.firstLabel.setText(":");
        this.lastLabel.setText(":");
        this.up = new Button((Composite)this, 132);
        this.down = new Button((Composite)this, 1028);
        this.label = new Label((Composite)this, 0);
        this.label.setBackground(Display.getCurrent().getSystemColor(1));
    }

    private void initActions() {
        this.up.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                SpinnerTime.this.value = 1;
                SpinnerTime.this.timer.start();
            }

            public void mouseUp(MouseEvent e) {
                SpinnerTime.this.timer.stop();
                SpinnerTime.this.buttonAction(1, true);
            }
        });
        this.down.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                SpinnerTime.this.value = -1;
                SpinnerTime.this.timer.start();
            }

            public void mouseUp(MouseEvent e) {
                SpinnerTime.this.timer.stop();
                SpinnerTime.this.buttonAction(-1, true);
            }
        });
        this.hour.addPropertyChangeListener(this);
        this.min.addPropertyChangeListener(this);
        this.sec.addPropertyChangeListener(this);
    }

    private SpinnerTimeText getDefaultText() {
        if (defaultText == null) {
            defaultText = this.hour;
        }
        return defaultText;
    }

    private void buttonAction(int increat, boolean needFocus) {
        try {
            int value = Integer.parseInt(this.getDefaultText().getValue());
        }
        catch (Exception exception) {
            return;
        }
        SpinnerTimeText text = this.getDefaultText();
        text.setValue(String.valueOf(value += increat));
        if (needFocus) {
            text.forceFocus();
        }
        text.selectAll();
    }

    private int transValue(int value, int limit) {
        if (limit == 0) {
            return value;
        }
        if ((value %= limit) < 0) {
            value += limit;
        }
        return value;
    }

    public SpinnerTimeInfo getTimeInfo() {
        return new SpinnerTimeInfo(Integer.parseInt(this.hour.getValue()), Integer.parseInt(this.min.getValue()), Integer.parseInt(this.sec.getValue()));
    }

    public void setTimeInfo(SpinnerTimeInfo info) {
        int hourValue = this.transValue(info.getHour(), this.hour.limit);
        this.hour.value = String.valueOf(hourValue);
        this.hour.setText(String.valueOf(hourValue));
        int minValue = this.transValue(info.getMin(), this.min.limit);
        this.min.value = String.valueOf(minValue);
        this.min.setText(String.valueOf(minValue));
        int secValue = this.transValue(info.getSec(), this.sec.limit);
        this.sec.value = String.valueOf(secValue);
        this.sec.setText(String.valueOf(secValue));
    }

    public static class SpinnerTimeInfo {
        private int hour;
        private int min;
        private int sec;

        public SpinnerTimeInfo(int hour, int min, int sec) {
            this.hour = hour;
            this.min = min;
            this.sec = sec;
        }

        public int getHour() {
            return this.hour;
        }

        public void setHour(int hour) {
            this.hour = hour;
        }

        public int getMin() {
            return this.min;
        }

        public void setMin(int min) {
            this.min = min;
        }

        public int getSec() {
            return this.sec;
        }

        public void setSec(int sec) {
            this.sec = sec;
        }
    }
}

