/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.property.widgets;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Timer;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.SpinnerText;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.SpinnerYearLayout;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class SpinnerYear
extends Composite
implements ActionListener {
    private Button up = null;
    private Button down = null;
    private Text text = null;
    private Label label = null;
    private String textContend = "";
    private Timer timer = null;
    private ArrayList listenerList = new ArrayList();
    private int value = 1;
    private final int delay = 150;

    public SpinnerYear(Composite parent, int style) {
        this(parent, style, 0);
    }

    public SpinnerYear(Composite parent, int style, int year) {
        super(parent, style | 0x800);
        this.initComponents();
        this.initActions();
        this.setLayout(new SpinnerYearLayout());
        this.initParent();
        this.textContend = String.valueOf(year);
        this.text.setText(this.textContend);
        this.timer = new Timer(150, this);
    }

    public void actionPerformed(ActionEvent evt) {
        this.buttonAction(this.value);
    }

    private void initParent() {
        this.setSize(65, 28);
    }

    private void initComponents() {
        this.up = new Button((Composite)this, 132);
        this.down = new Button((Composite)this, 1028);
        this.text = new SpinnerText(this, 0);
        this.label = new Label((Composite)this, 0);
        this.label.setBackground(Display.getCurrent().getSystemColor(1));
        this.text.setFont(FontManager.getFont((String)"Dialog", (int)12, (int)1));
        this.text.setTextLimit(5);
    }

    private void initActions() {
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SpinnerYear.this.setText(SpinnerYear.this.text.getText());
            }
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13) {
                    SpinnerYear.this.setText(SpinnerYear.this.text.getText());
                }
            }
        });
        this.up.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                SpinnerYear.this.value = 1;
                SpinnerYear.this.timer.start();
            }

            public void mouseUp(MouseEvent e) {
                SpinnerYear.this.timer.stop();
                SpinnerYear.this.buttonAction(1);
            }
        });
        this.down.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                SpinnerYear.this.value = -1;
                SpinnerYear.this.timer.start();
            }

            public void mouseUp(MouseEvent e) {
                SpinnerYear.this.timer.stop();
                SpinnerYear.this.buttonAction(-1);
            }
        });
    }

    private void setText(String text) {
        int value;
        try {
            value = Integer.parseInt(text);
        }
        catch (Exception exception) {
            this.text.setText(this.textContend);
            return;
        }
        if (value < 0) {
            this.text.setText(this.textContend);
            return;
        }
        this.firePropertyListener(new PropertyChangeEvent(new Object(), "yearchange", (Object)new Integer(Integer.parseInt(this.textContend)), (Object)new Integer(value)));
        this.textContend = text;
        this.text.setText(this.textContend);
    }

    private void buttonAction(int increat) {
        try {
            int value = Integer.parseInt(this.textContend);
        }
        catch (Exception exception) {
            return;
        }
        this.setText(String.valueOf(value += increat));
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listenerList.add(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listenerList.remove(listener);
    }

    public void firePropertyListener(PropertyChangeEvent e) {
        int size = this.listenerList.size();
        int i = 0;
        while (i < size) {
            IPropertyChangeListener listener = (IPropertyChangeListener)this.listenerList.get(i);
            listener.propertyChange(e);
            ++i;
        }
    }

    public void setYear(int year) {
        this.textContend = String.valueOf(year);
        this.text.setText(this.textContend);
    }

    public int getYear() {
        return Integer.parseInt(this.textContend);
    }
}

