/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatDateTimePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatNumberPage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatStringPage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatPage;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class FormatBuilder
extends BaseDialog {
    public static final int STRING = 1;
    public static final int NUMBER = 2;
    public static final int DATETIME = 3;
    public static final int DATE = 4;
    public static final int TIME = 5;
    private static final String DLG_TITLE = Messages.getString((String)"FormatBuilder.Title");
    private IFormatPage page;
    private String formatCategory = null;
    private String formatPattern = null;
    private String previewText = null;
    private int type;

    public FormatBuilder(int type) {
        super(DLG_TITLE);
        Assert.isLegal((type == 1 || type == 2 || type == 3 || type == 4 || type == 5 ? 1 : 0) != 0);
        this.type = type;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        switch (this.type) {
            case 1: {
                this.page = new FormatStringPage(composite, 0, 0);
                break;
            }
            case 2: {
                this.page = new FormatNumberPage(composite, 0, 0);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.page = new FormatDateTimePage(composite, this.type, 0, 0);
            }
        }
        ((Composite)this.page).setLayoutData((Object)new GridData(1808));
        UIUtil.bindHelp((Control)composite, "org.eclipse.birt.cshelp.FormatBuilder_ID");
        return composite;
    }

    public void setPreviewText(String previewText) {
        this.previewText = previewText;
    }

    public void setInputFormat(String formatCategroy, String formatPattern) {
        Assert.isLegal((!StringUtil.isBlank((String)formatCategroy) ? 1 : 0) != 0);
        this.formatCategory = formatCategroy;
        this.formatPattern = formatPattern;
    }

    protected boolean initDialog() {
        this.page.setInput(this.formatCategory, this.formatPattern);
        this.page.setPreviewText(this.previewText);
        return true;
    }

    protected void okPressed() {
        if (this.page.isFormatModified()) {
            this.setResult(new String[]{this.page.getCategory(), this.page.getPattern()});
            super.okPressed();
        } else {
            this.cancelPressed();
        }
    }
}

