/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.data.ui.util.SelectValueFetcher;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ExpressionFilter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ResourceEditDialog;
import org.eclipse.birt.report.designer.internal.ui.extension.IUseCubeQueryList;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.MultiValueCombo;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.ValueCombo;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.dialogs.provider.MapHandleProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.SelectValueDialog;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.AlphabeticallyComparator;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.MapRuleHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class MapRuleBuilder
extends BaseDialog {
    private final String NULL_STRING;
    protected IExpressionProvider expressionProvider;
    protected transient String bindingName = null;
    protected ReportElementHandle currentItem = null;
    protected String[] popupItems = null;
    protected static String[] EMPTY_ARRAY = new String[0];
    public static final String DLG_TITLE_NEW = Messages.getString((String)"MapRuleBuilder.DialogTitle.New");
    public static final String DLG_TITLE_EDIT = Messages.getString((String)"MapRuleBuilder.DialogTitle.Edit");
    protected List compositeList = new ArrayList();
    static final String[][] OPERATOR;
    protected List valueList = new ArrayList();
    private MapRuleHandle handle;
    private MapHandleProvider provider;
    private int handleCount;
    protected Combo expression;
    protected Combo operator;
    private Text display;
    protected Composite valueListComposite;
    protected MultiValueCombo addExpressionValue;
    protected Button addBtn;
    protected Button editBtn;
    protected Button delBtn;
    protected Button delAllBtn;
    protected Table table;
    protected TableViewer tableViewer;
    protected int valueVisible;
    private ValueCombo expressionValue1;
    private ValueCombo expressionValue2;
    private Label andLable;
    private Text resourceKeytext;
    private Button btnBrowse;
    private Button btnReset;
    protected DesignElementHandle designHandle;
    protected static final String VALUE_OF_THIS_DATA_ITEM;
    protected static String[] actions;
    private ParamBindingHandle[] bindingParams = null;
    protected List columnList;
    private static final String[] EMPTY;
    protected SelectionListener expSelListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (MapRuleBuilder.this.expression.getText().equals(VALUE_OF_THIS_DATA_ITEM) && MapRuleBuilder.this.designHandle instanceof DataItemHandle) {
                if (MapRuleBuilder.this.designHandle.getContainer() instanceof ExtendedItemHandle) {
                    MapRuleBuilder.this.expression.setText(DEUtil.getDataExpression((String)((DataItemHandle)MapRuleBuilder.this.designHandle).getResultSetColumn()));
                } else {
                    MapRuleBuilder.this.expression.setText(DEUtil.getColumnExpression((String)((DataItemHandle)MapRuleBuilder.this.designHandle).getResultSetColumn()));
                }
            } else {
                String newValue = MapRuleBuilder.this.expression.getText();
                String value = DEUtil.getExpression((Object)MapRuleBuilder.this.getResultSetColumn(newValue));
                if (value != null) {
                    newValue = value;
                }
                MapRuleBuilder.this.expression.setText(newValue);
            }
            MapRuleBuilder.this.updateButtons();
        }
    };
    protected MultiValueCombo.ISelection mAddExpValueAction = new MultiValueCombo.ISelection(){

        public String[] doSelection(String input) {
            String[] retValue = null;
            Iterator iter = MapRuleBuilder.this.columnList.iterator();
            while (iter.hasNext()) {
                String columnName = ((ComputedColumnHandle)iter.next()).getName();
                if (!DEUtil.getColumnExpression((String)columnName).equals(MapRuleBuilder.this.expression.getText())) continue;
                MapRuleBuilder.this.bindingName = columnName;
                break;
            }
            ExpressionBuilder dialog = new ExpressionBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), input);
            if (MapRuleBuilder.this.expressionProvider == null) {
                dialog.setExpressionProvier(new ExpressionProvider(MapRuleBuilder.this.designHandle));
            } else {
                dialog.setExpressionProvier(MapRuleBuilder.this.expressionProvider);
            }
            if (dialog.open() == 0 && dialog.getResult().length() != 0) {
                retValue = new String[]{dialog.getResult()};
            }
            return retValue;
        }

        public void doAfterSelection(MultiValueCombo combo) {
            MapRuleBuilder.this.mAddSelValueAction.doAfterSelection(combo);
        }
    };
    protected MultiValueCombo.ISelection mAddSelValueAction = new MultiValueCombo.ISelection(){

        public String[] doSelection(String input) {
            String[] retValue = null;
            Iterator iter = MapRuleBuilder.this.columnList.iterator();
            while (iter.hasNext()) {
                String columnName = ((ComputedColumnHandle)iter.next()).getName();
                if (MapRuleBuilder.this.expression.getText().equals(VALUE_OF_THIS_DATA_ITEM) && MapRuleBuilder.this.designHandle instanceof DataItemHandle) {
                    if (MapRuleBuilder.this.designHandle.getContainer() instanceof ExtendedItemHandle) {
                        if (!DEUtil.getDataExpression((String)columnName).equals(MapRuleBuilder.this.expression.getText())) continue;
                        MapRuleBuilder.this.bindingName = columnName;
                        break;
                    }
                    if (!DEUtil.getColumnExpression((String)columnName).equals(MapRuleBuilder.this.expression.getText())) continue;
                    MapRuleBuilder.this.bindingName = columnName;
                    break;
                }
                String value = DEUtil.getExpression((Object)MapRuleBuilder.this.getResultSetColumn(columnName));
                if (value == null || !value.equals(MapRuleBuilder.this.expression.getText())) continue;
                MapRuleBuilder.this.bindingName = columnName;
                break;
            }
            if (MapRuleBuilder.this.bindingName != null) {
                try {
                    List selectValueList = MapRuleBuilder.this.getSelectValueList();
                    SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ExpressionValueCellEditor.title"));
                    dialog.setSelectedValueList(selectValueList);
                    if (MapRuleBuilder.this.bindingParams != null) {
                        dialog.setBindingParams(MapRuleBuilder.this.bindingParams);
                    }
                    dialog.setMultipleSelection(true);
                    if (dialog.open() == 0) {
                        retValue = dialog.getSelectedExprValues();
                    }
                }
                catch (Exception ex) {
                    MessageDialog.openError(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)(String.valueOf(Messages.getString((String)"SelectValueDialog.messages.error.selectVauleUnavailable")) + "\n" + ex.getMessage()));
                }
            } else if (MapRuleBuilder.this.designHandle instanceof TabularCubeHandle) {
                DataSetHandle dataSet = ((TabularCubeHandle)MapRuleBuilder.this.designHandle).getDataSet();
                String expressionString = MapRuleBuilder.this.expression.getText();
                try {
                    List selectValueList = SelectValueFetcher.getSelectValueList(expressionString, dataSet);
                    SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ExpressionValueCellEditor.title"));
                    dialog.setSelectedValueList(selectValueList);
                    dialog.setMultipleSelection(true);
                    if (dialog.open() == 0) {
                        retValue = dialog.getSelectedExprValues();
                    }
                }
                catch (BirtException e1) {
                    MessageDialog.openError(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)(String.valueOf(Messages.getString((String)"SelectValueDialog.messages.error.selectVauleUnavailable")) + "\n" + e1.getMessage()));
                }
            } else {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)Messages.getString((String)"SelectValueDialog.messages.info.selectVauleUnavailable"));
            }
            return retValue;
        }

        public void doAfterSelection(MultiValueCombo combo) {
            MapRuleBuilder.this.addBtn.setEnabled(false);
            if (MapRuleBuilder.this.addExpressionValue.getSelStrings().length == 1) {
                MapRuleBuilder.this.addExpressionValue.setText(DEUtil.resolveNull((String)MapRuleBuilder.this.addExpressionValue.getSelStrings()[0]));
            } else if (MapRuleBuilder.this.addExpressionValue.getSelStrings().length > 1) {
                MapRuleBuilder.this.addExpressionValue.setText("");
            }
            boolean change = false;
            int i = 0;
            while (i < MapRuleBuilder.this.addExpressionValue.getSelStrings().length) {
                if (MapRuleBuilder.this.valueList.indexOf(DEUtil.resolveNull((String)MapRuleBuilder.this.addExpressionValue.getSelStrings()[i])) < 0) {
                    MapRuleBuilder.this.valueList.add(DEUtil.resolveNull((String)MapRuleBuilder.this.addExpressionValue.getSelStrings()[i]));
                    change = true;
                }
                ++i;
            }
            if (change) {
                MapRuleBuilder.this.tableViewer.refresh();
                MapRuleBuilder.this.updateButtons();
                MapRuleBuilder.this.addExpressionValue.setFocus();
            }
        }
    };
    protected ITableLabelProvider tableLableProvier = new ITableLabelProvider(){

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return (String)element;
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    protected IStructuredContentProvider tableContentProvider = new IStructuredContentProvider(){

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return null;
        }
    };
    private Listener textModifyListener = new Listener(){

        public void handleEvent(Event event) {
            MapRuleBuilder.this.updateButtons();
        }
    };
    protected ValueCombo.ISelection expValueAction = new ValueCombo.ISelection(){

        public String doSelection(String input) {
            String retValue = null;
            ExpressionBuilder dialog = new ExpressionBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), input);
            if (MapRuleBuilder.this.expressionProvider == null) {
                dialog.setExpressionProvier(new ExpressionProvider(MapRuleBuilder.this.designHandle));
            } else {
                dialog.setExpressionProvier(MapRuleBuilder.this.expressionProvider);
            }
            if (dialog.open() == 0) {
                retValue = dialog.getResult();
            }
            return retValue;
        }
    };
    protected ValueCombo.ISelection selectValueAction = new ValueCombo.ISelection(){

        public String doSelection(String input) {
            String retValue = null;
            Iterator iter = MapRuleBuilder.this.columnList.iterator();
            while (iter.hasNext()) {
                String columnName = ((ComputedColumnHandle)iter.next()).getName();
                if (MapRuleBuilder.this.expression.getText().equals(VALUE_OF_THIS_DATA_ITEM) && MapRuleBuilder.this.designHandle instanceof DataItemHandle) {
                    if (MapRuleBuilder.this.designHandle.getContainer() instanceof ExtendedItemHandle) {
                        if (!DEUtil.getDataExpression((String)columnName).equals(MapRuleBuilder.this.expression.getText())) continue;
                        MapRuleBuilder.this.bindingName = columnName;
                        break;
                    }
                    if (!DEUtil.getColumnExpression((String)columnName).equals(MapRuleBuilder.this.expression.getText())) continue;
                    MapRuleBuilder.this.bindingName = columnName;
                    break;
                }
                String value = DEUtil.getExpression((Object)MapRuleBuilder.this.getResultSetColumn(columnName));
                if (value == null || !value.equals(MapRuleBuilder.this.expression.getText())) continue;
                MapRuleBuilder.this.bindingName = columnName;
                break;
            }
            if (MapRuleBuilder.this.bindingName != null) {
                List selectValueList;
                block15: {
                    selectValueList = MapRuleBuilder.this.getSelectValueList();
                    if (selectValueList != null && selectValueList.size() != 0) break block15;
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)Messages.getString((String)"SelectValueDialog.messages.info.selectVauleUnavailable"));
                    return null;
                }
                try {
                    SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ExpressionValueCellEditor.title"));
                    dialog.setSelectedValueList(selectValueList);
                    if (MapRuleBuilder.this.bindingParams != null) {
                        dialog.setBindingParams(MapRuleBuilder.this.bindingParams);
                    }
                    if (dialog.open() == 0) {
                        retValue = dialog.getSelectedExprValue();
                    }
                }
                catch (Exception ex) {
                    MessageDialog.openError(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)(String.valueOf(Messages.getString((String)"SelectValueDialog.messages.error.selectVauleUnavailable")) + "\n" + ex.getMessage()));
                }
            } else if (MapRuleBuilder.this.designHandle instanceof TabularCubeHandle) {
                DataSetHandle dataSet = ((TabularCubeHandle)MapRuleBuilder.this.designHandle).getDataSet();
                String expressionString = MapRuleBuilder.this.expression.getText();
                try {
                    List selectValueList = SelectValueFetcher.getSelectValueList(expressionString, dataSet);
                    SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ExpressionValueCellEditor.title"));
                    dialog.setSelectedValueList(selectValueList);
                    if (dialog.open() == 0) {
                        retValue = dialog.getSelectedExprValue();
                    }
                }
                catch (BirtException e1) {
                    MessageDialog.openError(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)(String.valueOf(Messages.getString((String)"SelectValueDialog.messages.error.selectVauleUnavailable")) + "\n" + e1.getMessage()));
                }
            } else {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)Messages.getString((String)"SelectValueDialog.messages.info.selectVauleUnavailable"));
            }
            return retValue;
        }
    };

    static {
        IChoiceSet chset = ChoiceSetFactory.getStructChoiceSet("MapRule", "operator");
        IChoice[] chs = chset.getChoices((Comparator)new AlphabeticallyComparator());
        OPERATOR = new String[chs.length][2];
        int i = 0;
        while (i < chs.length) {
            MapRuleBuilder.OPERATOR[i][0] = chs[i].getDisplayName();
            MapRuleBuilder.OPERATOR[i][1] = chs[i].getName();
            ++i;
        }
        VALUE_OF_THIS_DATA_ITEM = Messages.getString((String)"HighlightRuleBuilderDialog.choice.ValueOfThisDataItem");
        actions = new String[]{Messages.getString((String)"ExpressionValueCellEditor.selectValueAction"), Messages.getString((String)"ExpressionValueCellEditor.buildExpressionAction")};
        EMPTY = new String[0];
    }

    public static String getValueForOperator(String name) {
        int i = 0;
        while (i < OPERATOR.length) {
            if (OPERATOR[i][0].equals(name)) {
                return OPERATOR[i][1];
            }
            ++i;
        }
        return null;
    }

    public static int determineValueVisible(String operatorValue) {
        if ("any".equals(operatorValue) || "is-false".equals(operatorValue) || "is-true".equals(operatorValue) || "is-null".equals(operatorValue) || "is-not-null".equals(operatorValue)) {
            return 0;
        }
        if ("lt".equals(operatorValue) || "le".equals(operatorValue) || "eq".equals(operatorValue) || "ne".equals(operatorValue) || "ge".equals(operatorValue) || "gt".equals(operatorValue) || "like".equals(operatorValue)) {
            return 1;
        }
        if ("between".equals(operatorValue) || "not-between".equals(operatorValue)) {
            return 2;
        }
        if ("in".equals(operatorValue) || "not-in".equals(operatorValue)) {
            return 3;
        }
        return 1;
    }

    public static String getNameForOperator(String value) {
        int i = 0;
        while (i < OPERATOR.length) {
            if (OPERATOR[i][1].equals(value)) {
                return OPERATOR[i][0];
            }
            ++i;
        }
        return "";
    }

    static int getIndexForOperatorValue(String value) {
        int i = 0;
        while (i < OPERATOR.length) {
            if (OPERATOR[i][1].equals(value)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public MapRuleBuilder(Shell parentShell, String title, MapHandleProvider provider) {
        super(parentShell, title);
        this.NULL_STRING = null;
        this.provider = provider;
    }

    private String[] getDataSetColumns() {
        if (this.columnList.isEmpty()) {
            return EMPTY;
        }
        String[] values = new String[this.columnList.size()];
        int i = 0;
        while (i < this.columnList.size()) {
            values[i] = ((ComputedColumnHandle)this.columnList.get(i)).getName();
            ++i;
        }
        return values;
    }

    protected Object getResultSetColumn(String name) {
        if (this.columnList.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < this.columnList.size()) {
            ComputedColumnHandle column = (ComputedColumnHandle)this.columnList.get(i);
            if (column.getName().equals(name)) {
                return column;
            }
            ++i;
        }
        return null;
    }

    protected Control createContents(Composite parent) {
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.AddEditMapRule_ID");
        this.refreshList();
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout());
        contents.setLayoutData((Object)new GridData(1808));
        this.createTitleArea(contents);
        Composite composite = new Composite(contents, 0);
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.verticalSpacing = 0;
        composite.setLayout((Layout)glayout);
        composite.setLayoutData((Object)new GridData(1808));
        MapRuleBuilder.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        Composite innerParent = (Composite)this.createDialogArea(composite);
        this.createButtonBar(composite);
        Label lb = new Label(innerParent, 0);
        lb.setText(Messages.getString((String)"MapRuleBuilderDialog.text.Condition"));
        Composite condition = new Composite(innerParent, 0);
        GridData gdata = new GridData(768);
        gdata.heightHint = 180;
        condition.setLayoutData((Object)gdata);
        glayout = new GridLayout(4, false);
        condition.setLayout((Layout)glayout);
        this.expression = new Combo(condition, 0);
        gdata = new GridData();
        gdata.widthHint = 120;
        this.expression.setLayoutData((Object)gdata);
        this.expression.setItems(this.getDataSetColumns());
        this.fillExpression(this.expression);
        this.expression.addSelectionListener(this.expSelListener);
        this.expression.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MapRuleBuilder.this.updateButtons();
            }
        });
        Button expBuilder = new Button(condition, 8);
        UIUtil.setExpressionButtonImage(expBuilder);
        expBuilder.setToolTipText(Messages.getString((String)"HighlightRuleBuilderDialog.tooltip.ExpBuilder"));
        expBuilder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapRuleBuilder.this.editValue((Control)MapRuleBuilder.this.expression);
            }
        });
        this.operator = new Combo(condition, 8);
        int i = 0;
        while (i < OPERATOR.length) {
            this.operator.add(OPERATOR[i][0]);
            ++i;
        }
        this.operator.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapRuleBuilder.this.update2ValueStatus();
            }
        });
        this.refreshList();
        this.create2ValueComposite(condition);
        lb = new Label(innerParent, 0);
        lb.setText(Messages.getString((String)"MapRuleBuilderDialog.text.Display"));
        Composite format = new Composite(innerParent, 0);
        format.setLayoutData((Object)new GridData(768));
        glayout = new GridLayout();
        format.setLayout((Layout)glayout);
        this.display = new Text(format, 2048);
        gdata = new GridData();
        gdata.widthHint = 300;
        this.display.setLayoutData((Object)gdata);
        Composite space = new Composite(innerParent, 0);
        gdata = new GridData(768);
        gdata.heightHint = 20;
        space.setLayoutData((Object)gdata);
        this.createResourceKeyArea(innerParent);
        lb = new Label(innerParent, 258);
        lb.setLayoutData((Object)new GridData(768));
        if (this.handle != null) {
            this.syncViewProperties();
        } else {
            this.update2ValueStatus();
        }
        this.updateButtons();
        return composite;
    }

    protected int create2ValueComposite(Composite condition) {
        if (this.expressionValue1 != null && !this.expressionValue1.isDisposed()) {
            return 0;
        }
        this.disposeComposites();
        GridData gd = new GridData(768);
        gd.minimumWidth = 110;
        gd.heightHint = 20;
        this.expressionValue1 = new ValueCombo(condition, 0);
        this.expressionValue1.setLayoutData(gd);
        this.expressionValue1.setItems(this.popupItems);
        this.expressionValue1.addListener(24, this.textModifyListener);
        this.expressionValue1.addSelectionListener(0, this.selectValueAction);
        this.expressionValue1.addSelectionListener(1, this.expValueAction);
        this.compositeList.add(this.expressionValue1);
        Composite dummy = this.createDummy(condition, 3);
        this.compositeList.add(dummy);
        this.andLable = new Label(condition, 0);
        this.andLable.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.AND"));
        this.andLable.setVisible(false);
        this.compositeList.add(this.andLable);
        dummy = this.createDummy(condition, 3);
        this.compositeList.add(dummy);
        this.expressionValue2 = new ValueCombo(condition, 0);
        this.expressionValue2.setLayoutData(gd);
        this.expressionValue2.setItems(this.popupItems);
        this.compositeList.add(this.expressionValue2);
        this.expressionValue2.addListener(24, this.textModifyListener);
        this.expressionValue2.addSelectionListener(0, this.selectValueAction);
        this.expressionValue2.addSelectionListener(1, this.expValueAction);
        this.expressionValue2.setVisible(false);
        if (this.operator.getItemCount() > 0 && this.operator.getSelectionIndex() == -1) {
            this.operator.select(0);
        }
        condition.getParent().layout(true, true);
        if (condition.getShell() != null) {
            condition.getShell().pack();
        }
        return 1;
    }

    private void delTableValue() {
        int index = this.table.getSelectionIndex();
        if (index > -1) {
            this.valueList.remove(index);
            this.tableViewer.refresh();
            if (this.valueList.size() > 0) {
                if (this.valueList.size() <= index) {
                    --index;
                }
                this.table.select(index);
            }
            this.updateButtons();
        } else {
            this.delBtn.setEnabled(false);
        }
    }

    private void editTableValue() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection.getFirstElement() != null && selection.getFirstElement() instanceof String) {
            String initValue = (String)selection.getFirstElement();
            ExpressionBuilder expressionBuilder = new ExpressionBuilder(this.getShell(), initValue);
            if (this.designHandle != null) {
                if (this.expressionProvider == null) {
                    expressionBuilder.setExpressionProvier(new ExpressionProvider(this.designHandle));
                } else {
                    expressionBuilder.setExpressionProvier(this.expressionProvider);
                }
            }
            if (expressionBuilder.open() == 0) {
                String result = DEUtil.resolveNull((String)expressionBuilder.getResult());
                if (result.length() == 0) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString((String)"MapRuleBuilderDialog.MsgDlg.Title"), (String)Messages.getString((String)"MapRuleBuilderDialog.MsgDlg.Msg"));
                    return;
                }
                int index = this.table.getSelectionIndex();
                this.valueList.remove(index);
                this.valueList.add(index, result);
                this.tableViewer.refresh();
                this.table.select(index);
            }
            this.updateButtons();
        } else {
            this.editBtn.setEnabled(false);
        }
    }

    private int createValueListComposite(Composite parent) {
        if (this.valueListComposite != null && !this.valueListComposite.isDisposed()) {
            return 0;
        }
        this.disposeComposites();
        this.valueListComposite = new Composite(parent, 0);
        GridData gdata = new GridData(768);
        gdata.horizontalSpan = 4;
        this.valueListComposite.setLayoutData((Object)gdata);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        this.valueListComposite.setLayout((Layout)layout);
        this.compositeList.add(this.valueListComposite);
        Group group = new Group(this.valueListComposite, 0);
        GridData data = new GridData(768);
        data.heightHint = 118;
        data.horizontalSpan = 3;
        data.horizontalIndent = 0;
        data.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 4;
        group.setLayout((Layout)layout);
        new Label((Composite)group, 0).setText(Messages.getString((String)"FilterConditionBuilder.label.value"));
        GridData expgd = new GridData();
        expgd.widthHint = 100;
        this.addExpressionValue = new MultiValueCombo((Composite)group, 0);
        this.addExpressionValue.setLayoutData(expgd);
        this.addBtn = new Button((Composite)group, 8);
        this.addBtn.setText(Messages.getString((String)"FilterConditionBuilder.button.add"));
        this.addBtn.setToolTipText(Messages.getString((String)"FilterConditionBuilder.button.add.tooltip"));
        this.setButtonLayoutData(this.addBtn);
        this.addBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String value = MapRuleBuilder.this.addExpressionValue.getText().trim();
                if (MapRuleBuilder.this.valueList.indexOf(value) < 0) {
                    MapRuleBuilder.this.valueList.add(value);
                    MapRuleBuilder.this.tableViewer.refresh();
                    MapRuleBuilder.this.updateButtons();
                    MapRuleBuilder.this.addExpressionValue.setFocus();
                    MapRuleBuilder.this.addExpressionValue.setText("");
                } else {
                    MapRuleBuilder.this.addBtn.setEnabled(false);
                }
            }
        });
        new Label((Composite)group, 0);
        int tableStyle = 68356;
        this.table = new Table((Composite)group, tableStyle);
        data = new GridData(1808);
        data.horizontalSpan = 4;
        this.table.setLayoutData((Object)data);
        this.table.setHeaderVisible(false);
        this.table.setLinesVisible(true);
        String[] columNames = new String[]{Messages.getString((String)"FilterConditionBuilder.list.item1")};
        int[] columLength = new int[]{288};
        int i = 0;
        while (i < columNames.length) {
            TableColumn column = new TableColumn(this.table, 0, i);
            column.setText(columNames[i]);
            column.setWidth(columLength[i]);
            ++i;
        }
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                MapRuleBuilder.this.checkEditDelButtonStatus();
            }
        });
        this.table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    MapRuleBuilder.this.delTableValue();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                MapRuleBuilder.this.editTableValue();
            }
        });
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(columNames);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.tableLableProvier);
        this.tableViewer.setContentProvider((IContentProvider)this.tableContentProvider);
        Composite rightPart = new Composite(this.valueListComposite, 0);
        data = new GridData(1816);
        rightPart.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        rightPart.setLayout((Layout)layout);
        this.editBtn = new Button(rightPart, 8);
        this.editBtn.setText(Messages.getString((String)"FilterConditionBuilder.button.edit"));
        this.editBtn.setToolTipText(Messages.getString((String)"FilterConditionBuilder.button.edit.tooltip"));
        this.setButtonLayoutData(this.editBtn);
        this.editBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                MapRuleBuilder.this.editTableValue();
            }
        });
        this.delBtn = new Button(rightPart, 8);
        this.delBtn.setText(Messages.getString((String)"FilterConditionBuilder.button.delete"));
        this.delBtn.setToolTipText(Messages.getString((String)"FilterConditionBuilder.button.delete.tooltip"));
        this.setButtonLayoutData(this.delBtn);
        this.delBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                MapRuleBuilder.this.delTableValue();
            }
        });
        this.delAllBtn = new Button(rightPart, 8);
        this.delAllBtn.setText(Messages.getString((String)"FilterConditionBuilder.button.deleteall"));
        this.delAllBtn.setToolTipText(Messages.getString((String)"FilterConditionBuilder.button.deleteall.tooltip"));
        this.setButtonLayoutData(this.delAllBtn);
        this.delAllBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int count = MapRuleBuilder.this.valueList.size();
                if (count > 0) {
                    MapRuleBuilder.this.valueList.clear();
                    MapRuleBuilder.this.tableViewer.refresh();
                    MapRuleBuilder.this.updateButtons();
                } else {
                    MapRuleBuilder.this.delAllBtn.setEnabled(false);
                }
            }
        });
        this.addExpressionValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MapRuleBuilder.this.checkAddButtonStatus();
                MapRuleBuilder.this.updateButtons();
            }
        });
        this.addExpressionValue.addSelectionListener(0, this.mAddSelValueAction);
        this.addExpressionValue.addSelectionListener(1, this.mAddExpValueAction);
        this.addExpressionValue.setItems(this.popupItems);
        parent.getParent().layout(true, true);
        if (parent.getShell() != null) {
            parent.getShell().pack();
        }
        return 1;
    }

    protected void checkAddButtonStatus() {
        if (this.addExpressionValue != null && !this.addExpressionValue.isDisposed()) {
            String value = this.addExpressionValue.getText();
            if (value == null || value.length() == 0 || value.trim().length() == 0) {
                this.addBtn.setEnabled(false);
                return;
            }
            if (value != null) {
                value = value.trim();
            }
            if (this.valueList.indexOf(value) < 0) {
                this.addBtn.setEnabled(true);
            } else {
                this.addBtn.setEnabled(false);
            }
        }
    }

    protected void checkEditDelButtonStatus() {
        StructuredSelection selection;
        boolean enabled;
        if (this.tableViewer == null) {
            return;
        }
        boolean bl = enabled = this.tableViewer.getSelection() != null;
        if (enabled && this.tableViewer.getSelection() instanceof StructuredSelection && (selection = (StructuredSelection)this.tableViewer.getSelection()).toList().size() <= 0) {
            enabled = false;
        }
        this.editBtn.setEnabled(enabled);
        this.delBtn.setEnabled(enabled);
        enabled = this.table.getItemCount() > 0;
        this.delAllBtn.setEnabled(enabled);
    }

    private void disposeComposites() {
        if (this.compositeList.size() > 0) {
            int count = this.compositeList.size();
            int i = 0;
            while (i < count) {
                Object obj = this.compositeList.get(i);
                if (obj != null && obj instanceof Widget && !((Widget)obj).isDisposed()) {
                    ((Widget)obj).dispose();
                }
                ++i;
            }
        }
        this.compositeList.clear();
    }

    private void update2ValueStatus() {
        String value = MapRuleBuilder.getValueForOperator(this.operator.getText());
        this.valueVisible = MapRuleBuilder.determineValueVisible(value);
        if (this.valueVisible == 3) {
            int ret = this.createValueListComposite(this.operator.getParent());
            if (ret != 0) {
                if (this.handle != null) {
                    this.valueList = new ArrayList(this.handle.getValue1List());
                }
                this.tableViewer.setInput((Object)this.valueList);
            }
        } else {
            int ret = this.create2ValueComposite(this.operator.getParent());
            if (ret != 0 && this.handle != null) {
                this.expressionValue1.setText(DEUtil.resolveNull((String)this.handle.getValue1()));
                this.expressionValue2.setText(DEUtil.resolveNull((String)this.handle.getValue2()));
            }
        }
        if (this.valueVisible == 0) {
            this.expressionValue1.setVisible(false);
            this.expressionValue2.setVisible(false);
            this.andLable.setVisible(false);
        } else if (this.valueVisible == 1) {
            this.expressionValue1.setVisible(true);
            this.expressionValue2.setVisible(false);
            this.andLable.setVisible(false);
        } else if (this.valueVisible == 2) {
            this.expressionValue1.setVisible(true);
            this.expressionValue2.setVisible(true);
            this.andLable.setVisible(true);
        }
        this.updateButtons();
    }

    private void refreshList() {
        ArrayList<String> finalItems = new ArrayList<String>(10);
        int n = 0;
        while (n < actions.length) {
            finalItems.add(actions[n]);
            ++n;
        }
        this.popupItems = finalItems.toArray(EMPTY_ARRAY);
    }

    private List getSelectValueList() throws BirtException {
        List selectValueList = new ArrayList();
        ReportItemHandle reportItem = DEUtil.getBindingHolder((DesignElementHandle)this.currentItem);
        if (this.bindingName != null && reportItem != null) {
            Object[] arrays;
            Object[] obj;
            if (reportItem instanceof ExtendedItemHandle && (obj = ElementAdapterManager.getAdapters(reportItem, IUseCubeQueryList.class)) instanceof Object[] && (arrays = obj).length == 1 && arrays[0] != null) {
                List valueList = ((IUseCubeQueryList)arrays[0]).getQueryList(this.expression.getText(), (ExtendedItemHandle)reportItem);
                selectValueList.addAll(valueList);
            }
            if (selectValueList.size() == 0) {
                selectValueList = SelectValueFetcher.getSelectValueList(this.expression.getText(), reportItem.getDataSet(), false);
            }
        } else {
            ExceptionHandler.openErrorMessageBox(Messages.getString((String)"SelectValueDialog.errorRetrievinglist"), Messages.getString((String)"SelectValueDialog.noExpressionSet"));
        }
        return selectValueList;
    }

    private Composite createResourceKeyArea(Composite parent) {
        Composite resourceKeyArea = new Composite(parent, 0);
        resourceKeyArea.setLayoutData((Object)new GridData(768));
        GridLayout glayout = new GridLayout(4, false);
        resourceKeyArea.setLayout((Layout)glayout);
        GridData gd = new GridData(768);
        resourceKeyArea.setLayoutData((Object)gd);
        Label lb = new Label(resourceKeyArea, 0);
        lb.setText(Messages.getString((String)"MapRuleBuilder.Button.ResourceKey"));
        this.resourceKeytext = new Text(resourceKeyArea, 2056);
        this.resourceKeytext.setLayoutData((Object)new GridData(768));
        this.btnBrowse = new Button(resourceKeyArea, 8);
        this.btnBrowse.setLayoutData((Object)new GridData());
        this.btnBrowse.setText("...");
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapRuleBuilder.this.handleBrowserSelectedEvent();
            }
        });
        this.btnReset = new Button(resourceKeyArea, 8);
        this.btnReset.setLayoutData((Object)new GridData());
        this.btnReset.setText(Messages.getString((String)"MapRuleBuilder.Button.Reset"));
        this.btnReset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapRuleBuilder.this.handleSelectedEvent(null);
            }
        });
        this.checkResourceKey();
        Label noteLabel = new Label(parent, 64);
        gd = new GridData(768);
        gd.horizontalSpan = 4;
        gd.widthHint = 350;
        noteLabel.setLayoutData((Object)gd);
        noteLabel.setText(Messages.getString((String)"I18nPage.text.Note"));
        return resourceKeyArea;
    }

    protected void handleBrowserSelectedEvent() {
        ResourceEditDialog dlg = new ResourceEditDialog(this.btnBrowse.getShell(), Messages.getString((String)"ResourceKeyDescriptor.title.SelectKey"));
        dlg.setResourceURL(this.provider.getResourceURL());
        if (dlg.open() == 0) {
            this.handleSelectedEvent((String)dlg.getResult());
        }
    }

    private void handleSelectedEvent(String newValue) {
        if ("".equals(newValue)) {
            newValue = null;
        }
        this.resourceKeytext.setText(DEUtil.resolveNull((String)newValue));
    }

    private Composite createTitleArea(Composite parent) {
        int heightMargins = 3;
        int widthMargins = 8;
        final Composite titleArea = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = heightMargins;
        layout.marginWidth = widthMargins;
        titleArea.setLayout((Layout)layout);
        Display display = parent.getDisplay();
        Color background = JFaceColors.getBannerBackground((Display)display);
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 20 + heightMargins * 2;
        titleArea.setLayoutData((Object)layoutData);
        titleArea.setBackground(background);
        titleArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(titleArea.getDisplay().getSystemColor(18));
                Rectangle bounds = titleArea.getClientArea();
                bounds.height -= 2;
                --bounds.width;
                e.gc.drawRectangle(bounds);
            }
        });
        Label label = new Label(titleArea, 0);
        label.setBackground(background);
        label.setFont(FontManager.getFont((String)label.getFont().toString(), (int)10, (int)1));
        label.setText(this.getTitle());
        return titleArea;
    }

    private Composite createDummy(Composite parent, int colSpan) {
        Composite dummy = new Composite(parent, 0);
        GridData gdata = new GridData();
        gdata.widthHint = 22;
        gdata.horizontalSpan = colSpan;
        gdata.heightHint = 10;
        dummy.setLayoutData((Object)gdata);
        return dummy;
    }

    private Text createText(Composite parent) {
        Text txt = new Text(parent, 2048);
        GridData gdata = new GridData(768);
        gdata.widthHint = 100;
        txt.setLayoutData((Object)gdata);
        return txt;
    }

    public void updateHandle(MapRuleHandle handle, int handleCount) {
        this.handle = handle;
        this.handleCount = handleCount;
    }

    public void setDesignHandle(DesignElementHandle handle) {
        this.designHandle = handle;
        this.initializeProviderType();
        this.inilializeColumnList(handle);
        this.initializeParamterBinding(handle);
    }

    public void setReportElement(ReportElementHandle reportItem) {
        this.currentItem = reportItem;
    }

    protected void inilializeColumnList(DesignElementHandle handle) {
        this.columnList = DEUtil.getVisiableColumnBindingsList((DesignElementHandle)handle);
    }

    private void initializeParamterBinding(DesignElementHandle handle) {
        if (handle instanceof ReportItemHandle) {
            ReportItemHandle inputHandle = (ReportItemHandle)handle;
            ArrayList<ParamBindingHandle> list = new ArrayList<ParamBindingHandle>();
            Iterator iterator = inputHandle.paramBindingsIterator();
            while (iterator.hasNext()) {
                ParamBindingHandle paramBindingHandle = (ParamBindingHandle)iterator.next();
                list.add(paramBindingHandle);
            }
            this.bindingParams = new ParamBindingHandle[list.size()];
            list.toArray(this.bindingParams);
        }
    }

    public MapRuleHandle getHandle() {
        return this.handle;
    }

    private void fillExpression(Combo control) {
        if (this.handle != null) {
            this.handle.getTestExpression();
        }
        if (this.designHandle instanceof DataItemHandle && ((DataItemHandle)this.designHandle).getResultSetColumn() != null) {
            control.add(VALUE_OF_THIS_DATA_ITEM);
        }
        if (control.getItemCount() == 0) {
            control.add(DEUtil.resolveNull(null));
            control.select(control.getItemCount() - 1);
        }
    }

    protected void updateButtons() {
        this.enableInput(this.isExpressionOK());
        this.getOkButton().setEnabled(this.isConditionOK());
    }

    private void enableInput(boolean val) {
        this.operator.setEnabled(val);
        if (this.valueVisible != 3) {
            if (this.expressionValue1 != null && !this.expressionValue1.isDisposed()) {
                this.expressionValue1.setEnabled(val);
            }
            if (this.expressionValue2 != null && !this.expressionValue2.isDisposed()) {
                this.expressionValue2.setEnabled(val);
            }
            if (this.andLable != null && !this.andLable.isDisposed()) {
                this.andLable.setEnabled(val);
            }
        } else {
            this.setControlEnable((Control)this.valueListComposite, val);
            if (val) {
                this.checkAddButtonStatus();
                this.checkEditDelButtonStatus();
            }
        }
        this.display.setEnabled(val);
    }

    protected void setControlEnable(Control control, boolean bool) {
        if (control == null || control.isDisposed()) {
            return;
        }
        control.setEnabled(bool);
        Composite tmp = null;
        if (control instanceof Composite) {
            tmp = (Composite)control;
        }
        if (tmp != null && tmp.getChildren() != null) {
            int i = 0;
            while (i < tmp.getChildren().length) {
                this.setControlEnable(tmp.getChildren()[i], bool);
                ++i;
            }
        }
    }

    private boolean isExpressionOK() {
        if (this.expression == null) {
            return false;
        }
        return this.expression.getText() != null && this.expression.getText().length() != 0;
    }

    private boolean isConditionOK() {
        if (this.expression == null) {
            return false;
        }
        if (!this.isExpressionOK()) {
            return false;
        }
        return this.checkValues();
    }

    private boolean checkValues() {
        if (this.valueVisible == 3) {
            return this.valueList.size() > 0;
        }
        if (this.expressionValue1.getVisible() && (this.expressionValue1.getText() == null || this.expressionValue1.getText().length() == 0)) {
            return false;
        }
        return !this.expressionValue2.getVisible() || this.expressionValue2.getText() != null && this.expressionValue2.getText().length() != 0;
    }

    private void syncViewProperties() {
        this.expression.setText(DEUtil.resolveNull((String)this.handle.getTestExpression()));
        this.operator.select(MapRuleBuilder.getIndexForOperatorValue(this.handle.getOperator()));
        String value = MapRuleBuilder.getValueForOperator(this.operator.getText());
        this.valueVisible = MapRuleBuilder.determineValueVisible(value);
        if (this.valueVisible == 3) {
            this.createValueListComposite(this.operator.getParent());
            if (this.handle != null) {
                this.valueList = new ArrayList(this.handle.getValue1List());
            }
            this.tableViewer.setInput((Object)this.valueList);
        } else {
            this.create2ValueComposite(this.operator.getParent());
            if (this.handle != null) {
                this.expressionValue1.setText(DEUtil.resolveNull((String)this.handle.getValue1()));
                this.expressionValue2.setText(DEUtil.resolveNull((String)this.handle.getValue2()));
            }
        }
        this.valueVisible = MapRuleBuilder.determineValueVisible(this.handle.getOperator());
        if (this.valueVisible == 0) {
            this.expressionValue1.setVisible(false);
            this.expressionValue2.setVisible(false);
            this.andLable.setVisible(false);
        } else if (this.valueVisible == 1) {
            this.expressionValue1.setVisible(true);
            this.expressionValue2.setVisible(false);
            this.andLable.setVisible(false);
        } else if (this.valueVisible == 2) {
            this.expressionValue1.setVisible(true);
            this.expressionValue2.setVisible(true);
            this.andLable.setVisible(true);
        } else if (this.valueVisible == 3) {
            if (this.expression.getText().length() == 0) {
                this.valueListComposite.setEnabled(false);
            } else {
                this.valueListComposite.setEnabled(true);
            }
        }
        this.display.setText(DEUtil.resolveNull((String)this.handle.getDisplay()));
        this.resourceKeytext.setText(DEUtil.resolveNull((String)this.handle.getDisplayKey()));
    }

    protected void okPressed() {
        try {
            this.valueVisible = MapRuleBuilder.determineValueVisible(DEUtil.resolveNull((String)MapRuleBuilder.getValueForOperator(this.operator.getText())));
            if (this.handle == null) {
                MapRule rule = StructureFactory.createMapRule();
                rule.setProperty("operator", (Object)DEUtil.resolveNull((String)MapRuleBuilder.getValueForOperator(this.operator.getText())));
                if (this.valueVisible == 3) {
                    rule.setValue1(this.valueList);
                    rule.setValue2("");
                } else {
                    if (this.expressionValue1.isVisible()) {
                        rule.setProperty("value1", (Object)DEUtil.resolveNull((String)this.expressionValue1.getText()));
                    }
                    if (this.expressionValue2.isVisible()) {
                        rule.setProperty("value2", (Object)DEUtil.resolveNull((String)this.expressionValue2.getText()));
                    }
                }
                rule.setProperty("display", (Object)DEUtil.resolveNull((String)this.display.getText()));
                rule.setTestExpression(DEUtil.resolveNull((String)this.expression.getText()));
                this.handle = this.provider.doAddItem(rule, this.handleCount);
            } else {
                this.handle.setOperator(DEUtil.resolveNull((String)MapRuleBuilder.getValueForOperator(this.operator.getText())));
                if (this.valueVisible != 3) {
                    if (this.expressionValue1.isVisible()) {
                        this.handle.setValue1(DEUtil.resolveNull((String)this.expressionValue1.getText()));
                    } else {
                        this.handle.setValue1(this.NULL_STRING);
                    }
                    if (this.expressionValue2.isVisible()) {
                        this.handle.setValue2(DEUtil.resolveNull((String)this.expressionValue2.getText()));
                    } else {
                        this.handle.setValue2(this.NULL_STRING);
                    }
                } else {
                    this.handle.setValue1(this.valueList);
                    this.handle.setValue2("");
                }
                this.handle.setDisplay(DEUtil.resolveNull((String)this.display.getText()));
                this.handle.setDisplayKey(DEUtil.resolveNull((String)this.resourceKeytext.getText()));
                this.handle.setTestExpression(DEUtil.resolveNull((String)this.expression.getText()));
            }
        }
        catch (Exception e) {
            WidgetUtil.processError(this.getShell(), e);
        }
        super.okPressed();
    }

    private void editValue(Control control) {
        String initValue = null;
        if (control instanceof Text) {
            initValue = ((Text)control).getText();
        } else if (control instanceof Combo) {
            initValue = ((Combo)control).getText();
        }
        ExpressionBuilder expressionBuilder = new ExpressionBuilder(this.getShell(), initValue);
        if (this.designHandle != null) {
            ExpressionProvider expressionProvider = new ExpressionProvider(this.designHandle);
            expressionProvider.addFilter(new ExpressionFilter(){

                public boolean select(Object parentElement, Object element) {
                    return !"Category".equals(parentElement) || !ExpressionProvider.CURRENT_CUBE.equals(element);
                }
            });
            expressionBuilder.setExpressionProvier(expressionProvider);
        }
        if (expressionBuilder.open() == 0) {
            String result = DEUtil.resolveNull((String)expressionBuilder.getResult());
            if (control instanceof Text) {
                ((Text)control).setText(result);
            } else if (control instanceof Combo) {
                ((Combo)control).setText(result);
            }
        }
        this.updateButtons();
    }

    private void checkResourceKey() {
        this.checkResourceKey(null);
    }

    private void checkResourceKey(MapRuleHandle handle) {
        this.resourceKeytext.setEnabled(true);
        this.btnBrowse.setEnabled(true);
        this.btnReset.setEnabled(true);
        String baseName = this.provider.getBaseName();
        if (baseName == null) {
            this.btnBrowse.setEnabled(false);
        } else {
            URL resource = this.provider.getResourceURL();
            String path = null;
            try {
                if (resource != null) {
                    path = DEUtil.getFilePathFormURL((URL)resource);
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
            if (resource == null || path == null || !new File(path).exists()) {
                this.btnBrowse.setEnabled(false);
            } else {
                this.btnBrowse.setEnabled(true);
            }
        }
        if (handle != null) {
            this.resourceKeytext.setText(DEUtil.resolveNull((String)handle.getDisplayKey()));
        }
    }

    protected String getExpression(String resultSet) {
        if (this.provider.getExpressionType() == MapHandleProvider.EXPRESSION_TYPE_ROW) {
            return DEUtil.getColumnExpression((String)resultSet);
        }
        if (this.provider.getExpressionType() == MapHandleProvider.EXPRESSION_TYPE_DATA) {
            return DEUtil.getDataExpression((String)resultSet);
        }
        return null;
    }

    private void initializeProviderType() {
        if (this.designHandle instanceof DataItemHandle) {
            DataItemHandle dataItem = (DataItemHandle)this.designHandle;
            if (dataItem.getContainer() instanceof ExtendedItemHandle) {
                this.provider.setExpressionType(MapHandleProvider.EXPRESSION_TYPE_DATA);
            } else {
                this.provider.setExpressionType(MapHandleProvider.EXPRESSION_TYPE_ROW);
            }
        }
    }
}

