/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceFileFolderSelectionDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceSelectionValidator;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.model.api.IncludedCssStyleSheetHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.css.StyleSheetException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class UseCssInReportDialog
extends TitleAreaDialog {
    protected Logger logger = Logger.getLogger(UseCssInReportDialog.class.getName());
    private static final String DIALOG_TITLE = Messages.getString((String)"UseCssInReportDialog.Wizard.Title");
    private static final String TITLE_AREA_TITLE = Messages.getString((String)"UseCssInReportDialog.TitleArea.Title");
    private static final String TITLE_AREA_MESSAGE = Messages.getString((String)"UseCssInReportDialog.TitleArea.Message");
    private static final String DIALOG_BROWSE = Messages.getString((String)"UseCssInReportDialog.Dialog.Browse");
    private static final String DIALOG_BROWSE_TITLE = Messages.getString((String)"UseCssInReportDialog.Dialog.Browse.Title");
    private static final String DIALOG_LABEL_NOFILE = Messages.getString((String)"UseCssInReportDialog.Label.No.File");
    private String dialogTitle = DIALOG_TITLE;
    private String areaTitle = TITLE_AREA_TITLE;
    private String areaMsg = TITLE_AREA_MESSAGE;
    private Text fileNameField;
    Button selectButton;
    private Label stylesTitle;
    private Table stylesTable;
    private Table notificationsTable;
    private Map styleMap = new HashMap();
    private List styleNames = new ArrayList();
    private List unSupportedStyleNames = new ArrayList();
    private IncludedCssStyleSheetHandle includedCssHandle;
    private CssStyleSheetHandle cssHandle;
    private String fileName;
    private String uri;
    private Button viewTimeBtn;
    private Text uriText;

    public void setDialogTitle(String dlgTitle) {
        this.dialogTitle = dlgTitle;
    }

    public void setTitle(String title) {
        this.areaTitle = title;
        super.setTitle(this.areaTitle);
    }

    public void setMsg(String msg) {
        this.areaMsg = msg;
    }

    public void setIncludedCssStyleSheetHandle(IncludedCssStyleSheetHandle handle) {
        this.includedCssHandle = handle;
    }

    protected void initializeContents() {
        if (this.fileName != null) {
            this.fileNameField.setText(this.fileName);
        }
        if (this.viewTimeBtn.isEnabled() && this.viewTimeBtn.getSelection()) {
            this.uriText.setEnabled(true);
        } else {
            this.uriText.setEnabled(false);
        }
        if (this.includedCssHandle == null) {
            return;
        }
        this.fileName = this.includedCssHandle.getFileName();
        this.uri = this.includedCssHandle.getExternalCssURI();
        if (this.fileName != null && this.fileName.trim().length() > 0) {
            this.fileNameField.setText(this.fileName.trim());
            if (this.uri != null && this.uri.trim().length() > 0) {
                this.viewTimeBtn.setSelection(true);
                this.uriText.setEnabled(true);
                this.uriText.setText(this.uri.trim());
            }
        }
        if (this.uri == null || this.uri.trim().length() == 0) {
            this.viewTimeBtn.setSelection(false);
            this.uriText.setEnabled(false);
        }
        this.refresh();
    }

    public UseCssInReportDialog() {
        super(UIUtil.getDefaultShell());
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    protected Control createDialogArea(Composite parent) {
        Composite topComposite = (Composite)super.createDialogArea(parent);
        topComposite.setLayout((Layout)new GridLayout());
        this.createFileNameComposite(parent);
        this.createStyleComposite(parent);
        this.initializeContents();
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.UseCssInReportDialog_ID");
        this.setTitle(TITLE_AREA_TITLE);
        this.setMessage(TITLE_AREA_MESSAGE);
        return topComposite;
    }

    private void createStyleComposite(Composite parent) {
        Composite styleComposite = new Composite(parent, 0);
        styleComposite.setLayout((Layout)new GridLayout());
        styleComposite.setLayoutData((Object)new GridData(768));
        GridData data = new GridData(768);
        this.stylesTitle = new Label(styleComposite, 0);
        this.stylesTitle.setLayoutData((Object)data);
        this.stylesTable = new Table(styleComposite, 67588);
        data = new GridData(768);
        data.heightHint = 100;
        this.stylesTable.setLayoutData((Object)data);
        new Label(styleComposite, 0).setText(Messages.getString((String)"UseCssInReportDialog.Label.notifications"));
        this.notificationsTable = new Table(styleComposite, 67588);
        data = new GridData(768);
        data.heightHint = 60;
        this.notificationsTable.setLayoutData((Object)data);
    }

    private void createFileNameComposite(Composite parent) {
        Composite nameComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        nameComposite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        nameComposite.setLayoutData((Object)gd);
        Label title = new Label(nameComposite, 0);
        title.setText(Messages.getString((String)"UseCssInReportDialog.Wizard.Filename"));
        this.fileNameField = new Text(nameComposite, 2056);
        this.fileNameField.setLayoutData((Object)new GridData(768));
        this.fileNameField.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                UseCssInReportDialog.this.fileName = UseCssInReportDialog.this.fileNameField.getText();
                try {
                    UseCssInReportDialog.this.cssHandle = SessionHandleAdapter.getInstance().getReportDesignHandle().openCssStyleSheet(UseCssInReportDialog.this.fileName);
                }
                catch (StyleSheetException e1) {
                    UseCssInReportDialog.this.logger.log(Level.SEVERE, e1.getMessage(), e1);
                }
                UseCssInReportDialog.this.refresh();
            }
        });
        this.fileNameField.setLayoutData((Object)gd);
        this.selectButton = new Button(nameComposite, 8);
        this.selectButton.setText(Messages.getString((String)"WizardSelectCssStylePage.button.label.browse"));
        this.selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String sourceFileName;
                ResourceFileFolderSelectionDialog dialog = new ResourceFileFolderSelectionDialog(true, new String[]{"*.css", "*.CSS"});
                dialog.setTitle(DIALOG_BROWSE);
                dialog.setMessage(DIALOG_BROWSE_TITLE);
                ResourceSelectionValidator validator = new ResourceSelectionValidator(new String[]{".css", ".CSS"});
                dialog.setValidator(validator);
                if (dialog.open() == 0 && (sourceFileName = dialog.getPath()) != null) {
                    UseCssInReportDialog.this.fileNameField.setText(sourceFileName);
                }
            }
        });
        new Label(nameComposite, 0);
        this.viewTimeBtn = new Button(nameComposite, 32);
        this.viewTimeBtn.setText(Messages.getString((String)"UseCssInReportDialog.Dialog.Button.viewTimeBtn.Text"));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.viewTimeBtn.setLayoutData((Object)gd);
        this.viewTimeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = UseCssInReportDialog.this.viewTimeBtn.getSelection();
                UseCssInReportDialog.this.uriText.setEnabled(selected);
            }
        });
        new Label(nameComposite, 0);
        Label viewTimeLb = new Label(nameComposite, 0);
        viewTimeLb.setText(Messages.getString((String)"UseCssInReportDialog.Dialog.Label.viewTimeLb"));
        viewTimeLb.setLayoutData((Object)gd);
        Label uri = new Label(nameComposite, 0);
        uri.setText(Messages.getString((String)"UseCssInReportDialog.Dialog.Text.uri"));
        uri.setLayoutData((Object)new GridData(128));
        this.uriText = new Text(nameComposite, 2048);
        this.uriText.setLayoutData((Object)gd);
        new Label(nameComposite, 0);
        Label example = new Label(nameComposite, 0);
        example.setText(Messages.getString((String)"UseCssInReportDialog.Dialog.Label.example"));
        example.setLayoutData((Object)gd);
    }

    private void refresh() {
        TableItem item;
        String sn;
        this.styleMap.clear();
        this.styleNames.clear();
        this.unSupportedStyleNames.clear();
        String fileName = null;
        TableItem[] ch = this.stylesTable.getItems();
        int i = 0;
        while (i < ch.length) {
            ch[i].dispose();
            ++i;
        }
        ch = this.notificationsTable.getItems();
        i = 0;
        while (i < ch.length) {
            ch[i].dispose();
            ++i;
        }
        this.stylesTitle.setText(DIALOG_LABEL_NOFILE);
        fileName = this.fileNameField.getText();
        if (fileName.length() == 0) {
            this.updateOKbuttons();
            return;
        }
        try {
            this.cssHandle = SessionHandleAdapter.getInstance().getReportDesignHandle().openCssStyleSheet(fileName.trim());
        }
        catch (StyleSheetException styleSheetException) {
            this.updateOKbuttons();
            return;
        }
        if (this.cssHandle == null) {
            this.updateOKbuttons();
            return;
        }
        this.stylesTitle.setText(Messages.getFormattedString((String)"UseCssInReportDialog.Label.Styles", (Object[])new String[]{fileName}));
        Iterator styleIter = this.cssHandle.getStyleIterator();
        while (styleIter.hasNext()) {
            SharedStyleHandle styleHandle = (SharedStyleHandle)styleIter.next();
            this.styleMap.put(styleHandle.getName(), styleHandle);
            this.styleNames.add(styleHandle.getName());
        }
        List unSupportedStyles = this.cssHandle.getUnsupportedStyles();
        for (String name : unSupportedStyles) {
            this.unSupportedStyleNames.add(String.valueOf(name) + Messages.getString((String)"WizardSelectCssStylePage.text.cannot.import.style"));
        }
        int i2 = 0;
        while (i2 < this.styleNames.size()) {
            sn = (String)this.styleNames.get(i2);
            item = new TableItem(this.stylesTable, 0);
            item.setText(sn);
            item.setImage(ReportPlatformUIImages.getImage("Style"));
            ++i2;
        }
        i2 = 0;
        while (i2 < this.unSupportedStyleNames.size()) {
            sn = (String)this.unSupportedStyleNames.get(i2);
            item = new TableItem(this.notificationsTable, 0);
            item.setText(sn);
            item.setImage(ReportPlatformUIImages.getImage("Style"));
            ++i2;
        }
        this.updateOKbuttons();
    }

    private void updateOKbuttons() {
        ReportDesignHandle moduleHandle = (ReportDesignHandle)SessionHandleAdapter.getInstance().getReportDesignHandle();
        if (this.getButton(0) != null) {
            if (!(this.fileName == null || this.includedCssHandle != null && this.fileName.equals(this.includedCssHandle.getFileName()) || moduleHandle.canAddCssStyleSheet(this.fileName))) {
                this.getButton(0).setEnabled(false);
                this.setErrorMessage(Messages.getFormattedString((String)"UseCssInReportDialog.Error.Already.Include", (Object[])new String[]{this.fileName}));
            } else if (this.styleNames.size() != 0) {
                this.getButton(0).setEnabled(true);
                this.setErrorMessage(null);
            } else {
                this.getButton(0).setEnabled(false);
                this.setErrorMessage(null);
            }
        }
    }

    private boolean checkExtensions(String[] fileExt, String fileName) {
        int i = 0;
        while (i < fileExt.length) {
            String ext = fileExt[i].substring(fileExt[i].lastIndexOf(46));
            if (fileName.toLowerCase().endsWith(ext.toLowerCase())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.updateOKbuttons();
    }

    public String getURI() {
        return this.uri;
    }

    protected void okPressed() {
        this.uri = this.uriText.isEnabled() ? this.uriText.getText().trim() : "";
        super.okPressed();
    }
}

