/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.parameters;

import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.ui.parameters.IParameter;
import org.eclipse.birt.report.designer.ui.parameters.IParameterGroup;
import org.eclipse.birt.report.designer.ui.parameters.ParameterUtil;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;

public abstract class ScalarParameter
implements IParameter {
    protected IParameterGroup group = null;
    private String selectionValue = null;
    protected ScalarParameterHandle handle;
    protected IEngineTask engineTask;

    public ScalarParameter(ScalarParameterHandle handle, IEngineTask engineTask) {
        this.handle = handle;
        this.engineTask = engineTask;
    }

    public abstract List getValueList();

    public String getSelectionValue() {
        return this.selectionValue;
    }

    public void setSelectionValue(String value) {
        this.selectionValue = value;
    }

    public void setParentGroup(IParameterGroup group) {
        this.group = group;
    }

    public IParameterGroup getParentGroup() {
        return this.group;
    }

    public String getDefaultValue() {
        return this.handle.getDefaultValue();
    }

    public ScalarParameterHandle getHandle() {
        return this.handle;
    }

    public String format(String input) throws BirtException {
        return ParameterUtil.format((ParameterHandle)this.handle, input);
    }

    public Object converToDataType(Object value) throws BirtException {
        return ParameterUtil.convert(value, this.handle.getDataType());
    }

    public boolean isRequired() {
        return this.handle.isRequired();
    }
}

