/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.views;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.ui.views.ElementAdapter;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterInvocationHandler;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterSet;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementAdapterManager {
    protected static Logger logger = Logger.getLogger(ElementAdapterManager.class.getName());
    private static Map adaptersMap = new HashMap(){
        private static final long serialVersionUID = 534728316184090251L;

        public Object get(Object key) {
            Object obj = super.get(key);
            if (obj == null) {
                obj = new ElementAdapterSet();
                this.put(key, obj);
            }
            return obj;
        }
    };

    static {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.birt.report.designer.ui.elementAdapters");
        if (extensionPoint != null) {
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                String adaptableClassName = elements[j].getAttribute("class");
                Class<?> adaptableType = null;
                IConfigurationElement[] adapters = elements[j].getChildren("adapter");
                int k = 0;
                while (k < adapters.length) {
                    String adapterClassName = null;
                    Class<?> adapterType = null;
                    try {
                        ElementAdapter adapter = new ElementAdapter();
                        adapter.setId(adapters[k].getAttribute("id"));
                        if (adapters[k].getAttribute("class") != null && !adapters[k].getAttribute("class").equals("")) {
                            adapter.setAdapterInstance(adapters[k].createExecutableExtension("class"));
                        } else if (adapters[k].getAttribute("factory") != null && !adapters[k].getAttribute("factory").equals("")) {
                            adapter.setFactory((IAdapterFactory)adapters[k].createExecutableExtension("factory"));
                        }
                        if (adaptableType == null) {
                            adaptableType = ElementAdapterManager.classForName(adaptableClassName, adapter.getAdapterInstance(), adapter.getFactory());
                        }
                        adapter.setAdaptableType(adaptableType);
                        adapterClassName = adapters[k].getAttribute("type");
                        adapterType = ElementAdapterManager.classForName(adapterClassName, adapter.getAdapterInstance(), adapter.getFactory());
                        adapter.setAdapterType(adapterType);
                        adapter.setSingleton(!"false".equals(adapters[k].getAttribute("singleton")));
                        if (adapters[k].getAttribute("priority") != null && !adapters[k].getAttribute("priority").equals("")) {
                            try {
                                adapter.setPriority(Integer.parseInt(adapters[k].getAttribute("priority")));
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        if (adapters[k].getAttribute("overwrite") != null && !adapters[k].getAttribute("overwrite").equals("")) {
                            adapter.setOverwrite(adapters[k].getAttribute("overwrite").split(";"));
                        }
                        adapter.setIncludeWorkbenchContribute("true".equals(adapters[k].getAttribute("includeWorkbenchContribute")));
                        IConfigurationElement[] enablements = adapters[k].getChildren("enablement");
                        if (enablements != null && enablements.length > 0) {
                            adapter.setExpression(ExpressionConverter.getDefault().perform(enablements[0]));
                        }
                        ElementAdapterManager.registerAdapter(adaptableType, adapter);
                    }
                    catch (ClassNotFoundException ce) {
                        if (adaptableType == null) {
                            System.out.println(MessageFormat.format("Adaptable Type class '{0}' not found!", adaptableClassName));
                            logger.log(Level.SEVERE, ce.getMessage(), ce);
                        } else {
                            System.out.println(MessageFormat.format("Adapter Type class '{0}' not found!", adapterClassName));
                            logger.log(Level.SEVERE, ce.getMessage(), ce);
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Register adapter error!");
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                    ++k;
                }
                ++j;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static Class<?> classForName(String className, Object adapterInstance, IAdapterFactory adapterFacotry) throws ClassNotFoundException {
        block9: {
            clazz = null;
            if (adapterInstance != null) {
                try {
                    clazz = adapterInstance.getClass().getClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException v0) {}
            }
            if (clazz == null && adapterFacotry != null) {
                try {
                    clazz = adapterFacotry.getClass().getClassLoader().loadClass(className);
                    break block9;
                }
                catch (ClassNotFoundException v1) {
                    adapterList = adapterFacotry.getAdapterList();
                    if (adapterList == null || adapterList.length <= 0) break block9;
                    i = 0;
                    ** while (i < adapterList.length)
                }
lbl-1000:
                // 1 sources

                {
                    if (className.equals(adapterList[i].getName())) {
                        clazz = adapterList[i];
                        break;
                    }
                    ++i;
                    continue;
                }
            }
        }
        if (clazz == null) {
            clazz = Class.forName(className);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerAdapter(Class adaptableType, ElementAdapter adapter) {
        Map map = adaptersMap;
        synchronized (map) {
            Set adapterSet = (Set)adaptersMap.get(adaptableType);
            adapterSet.add(adapter);
        }
    }

    public static Object[] getAdapters(Object adaptableObject, Class adatperType) {
        List adapterObjects = ElementAdapterManager.getAdapterList(adaptableObject, adatperType);
        return adapterObjects != null && adapterObjects.size() > 0 ? adapterObjects.toArray(new Object[adapterObjects.size()]) : null;
    }

    public static Object getAdapter(Object adaptableObject, Class adatperType) {
        List adapterObjects = ElementAdapterManager.getAdapterList(adaptableObject, adatperType);
        if (adapterObjects == null || adapterObjects.size() == 0) {
            return null;
        }
        if (adapterObjects.size() == 1) {
            return adapterObjects.get(0);
        }
        return Proxy.newProxyInstance(adatperType.getClassLoader(), new Class[]{adatperType}, (InvocationHandler)new ElementAdapterInvocationHandler(adapterObjects));
    }

    private static List getAdapterList(Object adaptableObject, Class adatperType) {
        Set adapters = ElementAdapterManager.getAdapters(adaptableObject);
        if (adapters == null) {
            return null;
        }
        ArrayList<Object> adapterObjects = new ArrayList<Object>();
        for (ElementAdapter adapter : adapters) {
            Object obj;
            if (adapter.getExpression() != null) {
                EvaluationContext context = new EvaluationContext(null, adaptableObject);
                context.setAllowPluginActivation(true);
                try {
                    if (adapter.getExpression().evaluate((IEvaluationContext)context) != EvaluationResult.TRUE) {
                        continue;
                    }
                }
                catch (CoreException coreException) {}
            }
            if ((obj = adapter.getAdater(adaptableObject)) == null || !adatperType.isAssignableFrom(obj.getClass())) continue;
            adapterObjects.add(obj);
        }
        return adapterObjects;
    }

    private static Set getAdapters(Object adaptableObject) {
        Set keys = adaptersMap.keySet();
        ElementAdapterSet adapters = null;
        for (Class clazz : keys) {
            if (!clazz.isAssignableFrom(adaptableObject.getClass())) continue;
            if (adapters == null) {
                adapters = new ElementAdapterSet();
            }
            Set set = (Set)adaptersMap.get(clazz);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                adapters.add(iterator.next());
            }
        }
        if (adapters != null) {
            adapters.reset();
        }
        return adapters;
    }
}

