/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.widget;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class PopupSelectionList {
    protected Shell shell;
    protected List list;
    private String result = null;
    private int selectionIndex = -1;

    public PopupSelectionList(Shell parent) {
        this.shell = new Shell(parent, 0);
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent e) {
                PopupSelectionList.this.closeShell();
            }
        });
        this.list = new List((Composite)this.shell, 516);
        this.list.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                PopupSelectionList.this.closeShell();
            }
        });
        this.list.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    PopupSelectionList.this.closeShell();
                }
            }
        });
    }

    public String open(Rectangle rect) {
        int maxWidth = this.getMaxStringWidth();
        if (rect.width > maxWidth) {
            maxWidth = rect.width;
        }
        Point listSize = this.list.computeSize(maxWidth, -1, false);
        Rectangle screenSize = this.shell.getDisplay().getBounds();
        int spaceBelow = screenSize.height - (rect.y + rect.height) - 30;
        int spaceAbove = rect.y - 30;
        int y = 0;
        if (spaceAbove > spaceBelow && listSize.y > spaceBelow) {
            listSize.y = listSize.y > spaceAbove ? spaceAbove : (listSize.y += 2);
            y = rect.y - listSize.y;
        } else {
            listSize.y = listSize.y > spaceBelow ? spaceBelow : (listSize.y += 2);
            y = rect.y + rect.height;
        }
        listSize.x = maxWidth;
        int x = rect.x + maxWidth - listSize.x;
        this.shell.setBounds(x, y, listSize.x, listSize.y);
        this.shell.open();
        this.list.setFocus();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private int getMaxStringWidth() {
        GC gc = new GC((Drawable)this.shell);
        String[] items = this.list.getItems();
        ArrayList<Integer> separatorIndexes = new ArrayList<Integer>(5);
        int maxChars = 0;
        int maxWidth = 0;
        Point pt = null;
        int n = 0;
        while (n < items.length) {
            int len;
            pt = gc.textExtent(items[n]);
            if (pt.x > maxWidth) {
                maxWidth = pt.x;
            }
            if ((len = items[n].length()) > maxChars) {
                maxChars = len;
            }
            if (items[n].equals("-")) {
                separatorIndexes.add(new Integer(n));
            }
            ++n;
        }
        gc.dispose();
        String separator = this.getSeparator(maxChars);
        Iterator iter = separatorIndexes.iterator();
        while (iter.hasNext()) {
            this.list.setItem(((Integer)iter.next()).intValue(), separator);
        }
        return maxWidth + 5;
    }

    private void closeShell() {
        if (!this.shell.isDisposed()) {
            String[] strings = this.list.getSelection();
            if (strings.length != 0) {
                this.result = strings[0];
                this.selectionIndex = this.list.getSelectionIndex();
            }
            this.shell.dispose();
        }
    }

    private String getSeparator(int maxChars) {
        StringBuffer buf = new StringBuffer();
        int n = 0;
        while (n < maxChars) {
            buf.append("_");
            ++n;
        }
        return buf.toString();
    }

    public void setItems(String[] items) {
        this.list.setItems(items);
    }

    public int getSelectionIndex() {
        return this.selectionIndex;
    }
}

