/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.repository.simple;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.repository.Activator;
import org.eclipse.equinox.internal.p2.artifact.repository.Messages;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.OrderedProperties;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.persistence.XMLParser;
import org.eclipse.equinox.internal.p2.persistence.XMLWriter;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.ArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepDescriptor;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SimpleArtifactRepositoryIO {
    static /* synthetic */ Class class$0;

    public void write(SimpleArtifactRepository repository, OutputStream output) {
        BufferedOutputStream bufferedOutput = null;
        try {
            try {
                bufferedOutput = new BufferedOutputStream(output);
                Writer repositoryWriter = new Writer(bufferedOutput);
                repositoryWriter.write(repository);
            }
            finally {
                if (bufferedOutput != null) {
                    ((OutputStream)bufferedOutput).close();
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public IArtifactRepository read(URL location, InputStream input, IProgressMonitor monitor) throws ProvisionException {
        SimpleArtifactRepository simpleArtifactRepository;
        block12: {
            BufferedInputStream bufferedInput = null;
            try {
                bufferedInput = new BufferedInputStream(input);
                Parser repositoryParser = new Parser(Activator.getContext(), "org.eclipse.equinox.p2.artifact.repository");
                repositoryParser.parse(input);
                IStatus result = repositoryParser.getStatus();
                switch (result.getSeverity()) {
                    case 8: {
                        throw new OperationCanceledException();
                    }
                    case 4: {
                        throw new ProvisionException(result);
                    }
                    case 1: 
                    case 2: {
                        LogHelper.log((IStatus)result);
                    }
                }
                SimpleArtifactRepository repository = repositoryParser.getRepository();
                if (repository == null) {
                    throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", 1002, Messages.io_parseError, null));
                }
                simpleArtifactRepository = repository;
                if (bufferedInput == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (bufferedInput != null) {
                        bufferedInput.close();
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    String msg = NLS.bind((String)Messages.io_failedRead, (Object)location);
                    throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", 1002, msg, (Throwable)ioe));
                }
            }
            bufferedInput.close();
        }
        return simpleArtifactRepository;
    }

    private class Parser
    extends XMLParser
    implements XMLConstants {
        private SimpleArtifactRepository theRepository = null;

        public Parser(BundleContext context, String bundleId) {
            super(context, bundleId);
        }

        public void parse(File file) throws IOException {
            this.parse(new FileInputStream(file));
        }

        public synchronized void parse(InputStream stream) throws IOException {
            this.status = null;
            try {
                try {
                    this.getParser();
                    RepositoryHandler repositoryHandler = new RepositoryHandler();
                    this.xmlReader.setContentHandler((ContentHandler)((Object)new RepositoryDocHandler("repository", repositoryHandler)));
                    this.xmlReader.parse(new InputSource(stream));
                    if (this.isValidXML()) {
                        this.theRepository = repositoryHandler.getRepository();
                    }
                }
                catch (SAXException e) {
                    throw new IOException(e.getMessage());
                }
                catch (ParserConfigurationException e) {
                    throw new IOException(e.getMessage());
                }
            }
            finally {
                stream.close();
            }
        }

        public SimpleArtifactRepository getRepository() {
            return this.theRepository;
        }

        protected Object getRootObject() {
            return this.theRepository;
        }

        protected String getErrorMessage() {
            return Messages.io_parseError;
        }

        public String toString() {
            return null;
        }

        protected class ArtifactHandler
        extends XMLParser.AbstractHandler {
            private final String[] required = new String[]{"classifier", "id", "version"};
            private Set artifacts;
            ArtifactDescriptor currentArtifact = null;
            private XMLParser.PropertiesHandler propertiesHandler = null;
            private XMLParser.PropertiesHandler repositoryPropertiesHandler = null;
            private ProcessingStepsHandler processingStepsHandler = null;

            public ArtifactHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, Set artifacts) {
                super((XMLParser)Parser.this, (ContentHandler)parentHandler, "artifact");
                this.artifacts = artifacts;
                String[] values = this.parseRequiredAttributes(attributes, this.required);
                Version version = Parser.this.checkVersion("artifact", "version", values[2]);
                this.currentArtifact = new ArtifactDescriptor((IArtifactKey)new ArtifactKey(values[0], values[1], version));
            }

            public ArtifactDescriptor getArtifact() {
                return this.currentArtifact;
            }

            public void startElement(String name, Attributes attributes) {
                if ("processing".equals(name)) {
                    if (this.processingStepsHandler == null) {
                        this.processingStepsHandler = new ProcessingStepsHandler(this, attributes);
                    } else {
                        Parser.this.duplicateElement(this, name, attributes);
                    }
                } else if ("properties".equals(name)) {
                    if (this.propertiesHandler == null) {
                        this.propertiesHandler = new XMLParser.PropertiesHandler((XMLParser)Parser.this, (ContentHandler)((Object)this), attributes);
                    } else {
                        Parser.this.duplicateElement(this, name, attributes);
                    }
                } else if ("repositoryProperties".equals(name)) {
                    if (this.repositoryPropertiesHandler == null) {
                        this.repositoryPropertiesHandler = new XMLParser.PropertiesHandler((XMLParser)Parser.this, (ContentHandler)((Object)this), attributes);
                    } else {
                        Parser.this.duplicateElement(this, name, attributes);
                    }
                } else {
                    this.invalidElement(name, attributes);
                }
            }

            protected void finished() {
                if (Parser.this.isValidXML() && this.currentArtifact != null) {
                    OrderedProperties properties = this.propertiesHandler == null ? new OrderedProperties(0) : this.propertiesHandler.getProperties();
                    this.currentArtifact.addProperties((Map)properties);
                    properties = this.repositoryPropertiesHandler == null ? new OrderedProperties(0) : this.repositoryPropertiesHandler.getProperties();
                    this.currentArtifact.addRepositoryProperties((Map)properties);
                    ProcessingStepDescriptor[] processingSteps = this.processingStepsHandler == null ? new ProcessingStepDescriptor[]{} : this.processingStepsHandler.getProcessingSteps();
                    this.currentArtifact.setProcessingSteps(processingSteps);
                    this.artifacts.add(this.currentArtifact);
                }
            }
        }

        protected class ArtifactsHandler
        extends XMLParser.AbstractHandler {
            private Set artifacts;

            public ArtifactsHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
                super((XMLParser)Parser.this, (ContentHandler)parentHandler, "artifacts");
                String size = this.parseOptionalAttribute(attributes, "size");
                this.artifacts = size != null ? new LinkedHashSet(new Integer(size)) : new LinkedHashSet(4);
            }

            public Set getArtifacts() {
                return this.artifacts;
            }

            public void startElement(String name, Attributes attributes) {
                if (name.equals("artifact")) {
                    new ArtifactHandler(this, attributes, this.artifacts);
                } else {
                    this.invalidElement(name, attributes);
                }
            }
        }

        protected class MappingRuleHandler
        extends XMLParser.AbstractHandler {
            private final String[] required = new String[]{"filter", "output"};

            public MappingRuleHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, List mappingRules) {
                super((XMLParser)Parser.this, (ContentHandler)parentHandler, "rule");
                mappingRules.add(this.parseRequiredAttributes(attributes, this.required));
            }

            public void startElement(String name, Attributes attributes) {
                this.invalidElement(name, attributes);
            }
        }

        protected class MappingRulesHandler
        extends XMLParser.AbstractHandler {
            private List mappingRules;

            public MappingRulesHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
                super((XMLParser)Parser.this, (ContentHandler)parentHandler, "mappings");
                String size = this.parseOptionalAttribute(attributes, "size");
                this.mappingRules = size != null ? new ArrayList(new Integer(size)) : new ArrayList(4);
            }

            public String[][] getMappingRules() {
                String[][] rules = new String[this.mappingRules.size()][2];
                int index = 0;
                while (index < this.mappingRules.size()) {
                    String[] ruleAttributes = (String[])this.mappingRules.get(index);
                    rules[index] = ruleAttributes;
                    ++index;
                }
                return rules;
            }

            public void startElement(String name, Attributes attributes) {
                if (name.equals("rule")) {
                    new MappingRuleHandler(this, attributes, this.mappingRules);
                } else {
                    this.invalidElement(name, attributes);
                }
            }
        }

        protected class ProcessingStepHandler
        extends XMLParser.AbstractHandler {
            private final String[] required = new String[]{"id", "required"};
            private final String[] optional = new String[]{"data"};

            public ProcessingStepHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, List processingSteps) {
                super((XMLParser)Parser.this, (ContentHandler)parentHandler, "step");
                String[] attributeValues = this.parseAttributes(attributes, this.required, this.optional);
                processingSteps.add(new ProcessingStepDescriptor(attributeValues[0], attributeValues[1], Parser.this.checkBoolean("step", "required", attributeValues[2])));
            }

            public void startElement(String name, Attributes attributes) {
                this.invalidElement(name, attributes);
            }
        }

        protected class ProcessingStepsHandler
        extends XMLParser.AbstractHandler {
            private List processingSteps;

            public ProcessingStepsHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
                super((XMLParser)Parser.this, (ContentHandler)parentHandler, "processing");
                String size = this.parseOptionalAttribute(attributes, "size");
                this.processingSteps = size != null ? new ArrayList(new Integer(size)) : new ArrayList(4);
            }

            public ProcessingStepDescriptor[] getProcessingSteps() {
                return this.processingSteps.toArray(new ProcessingStepDescriptor[this.processingSteps.size()]);
            }

            public void startElement(String name, Attributes attributes) {
                if (name.equals("step")) {
                    new ProcessingStepHandler(this, attributes, this.processingSteps);
                } else {
                    this.invalidElement(name, attributes);
                }
            }
        }

        private final class RepositoryDocHandler
        extends XMLParser.DocHandler {
            public RepositoryDocHandler(String rootName, XMLParser.RootHandler rootHandler) {
                super((XMLParser)Parser.this, rootName, rootHandler);
            }

            public void processingInstruction(String target, String data) throws SAXException {
                Version repositoryVersion;
                if ("artifactRepository".equals(target) && !XML_TOLERANCE.isIncluded(repositoryVersion = Parser.this.extractPIVersion(target, data))) {
                    throw new SAXException(NLS.bind((String)Messages.io_incompatibleVersion, (Object)repositoryVersion, (Object)XML_TOLERANCE));
                }
            }
        }

        private final class RepositoryHandler
        extends XMLParser.RootHandler {
            private final String[] required = new String[]{"name", "type", "version"};
            private final String[] optional = new String[]{"description", "provider"};
            private String[] attrValues = new String[this.required.length + this.optional.length];
            private MappingRulesHandler mappingRulesHandler = null;
            private XMLParser.PropertiesHandler propertiesHandler = null;
            private ArtifactsHandler artifactsHandler = null;
            private SimpleArtifactRepository repository = null;

            public RepositoryHandler() {
                super((XMLParser)Parser.this);
            }

            public SimpleArtifactRepository getRepository() {
                return this.repository;
            }

            protected void handleRootAttributes(Attributes attributes) {
                this.attrValues = this.parseAttributes(attributes, this.required, this.optional);
                this.attrValues[2] = Parser.this.checkVersion("repository", "version", this.attrValues[2]).toString();
            }

            public void startElement(String name, Attributes attributes) {
                if ("mappings".equals(name)) {
                    if (this.mappingRulesHandler == null) {
                        this.mappingRulesHandler = new MappingRulesHandler((XMLParser.AbstractHandler)this, attributes);
                    } else {
                        Parser.this.duplicateElement((XMLParser.AbstractHandler)this, name, attributes);
                    }
                } else if ("artifacts".equals(name)) {
                    if (this.artifactsHandler == null) {
                        this.artifactsHandler = new ArtifactsHandler((XMLParser.AbstractHandler)this, attributes);
                    } else {
                        Parser.this.duplicateElement((XMLParser.AbstractHandler)this, name, attributes);
                    }
                } else if ("properties".equals(name)) {
                    if (this.propertiesHandler == null) {
                        this.propertiesHandler = new XMLParser.PropertiesHandler((XMLParser)Parser.this, (ContentHandler)((Object)this), attributes);
                    } else {
                        Parser.this.duplicateElement((XMLParser.AbstractHandler)this, name, attributes);
                    }
                } else {
                    this.invalidElement(name, attributes);
                }
            }

            protected void finished() {
                if (Parser.this.isValidXML()) {
                    String[][] mappingRules = this.mappingRulesHandler == null ? new String[0][0] : this.mappingRulesHandler.getMappingRules();
                    OrderedProperties properties = this.propertiesHandler == null ? new OrderedProperties(0) : this.propertiesHandler.getProperties();
                    Set artifacts = this.artifactsHandler == null ? new HashSet(0) : this.artifactsHandler.getArtifacts();
                    this.repository = new SimpleArtifactRepository(this.attrValues[0], this.attrValues[1], this.attrValues[2], this.attrValues[3], this.attrValues[4], artifacts, mappingRules, (Map)properties);
                }
            }
        }
    }

    protected class Writer
    extends XMLWriter
    implements XMLConstants {
        public Writer(OutputStream output) throws IOException {
            super(output, PI_DEFAULTS);
        }

        public void write(SimpleArtifactRepository repository) {
            this.start("repository");
            this.attribute("name", repository.getName());
            this.attribute("type", repository.getType());
            this.attribute("version", repository.getVersion());
            this.attributeOptional("provider", repository.getProvider());
            this.attributeOptional("description", repository.getDescription());
            this.writeProperties(repository.getProperties());
            this.writeMappingRules(repository.getRules());
            this.writeArtifacts(repository.getDescriptors());
            this.end("repository");
            this.flush();
        }

        private void writeMappingRules(String[][] rules) {
            if (rules.length > 0) {
                this.start("mappings");
                this.attribute("size", rules.length);
                int i = 0;
                while (i < rules.length) {
                    this.start("rule");
                    this.attribute("filter", rules[i][0]);
                    this.attribute("output", rules[i][1]);
                    this.end("rule");
                    ++i;
                }
                this.end("mappings");
            }
        }

        private void writeArtifacts(Set artifactDescriptors) {
            this.start("artifacts");
            this.attribute("size", artifactDescriptors.size());
            Iterator iter = artifactDescriptors.iterator();
            while (iter.hasNext()) {
                ArtifactDescriptor descriptor = (ArtifactDescriptor)iter.next();
                IArtifactKey key = descriptor.getArtifactKey();
                this.start("artifact");
                this.attribute("classifier", key.getClassifier());
                this.attribute("id", key.getId());
                this.attribute("version", key.getVersion());
                this.writeProcessingSteps(descriptor.getProcessingSteps());
                this.writeProperties(descriptor.getProperties());
                this.writeProperties("repositoryProperties", descriptor.getRepositoryProperties());
                this.end("artifact");
            }
            this.end("artifacts");
        }

        private void writeProcessingSteps(ProcessingStepDescriptor[] processingSteps) {
            if (processingSteps.length > 0) {
                this.start("processing");
                this.attribute("size", processingSteps.length);
                int i = 0;
                while (i < processingSteps.length) {
                    this.start("step");
                    this.attribute("id", processingSteps[i].getProcessorId());
                    this.attribute("data", processingSteps[i].getData());
                    this.attribute("required", processingSteps[i].isRequired());
                    this.end("step");
                    ++i;
                }
                this.end("processing");
            }
        }
    }

    private static interface XMLConstants
    extends org.eclipse.equinox.internal.p2.persistence.XMLConstants {
        public static final Version CURRENT_VERSION = new Version(1, 0, 0);
        public static final VersionRange XML_TOLERANCE = new VersionRange(CURRENT_VERSION, true, new Version(2, 0, 0), false);
        public static final String PI_REPOSITORY_TARGET = "artifactRepository";
        public static final XMLWriter.ProcessingInstruction[] PI_DEFAULTS;
        public static final String REPOSITORY_ELEMENT = "repository";
        public static final String REPOSITORY_PROPERTIES_ELEMENT = "repositoryProperties";
        public static final String MAPPING_RULES_ELEMENT = "mappings";
        public static final String MAPPING_RULE_ELEMENT = "rule";
        public static final String ARTIFACTS_ELEMENT = "artifacts";
        public static final String ARTIFACT_ELEMENT = "artifact";
        public static final String PROCESSING_STEPS_ELEMENT = "processing";
        public static final String PROCESSING_STEP_ELEMENT = "step";
        public static final String MAPPING_RULE_FILTER_ATTRIBUTE = "filter";
        public static final String MAPPING_RULE_OUTPUT_ATTRIBUTE = "output";
        public static final String ARTIFACT_CLASSIFIER_ATTRIBUTE = "classifier";
        public static final String STEP_DATA_ATTRIBUTE = "data";
        public static final String STEP_REQUIRED_ATTRIBUTE = "required";

        static {
            XMLWriter.ProcessingInstruction[] processingInstructionArray = new XMLWriter.ProcessingInstruction[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            processingInstructionArray[0] = XMLWriter.ProcessingInstruction.makeClassVersionInstruction((String)PI_REPOSITORY_TARGET, (Class)clazz, (Version)CURRENT_VERSION);
            PI_DEFAULTS = processingInstructionArray;
        }
    }
}

