/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.HorizontalAlignment;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.VerticalAlignment;
import org.eclipse.birt.chart.model.attribute.impl.FontDefinitionImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.AngleSelectorComposite;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.FontCanvas;
import org.eclipse.birt.chart.ui.swt.composites.FontDefinitionComposite;
import org.eclipse.birt.chart.ui.swt.composites.IAngleChangeListener;
import org.eclipse.birt.chart.ui.swt.composites.IntegerSpinControl;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class FontDefinitionDialog
extends TrayDialog
implements FontDefinitionComposite.IFontDefinitionDialog,
SelectionListener,
Listener,
IAngleChangeListener,
FocusListener {
    private transient FontDefinition fdCurrent = null;
    private transient ColorDefinition cdCurrent = null;
    private transient FontDefinition fdBackup = null;
    private transient ColorDefinition cdBackup = null;
    private transient Composite cmpContent = null;
    private transient Combo cmbFontNames = null;
    private transient Combo cmbFontSizes = null;
    private transient FillChooserComposite fccColor = null;
    private transient Button btnATopLeft = null;
    private transient Button btnATopCenter = null;
    private transient Button btnATopRight = null;
    private transient Button btnACenterLeft = null;
    private transient Button btnACenter = null;
    private transient Button btnACenterRight = null;
    private transient Button btnABottomLeft = null;
    private transient Button btnABottomCenter = null;
    private transient Button btnABottomRight = null;
    private transient Button btnBold = null;
    private transient Button btnItalic = null;
    private transient Button btnUnderline = null;
    private transient Button btnStrikethru = null;
    private transient Button cbWrap = null;
    private transient AngleSelectorComposite ascRotation = null;
    private transient IntegerSpinControl iscRotation = null;
    private transient FontCanvas fcPreview = null;
    private transient boolean isAlignmentEnabled = true;
    private transient List listAlighmentButtons = new ArrayList(9);
    private transient ChartWizardContext wizardContext;
    private static final String[] FONT_SIZE = new String[]{ChartUIUtil.FONT_AUTO, "9", "10", "12", "14", "16", "18", "24", "36"};

    public FontDefinitionDialog(Shell shellParent, ChartWizardContext wizardContext, FontDefinition fdCurrent, ColorDefinition cdCurrent, boolean isAlignmentEnabled) {
        super(shellParent);
        this.isAlignmentEnabled = isAlignmentEnabled;
        this.wizardContext = wizardContext;
        this.fdCurrent = fdCurrent == null ? FontDefinitionImpl.createEmpty() : (FontDefinition)EcoreUtil.copy((EObject)fdCurrent);
        this.cdCurrent = cdCurrent == null ? null : (ColorDefinition)EcoreUtil.copy((EObject)cdCurrent);
        this.fdBackup = (FontDefinition)EcoreUtil.copy((EObject)this.fdCurrent);
        this.cdBackup = this.cdCurrent == null ? null : (ColorDefinition)EcoreUtil.copy((EObject)this.cdCurrent);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x860 | 0x10000);
    }

    protected Control createContents(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FontEditor_ID");
        this.getShell().setText(Messages.getString("FontDefinitionDialog.Title.FontDescriptor"));
        return super.createContents(parent);
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout glContent = new GridLayout();
        glContent.verticalSpacing = 5;
        glContent.horizontalSpacing = 5;
        glContent.marginHeight = 7;
        glContent.marginWidth = 7;
        glContent.numColumns = 9;
        this.cmpContent = new Composite(parent, 0);
        this.cmpContent.setLayout((Layout)glContent);
        this.cmpContent.setLayoutData((Object)new GridData(1808));
        Label lblFont = new Label(this.cmpContent, 0);
        GridData gdLFont = new GridData();
        lblFont.setLayoutData((Object)gdLFont);
        lblFont.setText(Messages.getString("FontDefinitionDialog.Lbl.Font"));
        this.cmbFontNames = new Combo(this.cmpContent, 12);
        GridData gdCMBFontNames = new GridData(768);
        gdCMBFontNames.horizontalSpan = 8;
        this.cmbFontNames.setLayoutData((Object)gdCMBFontNames);
        this.cmbFontNames.addSelectionListener((SelectionListener)this);
        Label lblSize = new Label(this.cmpContent, 0);
        GridData gdLSize = new GridData();
        lblSize.setLayoutData((Object)gdLSize);
        lblSize.setText(Messages.getString("FontDefinitionDialog.Lbl.Size"));
        this.cmbFontSizes = new Combo(this.cmpContent, 0);
        this.cmbFontSizes.setItems(FONT_SIZE);
        this.cmbFontSizes.setText(this.fdCurrent.isSetSize() ? String.valueOf((int)this.fdCurrent.getSize()) : ChartUIUtil.FONT_AUTO);
        GridData gdISCFontSizes = new GridData(768);
        gdISCFontSizes.horizontalSpan = 3;
        this.cmbFontSizes.setLayoutData((Object)gdISCFontSizes);
        this.cmbFontSizes.addSelectionListener((SelectionListener)this);
        this.cmbFontSizes.addFocusListener((FocusListener)this);
        Label lblForeground = new Label(this.cmpContent, 0);
        GridData gdLForeground = new GridData();
        gdLForeground.horizontalSpan = 2;
        gdLForeground.horizontalIndent = 40;
        lblForeground.setLayoutData((Object)gdLForeground);
        lblForeground.setText(Messages.getString("FontDefinitionDialog.Lbl.Color"));
        this.fccColor = new FillChooserComposite(this.cmpContent, 0, this.wizardContext, (Fill)this.cdCurrent, false, false, true, false);
        GridData gdFCCColor = new GridData(768);
        gdFCCColor.horizontalSpan = 3;
        this.fccColor.setLayoutData(gdFCCColor);
        this.fccColor.addListener(this);
        this.createFontStylePanel();
        if (this.isAlignmentEnabled) {
            this.createAlignmentPanel();
        }
        this.createRotationPanel();
        this.populateLists();
        this.updatePreview();
        return this.cmpContent;
    }

    protected void cancelPressed() {
        this.fdCurrent = this.fdBackup;
        this.cdCurrent = this.cdBackup;
        super.cancelPressed();
    }

    private void createFontStylePanel() {
        Label lblStyle = new Label(this.cmpContent, 0);
        lblStyle.setText(Messages.getString("FontDefinitionDialog.Lbl.Style"));
        Composite cmpFontStyle = new Composite(this.cmpContent, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        cmpFontStyle.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalSpan = 8;
        cmpFontStyle.setLayoutData((Object)gd);
        this.btnBold = new Button(cmpFontStyle, 2);
        GridData gdBBold = new GridData();
        this.btnBold.setLayoutData((Object)gdBBold);
        this.btnBold.setImage(UIHelper.getImage((String)"icons/obj16/fnt_style_bold.gif"));
        this.btnBold.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.Bold"));
        this.btnBold.addSelectionListener((SelectionListener)this);
        this.btnBold.setSelection(this.fdCurrent.isSetBold() && this.fdCurrent.isBold());
        this.btnItalic = new Button(cmpFontStyle, 2);
        GridData gdBItalic = new GridData();
        this.btnItalic.setLayoutData((Object)gdBItalic);
        this.btnItalic.setImage(UIHelper.getImage((String)"icons/obj16/fnt_style_italic.gif"));
        this.btnItalic.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.Italic"));
        this.btnItalic.addSelectionListener((SelectionListener)this);
        this.btnItalic.setSelection(this.fdCurrent.isSetItalic() && this.fdCurrent.isItalic());
        this.btnUnderline = new Button(cmpFontStyle, 2);
        GridData gdBUnderline = new GridData();
        this.btnUnderline.setLayoutData((Object)gdBUnderline);
        this.btnUnderline.setImage(UIHelper.getImage((String)"icons/obj16/fnt_style_underline.gif"));
        this.btnUnderline.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.Underline"));
        this.btnUnderline.addSelectionListener((SelectionListener)this);
        this.btnUnderline.setSelection(this.fdCurrent.isSetUnderline() && this.fdCurrent.isUnderline());
        this.btnStrikethru = new Button(cmpFontStyle, 2);
        this.btnStrikethru.setImage(UIHelper.getImage((String)"icons/obj16/fnt_style_Sthrough.gif"));
        this.btnStrikethru.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.Strikethrough"));
        this.btnStrikethru.addSelectionListener((SelectionListener)this);
        this.btnStrikethru.setSelection(this.fdCurrent.isSetStrikethrough() && this.fdCurrent.isStrikethrough());
    }

    private void createAlignmentPanel() {
        new Label(this.cmpContent, 0).setText(Messages.getString("FontDefinitionDialog.Lbl.Alignment"));
        Composite cmpAlignment = new Composite(this.cmpContent, 0);
        GridData gdCMPAlignment = new GridData(768);
        gdCMPAlignment.horizontalSpan = 8;
        cmpAlignment.setLayoutData((Object)gdCMPAlignment);
        GridLayout glAlignment = new GridLayout(11, false);
        glAlignment.marginWidth = 2;
        glAlignment.marginHeight = 0;
        cmpAlignment.setLayout((Layout)glAlignment);
        this.btnATopLeft = this.createAlighmentButton(cmpAlignment);
        this.btnATopCenter = this.createAlighmentButton(cmpAlignment);
        this.btnATopRight = this.createAlighmentButton(cmpAlignment);
        this.btnACenterLeft = this.createAlighmentButton(cmpAlignment);
        this.btnACenter = this.createAlighmentButton(cmpAlignment);
        this.btnACenterRight = this.createAlighmentButton(cmpAlignment);
        this.btnABottomLeft = this.createAlighmentButton(cmpAlignment);
        this.btnABottomCenter = this.createAlighmentButton(cmpAlignment);
        this.btnABottomRight = this.createAlighmentButton(cmpAlignment);
        if (this.isFlippedAxes()) {
            this.btnATopLeft.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignBottomRight"));
            this.btnATopLeft.setImage(UIHelper.getImage((String)"icons/obj28/alignmentbottomright.gif"));
            this.btnATopLeft.getImage().setBackground(this.btnATopLeft.getBackground());
            this.btnATopCenter.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignCenterRight"));
            this.btnATopCenter.setImage(UIHelper.getImage((String)"icons/obj28/alignmentcenterright.gif"));
            this.btnATopCenter.getImage().setBackground(this.btnATopCenter.getBackground());
            this.btnATopRight.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignTopRight"));
            this.btnATopRight.setImage(UIHelper.getImage((String)"icons/obj28/alignmenttopright.gif"));
            this.btnATopRight.getImage().setBackground(this.btnATopRight.getBackground());
            this.createSeparator(cmpAlignment);
            this.btnACenterLeft.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignBottomCenter"));
            this.btnACenterLeft.setImage(UIHelper.getImage((String)"icons/obj28/alignmentbottomcenter.gif"));
            this.btnACenterLeft.getImage().setBackground(this.btnACenterLeft.getBackground());
            this.btnACenter.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignCenter"));
            this.btnACenter.setImage(UIHelper.getImage((String)"icons/obj28/alignmentcenter.gif"));
            this.btnACenter.getImage().setBackground(this.btnACenter.getBackground());
            this.btnACenterRight.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignTopCenter"));
            this.btnACenterRight.setImage(UIHelper.getImage((String)"icons/obj28/alignmenttopcenter.gif"));
            this.btnACenterRight.getImage().setBackground(this.btnACenterRight.getBackground());
            this.createSeparator(cmpAlignment);
            this.btnABottomLeft.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignBottomLeft"));
            this.btnABottomLeft.setImage(UIHelper.getImage((String)"icons/obj28/alignmentbottomleft.gif"));
            this.btnABottomLeft.getImage().setBackground(this.btnABottomLeft.getBackground());
            this.btnABottomCenter.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignCenterLeft"));
            this.btnABottomCenter.setImage(UIHelper.getImage((String)"icons/obj28/alignmentcenterleft.gif"));
            this.btnABottomCenter.getImage().setBackground(this.btnABottomCenter.getBackground());
            this.btnABottomRight.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignTopLeft"));
            this.btnABottomRight.setImage(UIHelper.getImage((String)"icons/obj28/alignmenttopleft.gif"));
            this.btnABottomRight.getImage().setBackground(this.btnABottomRight.getBackground());
        } else {
            this.btnATopLeft.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignTopLeft"));
            this.btnATopLeft.setImage(UIHelper.getImage((String)"icons/obj28/alignmenttopleft.gif"));
            this.btnATopLeft.getImage().setBackground(this.btnATopLeft.getBackground());
            this.btnATopCenter.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignTopCenter"));
            this.btnATopCenter.setImage(UIHelper.getImage((String)"icons/obj28/alignmenttopcenter.gif"));
            this.btnATopCenter.getImage().setBackground(this.btnATopCenter.getBackground());
            this.btnATopRight.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignTopRight"));
            this.btnATopRight.setImage(UIHelper.getImage((String)"icons/obj28/alignmenttopright.gif"));
            this.btnATopRight.getImage().setBackground(this.btnATopRight.getBackground());
            this.createSeparator(cmpAlignment);
            this.btnACenterLeft.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignCenterLeft"));
            this.btnACenterLeft.setImage(UIHelper.getImage((String)"icons/obj28/alignmentcenterleft.gif"));
            this.btnACenterLeft.getImage().setBackground(this.btnACenterLeft.getBackground());
            this.btnACenter.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignCenter"));
            this.btnACenter.setImage(UIHelper.getImage((String)"icons/obj28/alignmentcenter.gif"));
            this.btnACenter.getImage().setBackground(this.btnACenter.getBackground());
            this.btnACenterRight.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignCenterRight"));
            this.btnACenterRight.setImage(UIHelper.getImage((String)"icons/obj28/alignmentcenterright.gif"));
            this.btnACenterRight.getImage().setBackground(this.btnACenterRight.getBackground());
            this.createSeparator(cmpAlignment);
            this.btnABottomLeft.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignBottomLeft"));
            this.btnABottomLeft.setImage(UIHelper.getImage((String)"icons/obj28/alignmentbottomleft.gif"));
            this.btnABottomLeft.getImage().setBackground(this.btnABottomLeft.getBackground());
            this.btnABottomCenter.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignBottomCenter"));
            this.btnABottomCenter.setImage(UIHelper.getImage((String)"icons/obj28/alignmentbottomcenter.gif"));
            this.btnABottomCenter.getImage().setBackground(this.btnABottomCenter.getBackground());
            this.btnABottomRight.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignBottomRight"));
            this.btnABottomRight.setImage(UIHelper.getImage((String)"icons/obj28/alignmentbottomright.gif"));
            this.btnABottomRight.getImage().setBackground(this.btnABottomRight.getBackground());
        }
    }

    private Button createAlighmentButton(Composite parent) {
        Button button = new Button(parent, 2);
        GridData gd = new GridData();
        gd.widthHint = 32;
        gd.heightHint = 32;
        button.setLayoutData((Object)gd);
        button.addSelectionListener((SelectionListener)this);
        this.listAlighmentButtons.add(button);
        return button;
    }

    private void selectAllToggleButtons(boolean selection) {
        int i = 0;
        while (i < this.listAlighmentButtons.size()) {
            ((Button)this.listAlighmentButtons.get(i)).setSelection(selection);
            ++i;
        }
    }

    private void createSeparator(Composite parent) {
        Label lable = new Label(parent, 0);
        lable.setLayoutData((Object)new GridData(768));
    }

    private void createRotationPanel() {
        Label lblRotation = new Label(this.cmpContent, 0);
        lblRotation.setLayoutData((Object)new GridData(2));
        lblRotation.setText(Messages.getString("FontDefinitionDialog.Lbl.Rotation"));
        Composite cmpPanel = new Composite(this.cmpContent, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        cmpPanel.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 8;
        cmpPanel.setLayoutData((Object)gd);
        GridLayout glRotation = new GridLayout();
        glRotation.verticalSpacing = 10;
        glRotation.marginHeight = 0;
        glRotation.marginWidth = 2;
        Composite cmpRotation = new Composite(cmpPanel, 0);
        GridData gdGRPRotation = new GridData(1040);
        gdGRPRotation.heightHint = 150;
        cmpRotation.setLayoutData((Object)gdGRPRotation);
        cmpRotation.setLayout((Layout)glRotation);
        this.ascRotation = new AngleSelectorComposite(cmpRotation, 2048, ChartUIUtil.getFontRotation((FontDefinition)this.fdCurrent), Display.getCurrent().getSystemColor(1));
        GridData gdASCRotation = new GridData(1808);
        this.ascRotation.setLayoutData(gdASCRotation);
        this.ascRotation.setAngleChangeListener(this);
        this.iscRotation = new IntegerSpinControl(cmpRotation, 0, ChartUIUtil.getFontRotation((FontDefinition)this.fdCurrent));
        GridData gdISCRotation = new GridData(768);
        this.iscRotation.setLayoutData(gdISCRotation);
        this.iscRotation.setMinimum(-90);
        this.iscRotation.setMaximum(90);
        this.iscRotation.setIncrement(1);
        this.iscRotation.addListener(this);
        Label lblDegrees = new Label(cmpPanel, 0);
        lblDegrees.setLayoutData((Object)new GridData(1032));
        lblDegrees.setText(Messages.getString("FontDefinitionDialog.Label.Degrees"));
        Label lblPreview = new Label(cmpPanel, 0);
        lblPreview.setText(Messages.getString("FontDefinitionDialog.Lbl.Preview"));
        lblPreview.setLayoutData((Object)new GridData(2));
        FillLayout flPreview = new FillLayout();
        flPreview.marginHeight = 2;
        flPreview.marginWidth = 3;
        Composite grpPreview = new Composite(cmpPanel, 0);
        GridData gdGRPPreview = new GridData(1808);
        grpPreview.setLayoutData((Object)gdGRPPreview);
        grpPreview.setLayout((Layout)flPreview);
        this.fcPreview = new FontCanvas(grpPreview, 2048, this.fdCurrent, this.cdCurrent, true, true, true);
    }

    private void populateLists() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] saFontNames = ge.getAvailableFontFamilyNames();
        String currentFont = ChartUIUtil.getFontName((FontDefinition)this.fdCurrent);
        this.cmbFontNames.add(ChartUIUtil.FONT_AUTO);
        if (ChartUIUtil.FONT_AUTO.equals(currentFont)) {
            this.cmbFontNames.select(0);
        }
        int iC = 0;
        while (iC < saFontNames.length) {
            this.cmbFontNames.add(saFontNames[iC]);
            if (saFontNames[iC].equalsIgnoreCase(currentFont)) {
                this.cmbFontNames.select(iC + 1);
            }
            ++iC;
        }
        if (this.cmbFontNames.getSelectionIndex() == -1) {
            this.cmbFontNames.select(0);
        }
        if (this.isAlignmentEnabled && this.fdCurrent.getAlignment() != null && this.fdCurrent.getAlignment().isSetHorizontalAlignment() && this.fdCurrent.getAlignment().isSetVerticalAlignment()) {
            HorizontalAlignment ha = this.fdCurrent.getAlignment().getHorizontalAlignment();
            VerticalAlignment va = this.fdCurrent.getAlignment().getVerticalAlignment();
            if (HorizontalAlignment.LEFT_LITERAL.equals(ha)) {
                if (VerticalAlignment.TOP_LITERAL.equals(va)) {
                    this.btnATopLeft.setSelection(true);
                } else if (VerticalAlignment.BOTTOM_LITERAL.equals(va)) {
                    this.btnABottomLeft.setSelection(true);
                } else {
                    this.btnACenterLeft.setSelection(true);
                }
            } else if (HorizontalAlignment.RIGHT_LITERAL.equals(ha)) {
                if (VerticalAlignment.TOP_LITERAL.equals(va)) {
                    this.btnATopRight.setSelection(true);
                } else if (VerticalAlignment.BOTTOM_LITERAL.equals(va)) {
                    this.btnABottomRight.setSelection(true);
                } else {
                    this.btnACenterRight.setSelection(true);
                }
            } else if (VerticalAlignment.TOP_LITERAL.equals(va)) {
                this.btnATopCenter.setSelection(true);
            } else if (VerticalAlignment.BOTTOM_LITERAL.equals(va)) {
                this.btnABottomCenter.setSelection(true);
            } else {
                this.btnACenter.setSelection(true);
            }
        }
    }

    private void updatePreview() {
        FontDefinition fd = (FontDefinition)EcoreUtil.copy((EObject)this.fdCurrent);
        ChartUIUtil.getFlippedAlignment((TextAlignment)fd.getAlignment(), (boolean)this.isFlippedAxes());
        this.fcPreview.setFontDefinition(fd);
        this.fcPreview.redraw();
    }

    public FontDefinition getFontDefinition() {
        return this.fdCurrent;
    }

    public ColorDefinition getFontColor() {
        return this.cdCurrent == null || this.cdCurrent.isSetTransparency() && this.cdCurrent.getTransparency() == 0 ? null : this.cdCurrent;
    }

    public void widgetSelected(SelectionEvent e) {
        Object oSource = e.getSource();
        if (this.listAlighmentButtons.contains(oSource)) {
            if (!((Button)oSource).getSelection()) {
                this.fdCurrent.getAlignment().unsetHorizontalAlignment();
                this.fdCurrent.getAlignment().unsetVerticalAlignment();
                this.updatePreview();
                return;
            }
            this.selectAllToggleButtons(false);
            ((Button)oSource).setSelection(true);
        }
        if (oSource.equals(this.btnBold)) {
            if (this.btnBold.getSelection()) {
                this.fdCurrent.setBold(this.btnBold.getSelection());
            } else {
                this.fdCurrent.unsetBold();
            }
            this.updatePreview();
        } else if (oSource.equals(this.btnItalic)) {
            if (this.btnItalic.getSelection()) {
                this.fdCurrent.setItalic(this.btnItalic.getSelection());
            } else {
                this.fdCurrent.unsetItalic();
            }
            this.updatePreview();
        } else if (oSource.equals(this.btnUnderline)) {
            if (this.btnUnderline.getSelection()) {
                this.fdCurrent.setUnderline(this.btnUnderline.getSelection());
            } else {
                this.fdCurrent.unsetUnderline();
            }
            this.updatePreview();
        } else if (oSource.equals(this.btnStrikethru)) {
            if (this.btnStrikethru.getSelection()) {
                this.fdCurrent.setStrikethrough(this.btnStrikethru.getSelection());
            } else {
                this.fdCurrent.unsetStrikethrough();
            }
            this.updatePreview();
        } else if (oSource.equals(this.cbWrap)) {
            this.fdCurrent.setWordWrap(this.cbWrap.getSelection());
            this.updatePreview();
        } else if (oSource.equals(this.cmbFontNames)) {
            if (this.cmbFontNames.getText().equals(ChartUIUtil.FONT_AUTO)) {
                this.fdCurrent.setName(null);
            } else {
                this.fdCurrent.setName(this.cmbFontNames.getText());
            }
            this.updatePreview();
        } else if (oSource.equals(this.cmbFontSizes)) {
            this.handleFontSize();
        } else if (oSource.equals(this.btnATopLeft)) {
            this.fdCurrent.getAlignment().setHorizontalAlignment(HorizontalAlignment.LEFT_LITERAL);
            this.fdCurrent.getAlignment().setVerticalAlignment(VerticalAlignment.TOP_LITERAL);
            this.updatePreview();
        } else if (oSource.equals(this.btnACenterLeft)) {
            this.fdCurrent.getAlignment().setHorizontalAlignment(HorizontalAlignment.LEFT_LITERAL);
            this.fdCurrent.getAlignment().setVerticalAlignment(VerticalAlignment.CENTER_LITERAL);
            this.updatePreview();
        } else if (oSource.equals(this.btnABottomLeft)) {
            this.fdCurrent.getAlignment().setHorizontalAlignment(HorizontalAlignment.LEFT_LITERAL);
            this.fdCurrent.getAlignment().setVerticalAlignment(VerticalAlignment.BOTTOM_LITERAL);
            this.updatePreview();
        } else if (oSource.equals(this.btnATopCenter)) {
            this.fdCurrent.getAlignment().setHorizontalAlignment(HorizontalAlignment.CENTER_LITERAL);
            this.fdCurrent.getAlignment().setVerticalAlignment(VerticalAlignment.TOP_LITERAL);
            this.updatePreview();
        } else if (oSource.equals(this.btnACenter)) {
            this.fdCurrent.getAlignment().setHorizontalAlignment(HorizontalAlignment.CENTER_LITERAL);
            this.fdCurrent.getAlignment().setVerticalAlignment(VerticalAlignment.CENTER_LITERAL);
            this.updatePreview();
        } else if (oSource.equals(this.btnABottomCenter)) {
            this.fdCurrent.getAlignment().setHorizontalAlignment(HorizontalAlignment.CENTER_LITERAL);
            this.fdCurrent.getAlignment().setVerticalAlignment(VerticalAlignment.BOTTOM_LITERAL);
            this.updatePreview();
        } else if (oSource.equals(this.btnATopRight)) {
            this.fdCurrent.getAlignment().setHorizontalAlignment(HorizontalAlignment.RIGHT_LITERAL);
            this.fdCurrent.getAlignment().setVerticalAlignment(VerticalAlignment.TOP_LITERAL);
            this.updatePreview();
        } else if (oSource.equals(this.btnACenterRight)) {
            this.fdCurrent.getAlignment().setHorizontalAlignment(HorizontalAlignment.RIGHT_LITERAL);
            this.fdCurrent.getAlignment().setVerticalAlignment(VerticalAlignment.CENTER_LITERAL);
            this.updatePreview();
        } else if (oSource.equals(this.btnABottomRight)) {
            this.fdCurrent.getAlignment().setHorizontalAlignment(HorizontalAlignment.RIGHT_LITERAL);
            this.fdCurrent.getAlignment().setVerticalAlignment(VerticalAlignment.BOTTOM_LITERAL);
            this.updatePreview();
        }
    }

    public void handleEvent(Event e) {
        if (e.widget.equals((Object)this.iscRotation)) {
            this.fdCurrent.setRotation((double)this.iscRotation.getValue());
            this.ascRotation.setAngle(this.iscRotation.getValue());
            this.ascRotation.redraw();
            this.updatePreview();
        } else if (e.widget.equals((Object)this.fccColor) && e.type == 1) {
            this.cdCurrent = (ColorDefinition)this.fccColor.getFill();
            this.fcPreview.setColor(this.cdCurrent);
            this.fcPreview.redraw();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.widget.equals(this.cmbFontSizes)) {
            this.handleFontSize();
        }
    }

    private void handleFontSize() {
        if (this.cmbFontSizes.getText().equals(ChartUIUtil.FONT_AUTO)) {
            this.fdCurrent.unsetSize();
        } else {
            boolean oldIsset = this.fdCurrent.isSetSize();
            float oldValue = this.fdCurrent.getSize();
            boolean isCorrect = true;
            int value = 0;
            try {
                value = Integer.valueOf(this.cmbFontSizes.getText());
                if (value <= 0 || value > 7200) {
                    isCorrect = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                isCorrect = false;
            }
            if (!isCorrect) {
                this.cmbFontSizes.setText(oldIsset ? String.valueOf((int)oldValue) : ChartUIUtil.FONT_AUTO);
            } else {
                this.fdCurrent.setSize((float)value);
            }
        }
        this.updatePreview();
    }

    public void angleChanged(int iNewAngle) {
        this.iscRotation.setValue(iNewAngle);
        this.fdCurrent.setRotation((double)iNewAngle);
        this.updatePreview();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.widget.equals(this.cmbFontSizes)) {
            this.cmbFontSizes.notifyListeners(14, null);
        }
    }

    private boolean isFlippedAxes() {
        return this.wizardContext.getModel() instanceof ChartWithAxes && ((ChartWithAxes)this.wizardContext.getModel()).getOrientation().getValue() == 0;
    }
}

