/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.DateFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.FractionNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.JavaDateFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.JavaNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.NumberFormatSpecifier;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.FormatSpecifierComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class FormatSpecifierPreview
extends Composite {
    private static final String SAMPLE_NONE = Messages.getString("FormatSpecifierPreview.Lbl.NoFormat");
    private static final String SAMPLE_NA = Messages.getString("FormatSpecifierPreview.Lbl.NotAvailable");
    private static final Double SAMPLE_NUMBER = new Double(0.12345678);
    private static final Calendar SAMPLE_DATETIME = Calendar.getInstance();
    private Label lblPreview;
    private String dataType;
    private boolean isInEditor = true;

    public FormatSpecifierPreview(Composite parent, int style, boolean isInEditor) {
        super(parent, style);
        this.isInEditor = isInEditor;
        this.setLayout((Layout)new FillLayout());
        this.lblPreview = new Label((Composite)this, 0);
        this.lblPreview.setBackground(parent.getBackground());
    }

    public void updatePreview(FormatSpecifier fs) {
        if (fs == null) {
            this.lblPreview.setText(SAMPLE_NONE);
            this.getParent().layout();
            return;
        }
        if (!this.isInEditor || this.dataType == null) {
            this.dataType = fs instanceof DateFormatSpecifier || fs instanceof JavaDateFormatSpecifier ? FormatSpecifierComposite.DATA_TYPE_DATETIME : (fs instanceof NumberFormatSpecifier || fs instanceof JavaNumberFormatSpecifier || fs instanceof FractionNumberFormatSpecifier ? FormatSpecifierComposite.DATA_TYPE_NUMBER : FormatSpecifierComposite.DATA_TYPE_NONE);
        }
        if (FormatSpecifierComposite.DATA_TYPE_NONE.equals(this.dataType)) {
            this.lblPreview.setText(SAMPLE_NA);
        } else if (FormatSpecifierComposite.DATA_TYPE_NUMBER.equals(this.dataType)) {
            if (fs == null) {
                this.lblPreview.setText(SAMPLE_NUMBER.toString());
            } else {
                try {
                    this.lblPreview.setText(ValueFormatter.format((Object)SAMPLE_NUMBER, (FormatSpecifier)fs, (ULocale)ULocale.getDefault(), null));
                }
                catch (ChartException e) {
                    e.printStackTrace();
                }
            }
        } else if (FormatSpecifierComposite.DATA_TYPE_DATETIME.equals(this.dataType)) {
            if (fs == null) {
                this.lblPreview.setText(SAMPLE_DATETIME.getTime().toString());
            } else {
                try {
                    this.lblPreview.setText(ValueFormatter.format((Object)SAMPLE_DATETIME, (FormatSpecifier)fs, (ULocale)ULocale.getDefault(), null));
                }
                catch (ChartException e) {
                    e.printStackTrace();
                }
            }
        }
        this.getParent().layout();
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public void setEnabled(boolean enabled) {
        this.lblPreview.setEnabled(enabled);
        super.setEnabled(enabled);
    }
}

