/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Angle3D;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.impl.Angle3DImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.Rotation3DImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.AxisImpl;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.AreaSeries;
import org.eclipse.birt.chart.model.type.impl.AreaSeriesImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartPreviewPainter;
import org.eclipse.birt.chart.ui.swt.DefaultChartSubTypeImpl;
import org.eclipse.birt.chart.ui.swt.DefaultChartTypeImpl;
import org.eclipse.birt.chart.ui.swt.HelpContentImpl;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartSubType;
import org.eclipse.birt.chart.ui.swt.interfaces.IHelpContent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataComponent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataCustomizeUI;
import org.eclipse.birt.chart.ui.swt.type.BarChart;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.data.DefaultBaseSeriesComponent;
import org.eclipse.birt.chart.ui.util.ChartCacheManager;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AreaChart
extends DefaultChartTypeImpl {
    public static final String TYPE_LITERAL = "Area Chart";
    protected static final String STACKED_SUBTYPE_LITERAL = "Stacked";
    protected static final String PERCENTSTACKED_SUBTYPE_LITERAL = "Percent Stacked";
    protected static final String OVERLAY_SUBTYPE_LITERAL = "Overlay";
    private static final String CHART_TITLE = Messages.getString("AreaChart.Txt.DefaultAreaChartTitle");
    private static final String sStackedDescription = Messages.getString("AreaChart.Txt.StackedDescription");
    private static final String sPercentStackedDescription = Messages.getString("AreaChart.Txt.PercentStackedDescription");
    private static final String sOverlayDescription = Messages.getString("AreaChart.Txt.OverlayDescription");
    private transient Image imgIcon = UIHelper.getImage((String)"icons/obj16/areacharticon.gif");
    private transient Image imgStacked = null;
    private transient Image imgStackedWithDepth = null;
    private transient Image imgPercentStacked = null;
    private transient Image imgSideBySide = null;
    private transient Image imgSideBySide3D = null;

    public String getName() {
        return TYPE_LITERAL;
    }

    public Image getImage() {
        return this.imgIcon;
    }

    public IHelpContent getHelp() {
        return new HelpContentImpl(TYPE_LITERAL, Messages.getString("AreaChart.Txt.HelpText"));
    }

    public Collection<IChartSubType> getChartSubtypes(String sDimension, Orientation orientation) {
        Vector<IChartSubType> vSubTypes = new Vector<IChartSubType>();
        if (sDimension.equals(TWO_DIMENSION_TYPE) || sDimension.equals(ChartDimension.TWO_DIMENSIONAL_LITERAL.getName())) {
            if (orientation.equals(Orientation.VERTICAL_LITERAL)) {
                this.imgStacked = UIHelper.getImage((String)"icons/wizban/stackedareachartimage.gif");
                this.imgPercentStacked = UIHelper.getImage((String)"icons/wizban/percentstackedareachartimage.gif");
                this.imgSideBySide = UIHelper.getImage((String)"icons/wizban/sidebysideareachartimage.gif");
            } else {
                this.imgStacked = UIHelper.getImage((String)"icons/wizban/horizontalstackedareachartimage.gif");
                this.imgPercentStacked = UIHelper.getImage((String)"icons/wizban/horizontalpercentstackedareachartimage.gif");
                this.imgSideBySide = UIHelper.getImage((String)"icons/wizban/horizontalsidebysideareachartimage.gif");
            }
            vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(OVERLAY_SUBTYPE_LITERAL, this.imgSideBySide, sOverlayDescription, Messages.getString("AreaChart.SubType.Overlay")));
            vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(STACKED_SUBTYPE_LITERAL, this.imgStacked, sStackedDescription, Messages.getString("AreaChart.SubType.Stacked")));
            vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(PERCENTSTACKED_SUBTYPE_LITERAL, this.imgPercentStacked, sPercentStackedDescription, Messages.getString("AreaChart.SubType.PercentStacked")));
        } else if (sDimension.equals(TWO_DIMENSION_WITH_DEPTH_TYPE) || sDimension.equals(ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL.getName())) {
            this.imgStackedWithDepth = orientation.equals(Orientation.VERTICAL_LITERAL) ? UIHelper.getImage((String)"icons/wizban/stackedareachartwithdepthimage.gif") : UIHelper.getImage((String)"icons/wizban/horizontalstackedareachartwithdepthimage.gif");
            vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(STACKED_SUBTYPE_LITERAL, this.imgStackedWithDepth, sStackedDescription, Messages.getString("AreaChart.SubType.Stacked")));
        } else if (sDimension.equals(THREE_DIMENSION_TYPE) || sDimension.equals(ChartDimension.THREE_DIMENSIONAL_LITERAL.getName())) {
            this.imgSideBySide3D = UIHelper.getImage((String)"icons/wizban/sidebysideareachart3dimage.gif");
            vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(OVERLAY_SUBTYPE_LITERAL, this.imgSideBySide3D, sOverlayDescription, Messages.getString("AreaChart.SubType.Overlay")));
        }
        return vSubTypes;
    }

    public Chart getModel(String sSubType, Orientation orientation, String sDimension, Chart currentChart) {
        Series valueSeries;
        SeriesDefinition sdY;
        ChartWithAxes newChart = null;
        if (currentChart != null && (newChart = (ChartWithAxes)this.getConvertedChart(currentChart, sSubType, orientation, sDimension)) != null) {
            return newChart;
        }
        newChart = ChartWithAxesImpl.create();
        newChart.setType(TYPE_LITERAL);
        newChart.setSubType(sSubType);
        newChart.setOrientation(orientation);
        newChart.setDimension(ChartUIUtil.getDimensionType((String)sDimension));
        newChart.setUnits("Points");
        ((Axis)newChart.getAxes().get(0)).setOrientation(Orientation.HORIZONTAL_LITERAL);
        ((Axis)newChart.getAxes().get(0)).setType(AxisType.TEXT_LITERAL);
        ((Axis)newChart.getAxes().get(0)).setCategoryAxis(true);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        Series categorySeries = SeriesImpl.create();
        sdX.getSeries().add((Object)categorySeries);
        sdX.getSeriesPalette().shift(0);
        ((Axis)newChart.getAxes().get(0)).getSeriesDefinitions().add((Object)sdX);
        newChart.getTitle().getLabel().getCaption().setValue(CHART_TITLE);
        if (sSubType.equalsIgnoreCase(STACKED_SUBTYPE_LITERAL)) {
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setOrientation(Orientation.VERTICAL_LITERAL);
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setType(AxisType.LINEAR_LITERAL);
            sdY = SeriesDefinitionImpl.create();
            sdY.getSeriesPalette().shift(0);
            valueSeries = this.getSeries();
            ((AreaSeries)valueSeries).setStacked(true);
            sdY.getSeries().add((Object)valueSeries);
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().add((Object)sdY);
        } else if (sSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL)) {
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setOrientation(Orientation.VERTICAL_LITERAL);
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setType(AxisType.LINEAR_LITERAL);
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setPercent(true);
            sdY = SeriesDefinitionImpl.create();
            sdY.getSeriesPalette().shift(0);
            valueSeries = this.getSeries();
            ((AreaSeries)valueSeries).setStacked(true);
            sdY.getSeries().add((Object)valueSeries);
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().add((Object)sdY);
        } else if (sSubType.equalsIgnoreCase(OVERLAY_SUBTYPE_LITERAL)) {
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setOrientation(Orientation.VERTICAL_LITERAL);
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setType(AxisType.LINEAR_LITERAL);
            sdY = SeriesDefinitionImpl.create();
            sdY.getSeriesPalette().shift(0);
            valueSeries = this.getSeries();
            ((AreaSeries)valueSeries).setStacked(false);
            sdY.getSeries().add((Object)valueSeries);
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().add((Object)sdY);
        }
        if (sDimension.equals(THREE_DIMENSION_TYPE)) {
            newChart.setRotation(Rotation3DImpl.create((Angle3D[])new Angle3D[]{Angle3DImpl.create((double)-20.0, (double)45.0, (double)0.0)}));
            newChart.setUnitSpacing(50.0);
            newChart.getPrimaryBaseAxes()[0].getAncillaryAxes().clear();
            Axis zAxisAncillary = AxisImpl.create((int)3);
            zAxisAncillary.setTitlePosition(Position.BELOW_LITERAL);
            zAxisAncillary.getTitle().getCaption().setValue(Messages.getString("ChartWithAxesImpl.Z_Axis.title"));
            zAxisAncillary.getTitle().setVisible(true);
            zAxisAncillary.setPrimaryAxis(true);
            zAxisAncillary.setLabelPosition(Position.BELOW_LITERAL);
            zAxisAncillary.setOrientation(Orientation.HORIZONTAL_LITERAL);
            zAxisAncillary.getOrigin().setType(IntersectionType.MIN_LITERAL);
            zAxisAncillary.getOrigin().setValue((DataElement)NumberDataElementImpl.create((double)0.0));
            zAxisAncillary.getTitle().setVisible(false);
            zAxisAncillary.setType(AxisType.TEXT_LITERAL);
            newChart.getPrimaryBaseAxes()[0].getAncillaryAxes().add((Object)zAxisAncillary);
            newChart.getPrimaryOrthogonalAxis(newChart.getPrimaryBaseAxes()[0]).getTitle().getCaption().getFont().setRotation(0.0);
            SeriesDefinition sdZ = SeriesDefinitionImpl.create();
            sdZ.getSeriesPalette().shift(0);
            sdZ.getSeries().add((Object)SeriesImpl.create());
            zAxisAncillary.getSeriesDefinitions().add((Object)sdZ);
        }
        this.addSampleData((Chart)newChart);
        return newChart;
    }

    private void addSampleData(Chart newChart) {
        SampleData sd = DataFactory.eINSTANCE.createSampleData();
        sd.getBaseSampleData().clear();
        sd.getOrthogonalSampleData().clear();
        BaseSampleData sdBase = DataFactory.eINSTANCE.createBaseSampleData();
        sdBase.setDataSetRepresentation("A, B, C");
        sd.getBaseSampleData().add((Object)sdBase);
        OrthogonalSampleData oSample = DataFactory.eINSTANCE.createOrthogonalSampleData();
        oSample.setDataSetRepresentation("5,14,10");
        oSample.setSeriesDefinitionIndex(0);
        sd.getOrthogonalSampleData().add((Object)oSample);
        if (newChart.getDimension() == ChartDimension.THREE_DIMENSIONAL_LITERAL) {
            BaseSampleData sdAncillary = DataFactory.eINSTANCE.createBaseSampleData();
            sdAncillary.setDataSetRepresentation("Series 1");
            sd.getAncillarySampleData().add((Object)sdAncillary);
        }
        newChart.setSampleData(sd);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Chart getConvertedChart(Chart currentChart, String sNewSubType, Orientation newOrientation, String sNewDimension) {
        Chart helperModel = (Chart)EcoreUtil.copy((EObject)currentChart);
        ChartDimension oldDimension = currentChart.getDimension();
        ChartCacheManager.getInstance().cacheSeries(ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)helperModel));
        if (currentChart instanceof ChartWithAxes) {
            Series series;
            int j;
            if (currentChart.getType().equals(TYPE_LITERAL)) {
                currentChart.setSubType(sNewSubType);
                EList axes = ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes();
                int i = 0;
                int seriesIndex = 0;
                while (i < axes.size()) {
                    if (sNewSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL)) {
                        if (!ChartPreviewPainter.isLivePreviewActive() && !this.isNumbericAxis((Axis)axes.get(i))) {
                            ((Axis)axes.get(i)).setType(AxisType.LINEAR_LITERAL);
                        }
                        ((Axis)axes.get(i)).setPercent(true);
                    } else {
                        ((Axis)axes.get(i)).setPercent(false);
                    }
                    EList seriesdefinitions = ((Axis)axes.get(i)).getSeriesDefinitions();
                    Series firstSeries = ((SeriesDefinition)seriesdefinitions.get(0)).getDesignTimeSeries();
                    j = 0;
                    while (j < seriesdefinitions.size()) {
                        series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                        if (sNewSubType.equalsIgnoreCase(STACKED_SUBTYPE_LITERAL) || sNewSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL)) {
                            if (j != 0) {
                                series = this.getConvertedSeriesAsFirst(series, seriesIndex, firstSeries);
                            }
                            ++seriesIndex;
                            if (!ChartPreviewPainter.isLivePreviewActive() && !this.isNumbericAxis((Axis)axes.get(i))) {
                                ((Axis)axes.get(i)).setType(AxisType.LINEAR_LITERAL);
                            }
                            if (series.canBeStacked()) {
                                series.setStacked(true);
                            }
                            ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().clear();
                            ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().add((Object)series);
                        } else {
                            series.setStacked(false);
                        }
                        ++j;
                    }
                    ++i;
                }
            } else {
                if (!currentChart.getType().equals(BarChart.TYPE_LITERAL) && !currentChart.getType().equals("Tube Chart") && !currentChart.getType().equals("Cone Chart") && !currentChart.getType().equals("Pyramid Chart") && !currentChart.getType().equals("Line Chart") && !currentChart.getType().equals("Stock Chart") && !currentChart.getType().equals("Scatter Chart") && !currentChart.getType().equals("Bubble Chart") && !currentChart.getType().equals("Difference Chart") && !currentChart.getType().equals("Gantt Chart")) return null;
                currentChart.setType(TYPE_LITERAL);
                currentChart.setSubType(sNewSubType);
                currentChart.getTitle().getLabel().getCaption().setValue(CHART_TITLE);
                ArrayList<AxisType> axisTypes = new ArrayList<AxisType>();
                EList axes = ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes();
                int i = 0;
                int seriesIndex = 0;
                while (i < axes.size()) {
                    if (!ChartPreviewPainter.isLivePreviewActive() && !this.isNumbericAxis((Axis)axes.get(i))) {
                        ((Axis)axes.get(i)).setType(AxisType.LINEAR_LITERAL);
                    }
                    if (sNewSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL)) {
                        ((Axis)axes.get(i)).setPercent(true);
                    } else {
                        ((Axis)axes.get(i)).setPercent(false);
                    }
                    EList seriesdefinitions = ((Axis)axes.get(i)).getSeriesDefinitions();
                    j = 0;
                    while (j < seriesdefinitions.size()) {
                        series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                        series = this.getConvertedSeries(series, seriesIndex++);
                        if (sNewSubType.equalsIgnoreCase(STACKED_SUBTYPE_LITERAL) || sNewSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL)) {
                            series.setStacked(true);
                        } else {
                            series.setStacked(false);
                        }
                        ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().clear();
                        ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().add((Object)series);
                        axisTypes.add(((Axis)axes.get(i)).getType());
                        ++j;
                    }
                    ++i;
                }
                currentChart.setSampleData(this.getConvertedSampleData(currentChart.getSampleData(), ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getType(), axisTypes));
            }
        } else {
            currentChart = ChartWithAxesImpl.create();
            currentChart.setType(TYPE_LITERAL);
            currentChart.setSubType(sNewSubType);
            ((ChartWithAxes)currentChart).setOrientation(newOrientation);
            currentChart.setDimension(ChartUIUtil.getDimensionType((String)sNewDimension));
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).setOrientation(Orientation.HORIZONTAL_LITERAL);
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).setType(AxisType.TEXT_LITERAL);
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).setCategoryAxis(true);
            ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).setOrientation(Orientation.VERTICAL_LITERAL);
            ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).setType(AxisType.LINEAR_LITERAL);
            currentChart.setBlock(helperModel.getBlock());
            currentChart.setDescription(helperModel.getDescription());
            currentChart.setGridColumnCount(helperModel.getGridColumnCount());
            currentChart.setSampleData(helperModel.getSampleData());
            currentChart.setScript(helperModel.getScript());
            currentChart.setSeriesThickness(helperModel.getSeriesThickness());
            currentChart.setUnits(helperModel.getUnits());
            if (helperModel.getInteractivity() != null) {
                currentChart.getInteractivity().setEnable(helperModel.getInteractivity().isEnable());
                currentChart.getInteractivity().setLegendBehavior(helperModel.getInteractivity().getLegendBehavior());
            }
            if (!helperModel.getType().equals("Pie Chart") && !helperModel.getType().equals("Meter Chart")) return null;
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().clear();
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().add(((ChartWithoutAxes)helperModel).getSeriesDefinitions().get(0));
            ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().clear();
            ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().addAll((Collection)((SeriesDefinition)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().get(0)).getSeriesDefinitions());
            Series series = ((SeriesDefinition)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().get(0)).getDesignTimeSeries();
            ((SeriesDefinition)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().get(0)).getSeries().clear();
            ((SeriesDefinition)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().get(0)).getSeries().add((Object)series);
            EList seriesdefinitions = ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions();
            int j = 0;
            while (j < seriesdefinitions.size()) {
                series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                series = this.getConvertedSeries(series, j);
                series.getLabel().setVisible(false);
                if (sNewSubType.equalsIgnoreCase(STACKED_SUBTYPE_LITERAL) || sNewSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL)) {
                    series.setStacked(true);
                } else {
                    series.setStacked(false);
                }
                ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().clear();
                ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().add((Object)series);
                ++j;
            }
            currentChart.getLegend().setItemType(LegendItemType.SERIES_LITERAL);
            currentChart.getTitle().getLabel().getCaption().setValue(CHART_TITLE);
        }
        if (currentChart instanceof ChartWithAxes && !((ChartWithAxes)currentChart).getOrientation().equals(newOrientation)) {
            ((ChartWithAxes)currentChart).setOrientation(newOrientation);
        }
        if (!currentChart.getDimension().equals(ChartUIUtil.getDimensionType((String)sNewDimension))) {
            currentChart.setDimension(ChartUIUtil.getDimensionType((String)sNewDimension));
        }
        if (sNewDimension.equals(THREE_DIMENSION_TYPE) && ChartUIUtil.getDimensionType((String)sNewDimension) != oldDimension) {
            ((ChartWithAxes)currentChart).setRotation(Rotation3DImpl.create((Angle3D[])new Angle3D[]{Angle3DImpl.create((double)-20.0, (double)45.0, (double)0.0)}));
            ((ChartWithAxes)currentChart).getPrimaryBaseAxes()[0].getAncillaryAxes().clear();
            Axis zAxisAncillary = AxisImpl.create((int)3);
            zAxisAncillary.setTitlePosition(Position.BELOW_LITERAL);
            zAxisAncillary.getTitle().getCaption().setValue(Messages.getString("ChartWithAxesImpl.Z_Axis.title"));
            zAxisAncillary.getTitle().setVisible(true);
            zAxisAncillary.setPrimaryAxis(true);
            zAxisAncillary.setLabelPosition(Position.BELOW_LITERAL);
            zAxisAncillary.setOrientation(Orientation.HORIZONTAL_LITERAL);
            zAxisAncillary.getOrigin().setType(IntersectionType.MIN_LITERAL);
            zAxisAncillary.getOrigin().setValue((DataElement)NumberDataElementImpl.create((double)0.0));
            zAxisAncillary.getTitle().setVisible(false);
            zAxisAncillary.setType(AxisType.TEXT_LITERAL);
            ((ChartWithAxes)currentChart).getPrimaryBaseAxes()[0].getAncillaryAxes().add((Object)zAxisAncillary);
            SeriesDefinition sdZ = SeriesDefinitionImpl.create();
            sdZ.getSeriesPalette().shift(0);
            sdZ.getSeries().add((Object)SeriesImpl.create());
            zAxisAncillary.getSeriesDefinitions().add((Object)sdZ);
            if (currentChart.getSampleData().getAncillarySampleData().isEmpty()) {
                BaseSampleData sdAncillary = DataFactory.eINSTANCE.createBaseSampleData();
                sdAncillary.setDataSetRepresentation("Series 1");
                currentChart.getSampleData().getAncillarySampleData().add((Object)sdAncillary);
            }
            EList seriesdefinitions = ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)currentChart, (int)0);
            int j = 0;
            while (j < seriesdefinitions.size()) {
                Series series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                series.setStacked(false);
                ++j;
            }
        }
        ChartUIUtil.restoreLabelPositionFromCache((Chart)currentChart);
        return currentChart;
    }

    private boolean isNumbericAxis(Axis axis) {
        return axis.getType().getValue() == 0 || axis.getType().getValue() == 1;
    }

    private Series getConvertedSeries(Series series, int seriesIndex) {
        if (series.getClass().getName().equals(SeriesImpl.class.getName())) {
            return series;
        }
        AreaSeries areaseries = (AreaSeries)ChartCacheManager.getInstance().findSeries(AreaSeriesImpl.class.getName(), seriesIndex);
        if (areaseries == null) {
            areaseries = (AreaSeries)this.getSeries();
        }
        ChartUIUtil.copyGeneralSeriesAttributes((Series)series, (Series)areaseries);
        return areaseries;
    }

    private SampleData getConvertedSampleData(SampleData currentSampleData, AxisType xAxisType, ArrayList axisTypes) {
        EList bsdList = currentSampleData.getBaseSampleData();
        Vector vNewBaseSampleData = this.getConvertedBaseSampleDataRepresentation(bsdList, xAxisType);
        currentSampleData.getBaseSampleData().clear();
        currentSampleData.getBaseSampleData().addAll((Collection)vNewBaseSampleData);
        EList osdList = currentSampleData.getOrthogonalSampleData();
        Vector vNewOrthogonalSampleData = this.getConvertedOrthogonalSampleDataRepresentation(osdList, axisTypes);
        currentSampleData.getOrthogonalSampleData().clear();
        currentSampleData.getOrthogonalSampleData().addAll((Collection)vNewOrthogonalSampleData);
        return currentSampleData;
    }

    private Vector getConvertedBaseSampleDataRepresentation(EList bsdList, AxisType xAxisType) {
        Vector<BaseSampleData> vNewBaseSampleData = new Vector<BaseSampleData>();
        int i = 0;
        while (i < bsdList.size()) {
            BaseSampleData bsd = (BaseSampleData)bsdList.get(i);
            bsd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation((AxisType)xAxisType, (String)bsd.getDataSetRepresentation(), (int)i));
            vNewBaseSampleData.add(bsd);
            ++i;
        }
        return vNewBaseSampleData;
    }

    private Vector getConvertedOrthogonalSampleDataRepresentation(EList osdList, ArrayList axisTypes) {
        Vector<OrthogonalSampleData> vNewOrthogonalSampleData = new Vector<OrthogonalSampleData>();
        int i = 0;
        while (i < osdList.size()) {
            OrthogonalSampleData osd = (OrthogonalSampleData)osdList.get(i);
            osd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation((AxisType)((AxisType)axisTypes.get(i)), (String)osd.getDataSetRepresentation(), (int)i));
            vNewOrthogonalSampleData.add(osd);
            ++i;
        }
        return vNewOrthogonalSampleData;
    }

    public String[] getSupportedDimensions() {
        return new String[]{TWO_DIMENSION_TYPE, TWO_DIMENSION_WITH_DEPTH_TYPE, THREE_DIMENSION_TYPE};
    }

    public String getDefaultDimension() {
        return TWO_DIMENSION_TYPE;
    }

    public boolean supportsTransposition() {
        return true;
    }

    public boolean supportsTransposition(String dimension) {
        if (ChartUIUtil.getDimensionType((String)dimension) == ChartDimension.THREE_DIMENSIONAL_LITERAL) {
            return false;
        }
        return this.supportsTransposition();
    }

    public ISelectDataComponent getBaseUI(Chart chart, ISelectDataCustomizeUI selectDataUI, ChartWizardContext context, String sTitle) {
        return new DefaultBaseSeriesComponent((SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)chart).get(0), context, sTitle);
    }

    public String getDisplayName() {
        return Messages.getString("AreaChart.Txt.DisplayName");
    }

    public boolean isDimensionSupported(String dimensionType, ChartWizardContext context, int nbOfAxes, int nbOfSeries) {
        boolean isSupported = super.isDimensionSupported(dimensionType, context, nbOfAxes, nbOfSeries);
        if (isSupported && TWO_DIMENSION_WITH_DEPTH_TYPE.equals(dimensionType)) {
            isSupported = nbOfAxes <= 1;
        }
        return isSupported;
    }

    public Series getSeries() {
        AreaSeries series = (AreaSeries)AreaSeriesImpl.create();
        ((Marker)series.getMarkers().get(0)).setVisible(false);
        series.getLineAttributes().setColor(ColorDefinitionImpl.BLUE());
        return series;
    }

    public boolean canCombine() {
        return true;
    }
}

