/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.chart;

import java.util.Collection;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Angle3D;
import org.eclipse.birt.chart.model.attribute.AngleType;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Interactivity;
import org.eclipse.birt.chart.model.attribute.impl.InteractivityImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartPreviewPainter;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.LocalizedNumberEditorComposite;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.format.SubtaskSheetImpl;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.InteractivitySheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart.BlockPropertiesSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart.CustomPropertiesSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart.GeneralPropertiesChartSheet;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ChartSheetImpl
extends SubtaskSheetImpl
implements SelectionListener,
Listener {
    private FillChooserComposite cmbBackground;
    private FillChooserComposite fccWall;
    private FillChooserComposite fccFloor;
    private Combo cmbStyle;
    private Button btnEnablePreview;
    private Button btnResetValue;
    private Button btnEnable;
    private AxisRotationChooser xChooser;
    private AxisRotationChooser yChooser;
    private AxisRotationChooser zChooser;

    public void createControl(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FormatChartArea_ID");
        this.init();
        this.cmpContent = new Composite(parent, 0);
        GridLayout glContent = new GridLayout(3, true);
        this.cmpContent.setLayout((Layout)glContent);
        GridData gd = new GridData(1808);
        this.cmpContent.setLayoutData((Object)gd);
        Composite cmpBasic = new Composite(this.cmpContent, 0);
        cmpBasic.setLayout((Layout)new GridLayout(3, false));
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        cmpBasic.setLayoutData((Object)gd);
        Composite cmp3D = new Composite(this.cmpContent, 0);
        cmp3D.setLayout((Layout)new GridLayout());
        cmp3D.setLayoutData((Object)new GridData(1808));
        Label lblBackground = new Label(cmpBasic, 0);
        lblBackground.setText(Messages.getString("ChartSheetImpl.Label.Background"));
        this.cmbBackground = new FillChooserComposite(cmpBasic, 0, this.getContext(), this.getChart().getBlock().getBackground(), true, true);
        GridData gridData = new GridData(768);
        this.cmbBackground.setLayoutData(gridData);
        this.cmbBackground.addListener(this);
        new Label(cmpBasic, 0);
        if (this.hasWallAndFloor()) {
            Label lblWall = new Label(cmpBasic, 0);
            lblWall.setLayoutData((Object)new GridData());
            lblWall.setText(Messages.getString("AttributeSheetImpl.Lbl.ChartWall"));
            this.fccWall = new FillChooserComposite(cmpBasic, 0, this.getContext(), ((ChartWithAxes)this.getChart()).getWallFill(), true, true, true, true);
            GridData gdFCCWall = new GridData(768);
            this.fccWall.setLayoutData(gdFCCWall);
            this.fccWall.addListener(this);
            new Label(cmpBasic, 0);
            Label lblFloor = new Label(cmpBasic, 0);
            lblFloor.setLayoutData((Object)new GridData());
            lblFloor.setText(Messages.getString("AttributeSheetImpl.Lbl.ChartFloor"));
            this.fccFloor = new FillChooserComposite(cmpBasic, 0, this.getContext(), ((ChartWithAxes)this.getChart()).getFloorFill(), true, true, true, true);
            GridData gdFCCFloor = new GridData(768);
            this.fccFloor.setLayoutData(gdFCCFloor);
            this.fccFloor.addListener(this);
            new Label(cmpBasic, 0);
        }
        new Label(cmpBasic, 0).setText(Messages.getString("ChartSheetImpl.Label.Style"));
        this.cmbStyle = new Combo(cmpBasic, 12);
        gridData = new GridData(768);
        this.cmbStyle.setLayoutData((Object)gridData);
        this.cmbStyle.addSelectionListener((SelectionListener)this);
        this.btnEnablePreview = new Button(cmpBasic, 32);
        this.btnEnablePreview.setText(Messages.getString("ChartSheetImpl.Label.EnableInPreview"));
        this.btnEnablePreview.setSelection(ChartPreviewPainter.isProcessorEnabled());
        this.btnEnablePreview.addSelectionListener((SelectionListener)this);
        if (this.getChart() instanceof ChartWithAxes && ChartUIUtil.is3DType((Chart)this.getChart())) {
            Group cmpRotation = new Group(cmp3D, 0);
            GridLayout gl = new GridLayout();
            gl.marginTop = 0;
            gl.verticalSpacing = 0;
            cmpRotation.setLayout((Layout)gl);
            cmpRotation.setLayoutData((Object)new GridData(768));
            cmpRotation.setText(Messages.getString("ChartLegendImpl.Group.Rotation"));
            this.xChooser = new AxisRotationChooser(ChartUIUtil.getAxisXForProcessing((ChartWithAxes)((ChartWithAxes)this.getChart())), 1);
            this.xChooser.placeComponents((Composite)cmpRotation);
            this.yChooser = new AxisRotationChooser(ChartUIUtil.getAxisYForProcessing((ChartWithAxes)((ChartWithAxes)this.getChart()), (int)0), 2);
            this.yChooser.placeComponents((Composite)cmpRotation);
            this.zChooser = new AxisRotationChooser(ChartUIUtil.getAxisZForProcessing((ChartWithAxes)((ChartWithAxes)this.getChart())), 3);
            this.zChooser.placeComponents((Composite)cmpRotation);
            this.btnResetValue = new Button((Composite)cmpRotation, 8);
            this.btnResetValue.setText(Messages.getString("ChartSheetImpl.Label.ResetValue"));
            this.btnResetValue.setSelection(ChartPreviewPainter.isProcessorEnabled());
            this.btnResetValue.addSelectionListener((SelectionListener)this);
        }
        this.btnEnable = new Button(cmpBasic, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.btnEnable.setLayoutData((Object)gridData);
        this.btnEnable.setText(Messages.getString("ChartSheetImpl.Label.InteractivityEnable"));
        this.btnEnable.setSelection(this.getChart().getInteractivity().isEnable());
        this.btnEnable.addSelectionListener((SelectionListener)this);
        this.populateLists();
        this.createButtonGroup(this.cmpContent);
    }

    private void init() {
        if (this.getChart().getInteractivity() == null) {
            Interactivity interactivity = InteractivityImpl.create();
            interactivity.eAdapters().addAll((Collection)this.getChart().eAdapters());
            this.getChart().setInteractivity(interactivity);
        }
    }

    private void populateLists() {
        IDataServiceProvider idsp = this.getContext().getDataServiceProvider();
        if (idsp != null) {
            String[] allStyleNames = idsp.getAllStyles();
            String[] displayNames = idsp.getAllStyleDisplayNames();
            String[] selection = new String[displayNames.length + 1];
            System.arraycopy(displayNames, 0, selection, 1, displayNames.length);
            selection[0] = Messages.getString("ChartSheetImpl.Label.None");
            this.cmbStyle.setItems(selection);
            this.cmbStyle.setData((Object)allStyleNames);
            String sStyle = idsp.getCurrentStyle();
            int idx = this.getStyleIndex(sStyle);
            this.cmbStyle.select(idx + 1);
        }
    }

    private int getStyleIndex(String style) {
        String[] allStyleNames = (String[])this.cmbStyle.getData();
        if (style != null && allStyleNames != null) {
            int i = 0;
            while (i < allStyleNames.length) {
                if (style.equals(allStyleNames[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private void createButtonGroup(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout(5, false));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 0x1000008;
        cmp.setLayoutData((Object)gridData);
        AbstractPopupSheet popup = new BlockPropertiesSheet(Messages.getString("ChartSheetImpl.Text.Outline"), this.getContext());
        Button btnBlockProp = this.createToggleButton(cmp, ".Outline", Messages.getString("ChartSheetImpl.Text.Outline&"), popup);
        btnBlockProp.addSelectionListener((SelectionListener)this);
        popup = new GeneralPropertiesChartSheet(Messages.getString("ChartSheetImpl.Text.GeneralProperties"), this.getContext());
        Button btnGeneralProp = this.createToggleButton(cmp, ".General", Messages.getString("ChartSheetImpl.Text.GeneralProperties&"), popup);
        btnGeneralProp.addSelectionListener((SelectionListener)this);
        popup = new CustomPropertiesSheet(Messages.getString("ChartSheetImpl.Text.CustomProperties"), this.getContext());
        Button btnCustomProp = this.createToggleButton(cmp, ".Custom", Messages.getString("ChartSheetImpl.Text.CustomProperties&"), popup);
        btnCustomProp.addSelectionListener((SelectionListener)this);
        popup = new InteractivitySheet(Messages.getString("ChartSheetImpl.Label.Interactivity"), this.getContext(), this.getChart().getBlock().getTriggers(), 4, false, true);
        Button btnInteractivity = this.createToggleButton(cmp, ".Interactivity", Messages.getString("SeriesYSheetImpl.Label.Interactivity&"), popup, this.getChart().getInteractivity().isEnable());
        btnInteractivity.addSelectionListener((SelectionListener)this);
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.cmbBackground)) {
            this.getChart().getBlock().setBackground((Fill)event.data);
        } else if (event.widget.equals((Object)this.fccWall)) {
            if (this.hasWallAndFloor()) {
                ((ChartWithAxes)this.getChart()).setWallFill((Fill)event.data);
            }
        } else if (event.widget.equals((Object)this.fccFloor) && this.hasWallAndFloor()) {
            ((ChartWithAxes)this.getChart()).setFloorFill((Fill)event.data);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.detachPopup(e.widget)) {
            return;
        }
        if (this.isRegistered(e.widget)) {
            this.attachPopup(((Button)e.widget).getData().toString());
        }
        if (e.widget.equals(this.cmbStyle)) {
            String[] allStyleNames = (String[])this.cmbStyle.getData();
            String sStyle = null;
            int idx = this.cmbStyle.getSelectionIndex();
            if (idx > 0) {
                sStyle = allStyleNames[idx - 1];
            }
            this.getContext().getDataServiceProvider().setStyle(sStyle);
            if (this.btnEnablePreview.getSelection()) {
                this.refreshPreview();
            }
        } else if (e.widget.equals(this.btnEnablePreview)) {
            ChartPreviewPainter.enableProcessor((boolean)this.btnEnablePreview.getSelection());
            this.refreshPreview();
        } else if (e.widget.equals(this.btnEnable)) {
            this.getChart().getInteractivity().setEnable(this.btnEnable.getSelection());
            this.setToggleButtonEnabled(".Interactivity", this.btnEnable.getSelection());
            if (this.getToggleButton(".Interactivity").getSelection()) {
                this.detachPopup();
            }
        } else if (e.widget.equals(this.btnResetValue)) {
            this.setAxisAngle(1, -20);
            this.xChooser.txtRotation.setValue(-20.0);
            this.setAxisAngle(2, 45);
            this.yChooser.txtRotation.setValue(45.0);
            this.setAxisAngle(3, 0);
            this.zChooser.txtRotation.setValue(0.0);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void refreshPreview() {
        boolean currentValue = this.getChart().getTitle().isVisible();
        ChartAdapter.ignoreNotifications((boolean)true);
        this.getChart().getTitle().setVisible(!currentValue);
        ChartAdapter.ignoreNotifications((boolean)false);
        this.getChart().getTitle().setVisible(currentValue);
    }

    private boolean hasWallAndFloor() {
        return this.getChart() instanceof ChartWithAxes && this.getChart().getDimension().getValue() != 0;
    }

    private void setAxisAngle(int angleType, int angleDegree) {
        Angle3D angle3D = this.getAngle3D();
        angle3D.setType(AngleType.NONE_LITERAL);
        ((ChartWithAxes)this.getChart()).getRotation().getAngles().clear();
        ((ChartWithAxes)this.getChart()).getRotation().getAngles().add((Object)angle3D);
        switch (angleType) {
            case 1: {
                angle3D.setXAngle((double)angleDegree);
                break;
            }
            case 2: {
                angle3D.setYAngle((double)angleDegree);
                break;
            }
            case 3: {
                angle3D.setZAngle((double)angleDegree);
            }
        }
    }

    private Angle3D getAngle3D() {
        return (Angle3D)((ChartWithAxes)this.getChart()).getRotation().getAngles().get(0);
    }

    private class AxisRotationChooser
    implements SelectionListener,
    ModifyListener {
        private Button btnAntiRotation;
        private Button btnRotation;
        private LocalizedNumberEditorComposite txtRotation;
        private int angleType;

        public AxisRotationChooser(Axis axis, int angleType) {
            this.angleType = angleType;
        }

        public void placeComponents(Composite parent) {
            Composite context = new Composite(parent, 0);
            context.setLayout((Layout)new GridLayout(3, false));
            context.setLayoutData((Object)new GridData(768));
            this.btnAntiRotation = new Button(context, 8);
            GridData gd = new GridData();
            ChartUIUtil.setChartImageButtonSizeByPlatform((GridData)gd);
            this.btnAntiRotation.setLayoutData((Object)gd);
            this.btnAntiRotation.setImage(UIHelper.getImage((String)this.getImagePath(this.angleType, true)));
            this.btnAntiRotation.addSelectionListener((SelectionListener)this);
            this.btnRotation = new Button(context, 8);
            gd = new GridData();
            gd.widthHint = 20;
            gd.heightHint = 20;
            this.btnRotation.setLayoutData((Object)gd);
            this.btnRotation.setImage(UIHelper.getImage((String)this.getImagePath(this.angleType, false)));
            this.btnRotation.addSelectionListener((SelectionListener)this);
            this.txtRotation = new LocalizedNumberEditorComposite(context, 2052);
            this.txtRotation.setLayoutData(new GridData(768));
            this.txtRotation.setValue(this.getAxisAngle(this.angleType));
            this.txtRotation.addModifyListener(this);
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget.equals(this.btnAntiRotation)) {
                ChartSheetImpl.this.setAxisAngle(this.angleType, (int)this.getAxisAngle(this.angleType) - 10);
                this.txtRotation.setValue(this.getAxisAngle(this.angleType));
            } else if (e.widget.equals(this.btnRotation)) {
                ChartSheetImpl.this.setAxisAngle(this.angleType, (int)this.getAxisAngle(this.angleType) + 10);
                this.txtRotation.setValue(this.getAxisAngle(this.angleType));
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void modifyText(ModifyEvent e) {
            if (e.widget.equals((Object)this.txtRotation)) {
                ChartSheetImpl.this.setAxisAngle(this.angleType, (int)this.txtRotation.getValue());
            }
        }

        private String getImagePath(int angleType, boolean bAntiRotation) {
            String basePath = "icons/obj16/";
            String filename = null;
            switch (angleType) {
                case 1: {
                    filename = bAntiRotation ? "x_rotation.gif" : "x_anti_rotation.gif";
                    break;
                }
                case 2: {
                    filename = bAntiRotation ? "y_anti_rotation.gif" : "y_rotation.gif";
                    break;
                }
                case 3: {
                    filename = bAntiRotation ? "z_rotation.gif" : "z_anti_rotation.gif";
                }
            }
            return String.valueOf(basePath) + filename;
        }

        private double getAxisAngle(int angleType) {
            switch (angleType) {
                case 1: {
                    return ChartSheetImpl.this.getAngle3D().getXAngle();
                }
                case 2: {
                    return ChartSheetImpl.this.getAngle3D().getYAngle();
                }
                case 3: {
                    return ChartSheetImpl.this.getAngle3D().getZAngle();
                }
            }
            return 0.0;
        }
    }
}

