/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.launching.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaLaunchDelegate;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xsl.jaxp.launching.IDebugger;
import org.eclipse.wst.xsl.jaxp.launching.IProcessorInstall;
import org.eclipse.wst.xsl.jaxp.launching.IProcessorInvoker;
import org.eclipse.wst.xsl.jaxp.launching.IProcessorJar;
import org.eclipse.wst.xsl.jaxp.launching.ITransformerFactory;
import org.eclipse.wst.xsl.jaxp.launching.JAXPRuntime;
import org.eclipse.wst.xsl.jaxp.launching.internal.JAXPLaunchingPlugin;
import org.eclipse.wst.xsl.jaxp.launching.internal.LaunchHelper;
import org.eclipse.wst.xsl.jaxp.launching.internal.Messages;
import org.eclipse.wst.xsl.jaxp.launching.model.JAXPDebugTarget;
import org.osgi.framework.Bundle;

public class JAXPJavaLaunchConfigurationDelegate
extends JavaLaunchDelegate
implements IDebugEventSetListener {
    private String mode;
    LaunchHelper launchHelper;

    public synchronized void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.mode = mode;
        this.launchHelper.save(this.getLaunchConfigFile());
        IProcessorInstall install = JAXPJavaLaunchConfigurationDelegate.getProcessorInstall(configuration, mode);
        String tfactory = this.getTransformerFactory(install);
        String name = install.getName();
        if (tfactory != null) {
            name = String.valueOf(name) + "[" + tfactory + "]";
        }
        launch.setAttribute("launchName", name);
        final ISourceLocator configuredLocator = launch.getSourceLocator();
        launch.setSourceLocator(null);
        super.launch(configuration, mode, launch, monitor);
        final ISourceLocator javaSourceLookupDirector = launch.getSourceLocator();
        launch.setSourceLocator(new ISourceLocator(){

            public Object getSourceElement(IStackFrame stackFrame) {
                Object sourceElement = javaSourceLookupDirector.getSourceElement(stackFrame);
                if (sourceElement == null) {
                    sourceElement = configuredLocator.getSourceElement(stackFrame);
                }
                return sourceElement;
            }
        });
        IDebugTarget javaTarget = launch.getDebugTarget();
        JAXPDebugTarget xslTarget = new JAXPDebugTarget(launch, launch.getProcesses()[0], this.launchHelper);
        launch.removeDebugTarget(javaTarget);
        launch.addDebugTarget((IDebugTarget)xslTarget);
    }

    protected IBreakpoint[] getBreakpoints(ILaunchConfiguration configuration) {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        if (!breakpointManager.isEnabled()) {
            return null;
        }
        IBreakpoint[] javaBreakpoints = super.getBreakpoints(configuration);
        IBreakpoint[] xslBreakpoints = breakpointManager.getBreakpoints("org.eclipse.wst.xsl.launching.XSLDebugModel");
        IBreakpoint[] breakpoints = new IBreakpoint[javaBreakpoints.length + xslBreakpoints.length];
        System.arraycopy(javaBreakpoints, 0, breakpoints, 0, javaBreakpoints.length);
        System.arraycopy(xslBreakpoints, 0, breakpoints, javaBreakpoints.length, xslBreakpoints.length);
        return breakpoints;
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        this.launchHelper = new LaunchHelper(configuration);
        if (mode.equals("debug")) {
            String installTF;
            final IProcessorInstall install = JAXPJavaLaunchConfigurationDelegate.getProcessorInstall(configuration, "run");
            if (install.getDebugger() == null) {
                final boolean[] result = new boolean[1];
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        String debuggingInstallId = JAXPLaunchingPlugin.getDefault().getPluginPreferences().getString("org.eclipse.wst.xsl.jaxp.launching.ATTR_DEFAULT_DEBUGGING_INSTALL_ID");
                        IProcessorInstall processor = JAXPRuntime.getProcessor(debuggingInstallId);
                        IWorkbenchWindow dw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        String title = Messages.getString("XSLTLaunchConfigurationDelegate.0");
                        String message = String.valueOf(Messages.getString("XSLTLaunchConfigurationDelegate.1")) + install.getName() + Messages.getString("XSLTLaunchConfigurationDelegate.2") + Messages.getString("XSLTLaunchConfigurationDelegate.3") + processor.getName() + Messages.getString("XSLTLaunchConfigurationDelegate.4");
                        MessageDialog dialog = new MessageDialog(dw.getShell(), title, null, message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                        result[0] = dialog.open() == 0;
                    }
                });
                return result[0];
            }
            String debuggerTF = install.getDebugger().getTransformerFactory();
            String string = installTF = this.launchHelper.getTransformerFactory() == null ? null : this.launchHelper.getTransformerFactory().getFactoryClass();
            if (!debuggerTF.equals(installTF)) {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        IWorkbenchWindow dw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        String title = Messages.getString("Change Transformer Factory");
                        String message = String.valueOf(install.getName()) + " must use the " + JAXPJavaLaunchConfigurationDelegate.this.launchHelper.getTransformerFactory().getName() + " transformer factory when debugging.\n" + "Be aware that this may give different results to the " + JAXPJavaLaunchConfigurationDelegate.this.launchHelper.getTransformerFactory().getName() + " transformer factory configured for this launch configuration.";
                        MessageDialog dialog = new MessageDialog(dw.getShell(), title, null, message, 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                        dialog.open();
                    }
                });
            }
        }
        return super.preLaunchCheck(configuration, mode, monitor);
    }

    public IVMRunner getVMRunner(ILaunchConfiguration configuration, String mode) throws CoreException {
        return super.getVMRunner(configuration, mode);
    }

    private File getLaunchConfigFile() {
        IPath launchPath = Platform.getStateLocation((Bundle)JAXPLaunchingPlugin.getDefault().getBundle()).append("launch");
        File launchDir = launchPath.toFile();
        if (!launchDir.exists()) {
            launchDir.mkdir();
        }
        File file = new File(launchDir, "launch.xml");
        return file;
    }

    public IPath getWorkingDirectoryPath(ILaunchConfiguration configuration) throws CoreException {
        return null;
    }

    private IProcessorInvoker getProcessorInvokerDescriptor(ILaunchConfiguration configuration) throws CoreException {
        String invokerId = configuration.getAttribute("org.eclipse.wst.xsl.jaxp.launching.INVOKER_DESCRIPTOR", "org.eclipse.wst.xsl.launching.jaxp.invoke");
        return JAXPRuntime.getProcessorInvoker(invokerId);
    }

    public static IProcessorInstall getProcessorInstall(ILaunchConfiguration configuration, String mode) throws CoreException {
        IProcessorInstall install = LaunchHelper.getProcessorInstall(configuration);
        if (mode.equals("debug") && install.getDebugger() == null) {
            String debuggingInstallId = JAXPLaunchingPlugin.getDefault().getPluginPreferences().getString("org.eclipse.wst.xsl.jaxp.launching.ATTR_DEFAULT_DEBUGGING_INSTALL_ID");
            install = JAXPRuntime.getProcessor(debuggingInstallId);
        }
        return install;
    }

    public String getMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        if ("debug".equals(this.mode)) {
            return "org.eclipse.wst.xsl.jaxp.debug.debugger.DebugRunner";
        }
        return "org.eclipse.wst.xsl.jaxp.debug.invoker.internal.Main";
    }

    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        IProcessorInstall install;
        IProcessorInvoker invoker = this.getProcessorInvokerDescriptor(configuration);
        String clazz = invoker.getInvokerClassName();
        StringBuffer sb = new StringBuffer();
        sb.append(clazz);
        sb.append(" ");
        sb.append("\"" + this.getLaunchConfigFile().getAbsolutePath() + "\"");
        sb.append(" ");
        sb.append("\"" + this.launchHelper.getSource() + "\"");
        sb.append(" ");
        sb.append("\"" + this.launchHelper.getTarget().getAbsolutePath() + "\"");
        if ("debug".equals(this.mode) && (install = JAXPJavaLaunchConfigurationDelegate.getProcessorInstall(configuration, this.mode)).getDebugger() != null) {
            IDebugger debugger = install.getDebugger();
            String className = debugger.getClassName();
            sb.append(" -debug ").append(className).append(" ");
            sb.append(this.launchHelper.getRequestPort());
            sb.append(" ").append(this.launchHelper.getEventPort());
            sb.append(" ").append(this.launchHelper.getGeneratePort());
        }
        return sb.toString();
    }

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        String[] userClasspath = super.getClasspath(configuration);
        IProcessorInvoker invoker = this.getProcessorInvokerDescriptor(configuration);
        ArrayList<String> invokerCP = new ArrayList<String>();
        String[] stringArray = invoker.getClasspathEntries();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            invokerCP.add(entry);
            ++n2;
        }
        IProcessorInstall install = JAXPJavaLaunchConfigurationDelegate.getProcessorInstall(configuration, this.mode);
        if ("debug".equals(this.mode) && install.getDebugger() != null) {
            String[] jars;
            String[] stringArray2 = jars = install.getDebugger().getClassPath();
            int n3 = jars.length;
            int n4 = 0;
            while (n4 < n3) {
                String jar = stringArray2[n4];
                invokerCP.add(jar);
                ++n4;
            }
        }
        String[] invokerClasspath = invokerCP.toArray(new String[0]);
        String[] classpath = new String[userClasspath.length + invokerClasspath.length];
        System.arraycopy(invokerClasspath, 0, classpath, 0, invokerClasspath.length);
        System.arraycopy(userClasspath, 0, classpath, invokerClasspath.length, userClasspath.length);
        return classpath;
    }

    public String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        String vmargs = super.getVMArguments(configuration);
        IProcessorInstall install = JAXPJavaLaunchConfigurationDelegate.getProcessorInstall(configuration, this.mode);
        if (install != null && !install.getProcessorType().isJREDefault()) {
            File tempDir = this.getEndorsedDir();
            if (tempDir.exists()) {
                File[] children;
                File[] fileArray = children = tempDir.listFiles();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    child.delete();
                    ++n2;
                }
                tempDir.delete();
            }
            tempDir.mkdir();
            IProcessorJar[] jars = install.getProcessorJars();
            int i = 0;
            while (i < jars.length) {
                URL entry = jars[i].asURL();
                if (entry == null) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xsl.jaxp.launching", 4, String.valueOf(Messages.getString("XSLTLaunchConfigurationDelegate.23")) + jars[i], null));
                }
                File file = new File(tempDir, "END_" + i + ".jar");
                JAXPJavaLaunchConfigurationDelegate.moveFile(entry, file);
                ++i;
            }
            vmargs = String.valueOf(vmargs) + " -Djava.endorsed.dirs=\"" + tempDir.getAbsolutePath() + "\"";
            String tfactory = this.getTransformerFactory(install);
            if (tfactory != null) {
                vmargs = String.valueOf(vmargs) + " -Djavax.xml.transform.TransformerFactory=" + tfactory;
            }
            if ("debug".equals(this.mode)) {
                try {
                    URL url = FileLocator.resolve((URL)FileLocator.find((Bundle)Platform.getBundle((String)"org.eclipse.wst.xsl.jaxp.launching"), (IPath)new Path("/log4j.debug.properties"), null));
                    vmargs = String.valueOf(vmargs) + " -Dlog4j.configuration=\"" + url.toExternalForm() + "\"";
                }
                catch (IOException e) {
                    JAXPLaunchingPlugin.log(e);
                }
            }
        }
        return vmargs;
    }

    private String getTransformerFactory(IProcessorInstall install) {
        String tfactory = null;
        if ("debug".equals(this.mode)) {
            tfactory = install.getDebugger().getTransformerFactory();
        } else {
            ITransformerFactory t = this.launchHelper.getTransformerFactory();
            if (t != null) {
                tfactory = t.getFactoryClass();
            }
        }
        return tfactory;
    }

    private File getEndorsedDir() {
        IPath tempLocation = Platform.getStateLocation((Bundle)JAXPLaunchingPlugin.getDefault().getBundle()).append("endorsed");
        return tempLocation.toFile();
    }

    private static void moveFile(URL src, File target) throws CoreException {
        BufferedOutputStream bos = null;
        BufferedInputStream bis = null;
        try {
            try {
                bos = new BufferedOutputStream(new FileOutputStream(target));
                bis = new BufferedInputStream(src.openStream());
                while (bis.available() > 0) {
                    int size = bis.available();
                    if (size > 1024) {
                        size = 1024;
                    }
                    byte[] b = new byte[size];
                    bis.read(b, 0, b.length);
                    bos.write(b);
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xsl.jaxp.launching", 4, String.valueOf(Messages.getString("XSLTLaunchConfigurationDelegate.7")) + src + Messages.getString("XSLTLaunchConfigurationDelegate.31") + target, (Throwable)e));
            }
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    JAXPLaunchingPlugin.log(e);
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    JAXPLaunchingPlugin.log(e);
                }
            }
        }
    }
}

