/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.launching.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.xsl.jaxp.launching.IAttribute;
import org.eclipse.wst.xsl.jaxp.launching.IOutputProperty;
import org.eclipse.wst.xsl.jaxp.launching.IProcessorType;
import org.eclipse.wst.xsl.jaxp.launching.ITransformerFactory;
import org.eclipse.wst.xsl.jaxp.launching.internal.Attribute;
import org.eclipse.wst.xsl.jaxp.launching.internal.JAXPLaunchingPlugin;
import org.eclipse.wst.xsl.jaxp.launching.internal.Messages;
import org.eclipse.wst.xsl.jaxp.launching.internal.OutputProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessorType
implements IProcessorType {
    private static final String DESC_SUFFIX = ".DESC";
    private static final String TYPE_SUFFIX = ".TYPE";
    private final String id;
    private final String name;
    private final ITransformerFactory[] transformerFactories;
    private final URL attributePropertiesURL;
    private final URL outputPropertiesURL;
    private IAttribute[] attributes;
    private IOutputProperty[] outputProperties;
    private Map<String, String> outputPropertyValues;
    private Map<String, String> attributeValues;

    public ProcessorType(String id, String name, URL attributePropertiesURL, URL outputPropertiesURL, Map<String, String> attributeValues, Map<String, String> outputPropertyValues, ITransformerFactory[] transformerFactories) {
        this.id = id;
        this.name = name;
        this.attributePropertiesURL = attributePropertiesURL;
        this.outputPropertiesURL = outputPropertiesURL;
        this.attributeValues = attributeValues;
        this.transformerFactories = transformerFactories;
        this.outputPropertyValues = outputPropertyValues;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.name;
    }

    @Override
    public Map<String, String> getAttributeValues() {
        return this.attributeValues;
    }

    @Override
    public IAttribute[] getAttributes() {
        if (this.attributes == null) {
            this.attributes = this.attributePropertiesURL != null ? this.loadAttributes() : new IAttribute[0];
        }
        return this.attributes;
    }

    @Override
    public Map<String, String> getOutputPropertyValues() {
        return this.outputPropertyValues;
    }

    @Override
    public boolean isJREDefault() {
        return "org.eclipse.wst.xsl.launching.processorType.jreDefault".equals(this.id);
    }

    @Override
    public ITransformerFactory[] getTransformerFactories() {
        return this.transformerFactories;
    }

    @Override
    public ITransformerFactory getDefaultTransformerFactory() {
        if (this.transformerFactories.length > 0) {
            return this.transformerFactories[0];
        }
        return null;
    }

    @Override
    public IOutputProperty[] getOutputProperties() {
        if (this.outputProperties == null) {
            this.outputProperties = this.outputPropertiesURL != null ? this.loadOutputProperties() : new IOutputProperty[0];
        }
        return this.outputProperties;
    }

    private IOutputProperty[] loadOutputProperties() {
        ArrayList<OutputProperty> outputs;
        block16: {
            BufferedInputStream is = null;
            outputs = new ArrayList<OutputProperty>();
            Properties props = new Properties();
            try {
                try {
                    is = new BufferedInputStream(this.outputPropertiesURL.openStream());
                    props.load(is);
                    for (Object element : props.keySet()) {
                        String key = (String)element;
                        if (key.endsWith(DESC_SUFFIX)) continue;
                        String name = key;
                        String uri = props.getProperty(key);
                        String desc = props.getProperty(String.valueOf(key) + DESC_SUFFIX);
                        if (uri != null && name != null && desc != null) {
                            OutputProperty prop = new OutputProperty(uri.trim(), desc);
                            outputs.add(prop);
                            continue;
                        }
                        JAXPLaunchingPlugin.log(new CoreException((IStatus)new Status(2, "org.eclipse.wst.xsl.jaxp.launching", String.valueOf(Messages.getString("ProcessorType.2")) + this.outputPropertiesURL + Messages.getString("ProcessorType.3") + key)));
                    }
                }
                catch (IOException e) {
                    JAXPLaunchingPlugin.log(e);
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e2) {
                            JAXPLaunchingPlugin.log(e2);
                        }
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        JAXPLaunchingPlugin.log(e);
                    }
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    JAXPLaunchingPlugin.log(e);
                }
            }
        }
        return outputs.toArray(new IOutputProperty[0]);
    }

    private IAttribute[] loadAttributes() {
        ArrayList<Attribute> attributesList;
        block16: {
            BufferedInputStream is = null;
            attributesList = new ArrayList<Attribute>();
            try {
                try {
                    is = new BufferedInputStream(this.attributePropertiesURL.openStream());
                    Properties props = new Properties();
                    props.load(is);
                    for (Object element : props.keySet()) {
                        String key = (String)element;
                        if (key.endsWith(DESC_SUFFIX) || key.endsWith(TYPE_SUFFIX)) continue;
                        String uri = props.getProperty(key);
                        String type = props.getProperty(String.valueOf(key) + TYPE_SUFFIX);
                        String desc = props.getProperty(String.valueOf(key) + DESC_SUFFIX);
                        if (uri != null && type != null && desc != null) {
                            Attribute attribute = new Attribute(uri.trim(), type.trim(), desc);
                            attributesList.add(attribute);
                            continue;
                        }
                        JAXPLaunchingPlugin.log(new CoreException((IStatus)new Status(2, "org.eclipse.wst.xsl.jaxp.launching", String.valueOf(Messages.getString("ProcessorType.4")) + this.attributePropertiesURL + Messages.getString("ProcessorType.5") + key)));
                    }
                }
                catch (IOException e) {
                    JAXPLaunchingPlugin.log(e);
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e2) {
                            JAXPLaunchingPlugin.log(e2);
                        }
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        JAXPLaunchingPlugin.log(e);
                    }
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    JAXPLaunchingPlugin.log(e);
                }
            }
        }
        Object[] attributes = attributesList.toArray(new IAttribute[0]);
        Arrays.sort(attributes);
        return attributes;
    }
}

