/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.navigator;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderEvent;
import org.eclipse.jst.j2ee.model.IModelProviderListener;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.navigator.internal.EMFRootObjectProvider;
import org.eclipse.jst.jee.ui.plugin.JEEUIPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;

public abstract class JEE5ContentProvider
implements ITreeContentProvider,
EMFRootObjectProvider.IRefreshHandlerListener,
IModelProviderListener {
    protected Viewer viewer;
    protected static final Class IPROJECT_CLASS = IProject.class;
    protected static HashMap<IProject, IModelProvider> groupProvidersMap = new HashMap();

    public void inputChanged(Viewer aViewer, Object anOldInput, Object aNewInput) {
        this.viewer = aViewer;
    }

    protected IModelProvider getCachedModelProvider(IProject project) {
        IModelProvider provider = groupProvidersMap.get(project);
        if (provider != null) {
            provider.getModelObject();
        } else {
            provider = ModelProviderManager.getModelProvider((IProject)project);
            provider.addListener((IModelProviderListener)this);
            groupProvidersMap.put(project, provider);
        }
        return provider;
    }

    public void projectChanged(final IProject project) {
        try {
            Runnable refreshThread = new Runnable(){

                public void run() {
                    if (JEE5ContentProvider.this.viewer != null) {
                        ISelection sel = ((TreeViewer)JEE5ContentProvider.this.viewer).getSelection();
                        ITreeContentProvider contentProvider = (ITreeContentProvider)((TreeViewer)JEE5ContentProvider.this.viewer).getContentProvider();
                        contentProvider.getChildren((Object)project);
                        ((StructuredViewer)JEE5ContentProvider.this.viewer).refresh((Object)project);
                        ((TreeViewer)JEE5ContentProvider.this.viewer).setSelection(sel);
                    }
                }
            };
            Display.getDefault().asyncExec(refreshThread);
        }
        catch (Exception e) {
            JEEUIPlugin.logError("Error during refresh", e);
        }
    }

    public void modelsChanged(IModelProviderEvent event) {
        this.projectChanged(event.getProject());
    }

    public void onRefresh(final Object element) {
        if (this.viewer instanceof AbstractTreeViewer) {
            if (Display.getCurrent() != null) {
                ((AbstractTreeViewer)this.viewer).refresh(element, true);
            } else {
                UIJob job = new UIJob("Update the Navigator Content Viewer Job"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        ((AbstractTreeViewer)JEE5ContentProvider.this.viewer).refresh(element, true);
                        return Status.OK_STATUS;
                    }
                };
                ISchedulingRule rule = new ISchedulingRule(){

                    public boolean contains(ISchedulingRule rule) {
                        return rule == this;
                    }

                    public boolean isConflicting(ISchedulingRule rule) {
                        return rule == this;
                    }
                };
                if (rule != null) {
                    job.setRule(rule);
                }
                job.schedule();
            }
        }
    }

    public void dispose() {
        groupProvidersMap.clear();
    }
}

