/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath.ui.internal.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentManager;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentManagerListener;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMDocumentCache;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.xpath.messages.Messages;
import org.eclipse.wst.xml.xpath.ui.internal.views.XPathView;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathComputer {
    private static final int UPDATE_DELAY = 200;
    private static final byte[] XPATH_LOCK = new byte[0];
    private XPathView xpathView;
    private CMDocumentManager cmDocumentManager;
    private CMDocumentManagerListener fCMDocumentManagerListener = new DocManagerListener();
    private Node node;
    private XPath path;
    private IStructuredModel model;
    private XPathExpression expression;
    private String text;
    private NodeList nodeList;

    public XPathComputer(XPathView xpathView) {
        this.xpathView = xpathView;
    }

    public void setModel(IStructuredModel model) {
        this.model = model;
        if (this.cmDocumentManager != null) {
            this.cmDocumentManager.removeListener(this.fCMDocumentManagerListener);
        }
        if (model != null) {
            ModelQuery modelQuery = ModelQueryUtil.getModelQuery((IStructuredModel)model);
            if (modelQuery != null) {
                this.cmDocumentManager = modelQuery.getCMDocumentManager();
                if (this.cmDocumentManager != null) {
                    this.cmDocumentManager.addListener(this.fCMDocumentManagerListener);
                }
            }
            this.updateXPath();
        } else {
            this.cmDocumentManager = null;
            this.node = null;
            this.path = null;
        }
    }

    private void updateXPath() {
        this.path = XPathFactory.newInstance().newXPath();
        Document doc = (Document)this.model.getAdapter(Document.class);
        if (doc == null) {
            return;
        }
        Element rootEl = doc.getDocumentElement();
        if (rootEl != null) {
            final HashMap<String, String> namespaces = new HashMap<String, String>();
            this.findNamespaces(rootEl, namespaces);
            this.path.setNamespaceContext(new NamespaceContext(){

                public String getNamespaceURI(String arg0) {
                    return (String)namespaces.get(arg0);
                }

                public String getPrefix(String arg0) {
                    for (Map.Entry entry : namespaces.entrySet()) {
                        if (!((String)entry.getValue()).equals(arg0)) continue;
                        return (String)entry.getKey();
                    }
                    return null;
                }

                public Iterator getPrefixes(String arg0) {
                    ArrayList<String> vals = new ArrayList<String>(1);
                    vals.add(this.getPrefix(arg0));
                    return vals.iterator();
                }
            });
        }
        try {
            this.updateExpression();
        }
        catch (XPathExpressionException xPathExpressionException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExpression() throws XPathExpressionException {
        byte[] byArray = XPATH_LOCK;
        synchronized (XPATH_LOCK) {
            this.expression = this.path != null && this.text != null ? this.path.compile(this.text) : null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void setText(String text) throws XPathExpressionException {
        this.text = text;
        this.updateExpression();
    }

    private void findNamespaces(Element element, Map<String, String> namespaces) {
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Attr att = (Attr)attrs.item(i);
            if ("xmlns".equals(att.getNodeName())) {
                namespaces.put("", att.getNodeValue());
            } else if ("xmlns".equals(att.getPrefix())) {
                namespaces.put(att.getLocalName(), att.getNodeValue());
            }
            ++i;
        }
        NodeList children = element.getChildNodes();
        int i2 = 0;
        while (i2 < children.getLength()) {
            Node child = children.item(i2);
            if (child.getNodeType() == 1) {
                this.findNamespaces((Element)child, namespaces);
            }
            ++i2;
        }
    }

    public void setSelectedNode(Node node) {
        this.node = node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compute() {
        final XPathExpression[] xps = new XPathExpression[1];
        byte[] byArray = XPATH_LOCK;
        synchronized (XPATH_LOCK) {
            xps[0] = this.expression;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            Job refresh = new Job(Messages.XPathComputer_5){

                protected IStatus run(IProgressMonitor monitor) {
                    if (xps[0] != XPathComputer.this.expression) {
                        return Status.CANCEL_STATUS;
                    }
                    return XPathComputer.this.doCompute(xps[0]);
                }
            };
            refresh.setSystem(true);
            refresh.setPriority(20);
            refresh.schedule(200L);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private IStatus doCompute(XPathExpression xp) {
        block5: {
            try {
                if (xp == null || this.node == null) break block5;
                byte[] byArray = XPATH_LOCK;
                // MONITORENTER : XPATH_LOCK
                this.nodeList = (NodeList)xp.evaluate(this.node, XPathConstants.NODESET);
                // MONITOREXIT : byArray
            }
            catch (XPathExpressionException xPathExpressionException) {
                return Status.CANCEL_STATUS;
            }
        }
        this.xpathView.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                XPathComputer.this.xpathView.xpathRecomputed(XPathComputer.this.nodeList);
            }
        });
        return Status.OK_STATUS;
    }

    public void dispose() {
        if (this.cmDocumentManager != null) {
            this.cmDocumentManager.removeListener(this.fCMDocumentManagerListener);
        }
    }

    private class DocManagerListener
    implements CMDocumentManagerListener {
        private DocManagerListener() {
        }

        public void propertyChanged(CMDocumentManager cmDocumentManager, String propertyName) {
            XPathComputer.this.updateXPath();
            XPathComputer.this.compute();
        }

        public void cacheCleared(CMDocumentCache cache) {
        }

        public void cacheUpdated(CMDocumentCache cache, String uri, int oldStatus, int newStatus, CMDocument cmDocument) {
            XPathComputer.this.updateXPath();
            XPathComputer.this.compute();
        }
    }
}

