/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath.ui.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.WeakHashMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceTable;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.ui.internal.provisional.IDOMSourceEditingTextTools;
import org.eclipse.wst.xml.xpath.ui.XPathUIMessages;
import org.eclipse.wst.xml.xpath.ui.internal.XPathUIPlugin;
import org.eclipse.wst.xml.xpath.ui.views.DOMNodeLabelProvider;
import org.eclipse.wst.xml.xpath.ui.views.DOMTreeContentProvider;
import org.eclipse.wst.xml.xpath.ui.views.DOMViewerFilter;
import org.eclipse.wst.xml.xpath.ui.views.EditNamespacePrefixDialog;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathNavigator
extends ViewPart {
    private TreeViewer viewer;
    private StyledText text;
    private CTabFolder resultTabs;
    private XPathAction query;
    private RefreshAction refresh;
    private ShowInSourceAction showInSource;
    private Text xpath;
    private ComboViewer documents;
    private Button queryByContext;
    private Button queryByDocument;
    private Button namespaceButton;
    protected IMemento memento;
    protected WeakHashMap<Document, List<NamespaceInfo>> namespaceInfo = new WeakHashMap();
    public static final String MEMENTO_XPATHNAVIGATOR_SECTION = "xpath-navigator-view";
    public static final String MEMENTO_QUERYCONTEXT_KEY = "query-context";
    public static final String MEMENTO_QUERYCONTEXT_DOCUMENT = "document";
    public static final String MEMENTO_QUERYCONTEXT_SELECTION = "selection";
    public static final String MEMENTO_XPATHQUERY_KEY = "xpath-query";

    public void createPartControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 5;
        gridLayout.marginWidth = 0;
        comp.setLayout((Layout)gridLayout);
        Label label = new Label(comp, 0);
        label.setText(XPathUIMessages.XPathNavigator_XML_Source_Document);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalIndent = gridLayout.horizontalSpacing / 2;
        label.setLayoutData((Object)data);
        this.documents = new ComboViewer(comp, 8);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalIndent = gridLayout.marginTop;
        data.verticalAlignment = 2;
        this.documents.getCombo().setLayoutData((Object)data);
        this.documents.setUseHashlookup(true);
        this.documents.setContentProvider((IContentProvider)new XMLEditorsContentProvider());
        this.documents.setLabelProvider((IBaseLabelProvider)new EditorReferenceLabelProvider());
        this.documents.setInput((Object)Boolean.TRUE);
        Group queryGroup = new Group(comp, 32);
        queryGroup.setText(XPathUIMessages.XPathNavigator_Context);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalIndent = gridLayout.marginTop;
        data.verticalAlignment = 2;
        queryGroup.setLayoutData((Object)data);
        GridLayout _gridLayout = new GridLayout();
        _gridLayout.numColumns = 3;
        queryGroup.setLayout((Layout)_gridLayout);
        this.queryByContext = new Button((Composite)queryGroup, 16);
        this.queryByContext.setText(XPathUIMessages.XPathNavigator_Selection);
        this.queryByDocument = new Button((Composite)queryGroup, 16);
        this.queryByDocument.setText(XPathUIMessages.XPathNavigator_Document);
        this.queryByDocument.setSelection(true);
        this.namespaceButton = new Button((Composite)queryGroup, 8);
        this.namespaceButton.setText(XPathUIMessages.XPathNavigator_Namespaces);
        this.namespaceButton.setToolTipText(XPathUIMessages.XPathNavigator_Namespaces_Tip);
        this.namespaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Document selectedDocument = XPathNavigator.this.getSelectedDocument();
                if (selectedDocument != null) {
                    List info = XPathNavigator.this.createNamespaceInfo(selectedDocument);
                    IStructuredSelection selection = (IStructuredSelection)XPathNavigator.this.documents.getSelection();
                    IEditorReference editorReference = (IEditorReference)selection.getFirstElement();
                    IPathEditorInput editorInput = (IPathEditorInput)editorReference.getEditor(true).getEditorInput();
                    EditNamespacePrefixDialog dlg = new EditNamespacePrefixDialog(XPathNavigator.this.getSite().getShell(), editorInput.getPath());
                    dlg.setNamespaceInfoList(info);
                    dlg.open();
                }
            }
        });
        label = new Label(comp, 0);
        label.setText(XPathUIMessages.XPathNavigator_Expression);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalIndent = gridLayout.horizontalSpacing;
        data.grabExcessHorizontalSpace = true;
        data.horizontalIndent = gridLayout.horizontalSpacing / 2;
        label.setLayoutData((Object)data);
        this.xpath = new Text(comp, 2048);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalIndent = gridLayout.marginTop;
        data.verticalAlignment = 2;
        this.xpath.setLayoutData((Object)data);
        this.xpath.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13) {
                    XPathNavigator.this.query.run();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.resultTabs = new CTabFolder(comp, 1024);
        data = new GridData();
        data.verticalIndent = gridLayout.marginTop;
        data.verticalAlignment = 2;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.resultTabs.setLayoutData((Object)data);
        this.viewer = new TreeViewer((Composite)this.resultTabs, 768);
        this.viewer.setLabelProvider((IBaseLabelProvider)new DOMNodeLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new DOMTreeContentProvider());
        this.viewer.addFilter((ViewerFilter)new DOMViewerFilter());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                XPathNavigator.this.showInSource.setEnabled(!event.getSelection().isEmpty());
            }
        });
        CTabItem item = new CTabItem(this.resultTabs, 0);
        item.setText(XPathUIMessages.XPathNavigator_DOM_Tree);
        item.setControl(this.viewer.getControl());
        this.resultTabs.setSelection(item);
        this.text = new StyledText((Composite)this.resultTabs, 770);
        Color white = this.text.getBackground();
        this.text.setEditable(false);
        this.text.setBackground(white);
        item = new CTabItem(this.resultTabs, 0);
        item.setText(XPathUIMessages.XPathNavigator_Text);
        item.setControl((Control)this.text);
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        if (this.memento != null) {
            this.restoreState();
            this.memento = null;
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    public void saveState(IMemento memento) {
        IMemento settings = memento.createChild(MEMENTO_XPATHNAVIGATOR_SECTION);
        settings.putString(MEMENTO_QUERYCONTEXT_KEY, this.queryByDocument.getSelection() ? MEMENTO_QUERYCONTEXT_DOCUMENT : MEMENTO_QUERYCONTEXT_SELECTION);
        settings.putString(MEMENTO_XPATHQUERY_KEY, this.xpath.getText());
        super.saveState(memento);
    }

    protected void restoreState() {
        IMemento settings = this.memento.getChild(MEMENTO_XPATHNAVIGATOR_SECTION);
        if (settings != null) {
            String queryContext = settings.getString(MEMENTO_QUERYCONTEXT_KEY);
            if (MEMENTO_QUERYCONTEXT_DOCUMENT.equals(queryContext)) {
                this.queryByDocument.setSelection(true);
                this.queryByContext.setSelection(false);
            } else {
                this.queryByDocument.setSelection(false);
                this.queryByContext.setSelection(true);
            }
            this.xpath.setText(settings.getString(MEMENTO_XPATHQUERY_KEY));
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                XPathNavigator.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.query);
        manager.add((IAction)this.refresh);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.query);
        manager.add((IAction)this.refresh);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.showInSource);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.query);
        manager.add((IAction)this.refresh);
    }

    private void makeActions() {
        this.query = new XPathAction();
        this.query.setText(XPathUIMessages.XPathNavigator_Run_XPath_Query);
        this.query.setToolTipText(XPathUIMessages.XPathNavigator_Run_on_selected);
        this.query.setImageDescriptor(XPathUIPlugin.getDefault().getImageRegistry().getDescriptor("run"));
        this.refresh = new RefreshAction();
        this.refresh.setText(XPathUIMessages.XPathNavigator_Refresh_Source_Docs);
        this.refresh.setToolTipText(XPathUIMessages.XPathNavigator_Refresh_Source_Docs_Tip);
        this.refresh.setImageDescriptor(XPathUIPlugin.getDefault().getImageRegistry().getDescriptor("refresh"));
        this.showInSource = new ShowInSourceAction();
        this.showInSource.setText(XPathUIMessages.XPathNavigator_Show_In_Source);
        this.showInSource.setToolTipText(XPathUIMessages.XPathNavigator_Show_In_Source_Tip);
    }

    protected Document getSelectedDocument() {
        IStructuredSelection selection = (IStructuredSelection)this.documents.getSelection();
        IEditorReference editorReference = (IEditorReference)selection.getFirstElement();
        return (Document)editorReference.getEditor(true).getAdapter(Document.class);
    }

    protected Element getQueryContext() {
        ISourceEditingTextTools sett;
        IStructuredSelection selection = (IStructuredSelection)this.documents.getSelection();
        IEditorReference editorReference = (IEditorReference)selection.getFirstElement();
        IEditorPart structuredTextEditor = editorReference.getEditor(true);
        if (this.queryByContext.getSelection() && (sett = (ISourceEditingTextTools)structuredTextEditor.getAdapter(ISourceEditingTextTools.class)) instanceof IDOMSourceEditingTextTools) {
            IDOMSourceEditingTextTools idsett = (IDOMSourceEditingTextTools)sett;
            Node n = null;
            try {
                n = idsett.getNode(idsett.getCaretOffset());
            }
            catch (BadLocationException badLocationException) {
                MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)XPathUIMessages.XPathNavigator_XPath_Navigator, (String)XPathUIMessages.XPathNavigator_Node_could_not_be_selected);
            }
            while (n != null && !(n instanceof Element) && !(n instanceof Document)) {
                n = n.getParentNode();
            }
            if (n instanceof Document) {
                n = ((Document)n).getDocumentElement();
            }
            if (n == null) {
                MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)XPathUIMessages.XPathNavigator_XPath_Navigator, (String)XPathUIMessages.XPathNavigator_Nothing_selected);
                structuredTextEditor.setFocus();
                return null;
            }
            return (Element)n;
        }
        return ((Document)structuredTextEditor.getAdapter(Document.class)).getDocumentElement();
    }

    public void setFocus() {
        this.xpath.setFocus();
    }

    public void update() {
        ISelection selection = this.documents.getSelection();
        this.documents.setInput((Object)(this.documents.getInput() == Boolean.FALSE ? Boolean.TRUE : Boolean.FALSE));
        this.documents.setSelection(selection);
    }

    private List<NamespaceInfo> createNamespaceInfo(Document document) {
        List<NamespaceInfo> info = this.namespaceInfo.get(document);
        if (info == null) {
            info = new ArrayList<NamespaceInfo>();
            NamespaceTable namespaceTable = new NamespaceTable(document);
            namespaceTable.visitElement(document.getDocumentElement());
            Collection namespaces = namespaceTable.getNamespaceInfoCollection();
            info.addAll(namespaces);
            this.namespaceInfo.put(document, info);
        }
        return info;
    }

    static class EditorReferenceLabelProvider
    extends LabelProvider {
        public static char DIRTY_INDICATOR = (char)42;

        EditorReferenceLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof IEditorReference) {
                return ((IEditorReference)element).getTitleImage();
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof IEditorReference) {
                IEditorReference reference = (IEditorReference)element;
                StringBuffer buffer = new StringBuffer();
                if (reference.isDirty()) {
                    buffer.append(DIRTY_INDICATOR);
                }
                buffer.append(reference.getTitle());
                return buffer.toString();
            }
            return super.getText(element);
        }
    }

    class RefreshAction
    extends Action {
        RefreshAction() {
        }

        public void run() {
            XPathNavigator.this.update();
        }
    }

    class ShowInSourceAction
    extends Action {
        ShowInSourceAction() {
        }

        public void run() {
        }
    }

    static class XMLEditorsContentProvider
    implements IStructuredContentProvider {
        XMLEditorsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList editorReferences = new ArrayList();
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int i = 0;
            while (i < windows.length) {
                IWorkbenchWindow window = windows[i];
                IWorkbenchPage[] pages = window.getPages();
                int j = 0;
                while (j < pages.length) {
                    IWorkbenchPage page = pages[j];
                    IEditorReference[] editors = page.getEditorReferences();
                    editorReferences.addAll(Arrays.asList(editors));
                    ++j;
                }
                ++i;
            }
            ArrayList aClone = new ArrayList();
            aClone.addAll(editorReferences);
            for (IEditorReference ref : aClone) {
                if (ref.getEditor(false) instanceof IEditorPart) continue;
                editorReferences.remove(ref);
            }
            return editorReferences.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class XPathAction
    extends Action {
        XPathAction() {
        }

        public void run() {
            String expr = XPathNavigator.this.xpath.getText().trim();
            if (expr.length() == 0) {
                XPathNavigator.this.xpath.setFocus();
                return;
            }
            if (XPathNavigator.this.documents.getSelection().isEmpty()) {
                MessageDialog.openInformation((Shell)XPathNavigator.this.getSite().getShell(), (String)XPathUIMessages.XPathNavigator_XPath_Navigator, (String)XPathUIMessages.XPathNavigator_Select_source_first);
                XPathNavigator.this.documents.getCombo().setFocus();
                return;
            }
            Element contextElement = XPathNavigator.this.getQueryContext();
            if (contextElement == null) {
                return;
            }
            try {
                XPathNavigator.this.text.setText("");
                XPathNavigator.this.viewer.setInput(null);
                XPath newXPath = XPathFactory.newInstance().newXPath();
                final List namespaces = XPathNavigator.this.createNamespaceInfo(XPathNavigator.this.getSelectedDocument());
                if (namespaces != null) {
                    newXPath.setNamespaceContext(new NamespaceContext(){

                        @Override
                        public String getNamespaceURI(String prefix) {
                            for (NamespaceInfo ni : namespaces) {
                                if (!prefix.equals(ni.prefix)) continue;
                                return ni.uri;
                            }
                            return null;
                        }

                        @Override
                        public String getPrefix(String uri) {
                            for (NamespaceInfo ni : namespaces) {
                                if (!uri.equals(ni.uri)) continue;
                                return ni.prefix;
                            }
                            return null;
                        }

                        @Override
                        public Iterator<String> getPrefixes(String uri) {
                            LinkedList<String> prefixes = new LinkedList<String>();
                            for (NamespaceInfo ni : namespaces) {
                                if (!uri.equals(ni.uri)) continue;
                                prefixes.add(ni.prefix);
                            }
                            return prefixes.iterator();
                        }
                    });
                }
                XPathExpression xpExp = newXPath.compile(expr);
                NodeList nl = null;
                String stringResult = null;
                try {
                    nl = (NodeList)xpExp.evaluate(contextElement, XPathConstants.NODESET);
                }
                catch (XPathExpressionException xPathExpressionException) {
                    stringResult = xpExp.evaluate(contextElement);
                }
                Document document = (Document)contextElement.getOwnerDocument().cloneNode(false);
                Element root = document.createElement("xpath-result");
                document.appendChild(root);
                boolean odd = false;
                StringBuffer sb = new StringBuffer();
                if (nl != null) {
                    int i = 0;
                    while (i < nl.getLength()) {
                        Node node = nl.item(i);
                        root.appendChild(document.importNode(node, true));
                        switch (node.getNodeType()) {
                            case 2: {
                                Attr attr = (Attr)node;
                                sb.append("#attribute :: ").append(attr.getName()).append("=\"").append(attr.getValue()).append('\"');
                                break;
                            }
                            case 4: {
                                CDATASection cdata = (CDATASection)node;
                                sb.append("#cdata :: ").append(cdata.toString());
                                break;
                            }
                            case 8: {
                                Comment comment = (Comment)node;
                                sb.append("#comment :: ").append(comment.toString());
                                break;
                            }
                            case 11: {
                                DocumentFragment fragment = (DocumentFragment)node;
                                sb.append("#fragment :: ").append(fragment.toString());
                                break;
                            }
                            case 9: {
                                Document doc = (Document)node;
                                sb.append("#document :: ");
                                sb.append(((DocumentImpl)doc).getSource());
                                break;
                            }
                            case 1: {
                                Element element = (Element)node;
                                sb.append("#element :: ");
                                sb.append(((ElementImpl)element).getSource());
                                break;
                            }
                            case 7: {
                                ProcessingInstruction pi = (ProcessingInstruction)node;
                                sb.append("#pi :: ").append(pi.toString());
                                break;
                            }
                            case 3: {
                                org.w3c.dom.Text text = (org.w3c.dom.Text)node;
                                sb.append("#text :: ").append(text.getNodeValue());
                                break;
                            }
                            default: {
                                sb.append("#unknown :: ").append(node.getNodeType()).append(node.toString());
                            }
                        }
                        sb.append("\r\n");
                        XPathNavigator.this.text.append(sb.toString());
                        StyleRange sr = new StyleRange();
                        sr.foreground = Display.getDefault().getSystemColor(odd ? 2 : 10);
                        sr.start = XPathNavigator.this.text.getText().length() - sb.length();
                        sr.length = sb.length();
                        XPathNavigator.this.text.setStyleRange(sr);
                        odd = !odd;
                        sb.setLength(0);
                        ++i;
                    }
                } else if (stringResult != null) {
                    XPathNavigator.this.text.setText(stringResult);
                    XPathNavigator.this.resultTabs.setSelection(1);
                } else {
                    XPathNavigator.this.text.setText("");
                }
                XPathNavigator.this.text.setCaretOffset(0);
                XPathNavigator.this.viewer.setInput((Object)document.getDocumentElement());
                XPathNavigator.this.viewer.refresh();
                XPathNavigator.this.viewer.expandToLevel(3);
                if (XPathNavigator.this.viewer.getTree().getItems().length > 0) {
                    XPathNavigator.this.viewer.getTree().showItem(XPathNavigator.this.viewer.getTree().getItems()[0]);
                }
            }
            catch (XPathExpressionException pex) {
                MessageDialog.openError((Shell)XPathNavigator.this.getSite().getShell(), (String)XPathUIMessages.XPathNavigator_XPath_Navigator, (String)(String.valueOf(XPathUIMessages.XPathNavigator_XPath_Eval_Failed) + pex.getCause().getMessage()));
                XPathUIPlugin.log(pex);
            }
            catch (Exception ex) {
                MessageDialog.openError((Shell)XPathNavigator.this.getSite().getShell(), (String)XPathUIMessages.XPathNavigator_XPath_Navigator, (String)(String.valueOf(XPathUIMessages.XPathNavigator_XPath_Eval_Failed) + ex.getMessage()));
                XPathUIPlugin.log(ex);
            }
        }
    }
}

