/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.util.ProductPreferences;
import org.eclipse.help.internal.webapp.data.UrlUtil;

public class WebappPreferences {
    Preferences prefs = HelpBasePlugin.getDefault().getPluginPreferences();

    public String getBanner() {
        return this.prefs.getString("banner");
    }

    public String getBannerHeight() {
        return this.prefs.getString("banner_height");
    }

    public String getHelpHome() {
        return this.prefs.getString("help_home");
    }

    public boolean isIndexView() {
        return ProductPreferences.getBoolean((Plugin)HelpBasePlugin.getDefault(), (String)"indexView");
    }

    public boolean isBookmarksView() {
        return BaseHelpSystem.getMode() != 1 && ProductPreferences.getBoolean((Plugin)HelpBasePlugin.getDefault(), (String)"bookmarksView");
    }

    public boolean isBookmarksAction() {
        return ProductPreferences.getBoolean((Plugin)HelpBasePlugin.getDefault(), (String)"bookmarksView");
    }

    public String getImagesDirectory() {
        String imagesDirectory = this.prefs.getString("imagesDirectory");
        if (imagesDirectory != null && imagesDirectory.startsWith("/")) {
            imagesDirectory = UrlUtil.getHelpURL(imagesDirectory);
        }
        return imagesDirectory;
    }

    public String getToolbarBackground() {
        return this.prefs.getString("advanced.toolbarBackground");
    }

    public String getBasicToolbarBackground() {
        return this.prefs.getString("basic.toolbarBackground");
    }

    public String getToolbarFont() {
        return this.prefs.getString("advanced.toolbarFont");
    }

    public String getViewBackground() {
        return this.prefs.getString("advanced.viewBackground");
    }

    public String getViewBackgroundStyle() {
        String viewBackground = this.prefs.getString("advanced.viewBackground");
        if (viewBackground == null || viewBackground.length() == 0) {
            return "";
        }
        return "background-color: " + viewBackground + ";";
    }

    public String getBasicViewBackground() {
        return this.prefs.getString("basic.viewBackground");
    }

    public String getViewFont() {
        return this.prefs.getString("advanced.viewFont");
    }

    public boolean isWindowTitlePrefix() {
        return ProductPreferences.getBoolean((Plugin)HelpBasePlugin.getDefault(), (String)"windowTitlePrefix");
    }

    public boolean isDontConfirmShowAll() {
        return this.prefs.getBoolean("dontConfirmShowAll");
    }

    public void setDontConfirmShowAll(boolean dontconfirm) {
        this.prefs.setValue("dontConfirmShowAll", dontconfirm);
    }

    public boolean isActiveHelp() {
        return ProductPreferences.getBoolean((Plugin)HelpBasePlugin.getDefault(), (String)"activeHelp");
    }

    public boolean isIndexInstruction() {
        return ProductPreferences.getBoolean((Plugin)HelpBasePlugin.getDefault(), (String)"indexInstruction");
    }

    public boolean isIndexButton() {
        return ProductPreferences.getBoolean((Plugin)HelpBasePlugin.getDefault(), (String)"indexButton");
    }

    public boolean isIndexPlusMinus() {
        return ProductPreferences.getBoolean((Plugin)HelpBasePlugin.getDefault(), (String)"indexPlusMinus");
    }

    public boolean isIndexExpandAll() {
        return ProductPreferences.getBoolean((Plugin)HelpBasePlugin.getDefault(), (String)"indexExpandAll");
    }

    public boolean isHighlightDefault() {
        return this.prefs.getBoolean("default_highlight");
    }

    public void setHighlightDefault(boolean highlight) {
        this.prefs.setValue("default_highlight", highlight);
    }

    public boolean isRestrictTopicParameter() {
        return this.prefs.getBoolean("restrictTopicParameter");
    }
}

