/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.protocols.HelpURLStreamHandler;
import org.eclipse.help.internal.webapp.HelpWebappPlugin;
import org.eclipse.help.internal.webapp.data.ServletResources;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.BreadcrumbsFilter;
import org.eclipse.help.internal.webapp.servlet.DynamicXHTMLFilter;
import org.eclipse.help.internal.webapp.servlet.FramesetFilter;
import org.eclipse.help.internal.webapp.servlet.HighlightFilter;
import org.eclipse.help.internal.webapp.servlet.IFilter;
import org.eclipse.help.internal.webapp.servlet.InjectionFilter;
import org.eclipse.help.internal.webapp.servlet.ShowInTocFilter;

public class EclipseConnector {
    private static final String errorPageBegin = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n<html><head>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n</head>\n<body><p>\n";
    private static final String errorPageEnd = "</p></body></html>";
    private static final IFilter[] allFilters = new IFilter[]{new HighlightFilter(), new FramesetFilter(), new InjectionFilter(), new DynamicXHTMLFilter(), new BreadcrumbsFilter(), new ShowInTocFilter()};
    private static final IFilter[] errorPageFilters = new IFilter[]{new FramesetFilter(), new InjectionFilter(), new DynamicXHTMLFilter()};
    private ServletContext context;

    public EclipseConnector(ServletContext context) {
        this.context = context;
    }

    public void transfer(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            IFilter[] filters;
            InputStream is;
            String url = this.getURL(req);
            if (url == null) {
                return;
            }
            int index = url.lastIndexOf("PLUGINS_ROOT/");
            if (index != -1 && url.indexOf("content/PLUGINS_ROOT/") == -1) {
                StringBuffer redirectURL = new StringBuffer();
                redirectURL.append(req.getContextPath());
                redirectURL.append(req.getServletPath());
                redirectURL.append("/");
                redirectURL.append(url.substring(index + "PLUGINS_ROOT/".length()));
                resp.sendRedirect(redirectURL.toString());
                return;
            }
            String lowerCaseuRL = url.toLowerCase(Locale.ENGLISH);
            if (lowerCaseuRL.startsWith("file:") || lowerCaseuRL.startsWith("jar:") || lowerCaseuRL.startsWith("platform:")) {
                int i = url.indexOf(63);
                if (i != -1) {
                    url = url.substring(0, i);
                }
                if (BaseHelpSystem.getMode() == 1 || !UrlUtil.isLocalRequest(req)) {
                    return;
                }
            } else {
                url = "help:" + url;
            }
            URLConnection con = this.createConnection(req, resp, url);
            boolean pageNotFound = false;
            try {
                is = con.getInputStream();
            }
            catch (IOException iOException) {
                pageNotFound = true;
                if (this.requiresErrorPage(lowerCaseuRL)) {
                    Preferences prefs = HelpBasePlugin.getDefault().getPluginPreferences();
                    String errorPage = prefs.getString("page_not_found");
                    if (errorPage != null && errorPage.length() > 0) {
                        con = this.createConnection(req, resp, "help:" + errorPage);
                        resp.setContentType("text/html");
                        try {
                            is = con.getInputStream();
                        }
                        catch (IOException iOException2) {
                            resp.setStatus(404);
                            return;
                        }
                    }
                    resp.setStatus(404);
                    return;
                }
                resp.setStatus(404);
                return;
            }
            catch (Exception e) {
                Throwable t = e;
                if (t instanceof UndeclaredThrowableException && t.getCause() != null) {
                    t = t.getCause();
                }
                StringBuffer message = new StringBuffer();
                message.append(errorPageBegin);
                message.append("<p>");
                message.append(ServletResources.getString("contentProducerException", req));
                message.append("</p>");
                message.append("<pre>");
                StringWriter writer = new StringWriter();
                t.printStackTrace(new PrintWriter(writer));
                message.append(((Object)writer).toString());
                message.append("</pre>");
                message.append(errorPageEnd);
                is = new ByteArrayInputStream(message.toString().getBytes("UTF8"));
            }
            Object out = resp.getOutputStream();
            IFilter[] iFilterArray = filters = pageNotFound ? errorPageFilters : allFilters;
            if (this.isProcessingRequired(resp.getContentType())) {
                int i = 0;
                while (i < filters.length) {
                    out = filters[i].filter(req, (OutputStream)out);
                    ++i;
                }
            }
            this.transferContent(is, (OutputStream)out);
            out.close();
            is.close();
        }
        catch (Exception e) {
            String msg = "Error processing help request " + this.getURL(req);
            HelpWebappPlugin.logError(msg, e);
        }
    }

    private boolean requiresErrorPage(String lowerCaseuRL) {
        return lowerCaseuRL.endsWith("htm") || lowerCaseuRL.endsWith("pdf") || lowerCaseuRL.endsWith("xhtml") || lowerCaseuRL.endsWith("shtml") || lowerCaseuRL.endsWith("html");
    }

    private boolean isProcessingRequired(String contentType) {
        if (!contentType.startsWith("text")) {
            return false;
        }
        if (contentType.equals("text/css")) {
            return false;
        }
        return !contentType.equals("text/javascript");
    }

    private URLConnection createConnection(HttpServletRequest req, HttpServletResponse resp, String url) throws Exception {
        URLConnection con = this.openConnection(url, req, resp);
        String pathInfo = req.getPathInfo();
        String mimeType = this.context.getMimeType(pathInfo);
        String contentType = mimeType != null && !mimeType.equals("application/xhtml+xml") ? mimeType : con.getContentType();
        resp.setContentType(contentType);
        long maxAge = 0L;
        try {
            long expiration = con.getExpiration();
            maxAge = (expiration - System.currentTimeMillis()) / 1000L;
            if (maxAge < 0L) {
                maxAge = 0L;
            }
        }
        catch (Exception exception) {}
        resp.setHeader("Cache-Control", "max-age=" + maxAge);
        return con;
    }

    private void transferContent(InputStream inputStream, OutputStream out) throws IOException {
        try {
            BufferedInputStream dataStream = new BufferedInputStream(inputStream);
            byte[] buffer = new byte[4096];
            int len = 0;
            while ((len = dataStream.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
        catch (Exception exception) {}
    }

    private URLConnection openConnection(String url, HttpServletRequest request, HttpServletResponse response) throws Exception {
        URL helpURL;
        URLConnection con = null;
        if (BaseHelpSystem.getMode() == 1) {
            String locale = UrlUtil.getLocale(request, response);
            url = url.indexOf(63) >= 0 ? String.valueOf(url) + "&lang=" + locale : String.valueOf(url) + "?lang=" + locale;
        }
        if (url.startsWith("help:")) {
            helpURL = new URL("help", null, -1, url.substring("help:".length()), HelpURLStreamHandler.getDefault());
        } else {
            if (url.startsWith("jar:")) {
                int excl = url.indexOf("!/");
                String jar = url.substring(0, excl);
                String path = url.length() > excl + 2 ? url.substring(excl + 2) : "";
                url = String.valueOf(jar.replaceAll("!", "%21")) + "!/" + path.replaceAll("!", "%21");
            }
            helpURL = new URL(url);
        }
        String protocol = helpURL.getProtocol();
        if (!("help".equals(protocol) || "file".equals(protocol) || "platform".equals(protocol) || "jar".equals(protocol))) {
            throw new IOException();
        }
        con = helpURL.openConnection();
        con.setAllowUserInteraction(false);
        con.setDoInput(true);
        con.connect();
        return con;
    }

    private String getURL(HttpServletRequest req) {
        String query = "";
        boolean firstParam = true;
        Enumeration params = req.getParameterNames();
        while (params.hasMoreElements()) {
            String param = (String)params.nextElement();
            String[] values = req.getParameterValues(param);
            if (values == null) continue;
            int i = 0;
            while (i < values.length) {
                if (firstParam) {
                    query = String.valueOf(query) + "?" + param + "=" + values[i];
                    firstParam = false;
                } else {
                    query = String.valueOf(query) + "&" + param + "=" + values[i];
                }
                ++i;
            }
        }
        String url = String.valueOf(req.getPathInfo()) + query;
        if (url.startsWith("/")) {
            url = url.substring(1);
        }
        return url;
    }
}

