/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.core.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xsl.core.internal.XSLCorePlugin;
import org.eclipse.wst.xsl.core.model.CallTemplate;
import org.eclipse.wst.xsl.core.model.Import;
import org.eclipse.wst.xsl.core.model.Include;
import org.eclipse.wst.xsl.core.model.Parameter;
import org.eclipse.wst.xsl.core.model.Stylesheet;
import org.eclipse.wst.xsl.core.model.Template;
import org.eclipse.wst.xsl.core.model.Variable;
import org.eclipse.wst.xsl.core.model.XSLAttribute;
import org.eclipse.wst.xsl.core.model.XSLElement;
import org.eclipse.wst.xsl.core.model.XSLNode;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StylesheetBuilder {
    private static StylesheetBuilder instance;
    private final Map<IFile, Stylesheet> builtFiles = new HashMap<IFile, Stylesheet>();

    private StylesheetBuilder() {
    }

    public Stylesheet getStylesheet(IFile file, boolean force) {
        Stylesheet stylesheet = this.builtFiles.get(file);
        if (stylesheet == null || force) {
            stylesheet = this.build(file);
            this.builtFiles.put(file, stylesheet);
        }
        return stylesheet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Stylesheet build(IFile file) {
        System.currentTimeMillis();
        Stylesheet stylesheet = null;
        IStructuredModel smodel = null;
        try {
            try {
                smodel = StructuredModelManager.getModelManager().getExistingModelForRead(file);
                if (smodel == null) {
                    smodel = StructuredModelManager.getModelManager().getModelForRead(file);
                }
                if (smodel == null || !(smodel instanceof IDOMModel)) return stylesheet;
                IDOMModel model = (IDOMModel)smodel;
                stylesheet = this.parseModel(model, file);
                return stylesheet;
            }
            catch (IOException e) {
                XSLCorePlugin.log(e);
                if (smodel == null) return stylesheet;
                smodel.releaseFromRead();
                return stylesheet;
            }
            catch (CoreException e) {
                XSLCorePlugin.log(e);
                if (smodel == null) return stylesheet;
                smodel.releaseFromRead();
                return stylesheet;
            }
        }
        finally {
            if (smodel != null) {
                smodel.releaseFromRead();
            }
        }
    }

    private Stylesheet parseModel(IDOMModel model, IFile file) {
        IDOMDocument document = model.getDocument();
        Stylesheet sf = new Stylesheet(file);
        StylesheetParser walker = new StylesheetParser(sf);
        walker.walkDocument(document);
        return sf;
    }

    public static synchronized StylesheetBuilder getInstance() {
        if (instance == null) {
            instance = new StylesheetBuilder();
        }
        return instance;
    }

    private static class StylesheetParser {
        private final Stylesheet sf;
        private final Stack<Element> elementStack = new Stack();
        private Template currentTemplate;
        private Stack<CallTemplate> callTemplates = new Stack();
        private XSLElement parentEl;

        public StylesheetParser(Stylesheet stylesheet) {
            this.sf = stylesheet;
        }

        public void walkDocument(IDOMDocument document) {
            if (document.getDocumentElement() != null) {
                this.recurse(document.getDocumentElement());
            }
        }

        private void recurse(Element element) {
            XSLElement xslEl = null;
            if ("http://www.w3.org/1999/XSL/Transform".equals(element.getNamespaceURI())) {
                Node childNode;
                NodeList childNodes;
                Parameter param;
                Include include;
                String elName = element.getLocalName();
                if ("stylesheet".equals(elName) && this.elementStack.size() == 0) {
                    element.getAttributes();
                    String version = element.getAttribute("version");
                    this.sf.setVersion(version);
                    xslEl = this.sf;
                } else if ("include".equals(elName) && this.elementStack.size() == 1) {
                    include = new Include(this.sf);
                    this.sf.addInclude(include);
                    xslEl = include;
                } else if ("import".equals(elName) && this.elementStack.size() == 1) {
                    include = new Import(this.sf);
                    this.sf.addImport((Import)include);
                    xslEl = include;
                } else if ("template".equals(elName) && this.elementStack.size() == 1) {
                    this.currentTemplate = new Template(this.sf);
                    this.sf.addTemplate(this.currentTemplate);
                    xslEl = this.currentTemplate;
                } else if ("param".equals(elName) && this.elementStack.size() == 2 && this.currentTemplate != null) {
                    param = new Parameter(this.sf);
                    childNodes = element.getChildNodes();
                    int i = 0;
                    while (i < childNodes.getLength()) {
                        childNode = childNodes.item(i);
                        if (childNode.getNodeType() != 2) {
                            param.setValue(true);
                            break;
                        }
                        ++i;
                    }
                    this.currentTemplate.addParameter(param);
                    xslEl = param;
                } else if ("call-template".equals(elName) && this.elementStack.size() >= 2) {
                    CallTemplate currentCallTemplate = new CallTemplate(this.sf);
                    this.callTemplates.push(currentCallTemplate);
                    this.sf.addCalledTemplate(currentCallTemplate);
                    xslEl = currentCallTemplate;
                } else if ("with-param".equals(elName) && this.elementStack.size() >= 3 && this.callTemplates.size() > 0) {
                    param = new Parameter(this.sf);
                    childNodes = element.getChildNodes();
                    int i = 0;
                    while (i < childNodes.getLength()) {
                        childNode = childNodes.item(i);
                        if (childNode.getNodeType() != 2) {
                            param.setValue(true);
                            break;
                        }
                        ++i;
                    }
                    CallTemplate currentCallTemplate = this.callTemplates.peek();
                    currentCallTemplate.addParameter(param);
                    xslEl = param;
                } else if ("variable".equals(elName)) {
                    Variable var;
                    if (this.elementStack.size() == 1) {
                        var = new Variable(this.sf);
                        this.sf.addGlobalVariable(var);
                        xslEl = var;
                    } else if (this.elementStack.size() > 1 && this.currentTemplate != null) {
                        var = new Variable(this.sf);
                        this.currentTemplate.addVariable(var);
                        xslEl = var;
                    }
                } else {
                    xslEl = new XSLElement(this.sf);
                }
                if (xslEl != null) {
                    this.configure((IDOMNode)element, xslEl);
                }
            }
            this.elementStack.push(element);
            NodeList childNodes = element.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node node = childNodes.item(i);
                if (node.getNodeType() == 1) {
                    this.recurse((Element)node);
                }
                ++i;
            }
            if (xslEl instanceof CallTemplate) {
                this.callTemplates.pop();
            }
            this.elementStack.pop();
        }

        private void configure(IDOMNode node, XSLElement element) {
            StylesheetParser.setPositionInfo(node, element);
            NamedNodeMap map = node.getAttributes();
            int i = 0;
            while (i < map.getLength()) {
                IDOMAttr attr = (IDOMAttr)map.item(i);
                XSLAttribute xslatt = new XSLAttribute(element, attr.getName(), attr.getValue());
                StylesheetParser.setPositionInfo((IDOMNode)attr, xslatt);
                element.setAttribute(xslatt);
                ++i;
            }
            if (this.parentEl != null) {
                this.parentEl.addChild(element);
            }
            this.parentEl = element;
        }

        private static void setPositionInfo(IDOMNode node, XSLNode inc) {
            try {
                IStructuredDocument structuredDocument = node.getStructuredDocument();
                int line = structuredDocument.getLineOfOffset(node.getStartOffset());
                int lineOffset = structuredDocument.getLineOffset(line);
                int col = node.getStartOffset() - lineOffset;
                inc.setOffset(node.getStartOffset());
                inc.setLineNumber(line);
                inc.setColumnNumber(col);
                inc.setLength(node.getLength());
            }
            catch (BadLocationException e) {
                XSLCorePlugin.log(e);
            }
        }
    }
}

