/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.core.internal.ant;

import java.io.File;
import java.util.Collection;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.wst.xsl.core.Messages;
import org.eclipse.wst.xsl.core.internal.xinclude.XIncluder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XIncludeTask
extends Task {
    private String inFile;
    private String outFile;

    public void setIn(String inFile) {
        this.log(String.valueOf(Messages.XIncludeTask_0) + inFile, 3);
        this.inFile = inFile;
    }

    public void setOut(String outFile) {
        this.log(String.valueOf(Messages.XIncludeTask_1) + outFile, 3);
        this.outFile = outFile;
    }

    public void execute() {
        this.validate();
        this.log(Messages.XIncludeTask_2, 3);
        File file = new File(this.inFile);
        if (!file.exists()) {
            throw new BuildException(String.valueOf(Messages.XIncludeTask_3) + this.inFile);
        }
        File fileout = new File(this.outFile);
        File dir = new File(fileout.getParent());
        if (!dir.exists()) {
            this.log(String.valueOf(Messages.XIncludeTask_4) + dir.getAbsolutePath());
            Boolean success = new File(dir.getAbsolutePath()).mkdirs();
            if (!success.booleanValue()) {
                throw new BuildException(String.valueOf(Messages.XIncludeTask_5) + this.outFile);
            }
        }
        if (this.checkmodified(this.inFile, this.outFile)) {
            this.log(Messages.XIncludeTask_6, 2);
            XIncluder la = new XIncluder();
            try {
                la.extractXMLFile(this.inFile, this.outFile);
            }
            catch (Exception e) {
                throw new BuildException(String.valueOf(Messages.XIncludeTask_7) + e.getMessage());
            }
        }
    }

    private boolean checkmodified(String inFile, String outFile) {
        File in = new File(inFile);
        File out = new File(outFile);
        File dir = new File(in.getParent());
        Collection<File> allFiles = this.listFiles(dir, true);
        for (File f : allFiles) {
            if (f.lastModified() <= out.lastModified()) continue;
            return true;
        }
        return false;
    }

    public Collection<File> listFiles(File directory, boolean recurse) {
        File[] entries;
        Vector<File> files = new Vector<File>();
        File[] fileArray = entries = directory.listFiles();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            File entry = fileArray[n2];
            files.add(entry);
            if (recurse && entry.isDirectory()) {
                files.addAll(this.listFiles(entry, recurse));
            }
            ++n2;
        }
        return files;
    }

    private void validate() {
        if (this.inFile == null) {
            throw new BuildException(Messages.XIncludeTask_8);
        }
        if (this.outFile == null) {
            throw new BuildException(Messages.XIncludeTask_9);
        }
    }
}

