/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.core.internal.validation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;
import org.eclipse.wst.xml.xpath.core.util.XSLTXPathHelper;
import org.eclipse.wst.xsl.core.Messages;
import org.eclipse.wst.xsl.core.XSLCore;
import org.eclipse.wst.xsl.core.internal.XSLCorePlugin;
import org.eclipse.wst.xsl.core.internal.validation.MaxErrorsExceededException;
import org.eclipse.wst.xsl.core.internal.validation.XSLValidationReport;
import org.eclipse.wst.xsl.core.model.CallTemplate;
import org.eclipse.wst.xsl.core.model.Include;
import org.eclipse.wst.xsl.core.model.Parameter;
import org.eclipse.wst.xsl.core.model.StylesheetModel;
import org.eclipse.wst.xsl.core.model.Template;
import org.eclipse.wst.xsl.core.model.XSLAttribute;
import org.eclipse.wst.xsl.core.model.XSLElement;
import org.eclipse.wst.xsl.core.model.XSLNode;

public class XSLValidator {
    private static XSLValidator instance;

    private XSLValidator() {
    }

    public ValidationReport validate(IFile xslFile, boolean forceBuild) throws CoreException {
        XSLValidationReport report = new XSLValidationReport(xslFile.getLocationURI().toString());
        this.validate(xslFile, report, forceBuild);
        return report;
    }

    public void validate(IFile xslFile, XSLValidationReport report, boolean forceBuild) throws CoreException {
        StylesheetModel stylesheet = forceBuild ? XSLCore.getInstance().buildStylesheet(xslFile) : XSLCore.getInstance().getStylesheet(xslFile);
        if (stylesheet != null) {
            try {
                this.calculateProblems(stylesheet, report);
            }
            catch (MaxErrorsExceededException maxErrorsExceededException) {}
        }
    }

    private void calculateProblems(StylesheetModel stylesheetComposed, XSLValidationReport report) throws MaxErrorsExceededException {
        this.checkCircularRef(stylesheetComposed, report);
        this.checkIncludes(stylesheetComposed, report);
        this.checkTemplates(stylesheetComposed, report);
        this.checkCallTemplates(stylesheetComposed, report);
        if (this.getPreference("CHECK_XPATHS") > 0) {
            this.checkXPaths(stylesheetComposed.getStylesheet(), report);
        }
    }

    private int getPreference(String key) {
        return XSLCorePlugin.getDefault().getPluginPreferences().getInt(key);
    }

    private void checkXPaths(XSLElement xslEl, XSLValidationReport report) throws MaxErrorsExceededException {
        this.validateXPath(xslEl, report, "select");
        this.validateXPath(xslEl, report, "test");
        this.validateXPath(xslEl, report, "match");
        for (XSLElement childEl : xslEl.getChildElements()) {
            this.checkXPaths(childEl, report);
        }
    }

    private void validateXPath(XSLElement xslEl, XSLValidationReport report, String attName) throws MaxErrorsExceededException {
        XSLAttribute att = xslEl.getAttribute(attName);
        if (att != null && att.getValue() != null) {
            try {
                XSLTXPathHelper.compile((String)att.getValue());
            }
            catch (XPathExpressionException xPathExpressionException) {
                this.createMarker(report, att, this.getPreference("CHECK_XPATHS"), Messages.XSLValidator_1);
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    private void checkCircularRef(StylesheetModel stylesheetComposed, XSLValidationReport report) throws MaxErrorsExceededException {
        if (stylesheetComposed.hasCircularReference()) {
            this.createMarker(report, stylesheetComposed.getStylesheet(), this.getPreference("CIRCULAR_REF"), Messages.XSLValidator_2);
        }
    }

    private void checkIncludes(StylesheetModel stylesheetComposed, XSLValidationReport report) throws MaxErrorsExceededException {
        IFile includedFile;
        for (Include include : stylesheetComposed.getStylesheet().getIncludes()) {
            includedFile = include.getHrefAsFile();
            if (includedFile == null || !includedFile.exists()) {
                XSLAttribute att = include.getAttribute("href");
                if (att != null) {
                    this.createMarker(report, att, this.getPreference("MISSING_INCLUDE"), String.valueOf(Messages.XSLValidator_4) + include.getHref());
                    continue;
                }
                this.createMarker(report, include, this.getPreference("NAME_ATTRIBUTE_EMPTY"), Messages.XSLValidator_23);
                continue;
            }
            if (!includedFile.equals((Object)include.getStylesheet().getFile())) continue;
            this.createMarker(report, include.getAttribute("href"), this.getPreference("CIRCULAR_REF"), Messages.XSLValidator_6);
        }
        for (Include include : stylesheetComposed.getStylesheet().getImports()) {
            includedFile = include.getHrefAsFile();
            if (includedFile == null || !includedFile.exists()) {
                this.createMarker(report, include.getAttribute("href"), this.getPreference("MISSING_INCLUDE"), String.valueOf(Messages.XSLValidator_8) + include.getHref());
                continue;
            }
            if (!includedFile.equals((Object)include.getStylesheet().getFile())) continue;
            this.createMarker(report, include.getAttribute("href"), this.getPreference("CIRCULAR_REF"), Messages.XSLValidator_10);
        }
    }

    private void checkTemplates(StylesheetModel stylesheetComposed, XSLValidationReport report) throws MaxErrorsExceededException {
        for (Template template : stylesheetComposed.getStylesheet().getTemplates()) {
            if (template.getName() != null) {
                this.checkParameters(report, template);
            }
            for (Template checkTemplate : stylesheetComposed.getTemplates()) {
                if (checkTemplate == template || !checkTemplate.equals((Object)template)) continue;
                if (template.getStylesheet() == stylesheetComposed.getStylesheet() && checkTemplate.getStylesheet() == stylesheetComposed.getStylesheet()) {
                    this.createMarker(report, template, this.getPreference("TEMPLATE_CONFLICT"), Messages.XSLValidator_11);
                    continue;
                }
                if (template.getStylesheet() == stylesheetComposed.getStylesheet()) {
                    this.createMarker(report, template, this.getPreference("TEMPLATE_CONFLICT"), Messages.XSLValidator_12);
                    continue;
                }
                this.createMarker(report, template.getStylesheet(), this.getPreference("TEMPLATE_CONFLICT"), Messages.XSLValidator_13);
            }
        }
    }

    private void checkParameters(XSLValidationReport report, Template template) throws MaxErrorsExceededException {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(template.getParameters());
        Collections.reverse(parameters);
        HashSet<Parameter> duplicateParameters = new HashSet<Parameter>();
        for (Parameter param : parameters) {
            if (param.getName() == null) {
                this.createMarker(report, param, this.getPreference("NAME_ATTRIBUTE_MISSING"), Messages.XSLValidator_14);
                continue;
            }
            if (param.getName().trim().length() == 0) {
                this.createMarker(report, param, this.getPreference("NAME_ATTRIBUTE_EMPTY"), Messages.XSLValidator_15);
                continue;
            }
            if (duplicateParameters.contains((Object)param)) continue;
            for (Parameter checkParam : parameters) {
                if (param == checkParam || !param.getName().equals(checkParam.getName())) continue;
                duplicateParameters.add(checkParam);
                this.createMarker(report, param, this.getPreference("DUPLICATE_PARAMETER"), Messages.XSLValidator_16);
            }
        }
    }

    private void checkCallTemplates(StylesheetModel stylesheetComposed, XSLValidationReport report) throws MaxErrorsExceededException {
        for (CallTemplate calledTemplate : stylesheetComposed.getStylesheet().getCalledTemplates()) {
            Object[] messageArgs;
            boolean found;
            if (calledTemplate.getName() == null) continue;
            List<Template> templateList = stylesheetComposed.getTemplatesByName(calledTemplate.getName());
            if (templateList.size() == 0) {
                Object[] messageArgs2 = new Object[]{calledTemplate.getName()};
                this.createMarker(report, calledTemplate.getAttribute("name"), this.getPreference("CHECK_CALL_TEMPLATES"), MessageFormat.format(Messages.XSLValidator_18, messageArgs2));
                continue;
            }
            Template namedTemplate = templateList.get(0);
            for (Parameter calledTemplateParam : calledTemplate.getParameters()) {
                found = false;
                for (Parameter namedTemplateParam : namedTemplate.getParameters()) {
                    if (!calledTemplateParam.getName().equals(namedTemplateParam.getName())) continue;
                    found = true;
                    if (namedTemplateParam.isValue() || calledTemplateParam.isValue()) break;
                    Object[] messageArgs3 = new Object[]{calledTemplateParam.getName()};
                    this.createMarker(report, calledTemplateParam, this.getPreference("EMPTY_PARAM"), MessageFormat.format(Messages.XSLValidator_20, messageArgs3));
                    break;
                }
                if (found) continue;
                messageArgs = new Object[]{calledTemplateParam.getName()};
                this.createMarker(report, calledTemplateParam.getAttribute("name"), this.getPreference("MISSING_PARAM"), MessageFormat.format(Messages.XSLValidator_22, messageArgs));
            }
            if (this.getPreference("MISSING_PARAM") <= 0) continue;
            for (Parameter namedTemplateParam : namedTemplate.getParameters()) {
                if (namedTemplateParam.isValue()) continue;
                found = false;
                for (Parameter calledTemplateParam : calledTemplate.getParameters()) {
                    if (!calledTemplateParam.getName().equals(namedTemplateParam.getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                messageArgs = new Object[]{namedTemplateParam.getName()};
                this.createMarker(report, calledTemplate, this.getPreference("MISSING_PARAM"), MessageFormat.format(Messages.XSLValidator_3, messageArgs));
            }
        }
    }

    private void createMarker(XSLValidationReport report, XSLNode xslNode, int severity, String message) throws MaxErrorsExceededException {
        if (severity > 0) {
            if (report.getErrors().size() + report.getWarnings().size() > this.getPreference("MAX_ERRORS")) {
                throw new MaxErrorsExceededException();
            }
            switch (severity) {
                case 2: {
                    report.addError(xslNode, message);
                    break;
                }
                case 1: {
                    report.addWarning(xslNode, message);
                }
            }
        }
    }

    public static XSLValidator getInstance() {
        if (instance == null) {
            instance = new XSLValidator();
        }
        return instance;
    }
}

