/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.core.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.xsl.core.XSLCore;
import org.eclipse.wst.xsl.core.model.Import;
import org.eclipse.wst.xsl.core.model.Include;
import org.eclipse.wst.xsl.core.model.Stylesheet;
import org.eclipse.wst.xsl.core.model.Template;
import org.eclipse.wst.xsl.core.model.Variable;
import org.eclipse.wst.xsl.core.model.XSLModelObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StylesheetModel
extends XSLModelObject {
    private final Stylesheet stylesheet;
    boolean circularReference;
    final Set<IFile> files = new HashSet<IFile>();
    final Set<Stylesheet> stylesheets = new HashSet<Stylesheet>();
    final List<Include> includeModel = new ArrayList<Include>();
    final List<Import> importModel = new ArrayList<Import>();
    final Set<Template> templateSet = new HashSet<Template>();
    final List<Template> templates = new ArrayList<Template>();
    final List<Variable> globalVariables = new ArrayList<Variable>();

    public StylesheetModel(Stylesheet stylesheet) {
        this.stylesheet = stylesheet;
    }

    public List<Include> getIncludes() {
        return this.includeModel;
    }

    public Set<IFile> getFileDependencies() {
        return this.files;
    }

    public Stylesheet getStylesheet() {
        return this.stylesheet;
    }

    public List<Variable> getGlobalVariables() {
        return this.globalVariables;
    }

    public List<Template> getTemplates() {
        return this.templates;
    }

    public List<Template> findAllNestedTemplates() {
        ArrayList<Template> allTemplates = new ArrayList<Template>();
        for (Stylesheet stylesheet : this.stylesheets) {
            allTemplates.addAll(stylesheet.getTemplates());
        }
        return allTemplates;
    }

    public List<Template> getTemplatesByName(String name) {
        ArrayList<Template> matching = new ArrayList<Template>(this.templates.size());
        for (Template template : this.templates) {
            if (!name.equals(template.getName())) continue;
            matching.add(template);
        }
        return matching;
    }

    public List<Template> findMatching(Template toMatch) {
        ArrayList<Template> matching = new ArrayList<Template>(this.templates.size());
        for (Template template : this.templates) {
            if (!template.equals((Object)toMatch)) continue;
            matching.add(template);
        }
        return matching;
    }

    public boolean hasCircularReference() {
        return this.circularReference;
    }

    public void fix() {
        System.currentTimeMillis();
        this.templates.addAll(this.stylesheet.getTemplates());
        this.templateSet.addAll(this.stylesheet.getTemplates());
        this.globalVariables.addAll(this.stylesheet.globalVariables);
        for (Include include : this.stylesheet.getIncludes()) {
            this.handleInclude(include);
        }
        for (Import import_ : this.stylesheet.getImports()) {
            this.handleInclude(import_);
        }
    }

    private void handleInclude(Include include) {
        IFile file = include.getHrefAsFile();
        if (file == null || !file.exists()) {
            return;
        }
        if (this.stylesheet.getFile().equals((Object)file) || this.files.contains(file)) {
            this.circularReference = true;
            return;
        }
        this.files.add(file);
        StylesheetModel includedModel = XSLCore.getInstance().getStylesheet(file);
        if (includedModel == null) {
            return;
        }
        this.stylesheets.add(includedModel.getStylesheet());
        this.globalVariables.addAll(includedModel.globalVariables);
        if (include.getIncludeType() == 1) {
            this.includeModel.add(include);
            this.templates.addAll(includedModel.getTemplates());
            this.templateSet.addAll(includedModel.getTemplates());
        } else {
            this.importModel.add((Import)include);
            for (Template includedTemplate : includedModel.getTemplates()) {
                if (this.templateSet.contains((Object)includedTemplate)) continue;
                this.templates.add(includedTemplate);
                this.templateSet.add(includedTemplate);
            }
        }
    }

    @Override
    public XSLModelObject.Type getModelType() {
        return XSLModelObject.Type.STYLESHEET_MODEL;
    }
}

