/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withoutaxes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.UserDataSetHints;
import org.eclipse.birt.chart.computation.withoutaxes.Coordinates;
import org.eclipse.birt.chart.computation.withoutaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.DataPoint;
import org.eclipse.birt.chart.model.attribute.DataPointComponent;
import org.eclipse.birt.chart.model.attribute.DataPointComponentType;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.Size;
import org.eclipse.birt.chart.model.attribute.impl.SizeImpl;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.impl.ChartWithoutAxesImpl;
import org.eclipse.emf.common.util.EList;

public final class PlotWithoutAxes {
    private final ChartWithoutAxes cwoa;
    private final RunTimeContext rtc;
    private transient double dPointToPixel = 0.0;
    private transient Size szCell = null;
    private transient int iRows = 0;
    private transient int iColumns = 0;
    private transient int iSeries = 0;
    private transient Bounds boPlot = null;
    private transient Insets insCA = null;
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine/computation.withoutaxes");

    public PlotWithoutAxes(IDisplayServer xs, ChartWithoutAxes cwoa, RunTimeContext rtc) {
        this.cwoa = cwoa;
        this.rtc = rtc;
        this.dPointToPixel = (double)xs.getDpiResolution() / 72.0;
    }

    public final void compute(Bounds bo) {
        this.boPlot = bo.scaledInstance(this.dPointToPixel);
        EList el = this.cwoa.getSeriesDefinitions();
        ArrayList al = new ArrayList();
        ((ChartWithoutAxesImpl)this.cwoa).recursivelyGetSeries(el, al, 0, 0);
        Series[] sea = al.toArray(new Series[al.size()]);
        this.iSeries = sea.length;
        this.iColumns = this.cwoa.getGridColumnCount();
        if (this.iColumns == 0) {
            this.iColumns = PlotWithoutAxes.getAutoColumCount(this.boPlot, this.iSeries);
        }
        this.iRows = (this.iSeries - 1) / this.iColumns + 1;
        this.szCell = SizeImpl.create(this.boPlot.getWidth() / (double)this.iColumns, this.boPlot.getHeight() / (double)this.iRows);
        this.insCA = this.cwoa.getPlot().getClientArea().getInsets().scaledInstance(this.dPointToPixel);
    }

    private static int getAutoColumCount(Bounds boPlot, int iSeries) {
        double rat = boPlot.getHeight() / boPlot.getWidth();
        int colums = (int)Math.round(Math.sqrt((double)iSeries / rat));
        if ((colums = Math.min(colums, iSeries)) == 0) {
            ++colums;
        }
        return colums;
    }

    public final Size getCellSize() {
        return this.szCell;
    }

    public final Insets getCellInsets() {
        return this.insCA;
    }

    public final Coordinates getCellCoordinates(int iCell) {
        return new Coordinates(iCell % this.iColumns, iCell / this.iColumns);
    }

    public final int getColumnCount() {
        return this.iColumns;
    }

    public final int getRowCount() {
        return this.iRows;
    }

    public final Bounds getBounds() {
        return this.boPlot;
    }

    public final ChartWithoutAxes getModel() {
        return this.cwoa;
    }

    public final SeriesRenderingHints getSeriesRenderingHints(Series seOrthogonal) throws ChartException, IllegalArgumentException {
        if (seOrthogonal == null || seOrthogonal.getClass() == SeriesImpl.class) {
            return null;
        }
        EList elCategories = this.cwoa.getSeriesDefinitions();
        if (elCategories.size() != 1) {
            throw new ChartException("org.eclipse.birt.chart.engine", 0, "exception.cwoa.single.series.definition", Messages.getResourceBundle(this.rtc.getULocale()));
        }
        SeriesDefinition sd = (SeriesDefinition)elCategories.get(0);
        List al = sd.getRunTimeSeries();
        if (al.size() != 1) {
            throw new ChartException("org.eclipse.birt.chart.engine", 0, "exception.cwoa.single.runtime.series", Messages.getResourceBundle(this.rtc.getULocale()));
        }
        Series seBase = (Series)al.get(0);
        DataSetIterator dsiBaseValues = new DataSetIterator(seBase.getDataSet());
        DataSetIterator dsiOrthogonalValues = new DataSetIterator(seOrthogonal.getDataSet());
        DataPointHints[] dpha = null;
        if (dsiBaseValues.size() != dsiOrthogonalValues.size()) {
            logger.log(1, Messages.getString("exception.data.outofsync", new Object[]{new Integer(dsiBaseValues.size()), new Integer(dsiOrthogonalValues.size())}, this.rtc.getULocale()));
        } else {
            int iCount = dsiOrthogonalValues.size();
            dpha = new DataPointHints[iCount];
            DataPoint dp = seOrthogonal.getDataPoint();
            EList el = dp.getComponents();
            FormatSpecifier fsBase = null;
            FormatSpecifier fsOrthogonal = null;
            FormatSpecifier fsSeries = null;
            FormatSpecifier fsPercentile = null;
            int i = 0;
            while (i < el.size()) {
                DataPointComponent dpc = (DataPointComponent)el.get(i);
                DataPointComponentType dpct = dpc.getType();
                if (((Object)((Object)DataPointComponentType.BASE_VALUE_LITERAL)).equals((Object)dpct) && (fsBase = dpc.getFormatSpecifier()) == null) {
                    fsBase = sd.getFormatSpecifier();
                }
                if (((Object)((Object)DataPointComponentType.ORTHOGONAL_VALUE_LITERAL)).equals((Object)dpct) && (fsOrthogonal = dpc.getFormatSpecifier()) == null && seOrthogonal.eContainer() instanceof SeriesDefinition) {
                    fsOrthogonal = ((SeriesDefinition)seOrthogonal.eContainer()).getFormatSpecifier();
                }
                if (((Object)((Object)DataPointComponentType.SERIES_VALUE_LITERAL)).equals((Object)dpct)) {
                    fsSeries = dpc.getFormatSpecifier();
                }
                if (((Object)((Object)DataPointComponentType.PERCENTILE_ORTHOGONAL_VALUE_LITERAL)).equals((Object)dpct)) {
                    fsPercentile = dpc.getFormatSpecifier();
                }
                ++i;
            }
            UserDataSetHints udsh = new UserDataSetHints(seOrthogonal.getDataSets());
            udsh.reset();
            double total = 0.0;
            int i2 = 0;
            while (i2 < iCount) {
                Object v = dsiOrthogonalValues.next();
                if (v instanceof Number) {
                    total += ((Number)v).doubleValue();
                } else if (v instanceof NumberDataElement) {
                    total += ((NumberDataElement)v).getValue();
                }
                ++i2;
            }
            dsiOrthogonalValues.reset();
            i2 = 0;
            while (i2 < iCount) {
                Object orthValue = dsiOrthogonalValues.next();
                Double percentileValue = null;
                if (total != 0.0) {
                    if (orthValue instanceof Number) {
                        percentileValue = new Double(((Number)orthValue).doubleValue() / total);
                    } else if (orthValue instanceof NumberDataElement) {
                        percentileValue = new Double(((NumberDataElement)orthValue).getValue() / total);
                    }
                } else {
                    percentileValue = new Double(0.0);
                }
                dpha[i2] = new DataPointHints(dsiBaseValues.next(), orthValue, seOrthogonal.getSeriesIdentifier(), (Object)percentileValue, seOrthogonal.getDataPoint(), fsBase, fsOrthogonal, fsSeries, fsPercentile, i2, null, -1.0, this.rtc);
                udsh.next(dpha[i2]);
                ++i2;
            }
        }
        return new SeriesRenderingHints(this, dpha, dsiBaseValues, dsiOrthogonalValues);
    }

    final RunTimeContext getRunTimeContext() {
        return this.rtc;
    }
}

