/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.registry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.DisabledInfo;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.runtime.MessageHelper;
import org.eclipse.pde.internal.runtime.PDERuntimeMessages;
import org.eclipse.pde.internal.runtime.PDERuntimePlugin;
import org.eclipse.pde.internal.runtime.PDERuntimePluginImages;
import org.eclipse.pde.internal.runtime.registry.DiagnosticsDialog;
import org.eclipse.pde.internal.runtime.registry.IBundleFolder;
import org.eclipse.pde.internal.runtime.registry.PluginAdapter;
import org.eclipse.pde.internal.runtime.registry.PluginObjectAdapter;
import org.eclipse.pde.internal.runtime.registry.RegistryBrowserContentProvider;
import org.eclipse.pde.internal.runtime.registry.RegistryBrowserLabelProvider;
import org.eclipse.pde.internal.runtime.registry.RegistryBrowserListener;
import org.eclipse.pde.internal.runtime.registry.RegistryFilteredTree;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceListener;
import org.osgi.service.packageadmin.PackageAdmin;

public class RegistryBrowser
extends ViewPart {
    public static final String SHOW_RUNNING_PLUGINS = "RegistryView.showRunning.label";
    public static final String SHOW_ADVANCED_MODE = "RegistryView.showAdvancedMode.label";
    public static final String SHOW_EXTENSIONS_ONLY = "RegistryView.showExtensions.label";
    public static final String SHOW_DISABLED_MODE = "RegistryView.showDisabledMode.label";
    private RegistryBrowserListener fListener;
    private FilteredTree fFilteredTree;
    private TreeViewer fTreeViewer;
    private IMemento fMemento;
    private int fTotalItems = 0;
    private Action fRefreshAction;
    private Action fShowPluginsAction;
    private Action fCollapseAllAction;
    private Action fShowAdvancedOperationsAction;
    private Action fShowExtensionsOnlyAction;
    private Action fShowDisabledAction;
    private Action fCopyAction;
    private Action fStartAction;
    private Action fStopAction;
    private Action fEnableAction;
    private Action fDisableAction;
    private Action fDiagnoseAction;
    private Clipboard fClipboard;
    private DrillDownAdapter fDrillDownAdapter;
    private ViewerFilter fActiveFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof PluginObjectAdapter) {
                element = ((PluginObjectAdapter)((Object)element)).getObject();
            }
            if (element instanceof IExtensionPoint) {
                element = Platform.getBundle((String)((IExtensionPoint)element).getNamespaceIdentifier());
            } else if (element instanceof IExtension) {
                element = Platform.getBundle((String)((IExtension)element).getNamespaceIdentifier());
            }
            if (element instanceof Bundle) {
                return ((Bundle)element).getState() == 32;
            }
            return true;
        }
    };
    private ViewerFilter fDisabledFilter = new ViewerFilter(){
        PlatformAdmin plaformAdmin = PDERuntimePlugin.getDefault().getPlatformAdmin();
        State state = this.plaformAdmin.getState(false);

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof PluginObjectAdapter) {
                element = ((PluginObjectAdapter)((Object)element)).getObject();
            }
            if (element instanceof Bundle) {
                Bundle bundle = (Bundle)element;
                BundleDescription description = this.state.getBundle(bundle.getBundleId());
                return this.state.getDisabledInfos(description).length > 0;
            }
            return false;
        }
    };

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fMemento = memento == null ? XMLMemento.createWriteRoot((String)"REGISTRYVIEW") : memento;
        this.initializeMemento();
        this.fListener = new RegistryBrowserListener(this);
    }

    private void initializeMemento() {
        if (this.fMemento.getString(SHOW_RUNNING_PLUGINS) == null) {
            this.fMemento.putString(SHOW_RUNNING_PLUGINS, "false");
        }
        if (this.fMemento.getString(SHOW_EXTENSIONS_ONLY) == null) {
            this.fMemento.putString(SHOW_EXTENSIONS_ONLY, "false");
        }
        if (this.fMemento.getString(SHOW_DISABLED_MODE) == null) {
            this.fMemento.putString(SHOW_DISABLED_MODE, "false");
        }
        if (this.fMemento.getString(SHOW_ADVANCED_MODE) == null) {
            this.fMemento.putString(SHOW_ADVANCED_MODE, "false");
        }
    }

    public void dispose() {
        if (this.fListener != null) {
            Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this.fListener);
            PDERuntimePlugin.getDefault().getBundleContext().removeBundleListener((BundleListener)this.fListener);
            PDERuntimePlugin.getDefault().getBundleContext().removeServiceListener((ServiceListener)this.fListener);
        }
        this.fClipboard.dispose();
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.makeActions();
        this.createTreeViewer(composite);
        this.fClipboard = new Clipboard(this.fTreeViewer.getTree().getDisplay());
        this.fillToolBar();
        PDERuntimePlugin.getDefault().getBundleContext().addBundleListener((BundleListener)this.fListener);
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this.fListener);
        PDERuntimePlugin.getDefault().getBundleContext().addServiceListener((ServiceListener)this.fListener);
    }

    private void createTreeViewer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.fFilteredTree = new RegistryFilteredTree(this, composite, 2, new PatternFilter());
        this.fFilteredTree.setBackground(parent.getDisplay().getSystemColor(25));
        Tree tree = this.fFilteredTree.getViewer().getTree();
        GridData gd = new GridData(1808);
        this.fFilteredTree.setLayoutData((Object)gd);
        this.fTreeViewer = this.fFilteredTree.getViewer();
        this.fTreeViewer.setContentProvider((IContentProvider)new RegistryBrowserContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new RegistryBrowserLabelProvider(this.fTreeViewer));
        this.fTreeViewer.setUseHashlookup(true);
        this.fTreeViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof PluginObjectAdapter) {
                    e1 = ((PluginObjectAdapter)((Object)e1)).getObject();
                }
                if (e2 instanceof PluginObjectAdapter) {
                    e2 = ((PluginObjectAdapter)((Object)e2)).getObject();
                }
                if (e1 instanceof IBundleFolder && e2 instanceof IBundleFolder) {
                    return ((IBundleFolder)e1).getFolderId() - ((IBundleFolder)e2).getFolderId();
                }
                if (e1 instanceof Bundle && e2 instanceof Bundle) {
                    e1 = ((Bundle)e1).getSymbolicName();
                    e2 = ((Bundle)e2).getSymbolicName();
                }
                return super.compare(viewer, e1, e2);
            }
        });
        if (this.fShowPluginsAction.isChecked()) {
            this.fTreeViewer.addFilter(this.fActiveFilter);
        }
        if (this.fShowDisabledAction.isChecked()) {
            this.fTreeViewer.addFilter(this.fDisabledFilter);
        }
        this.updateItems(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.fTreeViewer.getControl(), "org.eclipse.pde.doc.user.registry_view");
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.fTreeViewer);
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
                RegistryBrowser.this.fillContextMenu(mng);
            }
        };
        popupMenuManager.setRemoveAllWhenShown(true);
        popupMenuManager.addMenuListener(listener);
        Menu menu = popupMenuManager.createContextMenu((Control)tree);
        tree.setMenu(menu);
    }

    private PluginObjectAdapter[] getBundles() {
        Bundle[] bundles = PDERuntimePlugin.getDefault().getBundleContext().getBundles();
        ArrayList<PluginAdapter> list = new ArrayList<PluginAdapter>();
        int i = 0;
        while (i < bundles.length) {
            if (bundles[i].getHeaders().get("Fragment-Host") == null) {
                list.add(new PluginAdapter(bundles[i]));
            }
            ++i;
        }
        return list.toArray(new PluginObjectAdapter[list.size()]);
    }

    private void fillToolBar() {
        this.fDrillDownAdapter = new RegistryDrillDownAdapter(this.fTreeViewer);
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.fCopyAction);
        IToolBarManager mng = bars.getToolBarManager();
        this.fDrillDownAdapter.addNavigationActions(mng);
        mng.add((IAction)this.fRefreshAction);
        mng.add((IContributionItem)new Separator());
        mng.add((IAction)this.fCollapseAllAction);
        IMenuManager mgr = bars.getMenuManager();
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.fShowPluginsAction);
        mgr.add((IAction)this.fShowDisabledAction);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.fShowExtensionsOnlyAction);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.fShowAdvancedOperationsAction);
    }

    public void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.fRefreshAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fCopyAction);
        manager.add((IContributionItem)new Separator());
        this.fDrillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator());
        if (this.fShowAdvancedOperationsAction.isChecked() && this.isBundleSelected()) {
            if (this.selectedBundlesStopped()) {
                manager.add((IAction)this.fStartAction);
            }
            if (this.selectedBundlesStarted()) {
                manager.add((IAction)this.fStopAction);
            }
            if (this.getSelectedBundles().size() == 1) {
                manager.add((IAction)this.fDiagnoseAction);
            }
            if (this.selectedBundlesDisabled()) {
                manager.add((IAction)this.fEnableAction);
            }
            if (this.selectedBundlesEnabled()) {
                manager.add((IAction)this.fDisableAction);
            }
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fShowPluginsAction);
        manager.add((IAction)this.fShowDisabledAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fShowExtensionsOnlyAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fShowAdvancedOperationsAction);
    }

    public void saveState(IMemento memento) {
        if (memento == null || this.fMemento == null || this.fTreeViewer == null) {
            return;
        }
        this.fMemento.putString(SHOW_RUNNING_PLUGINS, Boolean.toString(this.fShowPluginsAction.isChecked()));
        this.fMemento.putString(SHOW_DISABLED_MODE, Boolean.toString(this.fShowDisabledAction.isChecked()));
        this.fMemento.putString(SHOW_EXTENSIONS_ONLY, Boolean.toString(this.fShowExtensionsOnlyAction.isChecked()));
        this.fMemento.putBoolean(SHOW_ADVANCED_MODE, this.fShowAdvancedOperationsAction.isChecked());
        memento.putMemento(this.fMemento);
    }

    public void setFocus() {
        Text filterText = this.fFilteredTree.getFilterControl();
        if (filterText != null) {
            filterText.setFocus();
        }
    }

    public void makeActions() {
        this.fRefreshAction = new Action("refresh"){

            public void run() {
                BusyIndicator.showWhile((Display)RegistryBrowser.this.fTreeViewer.getTree().getDisplay(), (Runnable)new Runnable(this){
                    final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        5.access$0(this.this$1).updateItems(true);
                    }
                });
            }

            static /* synthetic */ RegistryBrowser access$0(5 var0) {
                return var0.RegistryBrowser.this;
            }
        };
        this.fRefreshAction.setText(PDERuntimeMessages.RegistryView_refresh_label);
        this.fRefreshAction.setToolTipText(PDERuntimeMessages.RegistryView_refresh_tooltip);
        this.fRefreshAction.setImageDescriptor(PDERuntimePluginImages.DESC_REFRESH);
        this.fRefreshAction.setDisabledImageDescriptor(PDERuntimePluginImages.DESC_REFRESH_DISABLED);
        this.fShowPluginsAction = new Action(PDERuntimeMessages.RegistryView_showRunning_label){

            public void run() {
                if (RegistryBrowser.this.fShowPluginsAction.isChecked()) {
                    RegistryBrowser.this.fTreeViewer.addFilter(RegistryBrowser.this.fActiveFilter);
                } else {
                    RegistryBrowser.this.fTreeViewer.removeFilter(RegistryBrowser.this.fActiveFilter);
                }
                RegistryBrowser.this.updateTitle();
            }
        };
        this.fShowPluginsAction.setChecked(this.fMemento.getString(SHOW_RUNNING_PLUGINS).equals("true"));
        this.fShowDisabledAction = new Action(PDERuntimeMessages.RegistryView_showDisabled_label){

            public void run() {
                if (RegistryBrowser.this.fShowDisabledAction.isChecked()) {
                    RegistryBrowser.this.fTreeViewer.addFilter(RegistryBrowser.this.fDisabledFilter);
                } else {
                    RegistryBrowser.this.fTreeViewer.removeFilter(RegistryBrowser.this.fDisabledFilter);
                }
                RegistryBrowser.this.updateTitle();
            }
        };
        this.fShowDisabledAction.setChecked(this.fMemento.getString(SHOW_DISABLED_MODE).equals("true"));
        this.fCopyAction = new Action(PDERuntimeMessages.RegistryBrowser_copy_label){

            public void run() {
                ITreeSelection selection = (ITreeSelection)RegistryBrowser.this.fFilteredTree.getViewer().getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                String textVersion = ((ILabelProvider)RegistryBrowser.this.fTreeViewer.getLabelProvider()).getText(selection.getFirstElement());
                if (textVersion != null && textVersion.trim().length() > 0) {
                    RegistryBrowser.this.fClipboard.setContents(new Object[]{textVersion}, new Transfer[]{TextTransfer.getInstance()});
                }
            }
        };
        this.fCopyAction.setImageDescriptor(PDERuntimePluginImages.COPY_QNAME);
        this.fShowExtensionsOnlyAction = new Action(PDERuntimeMessages.RegistryBrowser_showExtOnlyLabel){

            public void run() {
                RegistryBrowser.this.fRefreshAction.run();
            }
        };
        this.fShowExtensionsOnlyAction.setChecked(this.fMemento.getString(SHOW_EXTENSIONS_ONLY).equals("true"));
        this.fShowAdvancedOperationsAction = new Action(PDERuntimeMessages.RegistryView_showAdvanced_label){

            public void run() {
            }
        };
        this.fShowAdvancedOperationsAction.setChecked(this.fMemento.getString(SHOW_ADVANCED_MODE).equals("true"));
        this.fStartAction = new Action(PDERuntimeMessages.RegistryView_startAction_label){

            public void run() {
                try {
                    List bundles = RegistryBrowser.this.getSelectedBundles();
                    Iterator it = bundles.iterator();
                    while (it.hasNext()) {
                        Bundle bundle = (Bundle)it.next();
                        bundle.start();
                    }
                }
                catch (BundleException e) {
                    PDERuntimePlugin.log(e);
                }
            }
        };
        this.fStopAction = new Action(PDERuntimeMessages.RegistryView_stopAction_label){

            public void run() {
                try {
                    List bundles = RegistryBrowser.this.getSelectedBundles();
                    Iterator it = bundles.iterator();
                    while (it.hasNext()) {
                        Bundle bundle = (Bundle)it.next();
                        bundle.stop();
                    }
                }
                catch (BundleException e) {
                    PDERuntimePlugin.log(e);
                }
            }
        };
        this.fEnableAction = new Action(PDERuntimeMessages.RegistryView_enableAction_label){

            public void run() {
                List bundles = RegistryBrowser.this.getSelectedBundles();
                State state = PDERuntimePlugin.getDefault().getState();
                Iterator it = bundles.iterator();
                while (it.hasNext()) {
                    Bundle bundle = (Bundle)it.next();
                    BundleDescription desc = state.getBundle(bundle.getBundleId());
                    DisabledInfo[] infos = state.getDisabledInfos(desc);
                    int i = 0;
                    while (i < infos.length) {
                        PlatformAdmin platformAdmin = PDERuntimePlugin.getDefault().getPlatformAdmin();
                        platformAdmin.removeDisabledInfo(infos[i]);
                        ++i;
                    }
                }
                PackageAdmin packageAdmin = PDERuntimePlugin.getDefault().getPackageAdmin();
                packageAdmin.refreshPackages(bundles.toArray(new Bundle[bundles.size()]));
            }
        };
        this.fDisableAction = new Action(PDERuntimeMessages.RegistryView_disableAction_label){

            public void run() {
                List bundles = RegistryBrowser.this.getSelectedBundles();
                State state = PDERuntimePlugin.getDefault().getState();
                Iterator it = bundles.iterator();
                while (it.hasNext()) {
                    Bundle bundle = (Bundle)it.next();
                    BundleDescription desc = state.getBundle(bundle.getBundleId());
                    DisabledInfo info = new DisabledInfo("org.eclipse.pde.ui", "Disabled via PDE", desc);
                    PlatformAdmin platformAdmin = PDERuntimePlugin.getDefault().getPlatformAdmin();
                    platformAdmin.addDisabledInfo(info);
                }
                PackageAdmin packageAdmin = PDERuntimePlugin.getDefault().getPackageAdmin();
                packageAdmin.refreshPackages(bundles.toArray(new Bundle[bundles.size()]));
            }
        };
        this.fDiagnoseAction = new Action(PDERuntimeMessages.RegistryView_diagnoseAction_label){

            public void run() {
                List bundles = RegistryBrowser.this.getSelectedBundles();
                State state = PDERuntimePlugin.getDefault().getState();
                Iterator it = bundles.iterator();
                while (it.hasNext()) {
                    Status status;
                    Bundle bundle = (Bundle)it.next();
                    BundleDescription desc = state.getBundle(bundle.getBundleId());
                    PlatformAdmin platformAdmin = PDERuntimePlugin.getDefault().getPlatformAdmin();
                    VersionConstraint[] unsatisfied = platformAdmin.getStateHelper().getUnsatisfiedConstraints(desc);
                    ResolverError[] resolverErrors = platformAdmin.getState(false).getResolverErrors(desc);
                    MultiStatus problems = new MultiStatus("org.eclipse.pde.runtime", 1, PDERuntimeMessages.RegistryView_found_problems, null);
                    int i = 0;
                    while (i < resolverErrors.length) {
                        if ((resolverErrors[i].getType() & 0x8007) == 0) {
                            status = new Status(2, "org.eclipse.pde.runtime", resolverErrors[i].toString());
                            problems.add((IStatus)status);
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < unsatisfied.length) {
                        status = new Status(2, "org.eclipse.pde.runtime", MessageHelper.getResolutionFailureMessage(unsatisfied[i]));
                        problems.add((IStatus)status);
                        ++i;
                    }
                    if (unsatisfied.length != 0 || resolverErrors.length != 0) {
                        DiagnosticsDialog dialog = new DiagnosticsDialog(RegistryBrowser.this.getSite().getShell(), PDERuntimeMessages.RegistryView_diag_dialog_title, null, (IStatus)problems, 2);
                        dialog.open();
                        continue;
                    }
                    MessageDialog.openInformation((Shell)RegistryBrowser.this.getSite().getShell(), (String)PDERuntimeMessages.RegistryView_diag_dialog_title, (String)PDERuntimeMessages.RegistryView_no_unresolved_constraints);
                }
            }
        };
        this.fCollapseAllAction = new Action("collapseAll"){

            public void run() {
                RegistryBrowser.this.fTreeViewer.collapseAll();
            }
        };
        this.fCollapseAllAction.setText(PDERuntimeMessages.RegistryView_collapseAll_label);
        this.fCollapseAllAction.setImageDescriptor(PDERuntimePluginImages.DESC_COLLAPSE_ALL);
        this.fCollapseAllAction.setToolTipText(PDERuntimeMessages.RegistryView_collapseAll_tooltip);
    }

    protected void updateItems(boolean resetInput) {
        Object[] input = null;
        boolean extOnly = this.fShowExtensionsOnlyAction.isChecked();
        input = extOnly ? Platform.getExtensionRegistry().getExtensionPoints() : this.getBundles();
        this.fListener.fExtOnly = extOnly;
        this.fTotalItems = input.length;
        if (resetInput) {
            this.fTreeViewer.setInput((Object)new PluginObjectAdapter(input));
        }
        this.updateTitle();
    }

    public void updateTitle() {
        this.setContentDescription(this.getTitleSummary());
    }

    protected Tree getUndisposedTree() {
        if (this.fTreeViewer == null || this.fTreeViewer.getTree() == null || this.fTreeViewer.getTree().isDisposed()) {
            return null;
        }
        return this.fTreeViewer.getTree();
    }

    public String getTitleSummary() {
        String type;
        Tree tree = this.getUndisposedTree();
        String string = type = this.fShowExtensionsOnlyAction.isChecked() ? PDERuntimeMessages.RegistryView_folders_extensionPoints : PDERuntimeMessages.RegistryBrowser_plugins;
        if (tree == null) {
            return NLS.bind((String)PDERuntimeMessages.RegistryView_titleSummary, (Object[])new String[]{"0", "0", type});
        }
        return NLS.bind((String)PDERuntimeMessages.RegistryView_titleSummary, (Object[])new String[]{Integer.toString(tree.getItemCount()), Integer.toString(this.fTotalItems), type});
    }

    private boolean isBundleSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        if (selection != null) {
            Object[] elements = selection.toArray();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof PluginObjectAdapter) {
                    PluginObjectAdapter adapter = (PluginObjectAdapter)((Object)elements[i]);
                    Object object = adapter.getObject();
                    if (!(object instanceof Bundle)) {
                        return false;
                    }
                } else {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private List getSelectedBundles() {
        ArrayList<Object> bundles = new ArrayList<Object>();
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        if (selection != null) {
            Object[] elements = selection.toArray();
            int i = 0;
            while (i < elements.length) {
                PluginObjectAdapter adapter;
                Object object;
                if (elements[i] instanceof PluginObjectAdapter && (object = (adapter = (PluginObjectAdapter)((Object)elements[i])).getObject()) instanceof Bundle) {
                    bundles.add(object);
                }
                ++i;
            }
        }
        return bundles;
    }

    private boolean selectedBundlesStarted() {
        List bundles = this.getSelectedBundles();
        Iterator it = bundles.iterator();
        while (it.hasNext()) {
            Bundle bundle = (Bundle)it.next();
            if (bundle.getState() == 32) continue;
            return false;
        }
        return true;
    }

    private boolean selectedBundlesStopped() {
        List bundles = this.getSelectedBundles();
        Iterator it = bundles.iterator();
        while (it.hasNext()) {
            Bundle bundle = (Bundle)it.next();
            if (bundle.getState() != 32) continue;
            return false;
        }
        return true;
    }

    private boolean selectedBundlesDisabled() {
        List bundles = this.getSelectedBundles();
        Iterator it = bundles.iterator();
        while (it.hasNext()) {
            BundleDescription desc;
            Bundle bundle = (Bundle)it.next();
            State state = PDERuntimePlugin.getDefault().getState();
            DisabledInfo[] infos = state.getDisabledInfos(desc = state.getBundle(bundle.getBundleId()));
            if (infos.length != 0) continue;
            return false;
        }
        return true;
    }

    private boolean selectedBundlesEnabled() {
        List bundles = this.getSelectedBundles();
        Iterator it = bundles.iterator();
        while (it.hasNext()) {
            BundleDescription desc;
            Bundle bundle = (Bundle)it.next();
            State state = PDERuntimePlugin.getDefault().getState();
            DisabledInfo[] infos = state.getDisabledInfos(desc = state.getBundle(bundle.getBundleId()));
            if (infos.length <= 0) continue;
            return false;
        }
        return true;
    }

    protected void add(Object object) {
        this.add(this.fTreeViewer.getInput(), object);
    }

    protected void add(Object parent, Object object) {
        if (this.fDrillDownAdapter.canGoHome()) {
            return;
        }
        ++this.fTotalItems;
        this.fTreeViewer.add(parent, object);
        this.updateTitle();
    }

    protected void remove(Object object) {
        if (this.fDrillDownAdapter.canGoHome()) {
            return;
        }
        --this.fTotalItems;
        this.fTreeViewer.remove(object);
        this.updateTitle();
    }

    protected void update(Object object) {
        this.fTreeViewer.update(object, null);
    }

    protected void refresh(Object object) {
        this.fTreeViewer.refresh(object);
    }

    protected TreeItem[] getTreeItems() {
        return this.fTreeViewer.getTree().getItems();
    }

    class RegistryDrillDownAdapter
    extends DrillDownAdapter {
        public RegistryDrillDownAdapter(TreeViewer tree) {
            super(tree);
        }

        public void goInto() {
            super.goInto();
            RegistryBrowser.this.fShowPluginsAction.setEnabled(!this.canGoHome());
            RegistryBrowser.this.fShowDisabledAction.setEnabled(!this.canGoHome());
        }

        public void goBack() {
            super.goBack();
            RegistryBrowser.this.fShowPluginsAction.setEnabled(!this.canGoHome());
            RegistryBrowser.this.fShowDisabledAction.setEnabled(!this.canGoHome());
        }

        public void goHome() {
            super.goHome();
            RegistryBrowser.this.fShowPluginsAction.setEnabled(!this.canGoHome());
            RegistryBrowser.this.fShowDisabledAction.setEnabled(!this.canGoHome());
        }

        public void goInto(Object newInput) {
            super.goInto(newInput);
            RegistryBrowser.this.fShowPluginsAction.setEnabled(!this.canGoHome());
            RegistryBrowser.this.fShowDisabledAction.setEnabled(!this.canGoHome());
        }
    }
}

