/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.core.patch.DiffProject;
import org.eclipse.compare.internal.core.patch.FileDiffResult;
import org.eclipse.compare.internal.core.patch.LineReader;
import org.eclipse.compare.internal.patch.HunkTypedElement;
import org.eclipse.compare.internal.patch.PatchCompareEditorInput;
import org.eclipse.compare.internal.patch.Patcher;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Image;

public class PatchFileTypedElement
implements ITypedElement,
IEncodedStreamContentAccessor {
    private final FileDiffResult result;
    private final boolean isAfterState;

    public PatchFileTypedElement(FileDiffResult result, boolean isAfterState) {
        this.result = result;
        this.isAfterState = isAfterState;
    }

    public Image getImage() {
        IFile file = this.getPatcher().getTargetFile(this.result.getDiff());
        if (file == null) {
            DiffProject project = this.result.getDiff().getProject();
            if (project != null) {
                file = project.getFile(this.result.getDiff().getPath(this.result.getConfiguration().isReversed()));
            } else {
                IResource target = this.getPatcher().getTarget();
                if (target instanceof IFile) {
                    file = (IFile)target;
                } else if (target instanceof IContainer) {
                    IContainer container = (IContainer)target;
                    file = container.getFile(this.result.getTargetPath());
                }
            }
        }
        Image image = null;
        if (file != null) {
            image = CompareUI.getImage((IAdaptable)file);
        }
        if (this.result.containsProblems()) {
            LocalResourceManager imageCache = PatchCompareEditorInput.getImageCache(this.result.getConfiguration());
            image = HunkTypedElement.getHunkErrorImage(image, imageCache, true);
        }
        return image;
    }

    public String getName() {
        return this.result.getTargetPath().toString();
    }

    public String getType() {
        return this.result.getTargetPath().getFileExtension();
    }

    public String getCharset() throws CoreException {
        return null;
    }

    public InputStream getContents() throws CoreException {
        if (this.isAfterState && this.getPatcher().hasCachedContents(this.result.getDiff())) {
            return new ByteArrayInputStream(this.getPatcher().getCachedContents(this.result.getDiff()));
        }
        List lines = this.isAfterState ? this.result.getAfterLines() : this.result.getBeforeLines();
        String contents = LineReader.createString((boolean)this.getPatcher().isPreserveLineDelimeters(), (List)lines);
        String charSet = this.getCharset();
        byte[] bytes = null;
        if (charSet != null) {
            try {
                bytes = contents.getBytes(charSet);
            }
            catch (UnsupportedEncodingException e) {
                CompareUIPlugin.log(e);
            }
        }
        if (bytes == null) {
            bytes = contents.getBytes();
        }
        return new ByteArrayInputStream(bytes);
    }

    private Patcher getPatcher() {
        return Patcher.getPatcher(this.result.getConfiguration());
    }
}

