/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.internal.core.Messages;
import org.eclipse.compare.internal.core.patch.DiffProject;
import org.eclipse.compare.internal.core.patch.FileDiff;
import org.eclipse.compare.internal.core.patch.Hunk;
import org.eclipse.compare.internal.core.patch.LineReader;
import org.eclipse.compare.internal.core.patch.PatchReader;
import org.eclipse.compare.internal.patch.Patcher;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;

public class WorkspacePatcher
extends Patcher {
    private DiffProject[] fDiffProjects;
    private boolean fIsWorkspacePatch = false;
    private final Map retargetedDiffs = new HashMap();

    public WorkspacePatcher() {
    }

    public WorkspacePatcher(IResource target) {
        this.setTarget(target);
    }

    protected void patchParsed(PatchReader patchReader) {
        super.patchParsed(patchReader);
        this.fDiffProjects = patchReader.getDiffProjects();
        this.fIsWorkspacePatch = patchReader.isWorkspacePatch();
    }

    public DiffProject[] getDiffProjects() {
        return this.fDiffProjects;
    }

    public boolean isWorkspacePatch() {
        return this.fIsWorkspacePatch;
    }

    public void applyAll(IProgressMonitor pm, Patcher.IFileValidator validator) throws CoreException {
        if (!this.fIsWorkspacePatch) {
            super.applyAll(pm, validator);
        } else {
            ArrayList<IFile> list = new ArrayList<IFile>();
            int j = 0;
            while (j < this.fDiffProjects.length) {
                DiffProject diffProject = this.fDiffProjects[j];
                if (diffProject.getProject().isAccessible()) {
                    list.addAll(Arrays.asList(this.getTargetFiles(diffProject)));
                }
                ++j;
            }
            if (!validator.validateResources(list.toArray(new IFile[list.size()]))) {
                return;
            }
            FileDiff[] diffs = this.getDiffs();
            if (pm != null) {
                String message = Messages.WorkspacePatcher_0;
                pm.beginTask(message, diffs.length * 10);
            }
            int i = 0;
            while (i < diffs.length) {
                int workTicks = 10;
                FileDiff diff = diffs[i];
                if (this.isAccessible(diff)) {
                    IFile file = this.getTargetFile(diff);
                    IPath path = file.getProjectRelativePath();
                    if (pm != null) {
                        pm.subTask(path.toString());
                    }
                    this.createPath((IContainer)file.getProject(), path);
                    ArrayList failed = new ArrayList();
                    int type = diff.getDiffType(this.isReversed());
                    switch (type) {
                        case 1: {
                            List result = this.apply(diff, file, true, failed);
                            if (result != null) {
                                this.store(LineReader.createString((boolean)this.isPreserveLineDelimeters(), (List)result), file, (IProgressMonitor)new SubProgressMonitor(pm, workTicks));
                            }
                            workTicks -= 10;
                            break;
                        }
                        case 2: {
                            file.delete(true, true, (IProgressMonitor)new SubProgressMonitor(pm, workTicks));
                            workTicks -= 10;
                            break;
                        }
                        case 3: {
                            List result = this.apply(diff, file, false, failed);
                            if (result != null) {
                                this.store(LineReader.createString((boolean)this.isPreserveLineDelimeters(), (List)result), file, (IProgressMonitor)new SubProgressMonitor(pm, workTicks));
                            }
                            workTicks -= 10;
                        }
                    }
                    if (this.isGenerateRejectFile() && failed.size() > 0) {
                        IPath pp = null;
                        if (path.segmentCount() > 1) {
                            pp = path.removeLastSegments(1);
                            pp = pp.append(String.valueOf(path.lastSegment()) + ".rej");
                        } else {
                            pp = new Path(String.valueOf(path.lastSegment()) + ".rej");
                        }
                        file = this.createPath((IContainer)file.getProject(), pp);
                        if (file != null) {
                            this.store(WorkspacePatcher.getRejected(failed), file, pm);
                            try {
                                IMarker marker = file.createMarker("org.eclipse.compare.rejectedPatchMarker");
                                marker.setAttribute("message", (Object)Messages.WorkspacePatcher_1);
                                marker.setAttribute("priority", 2);
                            }
                            catch (CoreException coreException) {}
                        }
                    }
                }
                if (pm != null) {
                    if (pm.isCanceled()) break;
                    if (workTicks > 0) {
                        pm.worked(workTicks);
                    }
                }
                ++i;
            }
        }
    }

    private boolean isAccessible(FileDiff diff) {
        return this.isEnabled(diff) && diff.getProject().getProject().isAccessible();
    }

    public IFile[] getTargetFiles(DiffProject project) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        FileDiff[] diffs = project.getFileDiffs();
        int i = 0;
        while (i < diffs.length) {
            FileDiff diff = diffs[i];
            if (this.isEnabled(diff)) {
                files.add(this.getTargetFile(diff));
            }
            ++i;
        }
        return files.toArray(new IFile[files.size()]);
    }

    public IFile getTargetFile(FileDiff diff) {
        IPath path = diff.getStrippedPath(this.getStripPrefixSegments(), this.isReversed());
        DiffProject project = this.getProject(diff);
        if (project != null) {
            return project.getFile(path);
        }
        return super.getTargetFile(diff);
    }

    private IPath getFullPath(FileDiff diff) {
        IPath path = diff.getStrippedPath(this.getStripPrefixSegments(), this.isReversed());
        DiffProject project = this.getProject(diff);
        if (project != null) {
            return project.getFile(path).getFullPath();
        }
        return this.getTarget().getFullPath().append(path);
    }

    public ISchedulingRule[] getTargetProjects() {
        ArrayList<MultiRule> projects = new ArrayList<MultiRule>();
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        int i = 0;
        while (i < this.fDiffProjects.length) {
            IProject tempProject = this.fDiffProjects[i].getProject();
            ISchedulingRule scheduleRule = ruleFactory.modifyRule((IResource)tempProject.getFile(".project"));
            MultiRule multiRule = new MultiRule(new ISchedulingRule[]{scheduleRule, tempProject});
            projects.add(multiRule);
            ++i;
        }
        return projects.toArray(new ISchedulingRule[projects.size()]);
    }

    public void setDiffProjects(DiffProject[] newProjectArray) {
        this.fDiffProjects = new DiffProject[newProjectArray.length];
        System.arraycopy(newProjectArray, 0, this.fDiffProjects, 0, newProjectArray.length);
    }

    public void removeProject(DiffProject project) {
        DiffProject[] temp = new DiffProject[this.fDiffProjects.length - 1];
        int counter = 0;
        int i = 0;
        while (i < this.fDiffProjects.length) {
            if (this.fDiffProjects[i] != project) {
                temp[counter++] = this.fDiffProjects[i];
            }
            ++i;
        }
        this.fDiffProjects = temp;
    }

    protected Object getElementParent(Object element) {
        if (element instanceof FileDiff && this.fDiffProjects != null) {
            FileDiff diff = (FileDiff)element;
            int i = 0;
            while (i < this.fDiffProjects.length) {
                DiffProject project = this.fDiffProjects[i];
                if (project.contains(diff)) {
                    return project;
                }
                ++i;
            }
        }
        return null;
    }

    public boolean isRetargeted(Object object) {
        return this.retargetedDiffs.containsKey(object);
    }

    public IPath getOriginalPath(Object object) {
        return (IPath)this.retargetedDiffs.get(object);
    }

    public void retargetDiff(FileDiff diff, IFile file) {
        this.retargetedDiffs.put(diff, diff.getPath(false));
        Hunk[] hunks = diff.getHunks();
        if (this.isWorkspacePatch()) {
            diff.getProject().remove(diff);
        }
        this.removeDiff(diff);
        FileDiff newDiff = this.getDiffForFile(file);
        int i = 0;
        while (i < hunks.length) {
            Hunk hunk = hunks[i];
            newDiff.add(hunk);
            ++i;
        }
    }

    private FileDiff getDiffForFile(IFile file) {
        FileDiff[] diffsToCheck;
        DiffProject diffProject = null;
        if (this.isWorkspacePatch()) {
            IProject project = file.getProject();
            DiffProject[] diffProjects = this.getDiffProjects();
            int i = 0;
            while (i < diffProjects.length) {
                if (diffProjects[i].getProject().equals((Object)project)) {
                    diffProject = diffProjects[i];
                    break;
                }
                ++i;
            }
            if (diffProject == null) {
                diffProject = this.addDiffProjectForProject(project);
            }
            diffsToCheck = diffProject.getFileDiffs();
        } else {
            diffsToCheck = this.getDiffs();
        }
        int i = 0;
        while (i < diffsToCheck.length) {
            FileDiff fileDiff = diffsToCheck[i];
            if (this.isDiffForFile(fileDiff, file)) {
                return fileDiff;
            }
            ++i;
        }
        IPath path = this.getDiffPath(file);
        FileDiff newDiff = new FileDiff(path, 0L, path, 0L);
        if (diffProject != null) {
            diffProject.add(newDiff);
        }
        this.addDiff(newDiff);
        return newDiff;
    }

    private IPath getDiffPath(IFile file) {
        DiffProject project = this.getDiffProject(file.getProject());
        if (project != null) {
            return file.getProjectRelativePath();
        }
        return file.getFullPath().removeFirstSegments(this.getTarget().getFullPath().segmentCount());
    }

    private boolean isDiffForFile(FileDiff fileDiff, IFile file) {
        return this.getFullPath(fileDiff).equals((Object)file.getFullPath());
    }

    private DiffProject addDiffProjectForProject(IProject project) {
        DiffProject[] diffProjects = this.getDiffProjects();
        DiffProject diffProject = new DiffProject(project);
        DiffProject[] newProjectArray = new DiffProject[diffProjects.length + 1];
        System.arraycopy(diffProjects, 0, newProjectArray, 0, diffProjects.length);
        newProjectArray[diffProjects.length] = diffProject;
        this.setDiffProjects(newProjectArray);
        return diffProject;
    }

    public void retargetHunk(Hunk hunk, IFile file) {
        FileDiff newDiff = this.getDiffForFile(file);
        newDiff.add(hunk);
    }

    public void retargetProject(DiffProject project, IProject targetProject) {
        this.retargetedDiffs.put(project, project.getProject().getFullPath());
        FileDiff[] diffs = project.getFileDiffs();
        DiffProject selectedProject = this.getDiffProject(targetProject);
        if (selectedProject == null) {
            selectedProject = this.addDiffProjectForProject(targetProject);
        }
        int i = 0;
        while (i < diffs.length) {
            selectedProject.add(diffs[i]);
            ++i;
        }
        this.removeProject(project);
    }

    private DiffProject getDiffProject(IProject project) {
        if (!this.isWorkspacePatch()) {
            return null;
        }
        DiffProject[] projects = this.getDiffProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].getProject().equals((Object)project)) {
                return projects[i];
            }
            ++i;
        }
        return null;
    }

    public int getStripPrefixSegments() {
        if (this.isWorkspacePatch()) {
            return 0;
        }
        return super.getStripPrefixSegments();
    }
}

