/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.report.engine.api.DataExtractionFormatInfo;
import org.eclipse.birt.report.engine.api.EmitterInfo;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IDataExtractionTask;
import org.eclipse.birt.report.engine.api.IDocumentWriter;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.IStatusHandler;
import org.eclipse.birt.report.engine.api.impl.EngineLogger;
import org.eclipse.birt.report.engine.api.impl.ReportEngineHelper;
import org.eclipse.birt.report.engine.executor.ScriptUtil;
import org.eclipse.birt.report.engine.extension.engine.IReportEngineExtension;
import org.eclipse.birt.report.engine.extension.engine.IReportEngineExtensionFactory;
import org.eclipse.birt.report.engine.util.SecurityUtil;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ReportEngine
implements IReportEngine {
    public static final String PROPERTYSEPARATOR = File.pathSeparator;
    public static final boolean USE_DYNAMIC_SCOPE = true;
    protected static Logger logger = Logger.getLogger(ReportEngine.class.getName());
    protected EngineConfig config;
    protected ReportEngineHelper helper;
    protected ScriptableObject rootScope;
    protected ClassLoader applicationClassLoader;
    private static String[] classPathes = new String[]{"webapplication.projectclasspath", "user.projectclasspath", "workspace.projectclasspath"};
    private EngineExtensionManager extensionManager = new EngineExtensionManager();

    static {
        ContextFactory.initGlobal((ContextFactory)new MyFactory());
    }

    public ReportEngine(EngineConfig config) {
        this.config = config;
        this.mergeConfigToAppContext();
        this.intializeLogger();
        logger.log(Level.FINE, "ReportEngine created. EngineConfig: {0} ", config);
        this.helper = new ReportEngineHelper(this);
        this.setupScriptScope();
    }

    private void mergeConfigToAppContext() {
        if (this.config == null) {
            return;
        }
        this.mergeProperty("PARENT_CLASSLOADER");
        this.mergeProperty("webapplication.projectclasspath");
        this.mergeProperty("user.projectclasspath");
        this.mergeProperty("workspace.projectclasspath");
    }

    private void mergeProperty(String property) {
        HashMap appContext = this.config.getAppContext();
        if (appContext.containsKey(property)) {
            return;
        }
        Object value = this.config.getProperty(property);
        if (value != null) {
            appContext.put(property, value);
        }
    }

    private void intializeLogger() {
        Logger logger = null;
        String dest = null;
        String file = null;
        Level level = Level.WARNING;
        if (this.config != null) {
            logger = this.config.getLogger();
            dest = this.config.getLogDirectory();
            file = this.config.getLogFile();
            level = this.config.getLogLevel();
            if (level == null) {
                level = Level.WARNING;
            }
        }
        EngineLogger.startEngineLogging(logger, dest, file, level);
    }

    private void setupScriptScope() {
        if (this.config != null) {
            Context cx = Context.enter();
            try {
                cx.setSecurityController(ScriptUtil.createSecurityController());
            }
            catch (Throwable throwable) {}
            try {
                try {
                    this.rootScope = cx.initStandardObjects();
                    cx.evaluateString((Scriptable)this.rootScope, "function registerGlobal( name, value) { _jsContext.registerGlobalBean(name, value); }", "<inline>", 0, null);
                    cx.evaluateString((Scriptable)this.rootScope, "function unregisterGlobal(name) { _jsContext.unregisterGlobalBean(name); }", "<inline>", 0, null);
                    this.registerBeans(this.rootScope, this.config.getConfigMap());
                    this.registerBeans(this.rootScope, this.config.getScriptObjects());
                    IStatusHandler handler = this.config.getStatusHandler();
                    if (handler != null) {
                        handler.initialize();
                        this.rootScope.put("_statusHandle", (Scriptable)this.rootScope, (Object)handler);
                        cx.evaluateString((Scriptable)this.rootScope, "function writeStatus(msg) { _statusHandle.showStatus(msg); }", "<inline>", 0, null);
                    }
                }
                catch (Exception ex) {
                    this.rootScope = null;
                    logger.log(Level.INFO, "Error occurs while initialze script scope", ex);
                    Context.exit();
                }
            }
            finally {
                Context.exit();
            }
        }
    }

    public Object getRootScope() {
        return this.rootScope;
    }

    private void registerBeans(ScriptableObject scope, Map map) {
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey() == null) continue;
            scope.put(entry.getKey().toString(), (Scriptable)scope, entry.getValue());
        }
    }

    public void changeLogLevel(Level newLevel) {
        EngineLogger.changeLogLevel(newLevel);
    }

    public EngineConfig getConfig() {
        return this.config;
    }

    public IReportRunnable openReportDesign(String designName) throws EngineException {
        logger.log(Level.FINE, "ReportEngine.openReportDesign: designName={0} ", designName);
        IResourceLocator locator = this.config.getResourceLocator();
        return this.helper.openReportDesign(designName, locator);
    }

    public IReportRunnable openReportDesign(ReportDesignHandle designHandle) throws EngineException {
        logger.log(Level.FINE, "ReportEngine.openReportDesign: designHandle={0} ", designHandle);
        return this.helper.openReportDesign(designHandle);
    }

    public IReportRunnable openReportDesign(InputStream designStream) throws EngineException {
        logger.log(Level.FINE, "ReportEngine.openReportDesign: designStream={0} ", designStream);
        return this.helper.openReportDesign(designStream);
    }

    public IReportRunnable openReportDesign(String name, InputStream designStream) throws EngineException {
        logger.log(Level.FINE, "ReportEngine.openReportDesign: name={0}, designStream={1} ", new Object[]{name, designStream});
        return this.helper.openReportDesign(name, designStream);
    }

    public IRunAndRenderTask createRunAndRenderTask(IReportRunnable reportRunnable) {
        logger.log(Level.FINE, "ReportEngine.createRunAndRenderTask: reportRunnable={0} ", reportRunnable);
        return this.helper.createRunAndRenderTask(reportRunnable);
    }

    public IGetParameterDefinitionTask createGetParameterDefinitionTask(IReportRunnable reportRunnable) {
        logger.log(Level.FINE, "ReportEngine.createGetParameterDefinitionTask: reportRunnable={0} ", reportRunnable);
        return this.helper.createGetParameterDefinitionTask(reportRunnable);
    }

    public String[] getSupportedFormats() {
        return this.helper.getSupportedFormats();
    }

    public EmitterInfo[] getEmitterInfo() {
        return this.helper.getEmitterInfo();
    }

    public String getMIMEType(String format) {
        return this.helper.getMIMEType(format);
    }

    public void destroy() {
        IStatusHandler handler;
        logger.fine("ReportEngine.destroy");
        this.rootScope = null;
        this.helper = null;
        if (this.config != null && (handler = this.config.getStatusHandler()) != null) {
            handler.finish();
        }
        if (this.extensionManager != null) {
            this.extensionManager.close();
            this.extensionManager = null;
        }
        EngineLogger.stopEngineLogging();
    }

    public IRunTask createRunTask(IReportRunnable reportRunnable) {
        logger.log(Level.FINE, "ReportEngine.createRunTask: reportRunnable={0} ", reportRunnable);
        return this.helper.createRunTask(reportRunnable);
    }

    public IRenderTask createRenderTask(IReportDocument reportDocument) {
        logger.log(Level.FINE, "ReportEngine.createRenderTask: reportDocument={0} ", reportDocument);
        return this.helper.createRenderTask(reportDocument);
    }

    public IRenderTask createRenderTask(IReportDocument reportDocument, IReportRunnable reportRunnable) {
        logger.log(Level.FINE, "ReportEngine.createRenderTask: reportDocument={0}, runnable={1}", new Object[]{reportDocument, reportRunnable});
        return this.helper.createRenderTask(reportDocument, reportRunnable);
    }

    public IReportDocument openReportDocument(String fileName) throws EngineException {
        logger.log(Level.FINE, "ReportEngine.openReportDocument: fileName={0} ", fileName);
        return this.helper.openReportDocument(fileName);
    }

    public IDataExtractionTask createDataExtractionTask(IReportDocument reportDocument) {
        logger.log(Level.FINE, "ReportEngine.createDataExtractionTask: reportDocument={0} ", reportDocument);
        return this.helper.createDataExtractionTask(reportDocument);
    }

    public void shutdown() {
        this.destroy();
    }

    public IReportDocument openReportDocument(String systemId, String fileName) throws EngineException {
        logger.log(Level.FINE, "ReportEngine.openReportDocument: systemID={0}, file={1} ", new Object[]{systemId, fileName});
        return this.openReportDocument(systemId, fileName, (IResourceLocator)null);
    }

    public IReportRunnable openReportDesign(String designName, IResourceLocator locator) throws EngineException {
        logger.log(Level.FINE, "ReportEngine.openReportDesign: design={0}, locator={1} ", new Object[]{designName, locator});
        return this.helper.openReportDesign(designName, locator);
    }

    public IReportRunnable openReportDesign(String name, InputStream designStream, IResourceLocator locator) throws EngineException {
        logger.log(Level.FINE, "ReportEngine.openReportDesign: name={0}, designStream={1}, locator={2} ", new Object[]{name, designStream, locator});
        return this.helper.openReportDesign(name, designStream, locator);
    }

    public IReportRunnable openReportDesign(String name, InputStream designStream, Map options) throws EngineException {
        logger.log(Level.FINE, "ReportEngine.openReportDesign: name={0}, designStream={1}, options={3} ", new Object[]{name, designStream, options});
        return this.helper.openReportDesign(name, designStream, options);
    }

    public IReportDocument openReportDocument(String fileName, IResourceLocator locator) throws EngineException {
        logger.log(Level.FINE, "ReportEngine.openReportDocument: file={0}, locator={1} ", new Object[]{fileName, locator});
        return this.openReportDocument(fileName, fileName, locator);
    }

    public IReportDocument openReportDocument(String systemId, String fileName, IResourceLocator locator) throws EngineException {
        logger.log(Level.FINE, "ReportEngine.openReportDocument: systemId={0}, file={1}, locator={2} ", new Object[]{systemId, fileName, locator});
        return this.helper.openReportDocument(systemId, fileName, locator);
    }

    public IReportDocument openReportDocument(String systemId, String fileName, Map options) throws EngineException {
        logger.log(Level.FINE, "ReportEngine.openReportDocument: systemId={0}, file={1}, options={2} ", new Object[]{systemId, fileName, options});
        return this.helper.openReportDocument(systemId, fileName, options);
    }

    public IReportDocument openReportDocument(String systemId, IDocArchiveReader reader, Map options) throws EngineException {
        logger.log(Level.FINE, "ReportEngine.openReportDocument: systemId={0}, reader={1}, options={2} ", new Object[]{systemId, reader, options});
        return this.helper.openReportDocument(systemId, reader, options);
    }

    public IDocumentWriter openDocumentWriter(IArchiveFile file) throws EngineException {
        logger.log(Level.FINE, "ReportEngine.openDocumentWriter: archive={0} ", new Object[]{file});
        return this.helper.openDocumentWriter(file);
    }

    public Logger getLogger() {
        return logger;
    }

    public void setLogger(Logger logger) {
        if (logger != null) {
            EngineLogger.startEngineLogging(logger, null, null, null);
        }
    }

    public ClassLoader getClassLoader() {
        if (this.applicationClassLoader == null) {
            this.applicationClassLoader = ReportEngine.createClassLoaderFromEngine(this);
        }
        return this.applicationClassLoader;
    }

    private static ClassLoader createClassLoaderFromEngine(IReportEngine engine) {
        ClassLoader root = ReportEngine.getAppClassLoader(engine);
        if (root == null) {
            root = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return IReportEngine.class.getClassLoader();
                }
            });
        }
        return ReportEngine.createClassLoaderFromProperty(engine, root);
    }

    private static ClassLoader createClassLoaderFromProperty(IReportEngine engine, ClassLoader parent) {
        EngineConfig config = engine.getConfig();
        if (config == null) {
            return parent;
        }
        HashMap appContext = config.getAppContext();
        ArrayList<URL> urls = new ArrayList<URL>();
        if (appContext != null) {
            int i = 0;
            while (i < classPathes.length) {
                String[] jars;
                String classPathName = classPathes[i];
                String classPath = null;
                Object propValue = appContext.get(classPathName);
                if (propValue instanceof String) {
                    classPath = (String)propValue;
                }
                if (classPath == null) {
                    classPath = SecurityUtil.getSystemProperty(classPathes[i]);
                }
                if (classPath != null && classPath.length() != 0 && (jars = classPath.split(PROPERTYSEPARATOR, -1)) != null && jars.length != 0) {
                    int j = 0;
                    while (j < jars.length) {
                        File file = new File(jars[j]);
                        try {
                            urls.add(file.toURL());
                        }
                        catch (MalformedURLException e) {
                            logger.log(Level.WARNING, e.getMessage(), e);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (urls.size() != 0) {
            return new URLClassLoader(urls.toArray(new URL[urls.size()]), parent);
        }
        return parent;
    }

    private static ClassLoader getAppClassLoader(IReportEngine engine) {
        Object appLoader;
        EngineConfig config = engine.getConfig();
        if (config == null) {
            return null;
        }
        HashMap appContext = config.getAppContext();
        if (appContext != null && (appLoader = appContext.get("PARENT_CLASSLOADER")) instanceof ClassLoader) {
            return (ClassLoader)appLoader;
        }
        return null;
    }

    public DataExtractionFormatInfo[] getDataExtractionFormatInfo() {
        return this.helper.getDataExtractionFormatInfo();
    }

    public IReportEngineExtension getEngineExtension(String name) {
        if (this.extensionManager != null) {
            return this.extensionManager.getExtension(name);
        }
        return null;
    }

    private class EngineExtensionManager {
        HashMap<String, IReportEngineExtension> exts = new HashMap();

        EngineExtensionManager() {
            IExtension[] extensions;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.birt.core.FactoryService");
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    String type = element.getAttribute("type");
                    if ("org.eclipse.birt.report.engine.extension".equals(type)) {
                        try {
                            Object factoryObject = element.createExecutableExtension("class");
                            if (factoryObject instanceof IReportEngineExtensionFactory) {
                                IReportEngineExtensionFactory factory = (IReportEngineExtensionFactory)factoryObject;
                                IReportEngineExtension engineExtension = factory.createExtension(ReportEngine.this);
                                this.exts.put(engineExtension.getExtensionName(), engineExtension);
                            }
                        }
                        catch (CoreException ex) {
                            logger.log(Level.WARNING, "can't load the engine extension factory", ex);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }

        synchronized IReportEngineExtension getExtension(String name) {
            if (this.exts.containsKey(name)) {
                return this.exts.get(name);
            }
            return null;
        }

        synchronized void close() {
            for (IReportEngineExtension ext : this.exts.values()) {
                if (ext == null) continue;
                ext.close();
            }
            this.exts.clear();
        }
    }

    static class MyFactory
    extends ContextFactory {
        MyFactory() {
        }

        protected boolean hasFeature(Context cx, int featureIndex) {
            if (featureIndex == 7) {
                return true;
            }
            return super.hasFeature(cx, featureIndex);
        }
    }
}

