/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.report.engine.adapter.ExpressionUtil;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.css.dom.StyleDeclaration;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.ReportItemExecutor;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.HighlightDesign;
import org.eclipse.birt.report.engine.ir.HighlightRuleDesign;
import org.eclipse.birt.report.engine.ir.MapDesign;
import org.eclipse.birt.report.engine.ir.MapRuleDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.StyledElementDesign;

public abstract class StyledItemExecutor
extends ReportItemExecutor {
    private ExpressionUtil expressionUtil = new ExpressionUtil();

    protected StyledItemExecutor(ExecutorManager manager, int type) {
        super(manager, type);
    }

    protected void processStyle(ReportItemDesign design, IContent content) {
        StyleDeclaration inlineStyle;
        HighlightDesign highlight = design.getHighlight();
        if (highlight != null && (inlineStyle = this.createHighlightStyle(design.getHighlight())) != null) {
            content.setInlineStyle(inlineStyle);
        }
    }

    protected void processColumnStyle(ColumnDesign columnDesign, IColumn column) {
        StyleDeclaration inlineStyle;
        HighlightDesign highlight = columnDesign.getHighlight();
        if (highlight != null && (inlineStyle = this.createHighlightStyle(highlight)) != null) {
            column.setInlineStyle(inlineStyle);
        }
    }

    private StyleDeclaration createHighlightStyle(HighlightDesign highlight) {
        StyleDeclaration style = (StyleDeclaration)this.report.createStyle();
        int i = 0;
        while (i < highlight.getRuleCount()) {
            HighlightRuleDesign rule = highlight.getRule(i);
            if (rule != null) {
                Object value = null;
                Object expression = rule.getConditionExpr();
                if (expression != null) {
                    try {
                        if (expression instanceof String) {
                            value = this.evaluate((String)expression);
                        } else if (expression instanceof IConditionalExpression) {
                            value = this.evaluate((IConditionalExpression)expression);
                        }
                    }
                    catch (BirtException ex) {
                        this.context.addException(this.design, ex);
                        value = Boolean.FALSE;
                    }
                } else {
                    IConditionalExpression newExpression = null;
                    newExpression = rule.ifValueIsList() ? this.expressionUtil.createConditionExpression(rule.getTestExpression(), rule.getOperator(), rule.getValue1List()) : this.expressionUtil.createConditionalExpression(rule.getTestExpression(), rule.getOperator(), rule.getValue1(), rule.getValue2());
                    try {
                        value = this.evaluate(newExpression);
                    }
                    catch (BirtException ex) {
                        this.context.addException(this.design, ex);
                        value = Boolean.FALSE;
                    }
                }
                if (value != null && value instanceof Boolean && ((Boolean)value).booleanValue()) {
                    style.setProperties(rule.getStyle());
                }
            }
            ++i;
        }
        return style;
    }

    protected void processMappingValue(StyledElementDesign item, IDataContent dataObj) {
        MapDesign map = item.getMap();
        if (map != null) {
            int i = 0;
            while (i < map.getRuleCount()) {
                MapRuleDesign rule = map.getRule(i);
                if (rule != null) {
                    Object value = null;
                    Object expression = rule.getConditionExpr();
                    if (expression != null) {
                        try {
                            if (expression instanceof String) {
                                value = this.evaluate((String)expression);
                            } else if (expression instanceof IConditionalExpression) {
                                value = this.evaluate((IConditionalExpression)expression);
                            }
                        }
                        catch (BirtException ex) {
                            this.context.addException(item, ex);
                            value = Boolean.FALSE;
                        }
                    } else {
                        IConditionalExpression newExpression = null;
                        newExpression = rule.ifValueIsList() ? this.expressionUtil.createConditionExpression(rule.getTestExpression(), rule.getOperator(), rule.getValue1List()) : this.expressionUtil.createConditionalExpression(rule.getTestExpression(), rule.getOperator(), rule.getValue1(), rule.getValue2());
                        try {
                            value = this.evaluate(newExpression);
                        }
                        catch (BirtException ex) {
                            this.context.addException(item, ex);
                            value = Boolean.FALSE;
                        }
                    }
                    if (value != null && value instanceof Boolean && ((Boolean)value).booleanValue()) {
                        dataObj.setLabelText(rule.getDisplayText());
                        dataObj.setLabelKey(rule.getDisplayKey());
                    }
                }
                ++i;
            }
        }
    }
}

