/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.emitter;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class TableBorder {
    int tableX = 0;
    int tableY = 0;
    int tableLRX = 0;
    int tableLRY = 0;
    HashMap columnBorders = new HashMap();
    HashMap rowBorders = new HashMap();

    TableBorder(int x, int y) {
        this.tableX = x;
        this.tableY = y;
        this.addColumn(x);
        this.addRow(y);
    }

    public void addColumn(int position) {
        if (!this.columnBorders.containsKey(new Integer(position))) {
            this.columnBorders.put(new Integer(position), new Border(position));
        }
        this.tableLRX = Math.max(position, this.tableLRX);
    }

    public void addRow(int position) {
        if (!this.rowBorders.containsKey(new Integer(position))) {
            this.rowBorders.put(new Integer(position), new Border(position));
        }
        this.tableLRY = Math.max(position, this.tableLRY);
    }

    public void setColumnBorder(int position, int start, int end, String style, int width, Color color) {
        this.addBorderSegment((Border)this.columnBorders.get(new Integer(position)), start, end, style, width, color);
    }

    public void setRowBorder(int position, int start, int end, String style, int width, Color color) {
        this.addBorderSegment((Border)this.rowBorders.get(new Integer(position)), start, end, style, width, color);
    }

    protected void addBorderSegment(Border border, int start, int end, String style, int width, Color color) {
        if (style == null || color == null || width == 0 || border == null) {
            return;
        }
        ArrayList segments = border.segments;
        BorderSegment last = null;
        if (!segments.isEmpty()) {
            last = (BorderSegment)segments.get(segments.size() - 1);
            if (last.width == width && last.color.equals(color) && last.style.equals(style)) {
                if (last.end == start) {
                    last.end = end;
                    return;
                }
                if (last.start == end) {
                    last.start = start;
                    return;
                }
            }
        }
        segments.add(new BorderSegment(start, end, style, width, color));
        if (border.width < width) {
            border.width = width;
        }
    }

    public void findBreakPoints() {
        Iterator i = this.rowBorders.keySet().iterator();
        while (i.hasNext()) {
            this.findBreakPoints((Border)this.rowBorders.get(i.next()));
        }
        i = this.columnBorders.keySet().iterator();
        while (i.hasNext()) {
            this.findBreakPoints((Border)this.columnBorders.get(i.next()));
        }
    }

    private void findBreakPoints(Border border) {
        int segCount = border.segments.size();
        BorderSegment last = null;
        int j = 0;
        while (j < segCount) {
            BorderSegment current = (BorderSegment)border.segments.get(j);
            if (last == null) {
                border.breakPoints.add(new Integer(current.start));
            } else if (current.start != last.end) {
                border.breakPoints.add(new Integer(last.end));
                border.breakPoints.add(new Integer(current.start));
            }
            last = current;
            ++j;
        }
        if (last != null) {
            border.breakPoints.add(new Integer(last.end));
        }
    }

    class Border {
        int position;
        int width;
        ArrayList breakPoints = new ArrayList();
        ArrayList segments = new ArrayList();

        Border(int position) {
            this.position = position;
        }
    }

    class BorderSegment {
        int start;
        int end;
        String style;
        int width;
        Color color;

        BorderSegment(int start, int end, String style, int width, Color color) {
            this.start = start;
            this.end = end;
            this.style = style;
            this.width = width;
            this.color = color;
        }
    }
}

