/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html.buffer;

import java.util.LinkedList;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutContext;
import org.eclipse.birt.report.engine.layout.html.buffer.CachedHTMLPageBuffer;
import org.eclipse.birt.report.engine.layout.html.buffer.HTMLPageBuffer;
import org.eclipse.birt.report.engine.layout.html.buffer.IPageBuffer;

public class PageBufferFactory {
    protected HTMLLayoutContext context;
    protected LinkedList<IPageBuffer> pages = new LinkedList();

    public PageBufferFactory(HTMLLayoutContext context) {
        this.context = context;
    }

    public IPageBuffer createBuffer() {
        HTMLPageBuffer buffer = null;
        buffer = this.pages.isEmpty() ? new HTMLPageBuffer(this.context) : new CachedHTMLPageBuffer(this.context, true);
        this.pages.addLast(buffer);
        return buffer;
    }

    public void refresh() {
        while (!this.pages.isEmpty()) {
            IPageBuffer buffer = this.pages.getFirst();
            if (!buffer.finished()) break;
            buffer.flush();
            this.pages.removeFirst();
        }
    }

    public void close() {
        while (!this.pages.isEmpty()) {
            IPageBuffer buffer = this.pages.getFirst();
            buffer.flush();
            this.pages.removeFirst();
        }
    }
}

