/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal.instance;

import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.script.IRowData;
import org.eclipse.birt.report.engine.api.script.ScriptException;
import org.eclipse.birt.report.engine.api.script.instance.IReportElementInstance;
import org.eclipse.birt.report.engine.api.script.instance.IScriptStyle;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ElementUtil;
import org.eclipse.birt.report.engine.script.internal.RowData;
import org.eclipse.birt.report.engine.script.internal.instance.StyleInstance;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.UserPropertyDefnHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public class ReportElementInstance
implements IReportElementInstance {
    protected IContent content;
    private ExecutionContext context;
    private RowData rowData;

    public ReportElementInstance(IContent content, ExecutionContext context) {
        this.content = content;
        this.context = context;
    }

    protected ReportElementInstance(ExecutionContext context) {
        this.context = context;
    }

    public IScriptStyle getStyle() {
        return new StyleInstance(this.content.getStyle());
    }

    public Object getNamedExpressionValue(String name) {
        Object generatedBy = this.content.getGenerateBy();
        if (generatedBy instanceof ReportElementDesign) {
            ReportElementDesign design = (ReportElementDesign)generatedBy;
            Map m = design.getNamedExpressions();
            String expr = (String)m.get(name);
            if (expr == null) {
                return null;
            }
            this.context.newScope(this);
            try {
                Object object = this.context.evaluate(expr);
                return object;
            }
            catch (BirtException ex) {
                this.context.addException(ex);
            }
            finally {
                this.context.exitScope();
            }
        }
        return null;
    }

    public Object getUserPropertyValue(String name) {
        ReportElementDesign design;
        DesignElementHandle handle;
        UserPropertyDefnHandle prop;
        Object generatedBy = this.content.getGenerateBy();
        if (generatedBy instanceof ReportElementDesign && (prop = (handle = (design = (ReportElementDesign)generatedBy).getHandle()).getUserPropertyDefnHandle(name)) != null) {
            return handle.getProperty(prop.getName());
        }
        return null;
    }

    public void setUserPropertyValue(String name, Object value) throws ScriptException {
        ReportElementDesign design;
        DesignElementHandle handle;
        UserPropertyDefnHandle prop;
        Object generatedBy = this.content.getGenerateBy();
        if (generatedBy instanceof ReportElementDesign && (prop = (handle = (design = (ReportElementDesign)generatedBy).getHandle()).getUserPropertyDefnHandle(name)) != null) {
            try {
                handle.setProperty(prop.getName(), value);
            }
            catch (SemanticException e) {
                throw new ScriptException(e.getLocalizedMessage());
            }
        }
    }

    public IReportElementInstance getParent() {
        return ElementUtil.getInstance(this.content.getParent(), this.context);
    }

    public String getHorizontalPosition() {
        DimensionType x = this.content.getX();
        if (x != null) {
            return x.toString();
        }
        return null;
    }

    public void setHorizontalPosition(String position) {
        this.content.setX(DimensionType.parserUnit(position));
    }

    public String getVerticalPosition() {
        DimensionType y = this.content.getY();
        if (y != null) {
            return y.toString();
        }
        return null;
    }

    public void setVerticalPosition(String position) {
        this.content.setY(DimensionType.parserUnit(position));
    }

    public String getWidth() {
        DimensionType width = this.content.getWidth();
        if (width != null) {
            return width.toString();
        }
        return null;
    }

    public void setWidth(String width) {
        this.content.setWidth(DimensionType.parserUnit(width));
    }

    public String getHeight() {
        DimensionType height = this.content.getHeight();
        if (height != null) {
            return height.toString();
        }
        return null;
    }

    public void setHeight(String height) {
        this.content.setHeight(DimensionType.parserUnit(height));
    }

    public IRowData getRowData() {
        DesignElementHandle handle;
        ReportItemDesign design;
        if (this.rowData != null) {
            return this.rowData;
        }
        Object objGen = this.content.getGenerateBy();
        if (objGen instanceof ReportItemDesign && (design = (ReportItemDesign)objGen).getQuery() != null && (handle = design.getHandle()) instanceof ReportItemHandle) {
            IBaseResultSet rset = this.context.getResultSet();
            this.rowData = new RowData(rset, (ReportItemHandle)handle);
            return this.rowData;
        }
        IReportElementInstance parent = this.getParent();
        if (parent != null) {
            return parent.getRowData();
        }
        return null;
    }
}

