/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQueryAction;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.editor.CMImageUtil;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.eclipse.wst.xml.ui.internal.taginfo.MarkupTagInfoProvider;
import org.eclipse.wst.xml.xpath.core.util.XSLTXPathHelper;
import org.eclipse.wst.xsl.ui.internal.contentassist.AbstractXSLContentAssistRequest;
import org.eclipse.wst.xsl.ui.internal.contentassist.contentmodel.XSLContentModelGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementContentAssistRequest
extends AbstractXSLContentAssistRequest {
    private XSLContentModelGenerator contentModel = new XSLContentModelGenerator();
    private static final String XPATH_FIRST_XSLANCESTOR_NODE = "ancestor::xsl:*[1]";
    private MarkupTagInfoProvider infoProvider = null;

    public ElementContentAssistRequest(Node node, IStructuredDocumentRegion documentRegion, ITextRegion completionRegion, int begin, int length, String filter, ITextViewer textViewer) {
        super(node, documentRegion, completionRegion, begin, length, filter, textViewer);
    }

    @Override
    public ICompletionProposal[] getCompletionProposals() {
        if (this.region.getType() == "XML_TAG_OPEN") {
            this.computeTagOpenProposals();
        } else if (this.region.getType() == "XML_TAG_NAME") {
            this.computeTagNameProposals();
        }
        return this.getAllCompletionProposals();
    }

    protected void computeTagOpenProposals() {
        if (this.replacementBeginPosition == this.documentRegion.getStartOffset(this.region)) {
            if (this.node.getNodeType() == 1) {
                this.computeTagNameProposals();
            }
        } else {
            ITextRegion name = this.getNameRegion(((IDOMNode)this.node).getStartStructuredDocumentRegion());
            if (name != null && this.documentRegion.getStartOffset(name) <= this.replacementBeginPosition && this.documentRegion.getEndOffset(name) >= this.replacementBeginPosition) {
                this.replacementBeginPosition = this.documentRegion.getStartOffset(name);
                this.replacementLength = name.getTextLength();
            } else {
                this.setReplacementLength(0);
            }
            this.addTagNameProposals(this.getElementPosition(this.node));
        }
    }

    protected void computeTagNameProposals() {
        if (this.inAttributeRegion()) {
            return;
        }
        IDOMNode cfr_ignored_0 = (IDOMNode)this.node;
        this.addTagNameProposals(this.getElementPosition(this.node));
    }

    protected boolean inAttributeRegion() {
        return this.replacementBeginPosition > this.documentRegion.getStartOffset(this.region) + this.region.getLength();
    }

    /*
     * Unable to fully structure code
     */
    protected void addTagNameProposals(int position) {
        block8: {
            ancestorNode = null;
            try {
                ancestorNode = XSLTXPathHelper.selectSingleNode((Node)this.getNode(), (String)"ancestor::xsl:*[1]");
            }
            catch (Exception v0) {
                return;
            }
            cmnodes = null;
            if (ancestorNode.getNodeType() != 1) break block8;
            cmnodes = this.getAvailableChildElementDeclarations((Element)ancestorNode, 0);
            nodeIterator = cmnodes.iterator();
            while (this.matchString.length() > 0 && (Character.isWhitespace(this.matchString.charAt(0)) || this.beginsWith(this.matchString, "<"))) {
                this.matchString = this.matchString.substring(1);
            }
            if (nodeIterator.hasNext()) ** GOTO lbl38
            return;
lbl-1000:
            // 1 sources

            {
                elementDecl = nodeIterator.next();
                if (elementDecl == null) continue;
                proposedText = null;
                proposedText = this.contentModel.getRequiredName(ancestorNode, elementDecl);
                cursorAdjustment = proposedText.length();
                if (elementDecl instanceof CMElementDeclaration) {
                    ed = (CMElementDeclaration)elementDecl;
                    if (ed.getContentType() == 1) {
                        proposedText = String.valueOf(proposedText) + this.contentModel.getStartTagClose(ancestorNode, ed);
                        cursorAdjustment = proposedText.length();
                    } else {
                        sb = new StringBuffer();
                        this.contentModel.generateTag(ancestorNode, ed, sb);
                        proposedText = sb.toString().substring(1);
                        cursorAdjustment = this.getCursorPositionForProposedText(proposedText);
                    }
                }
                if (!this.beginsWith(proposedText, this.matchString)) continue;
                image = CMImageUtil.getImage((CMNode)elementDecl);
                if (image == null) {
                    image = XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/tag-generic.gif");
                }
                proposedInfo = this.getAdditionalInfo((CMNode)this.getCMElementDeclaration(this.getParent()), elementDecl);
                proposal = new CustomCompletionProposal(proposedText, this.getReplacementBeginPosition(), this.getReplacementLength(), cursorAdjustment, image, this.contentModel.getRequiredName(this.getParent(), elementDecl), null, proposedInfo, 1200);
                this.addProposal((ICompletionProposal)proposal);
lbl38:
                // 4 sources

                ** while (nodeIterator.hasNext())
            }
        }
    }

    protected List<CMNode> getAvailableChildElementDeclarations(Element parent, int childPosition) {
        List modelQueryActions = this.getAvailableChildrenAtIndex(parent, childPosition, 0);
        Iterator iterator = modelQueryActions.iterator();
        Vector<CMNode> cmnodes = new Vector<CMNode>();
        while (iterator.hasNext()) {
            CMNode actionCMNode;
            ModelQueryAction action = (ModelQueryAction)iterator.next();
            if (childPosition >= 0 && (action.getStartIndex() > childPosition || childPosition > action.getEndIndex()) || (actionCMNode = action.getCMNode()) == null || cmnodes.contains(actionCMNode)) continue;
            cmnodes.add(actionCMNode);
        }
        return cmnodes;
    }

    protected List getAvailableChildrenAtIndex(Element parent, int index, int validityChecking) {
        ArrayList list = new ArrayList();
        CMElementDeclaration parentDecl = this.getCMElementDeclaration(parent);
        if (parentDecl != null) {
            ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)parent.getOwnerDocument());
            int editMode = 0;
            int ic = editMode == 2 ? 6 : 2;
            modelQuery.getInsertActions(parent, parentDecl, index, ic, validityChecking, list);
        }
        return list;
    }

    protected CMElementDeclaration getCMElementDeclaration(Node node) {
        ModelQuery modelQuery;
        CMElementDeclaration result = null;
        if (node.getNodeType() == 1 && (modelQuery = ModelQueryUtil.getModelQuery((Document)node.getOwnerDocument())) != null) {
            result = modelQuery.getCMElementDeclaration((Element)node);
        }
        return result;
    }

    protected int getElementPosition(Node child) {
        Node parent = child.getParentNode();
        if (parent == null) {
            return 0;
        }
        NodeList children = parent.getChildNodes();
        if (children == null) {
            return 0;
        }
        int count = 0;
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i) == child) {
                return count;
            }
            ++count;
            ++i;
        }
        return 0;
    }

    protected String getAdditionalInfo(CMNode parentOrOwner, CMNode cmnode) {
        String addlInfo = null;
        if (cmnode == null) {
            return null;
        }
        addlInfo = this.getInfoProvider().getInfo(cmnode);
        if (addlInfo == null && parentOrOwner != null) {
            addlInfo = this.getInfoProvider().getInfo(parentOrOwner);
        }
        return addlInfo;
    }

    public MarkupTagInfoProvider getInfoProvider() {
        if (this.infoProvider == null) {
            this.infoProvider = new MarkupTagInfoProvider();
        }
        return this.infoProvider;
    }

    protected boolean beginsWith(String aString, String prefix) {
        if (aString == null || prefix == null) {
            return true;
        }
        return aString.toLowerCase().startsWith(prefix.toLowerCase());
    }

    private int getCursorPositionForProposedText(String proposedText) {
        int cursorAdjustment = proposedText.indexOf("\"\"") + 1;
        if (cursorAdjustment == 0) {
            cursorAdjustment = proposedText.indexOf(62) + 1;
        }
        if (cursorAdjustment == 0) {
            cursorAdjustment = proposedText.length() + 1;
        }
        return cursorAdjustment;
    }

    protected ITextRegion getNameRegion(IStructuredDocumentRegion flatNode) {
        if (flatNode == null) {
            return null;
        }
        for (ITextRegion region : flatNode.getRegions()) {
            if (!this.isNameRegion(region)) continue;
            return region;
        }
        return null;
    }

    protected boolean isNameRegion(ITextRegion region) {
        String type = region.getType();
        return type == "XML_TAG_NAME" || type == "XML_ELEMENT_DECL_NAME" || type == "XML_DOCTYPE_NAME" || type == "XML_ATTLIST_DECL_NAME";
    }
}

