/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.contentassist;

import java.util.Collection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xsl.ui.internal.contentassist.AbstractXSLContentAssistRequest;
import org.eclipse.wst.xsl.ui.internal.contentassist.Messages;
import org.eclipse.wst.xsl.ui.internal.util.XSLPluginImageHelper;
import org.w3c.dom.Node;

public class ExcludeResultPrefixesContentAssist
extends AbstractXSLContentAssistRequest {
    private static final String EXCLUDE_RESULT_PREFIXES = "exclude-result-prefixes";
    private static final String DEFAULT = "#all";
    private static final String ADDITIONAL_INFO = Messages.getString("ExcludeResultPrefixesContentAssist.2");
    protected String[] tokens = null;

    public ExcludeResultPrefixesContentAssist(Node node, IStructuredDocumentRegion documentRegion, ITextRegion completionRegion, int begin, int length, String filter, ITextViewer textViewer) {
        super(node, documentRegion, completionRegion, begin, length, filter, textViewer);
    }

    public ICompletionProposal[] getCompletionProposals() {
        this.proposals.clear();
        IDOMAttr attrNode = (IDOMAttr)((IDOMElement)this.getNode()).getAttributeNode(EXCLUDE_RESULT_PREFIXES);
        String excludeResultPrefixes = attrNode.getValue();
        int offset = this.getCursorPosition();
        if (excludeResultPrefixes == null || excludeResultPrefixes.equals(DEFAULT)) {
            return this.getAllCompletionProposals();
        }
        this.tokens = excludeResultPrefixes.split("\\s");
        if (this.tokens[0].equals("")) {
            CustomCompletionProposal proposal = new CustomCompletionProposal(DEFAULT, offset, 0, DEFAULT.length(), XSLPluginImageHelper.getInstance().getImage("icons/full/package_obj.gif"), DEFAULT, null, null, 0);
            this.addProposal((ICompletionProposal)proposal);
        }
        Collection<NamespaceInfo> namespaces = this.getNamespaces((IDOMElement)this.node);
        for (NamespaceInfo namespace : namespaces) {
            if (!this.includePrefix(namespace)) continue;
            CustomCompletionProposal proposal = new CustomCompletionProposal(namespace.prefix, offset, 0, namespace.prefix.length(), XSLPluginImageHelper.getInstance().getImage("icons/full/package_obj.gif"), namespace.prefix, null, namespace.uri, 0);
            this.addProposal((ICompletionProposal)proposal);
        }
        return this.getAllCompletionProposals();
    }

    protected boolean includePrefix(NamespaceInfo namespace) {
        return !this.prefixExists(namespace.prefix) && !namespace.prefix.equals("") && !namespace.uri.equals("http://www.w3.org/1999/XSL/Transform");
    }

    protected boolean prefixExists(String prefix) {
        if (this.tokens == null || this.tokens.length == 0) {
            return false;
        }
        int cnt = 0;
        while (cnt < this.tokens.length) {
            if (prefix.equals(this.tokens[cnt])) {
                return true;
            }
            ++cnt;
        }
        return false;
    }
}

