/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.xpath.core.internal.parser.XPathParser;
import org.eclipse.wst.xml.xpath.core.util.XSLTXPathHelper;
import org.eclipse.wst.xml.xpath.ui.internal.contentassist.XPathTemplateCompletionProcessor;
import org.eclipse.wst.xml.xpath.ui.internal.templates.TemplateContextTypeIdsXPath;
import org.eclipse.wst.xsl.ui.internal.XSLUIPlugin;
import org.eclipse.wst.xsl.ui.internal.contentassist.AbstractXSLContentAssistRequest;
import org.eclipse.wst.xsl.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xsl.ui.internal.util.XSLPluginImageHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SelectAttributeContentAssist
extends AbstractXSLContentAssistRequest {
    private static final String XPATH_GLOBAL_VARIABLES = "/xsl:stylesheet/xsl:variable";
    private static final String XPATH_GLOBAL_PARAMS = "/xsl:stylesheet/xsl:param";
    private static final String XPATH_LOCAL_VARIABLES = "ancestor::xsl:template/descendant::xsl:variable";
    private static final String XPATH_LOCAL_PARAMS = "ancestor::xsl:template/descendant::xsl:param";
    private XPathTemplateCompletionProcessor fTemplateProcessor = null;
    private List<String> fTemplateContexts = new ArrayList<String>();
    private static final byte[] XPATH_LOCK = new byte[0];

    public SelectAttributeContentAssist(Node node, IStructuredDocumentRegion documentRegion, ITextRegion completionRegion, int begin, int length, String filter, ITextViewer textViewer) {
        super(node, documentRegion, completionRegion, begin, length, filter, textViewer);
    }

    public ICompletionProposal[] getCompletionProposals() {
        this.proposals.clear();
        this.adjustXPathStart();
        int offset = this.getReplacementBeginPosition();
        IDOMAttr attrNode = (IDOMAttr)((IDOMElement)this.getNode()).getAttributeNode("select");
        this.matchString = this.extractXPathMatchString(attrNode, this.getRegion(), this.getReplacementBeginPosition());
        this.addSelectProposals((Element)this.getNode().getParentNode(), offset);
        return this.getAllCompletionProposals();
    }

    protected void adjustXPathStart() {
        IDOMElement elem = (IDOMElement)this.getNode();
        IDOMAttr xpathNode = (IDOMAttr)elem.getAttributeNode("select");
        if (xpathNode != null) {
            XPathParser parser = new XPathParser(xpathNode.getValue());
            int startOffset = xpathNode.getValueRegionStartOffset() + parser.getTokenStartOffset(1, this.getReplacementBeginPosition() - xpathNode.getValueRegionStartOffset()) - 1;
            this.replacementLength = this.getReplacementBeginPosition() - startOffset;
        }
    }

    protected String extractXPathMatchString(IDOMAttr node, ITextRegion aRegion, int offset) {
        if (node == null || node.getValue().length() == 0) {
            return "";
        }
        if (this.matchString.length() == 1) {
            return this.matchString;
        }
        int column = offset - node.getValueRegionStartOffset() - 1;
        String nodeValue = node.getValue();
        XPathParser parser = new XPathParser(nodeValue);
        int tokenStart = parser.getTokenStartOffset(1, column);
        if (tokenStart >= column) {
            return "";
        }
        return node.getValue().substring(tokenStart - 1, column);
    }

    protected void addSelectProposals(Element rootElement, int offset) {
        this.addGlobalProposals(rootElement, offset);
        this.addLocalProposals(this.getNode(), offset);
        this.addTemplates(TemplateContextTypeIdsXPath.AXIS, offset);
        this.addTemplates(TemplateContextTypeIdsXPath.XPATH, offset);
        this.addTemplates(TemplateContextTypeIdsXPath.CUSTOM, offset);
        this.addTemplates(TemplateContextTypeIdsXPath.OPERATOR, offset);
    }

    protected void addTemplates(String context, int startOffset) {
        if (!this.fTemplateContexts.contains(context)) {
            this.fTemplateContexts.add(context);
            if (this.getTemplateCompletionProcessor() != null) {
                this.getTemplateCompletionProcessor().setContextType(context);
                ICompletionProposal[] proposals = this.getTemplateCompletionProcessor().computeCompletionProposals(this.textViewer, startOffset);
                int i = 0;
                while (i < proposals.length) {
                    ICompletionProposal proposal = proposals[i];
                    if (this.matchString.length() > 0) {
                        if (proposal.getDisplayString().startsWith(this.matchString)) {
                            this.addProposal(proposals[i]);
                        }
                    } else {
                        this.addProposal(proposals[i]);
                    }
                    ++i;
                }
            }
        }
    }

    private void addLocalProposals(Node xpathnode, int offset) {
        this.addVariablesProposals(XPATH_LOCAL_VARIABLES, xpathnode, offset);
        this.addVariablesProposals(XPATH_LOCAL_PARAMS, xpathnode, offset);
    }

    private void addGlobalProposals(Node xpathnode, int offset) {
        this.addVariablesProposals(XPATH_GLOBAL_VARIABLES, xpathnode, offset);
        this.addVariablesProposals(XPATH_GLOBAL_PARAMS, xpathnode, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addVariablesProposals(String xpath, Node xpathnode, int offset) {
        byte[] byArray = XPATH_LOCK;
        synchronized (XPATH_LOCK) {
            try {
                NodeList nodes = XSLTXPathHelper.selectNodeList((Node)xpathnode, (String)xpath);
                int startLength = this.getCursorPosition() - offset;
                if (this.hasNodes(nodes)) {
                    int nodecnt = 0;
                    while (nodecnt < nodes.getLength()) {
                        Node node = nodes.item(nodecnt);
                        String variableName = "$" + node.getAttributes().getNamedItem("name").getNodeValue();
                        CustomCompletionProposal proposal = new CustomCompletionProposal(variableName, offset, 0, startLength + variableName.length(), XSLPluginImageHelper.getInstance().getImage("icons/full/variable.gif"), variableName, null, null, 0);
                        if (this.matchString.length() > 0) {
                            if (proposal.getDisplayString().startsWith(this.matchString)) {
                                this.addProposal((ICompletionProposal)proposal);
                            }
                        } else {
                            this.addProposal((ICompletionProposal)proposal);
                        }
                        ++nodecnt;
                    }
                }
            }
            catch (TransformerException ex) {
                XSLUIPlugin.log(ex);
            }
            return;
        }
    }

    private XPathTemplateCompletionProcessor getTemplateCompletionProcessor() {
        if (this.fTemplateProcessor == null) {
            this.fTemplateProcessor = new XPathTemplateCompletionProcessor();
        }
        return this.fTemplateProcessor;
    }
}

