/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.contentassist;

import java.util.ArrayList;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.IReleasable;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentAssistProcessor;
import org.eclipse.wst.xsl.core.XSLCore;
import org.eclipse.wst.xsl.ui.internal.contentassist.AbstractXSLContentAssistRequest;
import org.eclipse.wst.xsl.ui.internal.contentassist.ElementContentAssistRequest;
import org.eclipse.wst.xsl.ui.internal.contentassist.Messages;
import org.eclipse.wst.xsl.ui.internal.contentassist.XSLContentAssistRequestFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLContentAssistProcessor
implements IContentAssistProcessor,
IReleasable {
    private String errorMessage = "";
    private ITextViewer textViewer = null;

    public ICompletionProposal[] computeCompletionProposals(ITextViewer textViewer, int documentPosition) {
        this.setErrorMessage(null);
        ICompletionProposal[] additionalProposals = null;
        this.textViewer = textViewer;
        IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)textViewer, (int)documentPosition);
        Node node = this.getActualDOMNode((Node)treeNode);
        IDOMNode xmlNode = (IDOMNode)node;
        IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(documentPosition);
        ITextRegion completionRegion = this.getCompletionRegion(documentPosition, node);
        ICompletionProposal[] xmlProposals = this.getXMLProposals(textViewer, documentPosition);
        String matchString = this.getXPathMatchString(sdRegion, completionRegion, documentPosition);
        additionalProposals = this.getAdditionalXSLElementProposals(textViewer, documentPosition, additionalProposals, xmlNode, sdRegion, completionRegion, matchString);
        ICompletionProposal[] xslNamespaceProposals = this.getXSLNamespaceProposals(textViewer, documentPosition, xmlNode, sdRegion, completionRegion, matchString);
        ArrayList<ICompletionProposal> proposalList = new ArrayList<ICompletionProposal>();
        this.addProposals(xmlProposals, proposalList);
        this.addProposals(additionalProposals, proposalList);
        this.addProposals(xslNamespaceProposals, proposalList);
        ICompletionProposal[] combinedProposals = this.combineProposals(proposalList);
        if (combinedProposals == null || combinedProposals.length == 0) {
            this.setErrorMessage(Messages.getString("NoContentAssistance"));
        }
        return combinedProposals;
    }

    private ICompletionProposal[] getXSLNamespaceProposals(ITextViewer textViewer, int documentPosition, IDOMNode xmlNode, IStructuredDocumentRegion sdRegion, ITextRegion completionRegion, String matchString) {
        ICompletionProposal[] xslProposals = null;
        if (XSLCore.isXSLNamespace((IDOMNode)xmlNode)) {
            xslProposals = this.getXSLProposals(textViewer, documentPosition, xmlNode, sdRegion, completionRegion, matchString);
        }
        return xslProposals;
    }

    private ICompletionProposal[] getAdditionalXSLElementProposals(ITextViewer textViewer, int documentPosition, ICompletionProposal[] additionalProposals, IDOMNode xmlNode, IStructuredDocumentRegion sdRegion, ITextRegion completionRegion, String matchString) {
        if (!XSLCore.isXSLNamespace((IDOMNode)xmlNode)) {
            additionalProposals = new ElementContentAssistRequest((Node)xmlNode, sdRegion, completionRegion, documentPosition, 0, matchString, textViewer).getCompletionProposals();
        }
        return additionalProposals;
    }

    private Node getActualDOMNode(Node node) {
        while (node != null && node.getNodeType() == 3 && node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    private ICompletionProposal[] getXMLProposals(ITextViewer textViewer, int documentPosition) {
        XMLContentAssistProcessor processor = new XMLContentAssistProcessor();
        ICompletionProposal[] proposals = processor.computeCompletionProposals(textViewer, documentPosition);
        return proposals;
    }

    private ICompletionProposal[] combineProposals(ArrayList<ICompletionProposal> proposalList) {
        ICompletionProposal[] combinedProposals = new ICompletionProposal[proposalList.size()];
        proposalList.toArray(combinedProposals);
        return combinedProposals;
    }

    private void addProposals(ICompletionProposal[] proposals, ArrayList<ICompletionProposal> proposalList) {
        if (proposals != null) {
            int cnt = 0;
            while (cnt < proposals.length) {
                proposalList.add(proposals[cnt]);
                ++cnt;
            }
        }
    }

    protected ICompletionProposal[] getXSLProposals(ITextViewer textViewer, int documentPosition, IDOMNode xmlNode, IStructuredDocumentRegion sdRegion, ITextRegion completionRegion, String matchString) {
        XSLContentAssistRequestFactory requestFactory = new XSLContentAssistRequestFactory();
        ICompletionProposal[] xslProposals = null;
        AbstractXSLContentAssistRequest contentAssistRequest = requestFactory.getContentAssistRequest(textViewer, documentPosition, xmlNode, sdRegion, completionRegion, matchString);
        xslProposals = contentAssistRequest.getCompletionProposals();
        return xslProposals;
    }

    public IStructuredDocumentRegion getStructuredDocumentRegion(int pos) {
        return ContentAssistUtils.getStructuredDocumentRegion((ITextViewer)this.textViewer, (int)pos);
    }

    protected ITextRegion getCompletionRegion(int documentPosition, Node domnode) {
        if (domnode == null) {
            return null;
        }
        ITextRegion region = null;
        int offset = documentPosition;
        IStructuredDocumentRegion flatNode = null;
        IDOMNode node = (IDOMNode)domnode;
        if (node.getNodeType() == 9) {
            if (node.getStructuredDocument().getLength() == 0) {
                return null;
            }
            ITextRegion result = node.getStructuredDocument().getRegionAtCharacterOffset(offset).getRegionAtCharacterOffset(offset);
            while (result == null) {
                result = node.getStructuredDocument().getRegionAtCharacterOffset(--offset).getRegionAtCharacterOffset(offset);
            }
            return result;
        }
        IStructuredDocumentRegion startTag = node.getStartStructuredDocumentRegion();
        IStructuredDocumentRegion endTag = node.getEndStructuredDocumentRegion();
        if (startTag != null && startTag.getStartOffset() <= offset && offset < startTag.getStartOffset() + startTag.getLength()) {
            flatNode = startTag;
        } else if (endTag != null && endTag.getStartOffset() <= offset && offset < endTag.getStartOffset() + endTag.getLength()) {
            flatNode = endTag;
        }
        region = flatNode != null ? this.getCompletionRegion(offset, flatNode) : ((flatNode = node.getStructuredDocument().getRegionAtCharacterOffset(offset)).getStartOffset() <= documentPosition && flatNode.getEndOffset() >= documentPosition ? (offset == flatNode.getStartOffset() && flatNode.getPrevious() != null && (flatNode.getRegionAtCharacterOffset(documentPosition) != null && flatNode.getRegionAtCharacterOffset(documentPosition).getType() != "XML_CONTENT" || flatNode.getPrevious().getLastRegion().getType() == "XML_TAG_OPEN" || flatNode.getPrevious().getLastRegion().getType() == "XML_END_TAG_OPEN") ? flatNode.getPrevious().getLastRegion() : (flatNode.getEndOffset() == documentPosition ? flatNode.getLastRegion() : flatNode.getFirstRegion())) : flatNode.getLastRegion());
        return region;
    }

    protected ITextRegion getCompletionRegion(int offset, IStructuredDocumentRegion sdRegion) {
        ITextRegion nextRegion;
        ITextRegion previousRegion;
        ITextRegion region = sdRegion.getRegionAtCharacterOffset(offset);
        if (region == null) {
            return null;
        }
        if (sdRegion.getStartOffset(region) == offset) {
            if (sdRegion.getStartOffset(region) == sdRegion.getStartOffset() && sdRegion.getPrevious() != null && !sdRegion.getPrevious().isEnded()) {
                region = sdRegion.getPrevious().getRegionAtCharacterOffset(offset - 1);
            } else {
                previousRegion = sdRegion.getRegionAtCharacterOffset(offset - 1);
                if (previousRegion != null && previousRegion != region && previousRegion.getTextLength() == previousRegion.getLength()) {
                    region = previousRegion;
                }
            }
        } else if (offset > sdRegion.getStartOffset(region) + region.getTextLength() && (nextRegion = sdRegion.getRegionAtCharacterOffset(sdRegion.getStartOffset(region) + region.getLength())) != null) {
            region = nextRegion;
        }
        if (region != null && region.getType() == "WHITE_SPACE" && (previousRegion = sdRegion.getRegionAtCharacterOffset(sdRegion.getStartOffset(region) - 1)) != null) {
            region = previousRegion;
        }
        return region;
    }

    protected String getXPathMatchString(IStructuredDocumentRegion parent, ITextRegion aRegion, int offset) {
        if (aRegion == null || this.isCloseRegion(aRegion)) {
            return "";
        }
        String matchString = null;
        String regionType = aRegion.getType();
        matchString = regionType == "XML_TAG_ATTRIBUTE_EQUALS" || regionType == "XML_TAG_OPEN" || offset > parent.getStartOffset(aRegion) + aRegion.getTextLength() ? "" : (regionType == "XML_CONTENT" ? "" : (parent.getText(aRegion).length() > 0 && parent.getStartOffset(aRegion) < offset ? parent.getText(aRegion).substring(0, offset - parent.getStartOffset(aRegion)) : ""));
        if (matchString.startsWith("\"")) {
            matchString = matchString.substring(1);
        }
        return matchString;
    }

    protected boolean isCloseRegion(ITextRegion region) {
        String type = region.getType();
        return type == "XML_PI_CLOSE" || type == "XML_TAG_CLOSE" || type == "XML_EMPTY_TAG_CLOSE" || type == "XML_CDATA_CLOSE" || type == "XML_COMMENT_CLOSE" || type == "XML_ATTLIST_DECL_CLOSE" || type == "XML_ELEMENT_DECL_CLOSE" || type == "XML_DOCTYPE_DECLARATION_CLOSE" || type == "XML_DECLARATION_CLOSE";
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        char[] completionProposals = new char[]{'\"', '\'', ':', '[', '{', '<'};
        return completionProposals;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void release() {
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    protected boolean hasAttributeAtTextRegion(String attrName, NamedNodeMap nodeMap, ITextRegion aRegion) {
        IDOMAttr attrNode = (IDOMAttr)nodeMap.getNamedItem(attrName);
        return attrNode != null && attrNode.getValueRegion().getStart() == aRegion.getStart();
    }

    protected IDOMAttr getAttributeAtTextRegion(String attrName, NamedNodeMap nodeMap, ITextRegion aRegion) {
        IDOMAttr node = (IDOMAttr)nodeMap.getNamedItem(attrName);
        if (node != null && node.getValueRegion().getStart() == aRegion.getStart()) {
            return node;
        }
        return null;
    }
}

