/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.editor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.wst.xsl.core.XSLCore;
import org.eclipse.wst.xsl.core.model.StylesheetModel;
import org.eclipse.wst.xsl.core.model.Template;

public class OverrideIndicatorManager {
    static final String ANNOTATION_TYPE = "org.eclipse.wst.xsl.ui.override";
    private IAnnotationModel fAnnotationModel;
    private Object fAnnotationModelLockObject;
    private Annotation[] fOverrideAnnotations;
    private IFile file;

    public OverrideIndicatorManager(IAnnotationModel annotationModel, IFile file) {
        Assert.isNotNull((Object)annotationModel);
        this.file = file;
        this.fAnnotationModel = annotationModel;
        this.fAnnotationModelLockObject = this.getLockObject(this.fAnnotationModel);
        this.updateAnnotations();
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAnnotations() {
        StylesheetModel stylesheetComposed = XSLCore.getInstance().getStylesheet(this.file);
        HashMap<OverrideIndicator, Position> annotationMap = new HashMap<OverrideIndicator, Position>(50);
        List nestedTemplates = stylesheetComposed.findAllNestedTemplates();
        for (Template template : stylesheetComposed.getStylesheet().getTemplates()) {
            for (Template nestedTemplate : nestedTemplates) {
                String text;
                IFile nestedFile = nestedTemplate.getStylesheet().getFile();
                if (nestedFile == null || !template.matchesByMatchOrName(nestedTemplate)) continue;
                if (template.getName() != null) {
                    text = "overrides " + template.getName() + " in " + nestedFile.getName();
                    annotationMap.put(new OverrideIndicator(text, "binding.getKey()"), new Position(template.getOffset(), template.getLength()));
                    continue;
                }
                text = "overrides \"" + template.getMatch() + "\"";
                String mode = template.getMode();
                if (mode != null) {
                    text = String.valueOf(text) + " (" + mode + ")";
                }
                text = String.valueOf(text) + " in " + nestedFile.getName();
                annotationMap.put(new OverrideIndicator(text, "binding.getKey()"), new Position(template.getOffset(), template.getLength()));
            }
        }
        Object object = this.fAnnotationModelLockObject;
        synchronized (object) {
            if (this.fAnnotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)this.fAnnotationModel).replaceAnnotations(this.fOverrideAnnotations, annotationMap);
            } else {
                this.removeAnnotations();
                for (Map.Entry mapEntry : annotationMap.entrySet()) {
                    this.fAnnotationModel.addAnnotation((Annotation)mapEntry.getKey(), (Position)mapEntry.getValue());
                }
            }
            this.fOverrideAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAnnotations() {
        if (this.fOverrideAnnotations == null) {
            return;
        }
        Object object = this.fAnnotationModelLockObject;
        synchronized (object) {
            if (this.fAnnotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)this.fAnnotationModel).replaceAnnotations(this.fOverrideAnnotations, null);
            } else {
                int i = 0;
                int length = this.fOverrideAnnotations.length;
                while (i < length) {
                    this.fAnnotationModel.removeAnnotation(this.fOverrideAnnotations[i]);
                    ++i;
                }
            }
            this.fOverrideAnnotations = null;
        }
    }

    class OverrideIndicator
    extends Annotation {
        private String fAstNodeKey;

        OverrideIndicator(String text, String key) {
            super(OverrideIndicatorManager.ANNOTATION_TYPE, false, text);
            this.fAstNodeKey = key;
        }

        public void open() {
        }
    }
}

