/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xsl.core.model.XSLNode;
import org.eclipse.wst.xsl.ui.internal.XSLUIPlugin;

public class SourceFileHyperlink
implements IHyperlink {
    private IRegion hyperLinkRegion;
    private IFile linkedFile;
    private XSLNode sourceArtifact;

    public SourceFileHyperlink(IRegion hyperLinkRegion, IFile linkedFile) {
        this.hyperLinkRegion = hyperLinkRegion;
        this.linkedFile = linkedFile;
    }

    public SourceFileHyperlink(IRegion hyperLinkRegion, IFile linkedFile, XSLNode node) {
        this.hyperLinkRegion = hyperLinkRegion;
        this.linkedFile = linkedFile;
        this.sourceArtifact = node;
    }

    public IRegion getHyperlinkRegion() {
        return this.hyperLinkRegion;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return this.linkedFile.getFullPath().toString();
    }

    public void open() {
        if (this.linkedFile != null && this.linkedFile.exists()) {
            try {
                IDocument openedDocument;
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IFile)this.linkedFile, (boolean)true);
                ITextEditor textEditor = (ITextEditor)editor.getAdapter(ITextEditor.class);
                if (this.sourceArtifact != null && textEditor != null && (openedDocument = (IDocument)editor.getAdapter(IDocument.class)) != null) {
                    int lineOffset = openedDocument.getLineOffset(this.sourceArtifact.getLineNumber());
                    int offset = lineOffset + this.sourceArtifact.getColumnNumber();
                    textEditor.setHighlightRange(offset, this.sourceArtifact.getLength(), true);
                }
            }
            catch (PartInitException pie) {
                XSLUIPlugin.log((CoreException)((Object)pie));
            }
            catch (BadLocationException e) {
                XSLUIPlugin.log((Exception)((Object)e));
            }
        }
    }
}

