/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.editor;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xsl.core.XSLCore;
import org.eclipse.wst.xsl.core.model.StylesheetModel;
import org.eclipse.wst.xsl.core.model.Template;
import org.eclipse.wst.xsl.core.model.XSLNode;
import org.eclipse.wst.xsl.ui.internal.editor.SourceFileHyperlink;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XSLHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IHyperlink[] iHyperlinkArray;
        Object hyperlink = null;
        if (region != null && textViewer != null) {
            return this.detectHyperlinks(textViewer.getDocument(), region, canShowMultipleHyperlinks);
        }
        if (hyperlink == null) {
            iHyperlinkArray = null;
        } else {
            IHyperlink[] iHyperlinkArray2 = new IHyperlink[1];
            iHyperlinkArray = iHyperlinkArray2;
            iHyperlinkArray2[0] = hyperlink;
        }
        return iHyperlinkArray;
    }

    public IHyperlink[] detectHyperlinks(IDocument document, IRegion region, boolean canShowMultipleHyperlinks) {
        IHyperlink[] iHyperlinkArray;
        IHyperlink hyperlink = null;
        if (region != null && document != null) {
            Element el;
            Node currentNode = this.getCurrentNode(document, region.getOffset());
            Element xslEl = null;
            Attr xslAttr = null;
            if (currentNode.getNodeType() == 2) {
                Attr att = (Attr)currentNode;
                if ("http://www.w3.org/1999/XSL/Transform".equals(att.getOwnerElement().getNamespaceURI())) {
                    xslEl = att.getOwnerElement();
                    xslAttr = att;
                }
            } else if (currentNode.getNodeType() == 1 && "http://www.w3.org/1999/XSL/Transform".equals((el = (Element)currentNode).getNamespaceURI())) {
                xslEl = el;
                xslAttr = this.getCurrentAttrNode(el, region.getOffset());
            }
            if (xslEl != null && xslAttr != null) {
                IRegion hyperlinkRegion = this.getHyperlinkRegion(xslAttr);
                IFile file = this.getFileForDocument(document);
                if (file != null) {
                    if ("call-template".equals(xslEl.getLocalName()) && "name".equals(xslAttr.getLocalName())) {
                        hyperlink = this.createCallTemplateHyperLink(file, xslAttr.getValue(), hyperlinkRegion);
                    } else if ("include".equals(xslEl.getLocalName()) || "import".equals(xslEl.getLocalName())) {
                        "href".equals(xslAttr.getLocalName());
                    }
                }
            }
        }
        if (hyperlink == null) {
            iHyperlinkArray = null;
        } else {
            IHyperlink[] iHyperlinkArray2 = new IHyperlink[1];
            iHyperlinkArray = iHyperlinkArray2;
            iHyperlinkArray2[0] = hyperlink;
        }
        return iHyperlinkArray;
    }

    private IHyperlink createCallTemplateHyperLink(IFile currentFile, String templateName, IRegion hyperlinkRegion) {
        List templates;
        SourceFileHyperlink hyperlink = null;
        StylesheetModel sf = XSLCore.getInstance().getStylesheet(currentFile);
        if (sf != null && (templates = sf.getTemplatesByName(templateName)) != null && templates.size() == 1) {
            Template template = (Template)templates.get(0);
            hyperlink = new SourceFileHyperlink(hyperlinkRegion, template.getStylesheet().getFile(), (XSLNode)template);
        }
        return hyperlink;
    }

    private Attr getCurrentAttrNode(Node node, int offset) {
        if (node instanceof IndexedRegion && ((IndexedRegion)node).contains(offset) && node.hasAttributes()) {
            NamedNodeMap attrs = node.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                IndexedRegion attRegion = (IndexedRegion)attrs.item(i);
                if (attRegion.contains(offset)) {
                    return (Attr)attrs.item(i);
                }
                ++i;
            }
        }
        return null;
    }

    private Node getCurrentNode(IDocument document, int offset) {
        IndexedRegion inode = null;
        IStructuredModel sModel = null;
        try {
            sModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            inode = sModel.getIndexedRegion(offset);
            if (inode == null) {
                inode = sModel.getIndexedRegion(offset - 1);
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
        if (inode instanceof Node) {
            return (Node)inode;
        }
        return null;
    }

    private IRegion getHyperlinkRegion(Node node) {
        Region hyperRegion = null;
        if (node != null) {
            short nodeType = node.getNodeType();
            if (nodeType == 10) {
                IDOMNode docNode = (IDOMNode)node;
                hyperRegion = new Region(docNode.getStartOffset(), docNode.getEndOffset() - docNode.getStartOffset());
            } else if (nodeType == 2) {
                IDOMAttr att = (IDOMAttr)node;
                int regOffset = att.getValueRegionStartOffset();
                ITextRegion valueRegion = att.getValueRegion();
                if (valueRegion != null) {
                    int regLength = valueRegion.getTextLength();
                    String attValue = att.getValueRegionText();
                    if (StringUtils.isQuoted((String)attValue)) {
                        ++regOffset;
                        regLength -= 2;
                    }
                    hyperRegion = new Region(regOffset, regLength);
                }
            }
        }
        return hyperRegion;
    }

    private IFile getFileForDocument(IDocument document) {
        IFile file = null;
        IStructuredModel sModel = null;
        try {
            sModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            if (sModel != null) {
                Path path = new Path(sModel.getBaseLocation());
                file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
        return file != null && file.exists() ? file : null;
    }
}

