/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.spelling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcileStep;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IAnnotationModelExtension2;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingContext;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;
import org.eclipse.wst.sse.core.internal.parser.ForeignRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.internal.ExtendedConfigurationBuilder;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.reconcile.ReconcileAnnotationKey;
import org.eclipse.wst.sse.ui.internal.reconcile.StructuredReconcileStep;
import org.eclipse.wst.sse.ui.internal.reconcile.StructuredTextReconcilingStrategy;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import org.eclipse.wst.sse.ui.internal.spelling.SpellingQuickAssistProcessor;

public class SpellcheckStrategy
extends StructuredTextReconcilingStrategy {
    private static final boolean _DEBUG_SPELLING = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/debug/reconcilerSpelling"));
    private static final boolean _DEBUG_SPELLING_PROBLEMS = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/debug/reconcilerSpelling/showProblems"));
    private static final String EXTENDED_BUILDER_TYPE_CONTEXTS = "spellingregions";
    private static final String KEY_CONTENT_TYPE = "org.eclipse.wst.sse.ui.temp.spelling";
    private String fContentTypeId = null;
    private SpellingProblemCollector fProblemCollector = new SpellingProblemCollector();
    ReconcileAnnotationKey fReconcileAnnotationKey;
    private IPropertyChangeListener fSpellCheckPreferenceListener;
    private SpellingContext fSpellingContext;
    private String[] fSupportedTextRegionContexts;
    private IReconcileStep fSpellingStep = new StructuredReconcileStep(){};

    public SpellcheckStrategy(ISourceViewer viewer, String contentTypeId) {
        super(viewer);
        this.fContentTypeId = contentTypeId;
        this.fSpellingContext = new SpellingContext();
        IContentType contentType = Platform.getContentTypeManager().getContentType(this.fContentTypeId);
        this.fSpellingContext.setContentType(contentType);
        this.fReconcileAnnotationKey = new ReconcileAnnotationKey(this.fSpellingStep, KEY_CONTENT_TYPE, 1);
        ArrayList<String> contexts = new ArrayList<String>();
        IContentType testType = contentType;
        while (testType != null) {
            String[] textRegionContexts = ExtendedConfigurationBuilder.getInstance().getDefinitions(EXTENDED_BUILDER_TYPE_CONTEXTS, testType.getId());
            int j = 0;
            while (j < textRegionContexts.length) {
                contexts.addAll(Arrays.asList(StringUtils.unpack((String)textRegionContexts[j])));
                ++j;
            }
            testType = testType.getBaseType();
        }
        this.fSupportedTextRegionContexts = contexts.toArray(new String[contexts.size()]);
        this.fSpellCheckPreferenceListener = new SpellCheckPreferenceListener();
    }

    protected boolean containsStep(IReconcileStep step) {
        return this.fSpellingStep.equals(step);
    }

    public void createReconcileSteps() {
    }

    private TemporaryAnnotation[] getSpellingAnnotationsToRemove(IRegion region) {
        ArrayList<TemporaryAnnotation> toRemove = new ArrayList<TemporaryAnnotation>();
        IAnnotationModel annotationModel = this.getAnnotationModel();
        if (annotationModel != null) {
            Iterator i = null;
            boolean annotationOverlaps = false;
            if (annotationModel instanceof IAnnotationModelExtension2) {
                i = ((IAnnotationModelExtension2)annotationModel).getAnnotationIterator(region.getOffset(), region.getLength(), true, true);
                annotationOverlaps = true;
            } else {
                i = annotationModel.getAnnotationIterator();
            }
            while (i.hasNext()) {
                TemporaryAnnotation annotation;
                ReconcileAnnotationKey key;
                Object obj = i.next();
                if (!(obj instanceof TemporaryAnnotation) || (key = (ReconcileAnnotationKey)(annotation = (TemporaryAnnotation)obj).getKey()) == null || !key.equals(this.fReconcileAnnotationKey)) continue;
                if (key.getScope() == 1 && (annotationOverlaps || annotation.getPosition().overlapsWith(region.getOffset(), region.getLength()))) {
                    toRemove.add(annotation);
                    continue;
                }
                if (key.getScope() != 0) continue;
                toRemove.add(annotation);
            }
        }
        return toRemove.toArray(new TemporaryAnnotation[toRemove.size()]);
    }

    protected boolean isInterestingProblem(SpellingProblem problem) {
        IDocument document = this.getDocument();
        if (document instanceof IStructuredDocument) {
            if (((IStructuredDocument)document).containsReadOnly(problem.getOffset(), problem.getLength())) {
                return false;
            }
            IStructuredDocumentRegion documentRegion = ((IStructuredDocument)document).getRegionAtCharacterOffset(problem.getOffset());
            if (documentRegion != null) {
                ITextRegion textRegion = documentRegion.getRegionAtCharacterOffset(problem.getOffset());
                if (textRegion != null && this.isSupportedContext(textRegion.getType())) {
                    return true;
                }
                if (documentRegion.getFirstRegion() instanceof ForeignRegion) {
                    return false;
                }
                return documentRegion.getRegions().size() == 1;
            }
        }
        return true;
    }

    private boolean isSupportedContext(String type) {
        boolean isSupported = false;
        if (this.fSupportedTextRegionContexts.length > 0) {
            int i = 0;
            while (i < this.fSupportedTextRegionContexts.length) {
                if (type.equals(this.fSupportedTextRegionContexts[i])) {
                    isSupported = true;
                    break;
                }
                ++i;
            }
        } else {
            isSupported = true;
        }
        return isSupported;
    }

    public void reconcile() {
        IDocument document = this.getDocument();
        if (document != null) {
            IAnnotationModel annotationModel = this.getAnnotationModel();
            Region documentRegion = new Region(0, document.getLength());
            this.spellCheck((IRegion)documentRegion, (IRegion)documentRegion, annotationModel);
        }
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        if (this.isCanceled()) {
            return;
        }
        IAnnotationModel annotationModel = this.getAnnotationModel();
        IDocument document = this.getDocument();
        if (document != null) {
            long time0 = 0L;
            if (_DEBUG_SPELLING) {
                time0 = System.currentTimeMillis();
            }
            if (_DEBUG_SPELLING) {
                Logger.log(1, "Spell Checking [" + dirtyRegion.getOffset() + ":" + dirtyRegion.getLength() + "] : " + (System.currentTimeMillis() - time0));
            }
            this.spellCheck((IRegion)dirtyRegion, (IRegion)dirtyRegion, annotationModel);
        }
    }

    private void spellCheck(IRegion dirtyRegion, IRegion regionToBeChecked, IAnnotationModel annotationModel) {
        Annotation[] annotationsToRemove = this.getSpellingAnnotationsToRemove(regionToBeChecked);
        if (_DEBUG_SPELLING_PROBLEMS) {
            Logger.log(1, "Spell checking [" + regionToBeChecked.getOffset() + "-" + (regionToBeChecked.getOffset() + regionToBeChecked.getLength()) + "]");
        }
        if (this.getDocument() != null) {
            EditorsUI.getSpellingService().check(this.getDocument(), new IRegion[]{regionToBeChecked}, this.fSpellingContext, (ISpellingProblemCollector)this.fProblemCollector, null);
        }
        Annotation[] annotationsToAdd = this.fProblemCollector.getAnnotations();
        this.fProblemCollector.clear();
        if (annotationModel instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension modelExtension = (IAnnotationModelExtension)annotationModel;
            HashMap<Annotation, Position> annotationsToAddMap = new HashMap<Annotation, Position>();
            int i = 0;
            while (i < annotationsToAdd.length) {
                annotationsToAddMap.put(annotationsToAdd[i], ((TemporaryAnnotation)annotationsToAdd[i]).getPosition());
                ++i;
            }
            modelExtension.replaceAnnotations(annotationsToRemove, annotationsToAddMap);
        } else {
            int j = 0;
            while (j < annotationsToAdd.length) {
                annotationModel.addAnnotation(annotationsToAdd[j], ((TemporaryAnnotation)annotationsToAdd[j]).getPosition());
                ++j;
            }
            j = 0;
            while (j < annotationsToRemove.length) {
                annotationModel.removeAnnotation(annotationsToRemove[j]);
                ++j;
            }
        }
    }

    public void reconcile(IRegion partition) {
        IDocument document = this.getDocument();
        if (document != null) {
            IAnnotationModel annotationModel = this.getAnnotationModel();
            this.spellCheck(partition, partition, annotationModel);
        }
    }

    public void setDocument(IDocument document) {
        if (this.getDocument() != null) {
            EditorsUI.getPreferenceStore().removePropertyChangeListener(this.fSpellCheckPreferenceListener);
        }
        super.setDocument(document);
        if (this.getDocument() != null) {
            EditorsUI.getPreferenceStore().addPropertyChangeListener(this.fSpellCheckPreferenceListener);
        }
    }

    class SpellCheckPreferenceListener
    implements IPropertyChangeListener {
        SpellCheckPreferenceListener() {
        }

        private boolean isInterestingProperty(Object property) {
            return "spellingEnabled".equals(property) || "spellingEngine".equals(property);
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (this.isInterestingProperty(event.getProperty()) && (event.getOldValue() == null || event.getNewValue() == null || !event.getNewValue().equals(event.getOldValue()))) {
                SpellcheckStrategy.this.reconcile();
            }
        }
    }

    private class SpellingProblemCollector
    implements ISpellingProblemCollector {
        List annotations = new ArrayList();

        private SpellingProblemCollector() {
        }

        public void accept(SpellingProblem problem) {
            if (SpellcheckStrategy.this.isInterestingProblem(problem)) {
                TemporaryAnnotation annotation = new TemporaryAnnotation(new Position(problem.getOffset(), problem.getLength()), "org.eclipse.ui.workbench.texteditor.spelling", problem.getMessage(), SpellcheckStrategy.this.fReconcileAnnotationKey);
                SpellingQuickAssistProcessor quickAssistProcessor = new SpellingQuickAssistProcessor();
                quickAssistProcessor.setSpellingProblem(problem);
                annotation.setAdditionalFixInfo(quickAssistProcessor);
                this.annotations.add(annotation);
                if (_DEBUG_SPELLING_PROBLEMS) {
                    Logger.log(1, problem.getMessage());
                }
            }
        }

        public void beginCollecting() {
        }

        void clear() {
            this.annotations.clear();
        }

        public void endCollecting() {
        }

        Annotation[] getAnnotations() {
            return this.annotations.toArray(new Annotation[this.annotations.size()]);
        }
    }
}

