/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.catalog;

import java.sql.Connection;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogSchema;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEIndex;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEUniqueConstraint;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.impl.SybaseASEPrimaryKeyImpl;
import org.eclipse.datatools.modelbase.sql.constraints.IndexMember;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.emf.common.util.EList;

public class SybaseASECatalogPrimaryKey
extends SybaseASEPrimaryKeyImpl
implements ICatalogObject,
IAdaptable {
    private static final long serialVersionUID = 3257852094999769398L;
    private boolean isMemberLoaded = false;
    private boolean isASEUniqueConstraintLoaded = false;

    public void refresh() {
        this.isMemberLoaded = false;
        this.isASEUniqueConstraintLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public Connection getConnection() {
        SybaseASECatalogSchema schema = (SybaseASECatalogSchema)this.getBaseTable().getSchema();
        return schema.getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getBaseTable().getSchema().getDatabase();
    }

    public EList getMembers() {
        if (!this.isMemberLoaded) {
            this.loadMemebers();
        }
        return super.getMembers();
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 13: {
                this.getAseUniqueConstraint();
            }
            case 11: {
                this.getMembers();
            }
        }
        return super.eIsSet(featureID);
    }

    private void loadMemebers() {
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        EList members = super.getMembers();
        members.clear();
        SybaseASEIndex uniqueIndex = this.getAseUniqueConstraint().getSystemGenedIndex();
        EList indexMems = uniqueIndex.getMembers();
        int i = 0;
        while (i < indexMems.size()) {
            IndexMember mem = (IndexMember)indexMems.get(i);
            members.add((Object)mem.getColumn());
            ++i;
        }
        this.isMemberLoaded = true;
        this.eSetDeliver(deliver);
    }

    public SybaseASEUniqueConstraint getAseUniqueConstraint() {
        if (!this.isASEUniqueConstraintLoaded) {
            this.loadASEUniqueConstraint();
        }
        return super.getAseUniqueConstraint();
    }

    private void loadASEUniqueConstraint() {
        SybaseASEUniqueConstraint uniqueConstraint = super.getAseUniqueConstraint();
        EList indexList = this.getBaseTable().getIndex();
        int i = 0;
        while (i < indexList.size()) {
            SybaseASEIndex index = (SybaseASEIndex)indexList.get(i);
            if (index.getName().equals(this.getName())) {
                uniqueConstraint.setSystemGenedIndex(index);
                break;
            }
            ++i;
        }
        this.isASEUniqueConstraintLoaded = true;
    }

    public Object getAdapter(Class adapter) {
        Object adapterObject = Platform.getAdapterManager().getAdapter((Object)this, adapter);
        if (adapterObject == null) {
            adapterObject = Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        }
        return adapterObject;
    }
}

